/*
 * Decompiled with CFR 0.152.
 */
package de.ii.ogcapi.foundation.infra.json;

import de.ii.ogcapi.foundation.domain.SchemaValidator;
import java.io.IOException;
import java.util.Optional;
import java.util.Set;
import shadow.com.fasterxml.jackson.databind.JsonNode;
import shadow.com.fasterxml.jackson.databind.ObjectMapper;
import shadow.com.networknt.schema.JsonSchema;
import shadow.com.networknt.schema.JsonSchemaException;
import shadow.com.networknt.schema.JsonSchemaFactory;
import shadow.com.networknt.schema.SchemaValidatorsConfig;
import shadow.com.networknt.schema.SpecVersion;
import shadow.com.networknt.schema.SpecVersionDetector;
import shadow.com.networknt.schema.ValidationMessage;

public class SchemaValidatorImpl
implements SchemaValidator {
    public Optional<String> validate(String schemaContent, String jsonContent, SpecVersion.VersionFlag version) throws IOException {
        ObjectMapper mapper = new ObjectMapper();
        JsonNode schemaNode = mapper.readTree(schemaContent);
        JsonNode jsonNode = mapper.readTree(jsonContent);
        return this.validate(schemaNode, jsonNode, version);
    }

    @Override
    public Optional<String> validate(String schemaContent, String jsonContent) throws IOException {
        SpecVersion.VersionFlag version;
        ObjectMapper mapper = new ObjectMapper();
        JsonNode schemaNode = mapper.readTree(schemaContent);
        JsonNode jsonNode = mapper.readTree(jsonContent);
        try {
            version = SpecVersionDetector.detect(schemaNode);
        }
        catch (Exception e) {
            version = SpecVersion.VersionFlag.V201909;
        }
        return this.validate(schemaNode, jsonNode, version);
    }

    private Optional<String> validate(JsonNode schemaNode, JsonNode jsonNode, SpecVersion.VersionFlag version) throws IOException {
        Set<ValidationMessage> result;
        JsonSchemaFactory validatorFactory = JsonSchemaFactory.getInstance(version);
        SchemaValidatorsConfig config = new SchemaValidatorsConfig();
        config.setTypeLoose(true);
        config.setFailFast(true);
        config.setHandleNullableField(true);
        JsonSchema schema = validatorFactory.getSchema(schemaNode, config);
        try {
            result = schema.validate(jsonNode);
        }
        catch (JsonSchemaException e) {
            result = e.getValidationMessages();
        }
        if (result.size() > 0) {
            return Optional.of(result.toString());
        }
        return Optional.empty();
    }
}

