/*
 * Decompiled with CFR 0.152.
 */
package de.ii.ogcapi.foundation.domain;

import java.net.URI;
import java.net.URISyntaxException;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import shadow.com.google.common.collect.ImmutableList;
import shadow.org.apache.http.NameValuePair;
import shadow.org.apache.http.client.utils.URIBuilder;

public class URICustomizer
extends URIBuilder {
    public URICustomizer() {
    }

    public URICustomizer(String string) throws URISyntaxException {
        super(string);
    }

    public URICustomizer(URI uri) {
        super(uri);
    }

    public URICustomizer copy() {
        try {
            return new URICustomizer(this.toString());
        }
        catch (URISyntaxException uRISyntaxException) {
            return this;
        }
    }

    @Override
    public URICustomizer clearParameters() {
        super.clearParameters();
        return this;
    }

    @Override
    public URICustomizer setScheme(String scheme) {
        super.setScheme(scheme);
        return this;
    }

    public URICustomizer ensureParameter(String parameter, String value) {
        if (this.getQueryParams().stream().noneMatch(nameValuePair -> nameValuePair.getName().equals(parameter))) {
            this.setParameter(parameter, value);
        }
        return this;
    }

    public URICustomizer removeParameters(String ... parameters) {
        List<String> parameterList = Arrays.asList(parameters);
        List<NameValuePair> queryParams = this.getQueryParams().stream().filter(nameValuePair -> !parameterList.contains(nameValuePair.getName())).collect(Collectors.toList());
        this.setParameters(queryParams);
        return this;
    }

    public boolean isLastPathSegment(String segment) {
        List<String> pathSegments = this.getPathSegments();
        return !pathSegments.isEmpty() && pathSegments.get(pathSegments.size() - 1).equals(segment);
    }

    public String getLastPathSegment() {
        List<String> pathSegments = this.getPathSegments();
        return !pathSegments.isEmpty() ? pathSegments.get(pathSegments.size() - 1) : null;
    }

    public URICustomizer ensureLastPathSegment(String segment) {
        List<String> pathSegments = this.getPathSegments();
        if (pathSegments.isEmpty() || !pathSegments.get(pathSegments.size() - 1).equals(segment)) {
            this.setPathSegments((List<String>)((Object)((ImmutableList.Builder)((ImmutableList.Builder)new ImmutableList.Builder().addAll(pathSegments)).add(segment)).build()));
        }
        return this;
    }

    public URICustomizer ensureLastPathSegments(String ... segments) {
        List<String> pathSegments = this.getPathSegments();
        int pathSegmentsIndex = pathSegments.size() >= segments.length ? pathSegments.size() - segments.length : 0;
        boolean match = true;
        int restIndex = 0;
        for (int k = pathSegmentsIndex; k < pathSegments.size(); ++k) {
            int l = 0;
            while (k + l < pathSegments.size()) {
                if (!pathSegments.get(k + l).equals(segments[l])) {
                    match = false;
                    break;
                }
                restIndex = l + 1;
                ++l;
            }
            if (match) break;
            match = true;
        }
        int segmentsIndex = match ? restIndex : 0;
        this.setPathSegments((List<String>)((Object)((ImmutableList.Builder)((ImmutableList.Builder)new ImmutableList.Builder().addAll(pathSegments)).addAll(Arrays.asList(segments).subList(segmentsIndex, segments.length))).build()));
        return this;
    }

    public URICustomizer cutPathAfterSegments(String ... segments) {
        if (segments.length <= 0) {
            return this;
        }
        List<String> pathSegments = this.getPathSegments();
        int pathSegmentsIndex = pathSegments.lastIndexOf(segments[0]);
        if (pathSegmentsIndex == -1) {
            return this;
        }
        boolean match = true;
        int cutIndex = 0;
        for (int k = pathSegmentsIndex; k < pathSegments.size(); ++k) {
            for (int l = 0; k + l < pathSegments.size() && l < segments.length; ++l) {
                if (!pathSegments.get(k + l).equals(segments[l])) {
                    match = false;
                    break;
                }
                cutIndex = k + l + 1;
            }
            if (match) break;
            match = true;
        }
        int segmentsIndex = match ? cutIndex : pathSegments.size();
        this.setPathSegments((List<String>)((Object)((ImmutableList.Builder)new ImmutableList.Builder().addAll(pathSegments.subList(0, segmentsIndex))).build()));
        return this;
    }

    public URICustomizer removePathSegment(String segment, int index) {
        int i;
        List<String> pathSegments = this.getPathSegments();
        int n = i = index < 0 ? pathSegments.size() + index : index;
        if (i >= 0 && i < pathSegments.size() && pathSegments.get(i).equals(segment)) {
            this.setPathSegments((List<String>)((Object)((ImmutableList.Builder)((ImmutableList.Builder)new ImmutableList.Builder().addAll(pathSegments.subList(0, i))).addAll(pathSegments.subList(i + 1, pathSegments.size()))).build()));
        }
        return this;
    }

    public URICustomizer removeLastPathSegment(String segment) {
        List<String> pathSegments = this.getPathSegments();
        if (!pathSegments.isEmpty() && pathSegments.get(pathSegments.size() - 1).equals(segment)) {
            this.setPathSegments(pathSegments.subList(0, pathSegments.size() - 1));
        }
        return this;
    }

    public URICustomizer removeLastPathSegments(int numberOfSegments) {
        List<String> pathSegments = this.getPathSegments();
        if (pathSegments.size() >= numberOfSegments) {
            this.setPathSegments(pathSegments.subList(0, pathSegments.size() - numberOfSegments));
        }
        return this;
    }

    public URICustomizer replaceInPath(String original, String replacement) {
        this.setPath(this.getPath().replaceFirst(original, replacement));
        return this;
    }

    public URICustomizer ensureTrailingSlash() {
        if (Objects.nonNull(this.getPath()) && !this.getPath().endsWith("/")) {
            this.setPath(this.getPath() + "/");
        }
        return this;
    }

    public URICustomizer ensureNoTrailingSlash() {
        if (Objects.nonNull(this.getPath()) && this.getPath().endsWith("/")) {
            this.setPath(this.getPath().substring(0, this.getPath().length() - 1));
        }
        return this;
    }
}

