/*
 * Decompiled with CFR 0.152.
 */
package de.ii.ogcapi.foundation.domain;

import de.ii.ogcapi.foundation.domain.ImmutableTemporalExtent;
import java.text.DateFormat;
import java.util.Date;
import java.util.Locale;
import java.util.Optional;
import shadow.com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import shadow.javax.annotation.Nullable;
import shadow.org.immutables.value.Value;

@JsonDeserialize(builder=ImmutableTemporalExtent.Builder.class)
@Value.Immutable
public interface TemporalExtent {
    @Nullable
    @Value.Default
    default public Long getStart() {
        return null;
    }

    @Nullable
    @Value.Default
    default public Long getEnd() {
        return null;
    }

    default public String humanReadable(Locale locale) {
        DateFormat df = DateFormat.getDateInstance(3, locale);
        return String.format("%s - %s", Optional.ofNullable(this.getStart()).map(start -> df.format(new Date((long)start))).orElse(".."), Optional.ofNullable(this.getEnd()).map(end -> df.format(new Date((long)end))).orElse(".."));
    }
}

