/*
 * Decompiled with CFR 0.152.
 */
package de.ii.ogcapi.foundation.domain;

import de.ii.ogcapi.foundation.domain.ApiMediaType;
import de.ii.ogcapi.foundation.domain.ApiRequestContext;
import de.ii.ogcapi.foundation.domain.FormatExtension;
import de.ii.ogcapi.foundation.domain.I18n;
import de.ii.ogcapi.foundation.domain.Link;
import de.ii.ogcapi.foundation.domain.OgcApi;
import de.ii.ogcapi.foundation.domain.PageRepresentation;
import de.ii.ogcapi.foundation.domain.QueryHandler;
import de.ii.ogcapi.foundation.domain.QueryIdentifier;
import de.ii.ogcapi.foundation.domain.QueryInput;
import de.ii.ogcapi.foundation.domain.UnprocessableEntity;
import de.ii.xtraplatform.base.domain.LogContext;
import de.ii.xtraplatform.crs.domain.EpsgCrs;
import de.ii.xtraplatform.features.domain.FeatureProvider2;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.text.MessageFormat;
import java.text.SimpleDateFormat;
import java.time.Instant;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.SimpleTimeZone;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import shadow.com.github.azahnen.dagger.annotations.AutoMultiBind;
import shadow.com.google.common.collect.ImmutableList;
import shadow.com.google.common.hash.Funnel;
import shadow.com.google.common.hash.Hashing;
import shadow.com.google.common.hash.HashingInputStream;
import shadow.com.google.common.io.Files;
import shadow.javax.ws.rs.BadRequestException;
import shadow.javax.ws.rs.InternalServerErrorException;
import shadow.javax.ws.rs.WebApplicationException;
import shadow.javax.ws.rs.core.CacheControl;
import shadow.javax.ws.rs.core.EntityTag;
import shadow.javax.ws.rs.core.MediaType;
import shadow.javax.ws.rs.core.Request;
import shadow.javax.ws.rs.core.Response;
import shadow.javax.ws.rs.core.Variant;
import shadow.org.eclipse.jetty.io.EofException;

@AutoMultiBind
public interface QueriesHandler<T extends QueryIdentifier> {
    public static final Logger LOGGER = LoggerFactory.getLogger(QueriesHandler.class);
    public static final Locale[] LANGUAGES = (Locale[])I18n.getLanguages().stream().collect(Collectors.toUnmodifiableList()).toArray(Locale[]::new);
    public static final String[] ENCODINGS = new String[]{"gzip", "identity"};

    public Map<T, QueryHandler<? extends QueryInput>> getQueryHandlers();

    default public Response handle(T queryIdentifier, QueryInput queryInput, ApiRequestContext requestContext) {
        QueryHandler<QueryInput> queryHandler = this.getQueryHandlers().get(queryIdentifier);
        if (Objects.isNull(queryHandler)) {
            throw new IllegalStateException("No query handler found for " + queryIdentifier + ".");
        }
        if (!queryHandler.isValidInput(queryInput)) {
            throw new RuntimeException(MessageFormat.format("Invalid query handler {0} for query input of class {1}.", queryHandler.getClass().getSimpleName(), queryInput.getClass().getSimpleName()));
        }
        return queryHandler.handle(queryInput, requestContext);
    }

    default public Response.ResponseBuilder prepareSuccessResponse(OgcApi api, ApiRequestContext requestContext) {
        return this.prepareSuccessResponse(api, requestContext, null);
    }

    default public Response.ResponseBuilder prepareSuccessResponse(OgcApi api, ApiRequestContext requestContext, List<Link> links) {
        return this.prepareSuccessResponse(api, requestContext, links, null);
    }

    default public Response.ResponseBuilder prepareSuccessResponse(OgcApi api, ApiRequestContext requestContext, List<Link> links, EpsgCrs crs) {
        Response.ResponseBuilder response = Response.ok().type(requestContext.getMediaType().type());
        Optional<Locale> language = requestContext.getLanguage();
        if (language.isPresent()) {
            response.language(language.get());
        }
        if (links != null) {
            links.stream().filter(link -> link.getTemplated() == null || link.getTemplated() == false).forEach(link -> response.links(link.getLink()));
        }
        if (crs != null) {
            response.header("Content-Crs", "<" + crs.toUriString() + ">");
        }
        return response;
    }

    default public Response.ResponseBuilder evaluatePreconditions(ApiRequestContext requestContext, Date lastModified, EntityTag etag) {
        if (requestContext.getRequest().isPresent()) {
            Request request = requestContext.getRequest().get();
            try {
                if (Objects.nonNull(lastModified) && Objects.nonNull(etag)) {
                    return request.evaluatePreconditions(lastModified, etag);
                }
                if (Objects.nonNull(etag)) {
                    return request.evaluatePreconditions(etag);
                }
                if (Objects.nonNull(lastModified)) {
                    return request.evaluatePreconditions(lastModified);
                }
                return request.evaluatePreconditions();
            }
            catch (Exception e) {
                LOGGER.debug("Ignoring invalid condition request headers: {}", (Object)e.getMessage());
            }
        }
        return null;
    }

    default public Response.ResponseBuilder prepareSuccessResponse(ApiRequestContext requestContext, List<Link> links, Date lastModified, EntityTag etag, String cacheControl, Date expires, EpsgCrs crs, boolean inline, String filename) {
        Response.ResponseBuilder response = Response.ok().type(requestContext.getMediaType().type());
        if (Objects.nonNull(lastModified)) {
            response.lastModified(lastModified);
        }
        if (Objects.nonNull(etag)) {
            response.tag(etag);
        }
        if (Objects.nonNull(cacheControl)) {
            response.cacheControl(CacheControl.valueOf(cacheControl));
        }
        if (Objects.nonNull(expires)) {
            response.expires(expires);
        }
        response.variants(Variant.mediaTypes((MediaType[])((ImmutableList.Builder)((ImmutableList.Builder)new ImmutableList.Builder().add(requestContext.getMediaType())).addAll(requestContext.getAlternateMediaTypes())).build().stream().map(ApiMediaType::type).toArray(MediaType[]::new)).languages(LANGUAGES).encodings(ENCODINGS).add().build());
        requestContext.getLanguage().ifPresent(response::language);
        if (links != null) {
            links.stream().filter(link -> link.getTemplated() == null || link.getTemplated() == false).forEach(link -> response.links(link.getLink()));
        }
        if (crs != null) {
            response.header("Content-Crs", "<" + crs.toUriString() + ">");
        }
        if (!inline || Objects.nonNull(filename)) {
            response.header("Content-Disposition", (inline ? "inline" : "attachment") + (String)(Objects.nonNull(filename) ? "; filename=\"" + filename + "\"" : ""));
        }
        return response;
    }

    default public Date getLastModified(QueryInput queryInput, PageRepresentation resource) {
        return queryInput.getLastModified().orElse(resource.getLastModified().orElse(null));
    }

    default public Date getLastModified(QueryInput queryInput, OgcApi api) {
        return queryInput.getLastModified().orElse(null);
    }

    default public Date getLastModified(QueryInput queryInput, OgcApi api, FeatureProvider2 provider) {
        return queryInput.getLastModified().orElse(null);
    }

    default public Date getLastModified(File file) {
        return Date.from(Instant.ofEpochMilli(file.lastModified()));
    }

    default public EntityTag getEtag(Date date) {
        if (Objects.isNull(date)) {
            return null;
        }
        SimpleDateFormat sdf = new SimpleDateFormat();
        sdf.setTimeZone(new SimpleTimeZone(0, "GMT"));
        sdf.applyPattern("dd MMM yyyy HH:mm:ss z");
        String etag = Hashing.murmur3_128().hashString(sdf.format(date), StandardCharsets.UTF_8).toString();
        return new EntityTag(etag, true);
    }

    default public EntityTag getEtag(byte[] byteArray) {
        String etag = Hashing.murmur3_128().hashBytes(byteArray).toString();
        return new EntityTag(etag, false);
    }

    default public EntityTag getEtag(File file) {
        String etag;
        try {
            etag = Files.asByteSource(file).hash(Hashing.murmur3_128()).toString();
        }
        catch (IOException e) {
            return null;
        }
        return new EntityTag(etag, false);
    }

    default public EntityTag getEtag(InputStream inputStream) {
        String etag = new HashingInputStream(Hashing.murmur3_128(), inputStream).hash().toString();
        return new EntityTag(etag, false);
    }

    default public <S> EntityTag getEtag(S entity, Funnel<S> funnel, FormatExtension outputFormat) {
        String etag = Hashing.murmur3_128().newHasher().putObject(entity, funnel).putString(Objects.nonNull(outputFormat) ? outputFormat.getMediaType().label() : "", StandardCharsets.UTF_8).hash().toString();
        return new EntityTag(etag, true);
    }

    public static void processStreamError(Throwable error) {
        Object errorMessage = error.getMessage();
        if (Objects.isNull(errorMessage)) {
            errorMessage = error.getClass().getSimpleName() + " at " + error.getStackTrace()[0].toString();
        }
        while (Objects.nonNull(error) && !Objects.equals(error, error.getCause())) {
            if (error instanceof EofException) {
                LOGGER.debug("Request cancelled due to lost connection.");
                return;
            }
            if (error instanceof UnprocessableEntity) {
                throw new WebApplicationException(error.getMessage(), 422);
            }
            if (error instanceof IllegalArgumentException) {
                LogContext.errorAsDebug(LOGGER, error, "Invalid request", new Object[0]);
                throw new BadRequestException(error.getMessage());
            }
            if (!(error instanceof RuntimeException) || !Objects.nonNull(error.getCause())) break;
            error = error.getCause();
        }
        LogContext.error(LOGGER, error, "", new Object[0]);
        throw new InternalServerErrorException((String)errorMessage, error);
    }
}

