/*
 * Decompiled with CFR 0.152.
 */
package de.ii.ogcapi.foundation.domain;

import de.ii.ogcapi.foundation.domain.ApiExtension;
import de.ii.ogcapi.foundation.domain.FeatureTypeConfigurationOgcApi;
import de.ii.ogcapi.foundation.domain.OgcApiDataV2;
import de.ii.ogcapi.foundation.infra.json.SchemaValidatorImpl;
import de.ii.xtraplatform.features.domain.ImmutableFeatureQuery;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import shadow.com.github.azahnen.dagger.annotations.AutoMultiBind;
import shadow.com.google.common.base.Splitter;
import shadow.io.swagger.v3.core.util.Json;
import shadow.io.swagger.v3.oas.models.media.Schema;
import shadow.io.swagger.v3.oas.models.media.StringSchema;

@AutoMultiBind
public interface ParameterExtension
extends ApiExtension {
    public static final Schema SCHEMA = new StringSchema();

    default public String getId() {
        return this.getName();
    }

    default public String getId(String collectionId) {
        return this.getId();
    }

    default public String getId(Optional<String> collectionId) {
        return collectionId.isPresent() ? this.getId(collectionId.get()) : this.getId();
    }

    public String getName();

    public String getDescription();

    default public boolean getRequired(OgcApiDataV2 apiData) {
        return false;
    }

    default public boolean getRequired(OgcApiDataV2 apiData, String collectionId) {
        return this.getRequired(apiData);
    }

    default public boolean getRequired(OgcApiDataV2 apiData, Optional<String> collectionId) {
        return collectionId.isPresent() ? this.getRequired(apiData, collectionId.get()) : this.getRequired(apiData);
    }

    default public Schema getSchema(OgcApiDataV2 apiData) {
        return SCHEMA;
    }

    default public Schema getSchema(OgcApiDataV2 apiData, String collectionId) {
        return this.getSchema(apiData);
    }

    default public Schema getSchema(OgcApiDataV2 apiData, Optional<String> collectionId) {
        return collectionId.isPresent() ? this.getSchema(apiData, collectionId.get()) : this.getSchema(apiData);
    }

    default public boolean getExplode() {
        return false;
    }

    default public Optional<String> validate(OgcApiDataV2 apiData, Optional<String> collectionId, List<String> values) {
        return this.validateSchema(apiData, collectionId, values);
    }

    default public Optional<String> validateSchema(OgcApiDataV2 apiData, Optional<String> collectionId, List<String> values) {
        try {
            Optional<String> resultn;
            SchemaValidatorImpl validator = new SchemaValidatorImpl();
            String schemaContent = Json.mapper().writeValueAsString(this.getSchema(apiData, collectionId));
            Optional<Object> result1 = Optional.empty();
            if (values.size() == 1) {
                result1 = validator.validate(schemaContent, "\"" + values.get(0) + "\"");
                if (!result1.isPresent()) {
                    return Optional.empty();
                }
                if (!this.getExplode() && values.get(0).contains(",")) {
                    values = Splitter.on(",").trimResults().omitEmptyStrings().splitToList(values.get(0));
                }
            }
            if ((resultn = validator.validate(schemaContent, "[\"" + String.join((CharSequence)"\",\"", values) + "\"]")).isPresent()) {
                if (result1.isPresent()) {
                    return Optional.of(String.format("Parameter value '%s' is invalid for parameter '%s': %s", values, this.getName(), result1.get()));
                }
                return Optional.of(String.format("Parameter value '%s' is invalid for parameter '%s': %s", values, this.getName(), resultn.get()));
            }
        }
        catch (IOException e) {
            return Optional.of(String.format("An exception occurred while validating the parameter value '%s' for parameter '%s'", values, this.getName()));
        }
        return Optional.empty();
    }

    default public Map<String, String> transformParameters(FeatureTypeConfigurationOgcApi featureType, Map<String, String> parameters, OgcApiDataV2 apiData) {
        return parameters;
    }

    default public ImmutableFeatureQuery.Builder transformQuery(FeatureTypeConfigurationOgcApi featureType, ImmutableFeatureQuery.Builder queryBuilder, Map<String, String> parameters, OgcApiDataV2 apiData) {
        return queryBuilder;
    }

    default public ImmutableFeatureQuery.Builder transformQuery(ImmutableFeatureQuery.Builder queryBuilder, Map<String, String> parameters, OgcApiDataV2 apiData) {
        return queryBuilder;
    }

    default public Map<String, Object> transformContext(FeatureTypeConfigurationOgcApi featureType, Map<String, Object> context, Map<String, String> parameters, OgcApiDataV2 apiData) {
        return context;
    }
}

