/*
 * Decompiled with CFR 0.152.
 */
package de.ii.ogcapi.foundation.domain;

import de.ii.ogcapi.foundation.domain.Link;
import java.nio.charset.StandardCharsets;
import java.util.Comparator;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import shadow.com.fasterxml.jackson.annotation.JsonIgnore;
import shadow.com.google.common.hash.Funnel;
import shadow.org.immutables.value.Value;

public abstract class PageRepresentation {
    public static final Funnel<PageRepresentation> FUNNEL = (from, into) -> {
        from.getTitle().ifPresent(s -> into.putString((CharSequence)s, StandardCharsets.UTF_8));
        from.getDescription().ifPresent(s -> into.putString((CharSequence)s, StandardCharsets.UTF_8));
        from.getLinks().stream().sorted(Comparator.comparing(Link::getHref)).forEachOrdered(link -> into.putString(link.getHref(), StandardCharsets.UTF_8).putString(Objects.requireNonNullElse(link.getRel(), ""), StandardCharsets.UTF_8));
    };

    public abstract Optional<String> getTitle();

    public abstract Optional<String> getDescription();

    public abstract List<Link> getLinks();

    @JsonIgnore
    public abstract Optional<Date> getLastModified();

    @JsonIgnore
    public abstract List<Map<String, Object>> getSections();

    @JsonIgnore
    @Value.Derived
    public List<Map<String, Object>> getOrderedSections() {
        return this.getSections().stream().sorted(new Comparator<Map<String, Object>>(){

            @Override
            public int compare(Map<String, Object> stringObjectMap, Map<String, Object> t1) {
                if (!stringObjectMap.containsKey("sortPriority")) {
                    return 1;
                }
                if (!t1.containsKey("sortPriority")) {
                    return -1;
                }
                return (Integer)stringObjectMap.get("sortPriority") - (Integer)t1.get("sortPriority");
            }
        }).collect(Collectors.toList());
    }

    @JsonIgnore
    @Value.Default
    public boolean getSectionsFirst() {
        return false;
    }
}

