/*
 * Decompiled with CFR 0.152.
 */
package de.ii.ogcapi.foundation.domain;

import de.ii.ogcapi.foundation.domain.Caching;
import de.ii.ogcapi.foundation.domain.CollectionExtent;
import de.ii.ogcapi.foundation.domain.ExtendableConfiguration;
import de.ii.ogcapi.foundation.domain.ExtensionConfiguration;
import de.ii.ogcapi.foundation.domain.ExternalDocumentation;
import de.ii.ogcapi.foundation.domain.FeatureTypeConfigurationOgcApi;
import de.ii.ogcapi.foundation.domain.ImmutableCollectionExtent;
import de.ii.ogcapi.foundation.domain.ImmutableFeatureTypeConfigurationOgcApi;
import de.ii.ogcapi.foundation.domain.ImmutableOgcApiDataV2;
import de.ii.ogcapi.foundation.domain.ImmutableTemporalExtent;
import de.ii.ogcapi.foundation.domain.Metadata;
import de.ii.ogcapi.foundation.domain.TemporalExtent;
import de.ii.xtraplatform.crs.domain.BoundingBox;
import de.ii.xtraplatform.crs.domain.CrsTransformationException;
import de.ii.xtraplatform.crs.domain.CrsTransformer;
import de.ii.xtraplatform.crs.domain.CrsTransformerFactory;
import de.ii.xtraplatform.crs.domain.EpsgCrs;
import de.ii.xtraplatform.crs.domain.OgcCrs;
import de.ii.xtraplatform.services.domain.ServiceData;
import de.ii.xtraplatform.store.domain.entities.EntityDataBuilder;
import de.ii.xtraplatform.store.domain.entities.ValidationResult;
import de.ii.xtraplatform.store.domain.entities.maptobuilder.BuildableMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import shadow.com.fasterxml.jackson.annotation.JsonIgnore;
import shadow.com.fasterxml.jackson.annotation.JsonMerge;
import shadow.com.fasterxml.jackson.annotation.JsonProperty;
import shadow.com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import shadow.com.google.common.collect.ImmutableList;
import shadow.org.immutables.value.Value;

@JsonDeserialize(builder=ImmutableOgcApiDataV2.Builder.class)
@Value.Immutable
public abstract class OgcApiDataV2
implements ServiceData,
ExtendableConfiguration {
    public static final String SERVICE_TYPE = "OGC_API";

    @Override
    @Value.Derived
    public long getEntitySchemaVersion() {
        return 2L;
    }

    @Override
    public Optional<String> getEntitySubType() {
        return Optional.of(SERVICE_TYPE);
    }

    @Override
    @Value.Default
    public String getServiceType() {
        return SERVICE_TYPE;
    }

    public abstract Optional<Metadata> getMetadata();

    public abstract Optional<ExternalDocumentation> getExternalDocs();

    public abstract Optional<CollectionExtent> getDefaultExtent();

    public abstract Optional<Caching> getDefaultCaching();

    @Value.Default
    public ValidationResult.MODE getApiValidation() {
        return ValidationResult.MODE.NONE;
    }

    public abstract List<String> getTags();

    @JsonIgnore
    @Value.Derived
    @Value.Auxiliary
    public List<String> getSubPath() {
        ImmutableList.Builder builder = new ImmutableList.Builder();
        builder.add(this.getId());
        if (this.getApiVersion().isPresent()) {
            builder.add("v" + this.getApiVersion().get());
        }
        return builder.build();
    }

    @Override
    @JsonProperty(value="api")
    @JsonMerge
    public abstract List<ExtensionConfiguration> getExtensions();

    public abstract BuildableMap<FeatureTypeConfigurationOgcApi, ImmutableFeatureTypeConfigurationOgcApi.Builder> getCollections();

    public Optional<FeatureTypeConfigurationOgcApi> getCollectionData(String collectionId) {
        return Optional.ofNullable((FeatureTypeConfigurationOgcApi)this.getCollections().get(collectionId));
    }

    @Override
    @Value.Derived
    public boolean isLoading() {
        return false;
    }

    @Override
    @Value.Derived
    public boolean hasError() {
        return false;
    }

    @Value.Check
    public OgcApiDataV2 mergeBuildingBlocks() {
        List<ExtensionConfiguration> distinctExtensions = this.getMergedExtensions();
        if (this.getExtensions().size() > distinctExtensions.size()) {
            return ((ImmutableOgcApiDataV2.Builder)new ImmutableOgcApiDataV2.Builder().from(this).extensions(distinctExtensions)).build();
        }
        boolean collectionsHaveMissingParentExtensions = this.getCollections().values().stream().anyMatch(collection -> collection.getParentExtensions().size() < this.getMergedExtensions().size());
        if (collectionsHaveMissingParentExtensions) {
            LinkedHashMap<FeatureTypeConfigurationOgcApi, ImmutableFeatureTypeConfigurationOgcApi.Builder> mergedCollections = new LinkedHashMap<FeatureTypeConfigurationOgcApi, ImmutableFeatureTypeConfigurationOgcApi.Builder>(this.getCollections());
            mergedCollections.values().forEach(featureTypeConfigurationOgcApi -> mergedCollections.put((FeatureTypeConfigurationOgcApi)((Object)featureTypeConfigurationOgcApi.getId()), (ImmutableFeatureTypeConfigurationOgcApi.Builder)((Object)featureTypeConfigurationOgcApi.getBuilder().parentExtensions(this.getMergedExtensions()).build())));
            return new ImmutableOgcApiDataV2.Builder().from(this).collections(mergedCollections).build();
        }
        return this;
    }

    public boolean isCollectionEnabled(String collectionId) {
        return this.getCollections().containsKey(collectionId) && ((FeatureTypeConfigurationOgcApi)this.getCollections().get(collectionId)).getEnabled();
    }

    @JsonIgnore
    @Value.Derived
    public Optional<BoundingBox> getSpatialExtent() {
        return this.getCollections().keySet().stream().map(this::getSpatialExtent).filter(Optional::isPresent).map(Optional::get).map(BoundingBox::toArray).reduce((doubles, doubles2) -> new double[]{Math.min(doubles[0], doubles2[0]), Math.min(doubles[1], doubles2[1]), Math.max(doubles[2], doubles2[2]), Math.max(doubles[3], doubles2[3])}).map(doubles -> BoundingBox.of(doubles[0], doubles[1], doubles[2], doubles[3], OgcCrs.CRS84));
    }

    public Optional<BoundingBox> getSpatialExtent(CrsTransformerFactory crsTransformerFactory, EpsgCrs targetCrs) throws CrsTransformationException {
        Optional<BoundingBox> spatialExtent = this.getSpatialExtent();
        if (spatialExtent.isPresent()) {
            return Optional.ofNullable(this.transformSpatialExtent(spatialExtent.get(), crsTransformerFactory, targetCrs));
        }
        return Optional.empty();
    }

    /*
     * Exception decompiling
     */
    @JsonIgnore
    @Value.Derived
    public Optional<TemporalExtent> getTemporalExtent() {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * java.lang.UnsupportedOperationException
         *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.NewAnonymousArray.getDimSize(NewAnonymousArray.java:142)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.isNewArrayLambda(LambdaRewriter.java:455)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteDynamicExpression(LambdaRewriter.java:409)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteDynamicExpression(LambdaRewriter.java:167)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteExpression(LambdaRewriter.java:105)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.rewriters.ExpressionRewriterHelper.applyForwards(ExpressionRewriterHelper.java:12)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.AbstractMemberFunctionInvokation.applyExpressionRewriterToArgs(AbstractMemberFunctionInvokation.java:101)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.AbstractMemberFunctionInvokation.applyExpressionRewriter(AbstractMemberFunctionInvokation.java:88)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteExpression(LambdaRewriter.java:103)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.AbstractMemberFunctionInvokation.applyExpressionRewriter(AbstractMemberFunctionInvokation.java:87)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteExpression(LambdaRewriter.java:103)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.AbstractMemberFunctionInvokation.applyExpressionRewriter(AbstractMemberFunctionInvokation.java:87)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteExpression(LambdaRewriter.java:103)
         *     at org.benf.cfr.reader.bytecode.analysis.structured.statement.StructuredReturn.rewriteExpressions(StructuredReturn.java:99)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewrite(LambdaRewriter.java:88)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.rewriteLambdas(Op04StructuredStatement.java:1137)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:912)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public Optional<BoundingBox> getSpatialExtent(String collectionId) {
        return this.getExtent(collectionId).flatMap(CollectionExtent::getSpatial);
    }

    public Optional<BoundingBox> getSpatialExtent(String collectionId, CrsTransformerFactory crsTransformerFactory, EpsgCrs targetCrs) throws CrsTransformationException {
        Optional<BoundingBox> spatialExtent = this.getSpatialExtent(collectionId);
        if (spatialExtent.isPresent()) {
            return Optional.ofNullable(this.transformSpatialExtent(spatialExtent.get(), crsTransformerFactory, targetCrs));
        }
        return Optional.empty();
    }

    private BoundingBox transformSpatialExtent(BoundingBox spatialExtent, CrsTransformerFactory crsTransformerFactory, EpsgCrs targetCrs) throws CrsTransformationException {
        Optional<CrsTransformer> crsTransformer = crsTransformerFactory.getTransformer(OgcCrs.CRS84, targetCrs, true);
        if (Objects.nonNull(spatialExtent) && crsTransformer.isPresent()) {
            return crsTransformer.get().transformBoundingBox(spatialExtent);
        }
        return spatialExtent;
    }

    public Optional<TemporalExtent> getTemporalExtent(String collectionId) {
        return this.getExtent(collectionId).flatMap(CollectionExtent::getTemporal);
    }

    public Optional<CollectionExtent> getExtent(String collectionId) {
        return this.getCollections().values().stream().filter(featureTypeConfiguration -> featureTypeConfiguration.getId().equals(collectionId)).filter(FeatureTypeConfigurationOgcApi::getEnabled).findFirst().flatMap(FeatureTypeConfigurationOgcApi::getExtent).flatMap(collectionExtent -> this.mergeExtents(this.getDefaultExtent(), Optional.of(collectionExtent))).or(this::getDefaultExtent);
    }

    private Optional<CollectionExtent> mergeExtents(Optional<CollectionExtent> defaultExtent, Optional<CollectionExtent> collectionExtent) {
        if (defaultExtent.isEmpty()) {
            return collectionExtent;
        }
        if (collectionExtent.isEmpty()) {
            return defaultExtent;
        }
        return Optional.of(new ImmutableCollectionExtent.Builder().from(defaultExtent.get()).from(collectionExtent.get()).build());
    }

    public <T extends ExtensionConfiguration> Optional<T> getExtension(Class<T> clazz, String collectionId) {
        if (this.isCollectionEnabled(collectionId)) {
            return ((FeatureTypeConfigurationOgcApi)this.getCollections().get(collectionId)).getExtension(clazz);
        }
        return this.getExtension(clazz);
    }

    private static /* synthetic */ TemporalExtent lambda$getTemporalExtent$6(Long[] longs) {
        return new ImmutableTemporalExtent.Builder().start(longs[0]).end(longs[1]).build();
    }

    private static /* synthetic */ Long[] lambda$getTemporalExtent$5(Long[] longs, Long[] longs2) {
        return new Long[]{longs[0] == null || longs2[0] == null ? null : Long.valueOf(Math.min(longs[0], longs2[0])), longs[1] == null || longs2[1] == null ? null : Long.valueOf(Math.max(longs[1], longs2[1]))};
    }

    static abstract class Builder
    implements EntityDataBuilder<OgcApiDataV2> {
        Builder() {
        }

        @JsonIgnore
        public abstract Builder extensions(Iterable<? extends ExtensionConfiguration> var1);

        @JsonProperty(value="api")
        public abstract Builder addAllExtensions(Iterable<? extends ExtensionConfiguration> var1);

        public abstract ImmutableOgcApiDataV2.Builder id(String var1);

        @Override
        public EntityDataBuilder<OgcApiDataV2> fillRequiredFieldsWithPlaceholders() {
            return this.id("__DEFAULT__").serviceType("__DEFAULT__");
        }
    }
}

