/*
 * Decompiled with CFR 0.152.
 */
package de.ii.ogcapi.foundation.domain;

import de.ii.ogcapi.foundation.domain.ImmutableLink;
import shadow.com.fasterxml.jackson.annotation.JsonIgnore;
import shadow.com.fasterxml.jackson.annotation.JsonInclude;
import shadow.com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import shadow.javax.annotation.Nullable;
import shadow.javax.ws.rs.core.Link;
import shadow.javax.xml.bind.annotation.XmlAttribute;
import shadow.javax.xml.bind.annotation.XmlTransient;
import shadow.javax.xml.bind.annotation.XmlType;
import shadow.org.immutables.value.Value;

@JsonInclude(value=JsonInclude.Include.NON_EMPTY)
@JsonDeserialize(as=ImmutableLink.class)
@XmlType(propOrder={"rel", "type", "title", "href", "hreflang", "length", "templated"})
@Value.Immutable
public abstract class Link {
    @Nullable
    @XmlAttribute
    public abstract String getRel();

    @Nullable
    @XmlAttribute
    public abstract String getType();

    @Nullable
    @XmlAttribute
    public abstract String getAnchor();

    @Nullable
    @XmlAttribute
    public abstract String getTitle();

    @XmlAttribute
    public abstract String getHref();

    @Nullable
    @XmlAttribute
    public abstract String getHreflang();

    @Nullable
    @XmlAttribute
    public abstract Integer getLength();

    @Nullable
    @XmlAttribute
    public abstract Boolean getTemplated();

    @JsonIgnore
    @XmlTransient
    public shadow.javax.ws.rs.core.Link getLink() {
        Link.Builder link = shadow.javax.ws.rs.core.Link.fromUri(this.getHref());
        if (this.getRel() != null && !this.getRel().isEmpty()) {
            link.rel(this.getRel());
        }
        if (this.getTitle() != null && !this.getTitle().isEmpty()) {
            link.title(this.getTitle());
        }
        if (this.getType() != null && !this.getType().isEmpty()) {
            link.type(this.getType());
        }
        return link.build(new Object[0]);
    }

    @JsonIgnore
    @XmlTransient
    @Value.Derived
    public String getTypeLabel() {
        String mediaType = this.getType();
        if (mediaType == null) {
            return "";
        }
        if (mediaType.toLowerCase().split(";")[0].equals("application/gml+xml")) {
            return "GML";
        }
        if (mediaType.toLowerCase().split(";")[0].equals("application/geo+json")) {
            return "GeoJSON";
        }
        if (mediaType.toLowerCase().split(";")[0].equals("application/ld+json")) {
            return "JSON-LD";
        }
        if (mediaType.toLowerCase().split(";")[0].equals("application/schema+json")) {
            return "JSON";
        }
        if (mediaType.toLowerCase().split(";")[0].equals("application/json")) {
            return "JSON";
        }
        if (mediaType.toLowerCase().split(";")[0].equals("application/xml")) {
            return "XML";
        }
        if (mediaType.toLowerCase().split(";")[0].equals("text/html")) {
            return "HTML";
        }
        if (mediaType.toLowerCase().split(";")[0].equals("application/flatgeobuf")) {
            return "FlatGeobuf";
        }
        if (mediaType.toLowerCase().split(";")[0].endsWith("fg+json")) {
            return "JSON-FG";
        }
        if (mediaType.toLowerCase().split(";")[0].equals("application/vnd.ogc.city+json")) {
            return "CityJSON";
        }
        if (mediaType.toLowerCase().split(";")[0].equals("application/vnd.ogc.city+json-seq")) {
            return "CityJSON-Seq";
        }
        if (mediaType.toLowerCase().split(";")[0].endsWith("+xml")) {
            return "XML";
        }
        if (mediaType.toLowerCase().split(";")[0].endsWith("+json")) {
            return "JSON";
        }
        return mediaType;
    }
}

