/*
 * Decompiled with CFR 0.152.
 */
package de.ii.ogcapi.foundation.domain;

import de.ii.ogcapi.foundation.domain.Caching;
import de.ii.ogcapi.foundation.domain.CollectionExtent;
import de.ii.ogcapi.foundation.domain.ExtendableConfiguration;
import de.ii.ogcapi.foundation.domain.ExtensionConfiguration;
import de.ii.ogcapi.foundation.domain.ExternalDocumentation;
import de.ii.ogcapi.foundation.domain.FeatureTypeConfigurationOgcApi;
import de.ii.ogcapi.foundation.domain.ImmutableCaching;
import de.ii.ogcapi.foundation.domain.ImmutableCollectionExtent;
import de.ii.ogcapi.foundation.domain.ImmutableExternalDocumentation;
import de.ii.ogcapi.foundation.domain.ImmutableFeatureTypeConfigurationOgcApi;
import de.ii.ogcapi.foundation.domain.ImmutableMetadata;
import de.ii.ogcapi.foundation.domain.Metadata;
import de.ii.ogcapi.foundation.domain.OgcApiDataV2;
import de.ii.ogcapi.foundation.domain.TemporalExtent;
import de.ii.xtraplatform.crs.domain.BoundingBox;
import de.ii.xtraplatform.services.domain.ImmutableNotification;
import de.ii.xtraplatform.services.domain.Notification;
import de.ii.xtraplatform.services.domain.ServiceData;
import de.ii.xtraplatform.store.domain.Value;
import de.ii.xtraplatform.store.domain.entities.AutoEntity;
import de.ii.xtraplatform.store.domain.entities.EntityData;
import de.ii.xtraplatform.store.domain.entities.ValidationResult;
import de.ii.xtraplatform.store.domain.entities.maptobuilder.BuildableMap;
import de.ii.xtraplatform.store.domain.entities.maptobuilder.ImmutableBuildableMap;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import shadow.com.fasterxml.jackson.annotation.JsonAlias;
import shadow.com.fasterxml.jackson.annotation.JsonIgnore;
import shadow.com.fasterxml.jackson.annotation.JsonMerge;
import shadow.com.fasterxml.jackson.annotation.JsonProperty;
import shadow.com.google.common.base.MoreObjects;
import shadow.com.google.common.collect.ImmutableList;
import shadow.com.google.common.primitives.Booleans;
import shadow.com.google.common.primitives.Longs;
import shadow.com.google.errorprone.annotations.CanIgnoreReturnValue;
import shadow.javax.annotation.CheckReturnValue;
import shadow.javax.annotation.Nullable;
import shadow.javax.annotation.ParametersAreNonnullByDefault;
import shadow.javax.annotation.concurrent.Immutable;
import shadow.javax.annotation.concurrent.NotThreadSafe;
import shadow.org.immutables.value.Generated;

@ParametersAreNonnullByDefault
@CheckReturnValue
@Generated(from="OgcApiDataV2", generator="Immutables")
@Immutable
public final class ImmutableOgcApiDataV2
extends OgcApiDataV2 {
    private final long storageVersion;
    private final String id;
    private final long createdAt;
    private final long lastModified;
    private final long entityStorageVersion;
    private final transient boolean isAuto;
    private final transient boolean isAutoPersist;
    private final String label;
    @Nullable
    private final String description;
    private final boolean enabled;
    private final ImmutableList<Notification> notifications;
    private final boolean secured;
    @Nullable
    private final Integer apiVersion;
    @Nullable
    private final Boolean auto;
    @Nullable
    private final Boolean autoPersist;
    private final transient List<ExtensionConfiguration> mergedExtensions;
    private final transient long entitySchemaVersion;
    private final String serviceType;
    @Nullable
    private final Metadata metadata;
    @Nullable
    private final ExternalDocumentation externalDocs;
    @Nullable
    private final CollectionExtent defaultExtent;
    @Nullable
    private final Caching defaultCaching;
    private final ValidationResult.MODE apiValidation;
    private final ImmutableList<String> tags;
    private final transient List<String> subPath;
    private final ImmutableList<ExtensionConfiguration> extensions;
    private final BuildableMap<FeatureTypeConfigurationOgcApi, ImmutableFeatureTypeConfigurationOgcApi.Builder> collections;
    private final transient boolean isLoading;
    private final transient boolean hasError;
    private final transient Optional<BoundingBox> spatialExtent;
    private final transient Optional<TemporalExtent> temporalExtent;
    private static final byte STAGE_INITIALIZING = -1;
    private static final byte STAGE_UNINITIALIZED = 0;
    private static final byte STAGE_INITIALIZED = 1;
    private volatile transient InitShim initShim = new InitShim();

    private ImmutableOgcApiDataV2(Builder builder) {
        this.id = builder.id;
        this.description = builder.description;
        this.notifications = ImmutableList.copyOf(ImmutableOgcApiDataV2.convertToValueTypede_ii_xtraplatform_services_domain_ImmutableNotification(builder.notifications.build()));
        this.apiVersion = builder.apiVersion;
        this.auto = builder.auto;
        this.autoPersist = builder.autoPersist;
        this.metadata = ImmutableOgcApiDataV2.convertToValueTypede_ii_ogcapi_foundation_domain_ImmutableMetadata(builder.metadata);
        this.externalDocs = ImmutableOgcApiDataV2.convertToValueTypede_ii_ogcapi_foundation_domain_ImmutableExternalDocumentation(builder.externalDocs);
        this.defaultExtent = ImmutableOgcApiDataV2.convertToValueTypede_ii_ogcapi_foundation_domain_ImmutableCollectionExtent(builder.defaultExtent);
        this.defaultCaching = ImmutableOgcApiDataV2.convertToValueTypede_ii_ogcapi_foundation_domain_ImmutableCaching(builder.defaultCaching);
        this.tags = builder.tags.build();
        this.extensions = builder.extensions.build();
        this.collections = builder.collections_build();
        if (builder.storageVersionIsSet()) {
            this.initShim.storageVersion(builder.storageVersion);
        }
        if (builder.createdAtIsSet()) {
            this.initShim.createdAt(builder.createdAt);
        }
        if (builder.lastModifiedIsSet()) {
            this.initShim.lastModified(builder.lastModified);
        }
        if (builder.entityStorageVersionIsSet()) {
            this.initShim.entityStorageVersion(builder.entityStorageVersion);
        }
        if (builder.label != null) {
            this.initShim.label(builder.label);
        }
        if (builder.enabledIsSet()) {
            this.initShim.enabled(builder.enabled);
        }
        if (builder.securedIsSet()) {
            this.initShim.secured(builder.secured);
        }
        if (builder.serviceType != null) {
            this.initShim.serviceType(builder.serviceType);
        }
        if (builder.apiValidation != null) {
            this.initShim.apiValidation(builder.apiValidation);
        }
        this.storageVersion = this.initShim.storageVersion();
        this.createdAt = this.initShim.getCreatedAt();
        this.lastModified = this.initShim.getLastModified();
        this.entityStorageVersion = this.initShim.getEntityStorageVersion();
        this.isAuto = this.initShim.isAuto();
        this.isAutoPersist = this.initShim.isAutoPersist();
        this.label = this.initShim.getLabel();
        this.enabled = this.initShim.getEnabled();
        this.secured = this.initShim.getSecured();
        this.mergedExtensions = this.initShim.getMergedExtensions();
        this.entitySchemaVersion = this.initShim.getEntitySchemaVersion();
        this.serviceType = this.initShim.getServiceType();
        this.apiValidation = this.initShim.getApiValidation();
        this.subPath = this.initShim.getSubPath();
        this.isLoading = this.initShim.isLoading();
        this.hasError = this.initShim.hasError();
        this.spatialExtent = this.initShim.getSpatialExtent();
        this.temporalExtent = this.initShim.getTemporalExtent();
        this.initShim = null;
    }

    private ImmutableOgcApiDataV2(long storageVersion, String id, long createdAt, long lastModified, long entityStorageVersion, String label, @Nullable String description, boolean enabled, ImmutableList<Notification> notifications, boolean secured, @Nullable Integer apiVersion, @Nullable Boolean auto, @Nullable Boolean autoPersist, String serviceType, @Nullable Metadata metadata, @Nullable ExternalDocumentation externalDocs, @Nullable CollectionExtent defaultExtent, @Nullable Caching defaultCaching, ValidationResult.MODE apiValidation, ImmutableList<String> tags, ImmutableList<ExtensionConfiguration> extensions, BuildableMap<FeatureTypeConfigurationOgcApi, ImmutableFeatureTypeConfigurationOgcApi.Builder> collections) {
        this.initShim.storageVersion(storageVersion);
        this.id = id;
        this.initShim.createdAt(createdAt);
        this.initShim.lastModified(lastModified);
        this.initShim.entityStorageVersion(entityStorageVersion);
        this.initShim.label(label);
        this.description = description;
        this.initShim.enabled(enabled);
        this.notifications = notifications;
        this.initShim.secured(secured);
        this.apiVersion = apiVersion;
        this.auto = auto;
        this.autoPersist = autoPersist;
        this.initShim.serviceType(serviceType);
        this.metadata = metadata;
        this.externalDocs = externalDocs;
        this.defaultExtent = defaultExtent;
        this.defaultCaching = defaultCaching;
        this.initShim.apiValidation(apiValidation);
        this.tags = tags;
        this.extensions = extensions;
        this.collections = collections;
        this.storageVersion = this.initShim.storageVersion();
        this.createdAt = this.initShim.getCreatedAt();
        this.lastModified = this.initShim.getLastModified();
        this.entityStorageVersion = this.initShim.getEntityStorageVersion();
        this.isAuto = this.initShim.isAuto();
        this.isAutoPersist = this.initShim.isAutoPersist();
        this.label = this.initShim.getLabel();
        this.enabled = this.initShim.getEnabled();
        this.secured = this.initShim.getSecured();
        this.mergedExtensions = this.initShim.getMergedExtensions();
        this.entitySchemaVersion = this.initShim.getEntitySchemaVersion();
        this.serviceType = this.initShim.getServiceType();
        this.apiValidation = this.initShim.getApiValidation();
        this.subPath = this.initShim.getSubPath();
        this.isLoading = this.initShim.isLoading();
        this.hasError = this.initShim.hasError();
        this.spatialExtent = this.initShim.getSpatialExtent();
        this.temporalExtent = this.initShim.getTemporalExtent();
        this.initShim = null;
    }

    @Override
    @JsonProperty(value="storageVersion")
    @JsonIgnore
    public long storageVersion() {
        InitShim shim = this.initShim;
        return shim != null ? shim.storageVersion() : this.storageVersion;
    }

    @Override
    @JsonProperty(value="id")
    public String getId() {
        return this.id;
    }

    @Override
    @JsonProperty(value="createdAt")
    public long getCreatedAt() {
        InitShim shim = this.initShim;
        return shim != null ? shim.getCreatedAt() : this.createdAt;
    }

    @Override
    @JsonProperty(value="lastModified")
    public long getLastModified() {
        InitShim shim = this.initShim;
        return shim != null ? shim.getLastModified() : this.lastModified;
    }

    @Override
    @JsonProperty(value="entityStorageVersion")
    public long getEntityStorageVersion() {
        InitShim shim = this.initShim;
        return shim != null ? shim.getEntityStorageVersion() : this.entityStorageVersion;
    }

    @Override
    @JsonProperty(value="isAuto")
    @JsonIgnore
    public boolean isAuto() {
        InitShim shim = this.initShim;
        return shim != null ? shim.isAuto() : this.isAuto;
    }

    @Override
    @JsonProperty(value="isAutoPersist")
    @JsonIgnore
    public boolean isAutoPersist() {
        InitShim shim = this.initShim;
        return shim != null ? shim.isAutoPersist() : this.isAutoPersist;
    }

    @Override
    @JsonProperty(value="label")
    public String getLabel() {
        InitShim shim = this.initShim;
        return shim != null ? shim.getLabel() : this.label;
    }

    @Override
    @JsonProperty(value="description")
    public Optional<String> getDescription() {
        return Optional.ofNullable(this.description);
    }

    @Override
    @JsonProperty(value="enabled")
    @JsonAlias(value={"shouldStart"})
    public boolean getEnabled() {
        InitShim shim = this.initShim;
        return shim != null ? shim.getEnabled() : this.enabled;
    }

    @JsonProperty(value="notifications")
    public ImmutableList<Notification> getNotifications() {
        return this.notifications;
    }

    @Override
    @JsonProperty(value="secured")
    public boolean getSecured() {
        InitShim shim = this.initShim;
        return shim != null ? shim.getSecured() : this.secured;
    }

    @Override
    @JsonProperty(value="apiVersion")
    public Optional<Integer> getApiVersion() {
        return Optional.ofNullable(this.apiVersion);
    }

    @Override
    @JsonProperty(access=JsonProperty.Access.WRITE_ONLY)
    public Optional<Boolean> getAuto() {
        return Optional.ofNullable(this.auto);
    }

    @Override
    @JsonProperty(access=JsonProperty.Access.WRITE_ONLY)
    public Optional<Boolean> getAutoPersist() {
        return Optional.ofNullable(this.autoPersist);
    }

    @Override
    @JsonProperty(value="mergedExtensions")
    @JsonIgnore
    public List<ExtensionConfiguration> getMergedExtensions() {
        InitShim shim = this.initShim;
        return shim != null ? shim.getMergedExtensions() : this.mergedExtensions;
    }

    @Override
    @JsonProperty(value="entitySchemaVersion")
    public long getEntitySchemaVersion() {
        InitShim shim = this.initShim;
        return shim != null ? shim.getEntitySchemaVersion() : this.entitySchemaVersion;
    }

    @Override
    @JsonProperty(value="serviceType")
    public String getServiceType() {
        InitShim shim = this.initShim;
        return shim != null ? shim.getServiceType() : this.serviceType;
    }

    @Override
    @JsonProperty(value="metadata")
    public Optional<Metadata> getMetadata() {
        return Optional.ofNullable(this.metadata);
    }

    @Override
    @JsonProperty(value="externalDocs")
    public Optional<ExternalDocumentation> getExternalDocs() {
        return Optional.ofNullable(this.externalDocs);
    }

    @Override
    @JsonProperty(value="defaultExtent")
    public Optional<CollectionExtent> getDefaultExtent() {
        return Optional.ofNullable(this.defaultExtent);
    }

    @Override
    @JsonProperty(value="defaultCaching")
    public Optional<Caching> getDefaultCaching() {
        return Optional.ofNullable(this.defaultCaching);
    }

    @Override
    @JsonProperty(value="apiValidation")
    public ValidationResult.MODE getApiValidation() {
        InitShim shim = this.initShim;
        return shim != null ? shim.getApiValidation() : this.apiValidation;
    }

    @JsonProperty(value="tags")
    public ImmutableList<String> getTags() {
        return this.tags;
    }

    @Override
    @JsonProperty(value="subPath")
    @JsonIgnore
    public List<String> getSubPath() {
        InitShim shim = this.initShim;
        return shim != null ? shim.getSubPath() : this.subPath;
    }

    @JsonProperty(value="api")
    @JsonMerge
    public ImmutableList<ExtensionConfiguration> getExtensions() {
        return this.extensions;
    }

    @Override
    @JsonProperty(value="collections")
    public BuildableMap<FeatureTypeConfigurationOgcApi, ImmutableFeatureTypeConfigurationOgcApi.Builder> getCollections() {
        return this.collections;
    }

    @Override
    @JsonProperty(value="isLoading")
    public boolean isLoading() {
        InitShim shim = this.initShim;
        return shim != null ? shim.isLoading() : this.isLoading;
    }

    @Override
    @JsonProperty(value="hasError")
    public boolean hasError() {
        InitShim shim = this.initShim;
        return shim != null ? shim.hasError() : this.hasError;
    }

    @Override
    @JsonProperty(value="spatialExtent")
    @JsonIgnore
    public Optional<BoundingBox> getSpatialExtent() {
        InitShim shim = this.initShim;
        return shim != null ? shim.getSpatialExtent() : this.spatialExtent;
    }

    @Override
    @JsonProperty(value="temporalExtent")
    @JsonIgnore
    public Optional<TemporalExtent> getTemporalExtent() {
        InitShim shim = this.initShim;
        return shim != null ? shim.getTemporalExtent() : this.temporalExtent;
    }

    public final ImmutableOgcApiDataV2 withStorageVersion(long value) {
        if (this.storageVersion == value) {
            return this;
        }
        return ImmutableOgcApiDataV2.validate(new ImmutableOgcApiDataV2(value, this.id, this.createdAt, this.lastModified, this.entityStorageVersion, this.label, this.description, this.enabled, this.notifications, this.secured, this.apiVersion, this.auto, this.autoPersist, this.serviceType, this.metadata, this.externalDocs, this.defaultExtent, this.defaultCaching, this.apiValidation, this.tags, this.extensions, this.collections));
    }

    public final ImmutableOgcApiDataV2 withId(String value) {
        String newValue = Objects.requireNonNull(value, "id");
        if (this.id.equals(newValue)) {
            return this;
        }
        return ImmutableOgcApiDataV2.validate(new ImmutableOgcApiDataV2(this.storageVersion, newValue, this.createdAt, this.lastModified, this.entityStorageVersion, this.label, this.description, this.enabled, this.notifications, this.secured, this.apiVersion, this.auto, this.autoPersist, this.serviceType, this.metadata, this.externalDocs, this.defaultExtent, this.defaultCaching, this.apiValidation, this.tags, this.extensions, this.collections));
    }

    public final ImmutableOgcApiDataV2 withCreatedAt(long value) {
        if (this.createdAt == value) {
            return this;
        }
        return ImmutableOgcApiDataV2.validate(new ImmutableOgcApiDataV2(this.storageVersion, this.id, value, this.lastModified, this.entityStorageVersion, this.label, this.description, this.enabled, this.notifications, this.secured, this.apiVersion, this.auto, this.autoPersist, this.serviceType, this.metadata, this.externalDocs, this.defaultExtent, this.defaultCaching, this.apiValidation, this.tags, this.extensions, this.collections));
    }

    public final ImmutableOgcApiDataV2 withLastModified(long value) {
        if (this.lastModified == value) {
            return this;
        }
        return ImmutableOgcApiDataV2.validate(new ImmutableOgcApiDataV2(this.storageVersion, this.id, this.createdAt, value, this.entityStorageVersion, this.label, this.description, this.enabled, this.notifications, this.secured, this.apiVersion, this.auto, this.autoPersist, this.serviceType, this.metadata, this.externalDocs, this.defaultExtent, this.defaultCaching, this.apiValidation, this.tags, this.extensions, this.collections));
    }

    public final ImmutableOgcApiDataV2 withEntityStorageVersion(long value) {
        if (this.entityStorageVersion == value) {
            return this;
        }
        return ImmutableOgcApiDataV2.validate(new ImmutableOgcApiDataV2(this.storageVersion, this.id, this.createdAt, this.lastModified, value, this.label, this.description, this.enabled, this.notifications, this.secured, this.apiVersion, this.auto, this.autoPersist, this.serviceType, this.metadata, this.externalDocs, this.defaultExtent, this.defaultCaching, this.apiValidation, this.tags, this.extensions, this.collections));
    }

    public final ImmutableOgcApiDataV2 withLabel(String value) {
        String newValue = Objects.requireNonNull(value, "label");
        if (this.label.equals(newValue)) {
            return this;
        }
        return ImmutableOgcApiDataV2.validate(new ImmutableOgcApiDataV2(this.storageVersion, this.id, this.createdAt, this.lastModified, this.entityStorageVersion, newValue, this.description, this.enabled, this.notifications, this.secured, this.apiVersion, this.auto, this.autoPersist, this.serviceType, this.metadata, this.externalDocs, this.defaultExtent, this.defaultCaching, this.apiValidation, this.tags, this.extensions, this.collections));
    }

    public final ImmutableOgcApiDataV2 withDescription(String value) {
        String newValue = Objects.requireNonNull(value, "description");
        if (Objects.equals(this.description, newValue)) {
            return this;
        }
        return ImmutableOgcApiDataV2.validate(new ImmutableOgcApiDataV2(this.storageVersion, this.id, this.createdAt, this.lastModified, this.entityStorageVersion, this.label, newValue, this.enabled, this.notifications, this.secured, this.apiVersion, this.auto, this.autoPersist, this.serviceType, this.metadata, this.externalDocs, this.defaultExtent, this.defaultCaching, this.apiValidation, this.tags, this.extensions, this.collections));
    }

    public final ImmutableOgcApiDataV2 withDescription(Optional<String> optional) {
        String value = optional.orElse(null);
        if (Objects.equals(this.description, value)) {
            return this;
        }
        return ImmutableOgcApiDataV2.validate(new ImmutableOgcApiDataV2(this.storageVersion, this.id, this.createdAt, this.lastModified, this.entityStorageVersion, this.label, value, this.enabled, this.notifications, this.secured, this.apiVersion, this.auto, this.autoPersist, this.serviceType, this.metadata, this.externalDocs, this.defaultExtent, this.defaultCaching, this.apiValidation, this.tags, this.extensions, this.collections));
    }

    public final ImmutableOgcApiDataV2 withEnabled(boolean value) {
        if (this.enabled == value) {
            return this;
        }
        return ImmutableOgcApiDataV2.validate(new ImmutableOgcApiDataV2(this.storageVersion, this.id, this.createdAt, this.lastModified, this.entityStorageVersion, this.label, this.description, value, this.notifications, this.secured, this.apiVersion, this.auto, this.autoPersist, this.serviceType, this.metadata, this.externalDocs, this.defaultExtent, this.defaultCaching, this.apiValidation, this.tags, this.extensions, this.collections));
    }

    public final ImmutableOgcApiDataV2 withNotifications(Notification ... elements) {
        ImmutableList<Notification> newValue = ImmutableList.copyOf(elements);
        return ImmutableOgcApiDataV2.validate(new ImmutableOgcApiDataV2(this.storageVersion, this.id, this.createdAt, this.lastModified, this.entityStorageVersion, this.label, this.description, this.enabled, newValue, this.secured, this.apiVersion, this.auto, this.autoPersist, this.serviceType, this.metadata, this.externalDocs, this.defaultExtent, this.defaultCaching, this.apiValidation, this.tags, this.extensions, this.collections));
    }

    public final ImmutableOgcApiDataV2 withNotifications(Iterable<? extends Notification> elements) {
        if (this.notifications == elements) {
            return this;
        }
        ImmutableList<Notification> newValue = ImmutableList.copyOf(elements);
        return ImmutableOgcApiDataV2.validate(new ImmutableOgcApiDataV2(this.storageVersion, this.id, this.createdAt, this.lastModified, this.entityStorageVersion, this.label, this.description, this.enabled, newValue, this.secured, this.apiVersion, this.auto, this.autoPersist, this.serviceType, this.metadata, this.externalDocs, this.defaultExtent, this.defaultCaching, this.apiValidation, this.tags, this.extensions, this.collections));
    }

    public final ImmutableOgcApiDataV2 withSecured(boolean value) {
        if (this.secured == value) {
            return this;
        }
        return ImmutableOgcApiDataV2.validate(new ImmutableOgcApiDataV2(this.storageVersion, this.id, this.createdAt, this.lastModified, this.entityStorageVersion, this.label, this.description, this.enabled, this.notifications, value, this.apiVersion, this.auto, this.autoPersist, this.serviceType, this.metadata, this.externalDocs, this.defaultExtent, this.defaultCaching, this.apiValidation, this.tags, this.extensions, this.collections));
    }

    public final ImmutableOgcApiDataV2 withApiVersion(int value) {
        Integer newValue = value;
        if (Objects.equals(this.apiVersion, newValue)) {
            return this;
        }
        return ImmutableOgcApiDataV2.validate(new ImmutableOgcApiDataV2(this.storageVersion, this.id, this.createdAt, this.lastModified, this.entityStorageVersion, this.label, this.description, this.enabled, this.notifications, this.secured, newValue, this.auto, this.autoPersist, this.serviceType, this.metadata, this.externalDocs, this.defaultExtent, this.defaultCaching, this.apiValidation, this.tags, this.extensions, this.collections));
    }

    public final ImmutableOgcApiDataV2 withApiVersion(Optional<Integer> optional) {
        Integer value = optional.orElse(null);
        if (Objects.equals(this.apiVersion, value)) {
            return this;
        }
        return ImmutableOgcApiDataV2.validate(new ImmutableOgcApiDataV2(this.storageVersion, this.id, this.createdAt, this.lastModified, this.entityStorageVersion, this.label, this.description, this.enabled, this.notifications, this.secured, value, this.auto, this.autoPersist, this.serviceType, this.metadata, this.externalDocs, this.defaultExtent, this.defaultCaching, this.apiValidation, this.tags, this.extensions, this.collections));
    }

    public final ImmutableOgcApiDataV2 withAuto(boolean value) {
        Boolean newValue = value;
        if (Objects.equals(this.auto, newValue)) {
            return this;
        }
        return ImmutableOgcApiDataV2.validate(new ImmutableOgcApiDataV2(this.storageVersion, this.id, this.createdAt, this.lastModified, this.entityStorageVersion, this.label, this.description, this.enabled, this.notifications, this.secured, this.apiVersion, newValue, this.autoPersist, this.serviceType, this.metadata, this.externalDocs, this.defaultExtent, this.defaultCaching, this.apiValidation, this.tags, this.extensions, this.collections));
    }

    public final ImmutableOgcApiDataV2 withAuto(Optional<Boolean> optional) {
        Boolean value = optional.orElse(null);
        if (Objects.equals(this.auto, value)) {
            return this;
        }
        return ImmutableOgcApiDataV2.validate(new ImmutableOgcApiDataV2(this.storageVersion, this.id, this.createdAt, this.lastModified, this.entityStorageVersion, this.label, this.description, this.enabled, this.notifications, this.secured, this.apiVersion, value, this.autoPersist, this.serviceType, this.metadata, this.externalDocs, this.defaultExtent, this.defaultCaching, this.apiValidation, this.tags, this.extensions, this.collections));
    }

    public final ImmutableOgcApiDataV2 withAutoPersist(boolean value) {
        Boolean newValue = value;
        if (Objects.equals(this.autoPersist, newValue)) {
            return this;
        }
        return ImmutableOgcApiDataV2.validate(new ImmutableOgcApiDataV2(this.storageVersion, this.id, this.createdAt, this.lastModified, this.entityStorageVersion, this.label, this.description, this.enabled, this.notifications, this.secured, this.apiVersion, this.auto, newValue, this.serviceType, this.metadata, this.externalDocs, this.defaultExtent, this.defaultCaching, this.apiValidation, this.tags, this.extensions, this.collections));
    }

    public final ImmutableOgcApiDataV2 withAutoPersist(Optional<Boolean> optional) {
        Boolean value = optional.orElse(null);
        if (Objects.equals(this.autoPersist, value)) {
            return this;
        }
        return ImmutableOgcApiDataV2.validate(new ImmutableOgcApiDataV2(this.storageVersion, this.id, this.createdAt, this.lastModified, this.entityStorageVersion, this.label, this.description, this.enabled, this.notifications, this.secured, this.apiVersion, this.auto, value, this.serviceType, this.metadata, this.externalDocs, this.defaultExtent, this.defaultCaching, this.apiValidation, this.tags, this.extensions, this.collections));
    }

    public final ImmutableOgcApiDataV2 withServiceType(String value) {
        String newValue = Objects.requireNonNull(value, "serviceType");
        if (this.serviceType.equals(newValue)) {
            return this;
        }
        return ImmutableOgcApiDataV2.validate(new ImmutableOgcApiDataV2(this.storageVersion, this.id, this.createdAt, this.lastModified, this.entityStorageVersion, this.label, this.description, this.enabled, this.notifications, this.secured, this.apiVersion, this.auto, this.autoPersist, newValue, this.metadata, this.externalDocs, this.defaultExtent, this.defaultCaching, this.apiValidation, this.tags, this.extensions, this.collections));
    }

    public final ImmutableOgcApiDataV2 withMetadata(Metadata value) {
        Metadata newValue = Objects.requireNonNull(value, "metadata");
        if (this.metadata == newValue) {
            return this;
        }
        return ImmutableOgcApiDataV2.validate(new ImmutableOgcApiDataV2(this.storageVersion, this.id, this.createdAt, this.lastModified, this.entityStorageVersion, this.label, this.description, this.enabled, this.notifications, this.secured, this.apiVersion, this.auto, this.autoPersist, this.serviceType, newValue, this.externalDocs, this.defaultExtent, this.defaultCaching, this.apiValidation, this.tags, this.extensions, this.collections));
    }

    public final ImmutableOgcApiDataV2 withMetadata(Optional<? extends Metadata> optional) {
        Metadata value = optional.orElse(null);
        if (this.metadata == value) {
            return this;
        }
        return ImmutableOgcApiDataV2.validate(new ImmutableOgcApiDataV2(this.storageVersion, this.id, this.createdAt, this.lastModified, this.entityStorageVersion, this.label, this.description, this.enabled, this.notifications, this.secured, this.apiVersion, this.auto, this.autoPersist, this.serviceType, value, this.externalDocs, this.defaultExtent, this.defaultCaching, this.apiValidation, this.tags, this.extensions, this.collections));
    }

    public final ImmutableOgcApiDataV2 withExternalDocs(ExternalDocumentation value) {
        ExternalDocumentation newValue = Objects.requireNonNull(value, "externalDocs");
        if (this.externalDocs == newValue) {
            return this;
        }
        return ImmutableOgcApiDataV2.validate(new ImmutableOgcApiDataV2(this.storageVersion, this.id, this.createdAt, this.lastModified, this.entityStorageVersion, this.label, this.description, this.enabled, this.notifications, this.secured, this.apiVersion, this.auto, this.autoPersist, this.serviceType, this.metadata, newValue, this.defaultExtent, this.defaultCaching, this.apiValidation, this.tags, this.extensions, this.collections));
    }

    public final ImmutableOgcApiDataV2 withExternalDocs(Optional<? extends ExternalDocumentation> optional) {
        ExternalDocumentation value = optional.orElse(null);
        if (this.externalDocs == value) {
            return this;
        }
        return ImmutableOgcApiDataV2.validate(new ImmutableOgcApiDataV2(this.storageVersion, this.id, this.createdAt, this.lastModified, this.entityStorageVersion, this.label, this.description, this.enabled, this.notifications, this.secured, this.apiVersion, this.auto, this.autoPersist, this.serviceType, this.metadata, value, this.defaultExtent, this.defaultCaching, this.apiValidation, this.tags, this.extensions, this.collections));
    }

    public final ImmutableOgcApiDataV2 withDefaultExtent(CollectionExtent value) {
        CollectionExtent newValue = Objects.requireNonNull(value, "defaultExtent");
        if (this.defaultExtent == newValue) {
            return this;
        }
        return ImmutableOgcApiDataV2.validate(new ImmutableOgcApiDataV2(this.storageVersion, this.id, this.createdAt, this.lastModified, this.entityStorageVersion, this.label, this.description, this.enabled, this.notifications, this.secured, this.apiVersion, this.auto, this.autoPersist, this.serviceType, this.metadata, this.externalDocs, newValue, this.defaultCaching, this.apiValidation, this.tags, this.extensions, this.collections));
    }

    public final ImmutableOgcApiDataV2 withDefaultExtent(Optional<? extends CollectionExtent> optional) {
        CollectionExtent value = optional.orElse(null);
        if (this.defaultExtent == value) {
            return this;
        }
        return ImmutableOgcApiDataV2.validate(new ImmutableOgcApiDataV2(this.storageVersion, this.id, this.createdAt, this.lastModified, this.entityStorageVersion, this.label, this.description, this.enabled, this.notifications, this.secured, this.apiVersion, this.auto, this.autoPersist, this.serviceType, this.metadata, this.externalDocs, value, this.defaultCaching, this.apiValidation, this.tags, this.extensions, this.collections));
    }

    public final ImmutableOgcApiDataV2 withDefaultCaching(Caching value) {
        Caching newValue = Objects.requireNonNull(value, "defaultCaching");
        if (this.defaultCaching == newValue) {
            return this;
        }
        return ImmutableOgcApiDataV2.validate(new ImmutableOgcApiDataV2(this.storageVersion, this.id, this.createdAt, this.lastModified, this.entityStorageVersion, this.label, this.description, this.enabled, this.notifications, this.secured, this.apiVersion, this.auto, this.autoPersist, this.serviceType, this.metadata, this.externalDocs, this.defaultExtent, newValue, this.apiValidation, this.tags, this.extensions, this.collections));
    }

    public final ImmutableOgcApiDataV2 withDefaultCaching(Optional<? extends Caching> optional) {
        Caching value = optional.orElse(null);
        if (this.defaultCaching == value) {
            return this;
        }
        return ImmutableOgcApiDataV2.validate(new ImmutableOgcApiDataV2(this.storageVersion, this.id, this.createdAt, this.lastModified, this.entityStorageVersion, this.label, this.description, this.enabled, this.notifications, this.secured, this.apiVersion, this.auto, this.autoPersist, this.serviceType, this.metadata, this.externalDocs, this.defaultExtent, value, this.apiValidation, this.tags, this.extensions, this.collections));
    }

    public final ImmutableOgcApiDataV2 withApiValidation(ValidationResult.MODE value) {
        if (this.apiValidation == value) {
            return this;
        }
        ValidationResult.MODE newValue = Objects.requireNonNull(value, "apiValidation");
        if (this.apiValidation.equals((Object)newValue)) {
            return this;
        }
        return ImmutableOgcApiDataV2.validate(new ImmutableOgcApiDataV2(this.storageVersion, this.id, this.createdAt, this.lastModified, this.entityStorageVersion, this.label, this.description, this.enabled, this.notifications, this.secured, this.apiVersion, this.auto, this.autoPersist, this.serviceType, this.metadata, this.externalDocs, this.defaultExtent, this.defaultCaching, newValue, this.tags, this.extensions, this.collections));
    }

    public final ImmutableOgcApiDataV2 withTags(String ... elements) {
        ImmutableList<String> newValue = ImmutableList.copyOf(elements);
        return ImmutableOgcApiDataV2.validate(new ImmutableOgcApiDataV2(this.storageVersion, this.id, this.createdAt, this.lastModified, this.entityStorageVersion, this.label, this.description, this.enabled, this.notifications, this.secured, this.apiVersion, this.auto, this.autoPersist, this.serviceType, this.metadata, this.externalDocs, this.defaultExtent, this.defaultCaching, this.apiValidation, newValue, this.extensions, this.collections));
    }

    public final ImmutableOgcApiDataV2 withTags(Iterable<String> elements) {
        if (this.tags == elements) {
            return this;
        }
        ImmutableList<String> newValue = ImmutableList.copyOf(elements);
        return ImmutableOgcApiDataV2.validate(new ImmutableOgcApiDataV2(this.storageVersion, this.id, this.createdAt, this.lastModified, this.entityStorageVersion, this.label, this.description, this.enabled, this.notifications, this.secured, this.apiVersion, this.auto, this.autoPersist, this.serviceType, this.metadata, this.externalDocs, this.defaultExtent, this.defaultCaching, this.apiValidation, newValue, this.extensions, this.collections));
    }

    public final ImmutableOgcApiDataV2 withExtensions(ExtensionConfiguration ... elements) {
        ImmutableList<ExtensionConfiguration> newValue = ImmutableList.copyOf(elements);
        return ImmutableOgcApiDataV2.validate(new ImmutableOgcApiDataV2(this.storageVersion, this.id, this.createdAt, this.lastModified, this.entityStorageVersion, this.label, this.description, this.enabled, this.notifications, this.secured, this.apiVersion, this.auto, this.autoPersist, this.serviceType, this.metadata, this.externalDocs, this.defaultExtent, this.defaultCaching, this.apiValidation, this.tags, newValue, this.collections));
    }

    public final ImmutableOgcApiDataV2 withExtensions(Iterable<? extends ExtensionConfiguration> elements) {
        if (this.extensions == elements) {
            return this;
        }
        ImmutableList<ExtensionConfiguration> newValue = ImmutableList.copyOf(elements);
        return ImmutableOgcApiDataV2.validate(new ImmutableOgcApiDataV2(this.storageVersion, this.id, this.createdAt, this.lastModified, this.entityStorageVersion, this.label, this.description, this.enabled, this.notifications, this.secured, this.apiVersion, this.auto, this.autoPersist, this.serviceType, this.metadata, this.externalDocs, this.defaultExtent, this.defaultCaching, this.apiValidation, this.tags, newValue, this.collections));
    }

    public ImmutableOgcApiDataV2 withCollections(BuildableMap<FeatureTypeConfigurationOgcApi, ImmutableFeatureTypeConfigurationOgcApi.Builder> value) {
        BuildableMap<FeatureTypeConfigurationOgcApi, ImmutableFeatureTypeConfigurationOgcApi.Builder> newValue = value;
        if (this.collections == newValue) {
            return this;
        }
        return ImmutableOgcApiDataV2.validate(new ImmutableOgcApiDataV2(this.storageVersion, this.id, this.createdAt, this.lastModified, this.entityStorageVersion, this.label, this.description, this.enabled, this.notifications, this.secured, this.apiVersion, this.auto, this.autoPersist, this.serviceType, this.metadata, this.externalDocs, this.defaultExtent, this.defaultCaching, this.apiValidation, this.tags, this.extensions, newValue));
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableOgcApiDataV2 && this.equalTo((ImmutableOgcApiDataV2)another);
    }

    private boolean equalTo(ImmutableOgcApiDataV2 another) {
        return this.storageVersion == another.storageVersion && this.id.equals(another.id) && this.createdAt == another.createdAt && this.lastModified == another.lastModified && this.entityStorageVersion == another.entityStorageVersion && this.label.equals(another.label) && Objects.equals(this.description, another.description) && this.enabled == another.enabled && this.notifications.equals(another.notifications) && this.secured == another.secured && Objects.equals(this.apiVersion, another.apiVersion) && Objects.equals(this.auto, another.auto) && Objects.equals(this.autoPersist, another.autoPersist) && this.entitySchemaVersion == another.entitySchemaVersion && this.serviceType.equals(another.serviceType) && Objects.equals(this.metadata, another.metadata) && Objects.equals(this.externalDocs, another.externalDocs) && Objects.equals(this.defaultExtent, another.defaultExtent) && Objects.equals(this.defaultCaching, another.defaultCaching) && this.apiValidation.equals((Object)another.apiValidation) && this.tags.equals(another.tags) && this.extensions.equals(another.extensions) && this.getCollections().equals(another.getCollections()) && this.isLoading == another.isLoading && this.hasError == another.hasError && this.spatialExtent.equals(another.spatialExtent) && this.temporalExtent.equals(another.temporalExtent);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + Longs.hashCode(this.storageVersion);
        h += (h << 5) + this.id.hashCode();
        h += (h << 5) + Longs.hashCode(this.createdAt);
        h += (h << 5) + Longs.hashCode(this.lastModified);
        h += (h << 5) + Longs.hashCode(this.entityStorageVersion);
        h += (h << 5) + this.label.hashCode();
        h += (h << 5) + Objects.hashCode(this.description);
        h += (h << 5) + Booleans.hashCode(this.enabled);
        h += (h << 5) + this.notifications.hashCode();
        h += (h << 5) + Booleans.hashCode(this.secured);
        h += (h << 5) + Objects.hashCode(this.apiVersion);
        h += (h << 5) + Objects.hashCode(this.auto);
        h += (h << 5) + Objects.hashCode(this.autoPersist);
        h += (h << 5) + Longs.hashCode(this.entitySchemaVersion);
        h += (h << 5) + this.serviceType.hashCode();
        h += (h << 5) + Objects.hashCode(this.metadata);
        h += (h << 5) + Objects.hashCode(this.externalDocs);
        h += (h << 5) + Objects.hashCode(this.defaultExtent);
        h += (h << 5) + Objects.hashCode(this.defaultCaching);
        h += (h << 5) + this.apiValidation.hashCode();
        h += (h << 5) + this.tags.hashCode();
        h += (h << 5) + this.extensions.hashCode();
        h += (h << 5) + this.getCollections().hashCode();
        h += (h << 5) + Booleans.hashCode(this.isLoading);
        h += (h << 5) + Booleans.hashCode(this.hasError);
        h += (h << 5) + this.spatialExtent.hashCode();
        h += (h << 5) + this.temporalExtent.hashCode();
        return h;
    }

    public String toString() {
        return MoreObjects.toStringHelper("OgcApiDataV2").omitNullValues().add("storageVersion", this.storageVersion).add("id", this.id).add("createdAt", this.createdAt).add("lastModified", this.lastModified).add("entityStorageVersion", this.entityStorageVersion).add("label", this.label).add("description", this.description).add("enabled", this.enabled).add("notifications", this.notifications).add("secured", this.secured).add("apiVersion", this.apiVersion).add("auto", this.auto).add("autoPersist", this.autoPersist).add("entitySchemaVersion", this.entitySchemaVersion).add("serviceType", this.serviceType).add("metadata", this.metadata).add("externalDocs", this.externalDocs).add("defaultExtent", this.defaultExtent).add("defaultCaching", this.defaultCaching).add("apiValidation", (Object)this.apiValidation).add("tags", this.tags).add("extensions", this.extensions).add("collections", this.getCollections().toString()).add("isLoading", this.isLoading).add("hasError", this.hasError).add("spatialExtent", this.spatialExtent).add("temporalExtent", this.temporalExtent).toString();
    }

    private static ImmutableOgcApiDataV2 validate(ImmutableOgcApiDataV2 instance) {
        instance = (ImmutableOgcApiDataV2)instance.mergeBuildingBlocks();
        return instance;
    }

    public static ImmutableOgcApiDataV2 copyOf(OgcApiDataV2 instance) {
        if (instance instanceof ImmutableOgcApiDataV2) {
            return (ImmutableOgcApiDataV2)instance;
        }
        return new Builder().from(instance).build();
    }

    @Nullable
    private static ImmutableNotification convertToValueTypede_ii_xtraplatform_services_domain_ImmutableNotification(@Nullable ImmutableNotification.Builder builder) {
        if (builder == null) {
            return null;
        }
        return builder.build();
    }

    @Nullable
    private static Notification convertToValueTypede_ii_xtraplatform_services_domain_ImmutableNotification(@Nullable Notification value) {
        if (value == null) {
            return null;
        }
        return new ImmutableNotification.Builder().from(value).build();
    }

    @Nullable
    private static ImmutableNotification.Builder convertToBuilderTypede_ii_xtraplatform_services_domain_ImmutableNotification(@Nullable Notification value) {
        if (value == null) {
            return null;
        }
        return new ImmutableNotification.Builder().from(value);
    }

    @Nullable
    private static ImmutableMetadata convertToValueTypede_ii_ogcapi_foundation_domain_ImmutableMetadata(@Nullable ImmutableMetadata.Builder builder) {
        if (builder == null) {
            return null;
        }
        return builder.build();
    }

    @Nullable
    private static Metadata convertToValueTypede_ii_ogcapi_foundation_domain_ImmutableMetadata(@Nullable Metadata value) {
        if (value == null) {
            return null;
        }
        return new ImmutableMetadata.Builder().from(value).build();
    }

    @Nullable
    private static ImmutableMetadata.Builder convertToBuilderTypede_ii_ogcapi_foundation_domain_ImmutableMetadata(@Nullable Metadata value) {
        if (value == null) {
            return null;
        }
        return new ImmutableMetadata.Builder().from(value);
    }

    @Nullable
    private static ImmutableExternalDocumentation convertToValueTypede_ii_ogcapi_foundation_domain_ImmutableExternalDocumentation(@Nullable ImmutableExternalDocumentation.Builder builder) {
        if (builder == null) {
            return null;
        }
        return builder.build();
    }

    @Nullable
    private static ExternalDocumentation convertToValueTypede_ii_ogcapi_foundation_domain_ImmutableExternalDocumentation(@Nullable ExternalDocumentation value) {
        if (value == null) {
            return null;
        }
        return new ImmutableExternalDocumentation.Builder().from(value).build();
    }

    @Nullable
    private static ImmutableExternalDocumentation.Builder convertToBuilderTypede_ii_ogcapi_foundation_domain_ImmutableExternalDocumentation(@Nullable ExternalDocumentation value) {
        if (value == null) {
            return null;
        }
        return new ImmutableExternalDocumentation.Builder().from(value);
    }

    @Nullable
    private static ImmutableCollectionExtent convertToValueTypede_ii_ogcapi_foundation_domain_ImmutableCollectionExtent(@Nullable ImmutableCollectionExtent.Builder builder) {
        if (builder == null) {
            return null;
        }
        return builder.build();
    }

    @Nullable
    private static CollectionExtent convertToValueTypede_ii_ogcapi_foundation_domain_ImmutableCollectionExtent(@Nullable CollectionExtent value) {
        if (value == null) {
            return null;
        }
        return new ImmutableCollectionExtent.Builder().from(value).build();
    }

    @Nullable
    private static ImmutableCollectionExtent.Builder convertToBuilderTypede_ii_ogcapi_foundation_domain_ImmutableCollectionExtent(@Nullable CollectionExtent value) {
        if (value == null) {
            return null;
        }
        return new ImmutableCollectionExtent.Builder().from(value);
    }

    @Nullable
    private static ImmutableCaching convertToValueTypede_ii_ogcapi_foundation_domain_ImmutableCaching(@Nullable ImmutableCaching.Builder builder) {
        if (builder == null) {
            return null;
        }
        return builder.build();
    }

    @Nullable
    private static Caching convertToValueTypede_ii_ogcapi_foundation_domain_ImmutableCaching(@Nullable Caching value) {
        if (value == null) {
            return null;
        }
        return new ImmutableCaching.Builder().from(value).build();
    }

    @Nullable
    private static ImmutableCaching.Builder convertToBuilderTypede_ii_ogcapi_foundation_domain_ImmutableCaching(@Nullable Caching value) {
        if (value == null) {
            return null;
        }
        return new ImmutableCaching.Builder().from(value);
    }

    private static List<Notification> convertToValueTypede_ii_xtraplatform_services_domain_ImmutableNotification(Iterable<? extends ImmutableNotification.Builder> builderList) {
        ImmutableList.Builder list = ImmutableList.builder();
        for (ImmutableNotification.Builder builder : builderList) {
            list.add(builder.build());
        }
        return list.build();
    }

    private static List<Notification> convertToValueTypede_ii_xtraplatform_services_domain_ImmutableNotification(ImmutableNotification.Builder ... builderArray) {
        ImmutableList.Builder list = ImmutableList.builder();
        for (ImmutableNotification.Builder element : builderArray) {
            list.add(element.build());
        }
        return list.build();
    }

    private static List<ImmutableNotification.Builder> convertToBuilderTypede_ii_xtraplatform_services_domain_ImmutableNotification(Iterable<? extends ImmutableNotification> valueList) {
        ImmutableList.Builder list = ImmutableList.builder();
        for (ImmutableNotification immutableNotification : valueList) {
            list.add(new ImmutableNotification.Builder().from(immutableNotification));
        }
        return list.build();
    }

    private static List<ImmutableNotification.Builder> convertToBuilderTypede_ii_xtraplatform_services_domain_ImmutableNotification(ImmutableNotification ... valueArray) {
        ImmutableList.Builder list = ImmutableList.builder();
        for (ImmutableNotification element : valueArray) {
            list.add(new ImmutableNotification.Builder().from(element));
        }
        return list.build();
    }

    @Generated(from="OgcApiDataV2", generator="Immutables")
    @NotThreadSafe
    public static final class Builder
    extends OgcApiDataV2.Builder {
        private static final long INIT_BIT_ID = 1L;
        private static final long OPT_BIT_STORAGE_VERSION = 1L;
        private static final long OPT_BIT_CREATED_AT = 2L;
        private static final long OPT_BIT_LAST_MODIFIED = 4L;
        private static final long OPT_BIT_ENTITY_STORAGE_VERSION = 8L;
        private static final long OPT_BIT_ENABLED = 16L;
        private static final long OPT_BIT_SECURED = 32L;
        private long initBits = 1L;
        private long optBits;
        private Map<String, ImmutableFeatureTypeConfigurationOgcApi.Builder> collections_builderMap = new LinkedHashMap<String, ImmutableFeatureTypeConfigurationOgcApi.Builder>();
        private long storageVersion;
        @Nullable
        private String id;
        private long createdAt;
        private long lastModified;
        private long entityStorageVersion;
        @Nullable
        private String label;
        @Nullable
        private String description;
        private boolean enabled;
        private ImmutableList.Builder<ImmutableNotification.Builder> notifications = ImmutableList.builder();
        private boolean secured;
        @Nullable
        private Integer apiVersion;
        @Nullable
        private Boolean auto;
        @Nullable
        private Boolean autoPersist;
        @Nullable
        private String serviceType;
        @Nullable
        private ImmutableMetadata.Builder metadata;
        @Nullable
        private ImmutableExternalDocumentation.Builder externalDocs;
        @Nullable
        private ImmutableCollectionExtent.Builder defaultExtent;
        @Nullable
        private ImmutableCaching.Builder defaultCaching;
        @Nullable
        private ValidationResult.MODE apiValidation;
        private ImmutableList.Builder<String> tags = ImmutableList.builder();
        private ImmutableList.Builder<ExtensionConfiguration> extensions = ImmutableList.builder();

        @Override
        @CanIgnoreReturnValue
        public final Builder from(Value instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder from(AutoEntity instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder from(OgcApiDataV2 instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder from(EntityData instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder from(ExtendableConfiguration instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder from(ServiceData instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        private void from(Object object) {
            Optional<Boolean> autoOptional;
            Optional<Boolean> autoPersistOptional;
            Object instance;
            long bits = 0L;
            if (object instanceof Value) {
                instance = (Value)object;
                this.storageVersion(instance.storageVersion());
            }
            if (object instanceof AutoEntity) {
                instance = (AutoEntity)object;
                if ((bits & 1L) == 0L) {
                    autoPersistOptional = instance.getAutoPersist();
                    if (autoPersistOptional.isPresent()) {
                        this.autoPersist(autoPersistOptional);
                    }
                    bits |= 1L;
                }
                if ((bits & 4L) == 0L) {
                    autoOptional = instance.getAuto();
                    if (autoOptional.isPresent()) {
                        this.auto(autoOptional);
                    }
                    bits |= 4L;
                }
            }
            if (object instanceof OgcApiDataV2) {
                Optional<ExternalDocumentation> externalDocsOptional;
                Optional<CollectionExtent> defaultExtentOptional;
                Optional<Metadata> metadataOptional;
                instance = (OgcApiDataV2)object;
                if ((bits & 2L) == 0L) {
                    this.serviceType(((OgcApiDataV2)instance).getServiceType());
                    bits |= 2L;
                }
                if ((metadataOptional = ((OgcApiDataV2)instance).getMetadata()).isPresent()) {
                    this.metadata(metadataOptional);
                }
                if ((bits & 8L) == 0L) {
                    this.addAllExtensions(((OgcApiDataV2)instance).getExtensions());
                    bits |= 8L;
                }
                this.collections(((OgcApiDataV2)instance).getCollections());
                this.apiValidation(((OgcApiDataV2)instance).getApiValidation());
                Optional<Caching> defaultCachingOptional = ((OgcApiDataV2)instance).getDefaultCaching();
                if (defaultCachingOptional.isPresent()) {
                    this.defaultCaching(defaultCachingOptional);
                }
                if ((defaultExtentOptional = ((OgcApiDataV2)instance).getDefaultExtent()).isPresent()) {
                    this.defaultExtent(defaultExtentOptional);
                }
                if ((externalDocsOptional = ((OgcApiDataV2)instance).getExternalDocs()).isPresent()) {
                    this.externalDocs(externalDocsOptional);
                }
                this.addAllTags(((OgcApiDataV2)instance).getTags());
            }
            if (object instanceof EntityData) {
                instance = (EntityData)object;
                this.createdAt(instance.getCreatedAt());
                this.entityStorageVersion(instance.getEntityStorageVersion());
                this.id(instance.getId());
                this.lastModified(instance.getLastModified());
            }
            if (object instanceof ExtendableConfiguration) {
                instance = (ExtendableConfiguration)object;
                if ((bits & 8L) == 0L) {
                    this.addAllExtensions(instance.getExtensions());
                    bits |= 8L;
                }
            }
            if (object instanceof ServiceData) {
                Optional<String> descriptionOptional;
                Optional<Integer> apiVersionOptional;
                instance = (ServiceData)object;
                if ((bits & 1L) == 0L) {
                    autoPersistOptional = instance.getAutoPersist();
                    if (autoPersistOptional.isPresent()) {
                        this.autoPersist(autoPersistOptional);
                    }
                    bits |= 1L;
                }
                if ((bits & 2L) == 0L) {
                    this.serviceType(instance.getServiceType());
                    bits |= 2L;
                }
                if ((bits & 4L) == 0L) {
                    autoOptional = instance.getAuto();
                    if (autoOptional.isPresent()) {
                        this.auto(autoOptional);
                    }
                    bits |= 4L;
                }
                if ((apiVersionOptional = instance.getApiVersion()).isPresent()) {
                    this.apiVersion(apiVersionOptional);
                }
                if ((descriptionOptional = instance.getDescription()).isPresent()) {
                    this.description(descriptionOptional);
                }
                this.label(instance.getLabel());
                this.secured(instance.getSecured());
                this.enabled(instance.getEnabled());
                this.addAllNotifications(instance.getNotifications());
            }
        }

        @JsonProperty(value="storageVersion")
        @JsonIgnore
        @CanIgnoreReturnValue
        public final Builder storageVersion(long storageVersion) {
            this.storageVersion = storageVersion;
            this.optBits |= 1L;
            return this;
        }

        @Override
        @JsonProperty(value="id")
        @CanIgnoreReturnValue
        public final Builder id(String id) {
            this.id = Objects.requireNonNull(id, "id");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        @JsonProperty(value="createdAt")
        @CanIgnoreReturnValue
        public final Builder createdAt(long createdAt) {
            this.createdAt = createdAt;
            this.optBits |= 2L;
            return this;
        }

        @JsonProperty(value="lastModified")
        @CanIgnoreReturnValue
        public final Builder lastModified(long lastModified) {
            this.lastModified = lastModified;
            this.optBits |= 4L;
            return this;
        }

        @JsonProperty(value="entityStorageVersion")
        @CanIgnoreReturnValue
        public final Builder entityStorageVersion(long entityStorageVersion) {
            this.entityStorageVersion = entityStorageVersion;
            this.optBits |= 8L;
            return this;
        }

        @JsonProperty(value="label")
        @CanIgnoreReturnValue
        public final Builder label(String label) {
            this.label = Objects.requireNonNull(label, "label");
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder description(String description) {
            this.description = Objects.requireNonNull(description, "description");
            return this;
        }

        @JsonProperty(value="description")
        @CanIgnoreReturnValue
        public final Builder description(Optional<String> description) {
            this.description = description.orElse(null);
            return this;
        }

        @JsonProperty(value="enabled")
        @JsonAlias(value={"shouldStart"})
        @CanIgnoreReturnValue
        public final Builder enabled(boolean enabled) {
            this.enabled = enabled;
            this.optBits |= 0x10L;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder addNotifications(Notification element) {
            element = Builder.convertToValueTypede_ii_xtraplatform_services_domain_ImmutableNotification(element);
            this.notifications.add((Object)new ImmutableNotification.Builder().from(element));
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder addNotifications(Notification ... elements) {
            for (Notification element : elements) {
                element = Builder.convertToValueTypede_ii_xtraplatform_services_domain_ImmutableNotification(element);
                this.notifications.add((Object)new ImmutableNotification.Builder().from(Objects.requireNonNull(element, "notifications element")));
            }
            return this;
        }

        @CanIgnoreReturnValue
        public final ImmutableNotification.Builder addNotificationsBuilder() {
            ImmutableNotification.Builder builder = new ImmutableNotification.Builder();
            this.notifications.add((Object)builder);
            return builder;
        }

        @CanIgnoreReturnValue
        public final Builder addAllNotificationsBuilders(ImmutableNotification.Builder ... elements) {
            for (ImmutableNotification.Builder element : elements) {
                this.notifications.add((Object)Objects.requireNonNull(element, "notifications element"));
            }
            return this;
        }

        public final List<ImmutableNotification.Builder> notificationsBuilders() {
            return this.notifications.build();
        }

        @JsonProperty(value="notifications")
        @CanIgnoreReturnValue
        public final Builder notifications(Iterable<? extends Notification> elements) {
            this.notifications = ImmutableList.builder();
            return this.addAllNotifications(elements);
        }

        @CanIgnoreReturnValue
        public final Builder addAllNotifications(Iterable<? extends Notification> elements) {
            for (Notification notification : elements) {
                Notification notification2 = Builder.convertToValueTypede_ii_xtraplatform_services_domain_ImmutableNotification(notification);
                this.notifications.add((Object)new ImmutableNotification.Builder().from(Objects.requireNonNull(notification2, "notifications element")));
            }
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder addAllNotificationsBuilders(Iterable<ImmutableNotification.Builder> elements) {
            for (ImmutableNotification.Builder element : elements) {
                this.notifications.add((Object)Objects.requireNonNull(element, "notifications element"));
            }
            return this;
        }

        @JsonProperty(value="secured")
        @CanIgnoreReturnValue
        public final Builder secured(boolean secured) {
            this.secured = secured;
            this.optBits |= 0x20L;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder apiVersion(int apiVersion) {
            this.apiVersion = apiVersion;
            return this;
        }

        @JsonProperty(value="apiVersion")
        @CanIgnoreReturnValue
        public final Builder apiVersion(Optional<Integer> apiVersion) {
            this.apiVersion = apiVersion.orElse(null);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder auto(boolean auto) {
            this.auto = auto;
            return this;
        }

        @JsonProperty(access=JsonProperty.Access.WRITE_ONLY)
        @CanIgnoreReturnValue
        public final Builder auto(Optional<Boolean> auto) {
            this.auto = auto.orElse(null);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder autoPersist(boolean autoPersist) {
            this.autoPersist = autoPersist;
            return this;
        }

        @JsonProperty(access=JsonProperty.Access.WRITE_ONLY)
        @CanIgnoreReturnValue
        public final Builder autoPersist(Optional<Boolean> autoPersist) {
            this.autoPersist = autoPersist.orElse(null);
            return this;
        }

        @JsonProperty(value="serviceType")
        @CanIgnoreReturnValue
        public final Builder serviceType(String serviceType) {
            this.serviceType = Objects.requireNonNull(serviceType, "serviceType");
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder metadata(Metadata metadata) {
            this.metadata = new ImmutableMetadata.Builder().from(Objects.requireNonNull(metadata, "metadata"));
            return this;
        }

        @JsonProperty(value="metadata")
        public final ImmutableMetadata.Builder metadataBuilder() {
            if (this.metadata == null) {
                this.metadata = new ImmutableMetadata.Builder();
            }
            return this.metadata;
        }

        @JsonProperty(value="metadata")
        @CanIgnoreReturnValue
        public final Builder metadataBuilder(ImmutableMetadata.Builder metadata) {
            this.metadata = metadata;
            return this;
        }

        @JsonProperty(value="metadata")
        @CanIgnoreReturnValue
        public final Builder metadata(Optional<? extends Metadata> metadata) {
            this.metadata = Builder.convertToBuilderTypede_ii_ogcapi_foundation_domain_ImmutableMetadata(metadata.orElse(null));
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder externalDocs(ExternalDocumentation externalDocs) {
            this.externalDocs = new ImmutableExternalDocumentation.Builder().from(Objects.requireNonNull(externalDocs, "externalDocs"));
            return this;
        }

        @JsonProperty(value="externalDocs")
        public final ImmutableExternalDocumentation.Builder externalDocsBuilder() {
            if (this.externalDocs == null) {
                this.externalDocs = new ImmutableExternalDocumentation.Builder();
            }
            return this.externalDocs;
        }

        @JsonProperty(value="externalDocs")
        @CanIgnoreReturnValue
        public final Builder externalDocsBuilder(ImmutableExternalDocumentation.Builder externalDocs) {
            this.externalDocs = externalDocs;
            return this;
        }

        @JsonProperty(value="externalDocs")
        @CanIgnoreReturnValue
        public final Builder externalDocs(Optional<? extends ExternalDocumentation> externalDocs) {
            this.externalDocs = Builder.convertToBuilderTypede_ii_ogcapi_foundation_domain_ImmutableExternalDocumentation(externalDocs.orElse(null));
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder defaultExtent(CollectionExtent defaultExtent) {
            this.defaultExtent = new ImmutableCollectionExtent.Builder().from(Objects.requireNonNull(defaultExtent, "defaultExtent"));
            return this;
        }

        @JsonProperty(value="defaultExtent")
        public final ImmutableCollectionExtent.Builder defaultExtentBuilder() {
            if (this.defaultExtent == null) {
                this.defaultExtent = new ImmutableCollectionExtent.Builder();
            }
            return this.defaultExtent;
        }

        @JsonProperty(value="defaultExtent")
        @CanIgnoreReturnValue
        public final Builder defaultExtentBuilder(ImmutableCollectionExtent.Builder defaultExtent) {
            this.defaultExtent = defaultExtent;
            return this;
        }

        @JsonProperty(value="defaultExtent")
        @CanIgnoreReturnValue
        public final Builder defaultExtent(Optional<? extends CollectionExtent> defaultExtent) {
            this.defaultExtent = Builder.convertToBuilderTypede_ii_ogcapi_foundation_domain_ImmutableCollectionExtent(defaultExtent.orElse(null));
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder defaultCaching(Caching defaultCaching) {
            this.defaultCaching = new ImmutableCaching.Builder().from(Objects.requireNonNull(defaultCaching, "defaultCaching"));
            return this;
        }

        @JsonProperty(value="defaultCaching")
        public final ImmutableCaching.Builder defaultCachingBuilder() {
            if (this.defaultCaching == null) {
                this.defaultCaching = new ImmutableCaching.Builder();
            }
            return this.defaultCaching;
        }

        @JsonProperty(value="defaultCaching")
        @CanIgnoreReturnValue
        public final Builder defaultCachingBuilder(ImmutableCaching.Builder defaultCaching) {
            this.defaultCaching = defaultCaching;
            return this;
        }

        @JsonProperty(value="defaultCaching")
        @CanIgnoreReturnValue
        public final Builder defaultCaching(Optional<? extends Caching> defaultCaching) {
            this.defaultCaching = Builder.convertToBuilderTypede_ii_ogcapi_foundation_domain_ImmutableCaching(defaultCaching.orElse(null));
            return this;
        }

        @JsonProperty(value="apiValidation")
        @CanIgnoreReturnValue
        public final Builder apiValidation(ValidationResult.MODE apiValidation) {
            this.apiValidation = Objects.requireNonNull(apiValidation, "apiValidation");
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder addTags(String element) {
            this.tags.add((Object)element);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder addTags(String ... elements) {
            this.tags.add(elements);
            return this;
        }

        @JsonProperty(value="tags")
        @CanIgnoreReturnValue
        public final Builder tags(Iterable<String> elements) {
            this.tags = ImmutableList.builder();
            return this.addAllTags(elements);
        }

        @CanIgnoreReturnValue
        public final Builder addAllTags(Iterable<String> elements) {
            this.tags.addAll((Iterable)elements);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder addExtensions(ExtensionConfiguration element) {
            this.extensions.add((Object)element);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder addExtensions(ExtensionConfiguration ... elements) {
            this.extensions.add(elements);
            return this;
        }

        @Override
        @JsonProperty(value="api")
        @JsonMerge
        @CanIgnoreReturnValue
        public final Builder extensions(Iterable<? extends ExtensionConfiguration> elements) {
            this.extensions = ImmutableList.builder();
            return this.addAllExtensions((Iterable)elements);
        }

        @Override
        @CanIgnoreReturnValue
        public final Builder addAllExtensions(Iterable<? extends ExtensionConfiguration> elements) {
            this.extensions.addAll(elements);
            return this;
        }

        @JsonIgnore
        @JsonProperty(value="collections")
        @CanIgnoreReturnValue
        public Builder collections(Map<String, FeatureTypeConfigurationOgcApi> values) {
            this.collections_builderMap = new LinkedHashMap<String, ImmutableFeatureTypeConfigurationOgcApi.Builder>();
            values.forEach(this::putCollections);
            return this;
        }

        @CanIgnoreReturnValue
        public Builder putCollections(String key, FeatureTypeConfigurationOgcApi value) {
            this.collections_builderMap.put(key, value.getBuilder());
            return this;
        }

        @CanIgnoreReturnValue
        public Builder putCollections(String key, ImmutableFeatureTypeConfigurationOgcApi.Builder builder) {
            this.collections_builderMap.put(key, builder);
            return this;
        }

        @CanIgnoreReturnValue
        public Builder putAllCollections(Map<String, FeatureTypeConfigurationOgcApi> values) {
            values.forEach(this::putCollections);
            return this;
        }

        @JsonProperty
        @CanIgnoreReturnValue
        public Builder setCollections(Map<String, ImmutableFeatureTypeConfigurationOgcApi.Builder> builders) {
            this.collections_builderMap.putAll(builders);
            return this;
        }

        @Override
        public ImmutableOgcApiDataV2 build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return ImmutableOgcApiDataV2.validate(new ImmutableOgcApiDataV2(this));
        }

        private boolean storageVersionIsSet() {
            return (this.optBits & 1L) != 0L;
        }

        private boolean createdAtIsSet() {
            return (this.optBits & 2L) != 0L;
        }

        private boolean lastModifiedIsSet() {
            return (this.optBits & 4L) != 0L;
        }

        private boolean entityStorageVersionIsSet() {
            return (this.optBits & 8L) != 0L;
        }

        private boolean enabledIsSet() {
            return (this.optBits & 0x10L) != 0L;
        }

        private boolean securedIsSet() {
            return (this.optBits & 0x20L) != 0L;
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("id");
            }
            return "Cannot build OgcApiDataV2, some of required attributes are not set " + attributes;
        }

        private BuildableMap<FeatureTypeConfigurationOgcApi, ImmutableFeatureTypeConfigurationOgcApi.Builder> collections_build() {
            return new ImmutableBuildableMap.Builder().builders(this.collections_builderMap).build();
        }

        @JsonProperty
        public Map<String, ImmutableFeatureTypeConfigurationOgcApi.Builder> getCollections() {
            return this.collections_builderMap;
        }

        @Nullable
        private static ImmutableNotification convertToValueTypede_ii_xtraplatform_services_domain_ImmutableNotification(@Nullable ImmutableNotification.Builder builder) {
            if (builder == null) {
                return null;
            }
            return builder.build();
        }

        @Nullable
        private static Notification convertToValueTypede_ii_xtraplatform_services_domain_ImmutableNotification(@Nullable Notification value) {
            if (value == null) {
                return null;
            }
            return new ImmutableNotification.Builder().from(value).build();
        }

        @Nullable
        private static ImmutableNotification.Builder convertToBuilderTypede_ii_xtraplatform_services_domain_ImmutableNotification(@Nullable Notification value) {
            if (value == null) {
                return null;
            }
            return new ImmutableNotification.Builder().from(value);
        }

        @Nullable
        private static ImmutableMetadata convertToValueTypede_ii_ogcapi_foundation_domain_ImmutableMetadata(@Nullable ImmutableMetadata.Builder builder) {
            if (builder == null) {
                return null;
            }
            return builder.build();
        }

        @Nullable
        private static Metadata convertToValueTypede_ii_ogcapi_foundation_domain_ImmutableMetadata(@Nullable Metadata value) {
            if (value == null) {
                return null;
            }
            return new ImmutableMetadata.Builder().from(value).build();
        }

        @Nullable
        private static ImmutableMetadata.Builder convertToBuilderTypede_ii_ogcapi_foundation_domain_ImmutableMetadata(@Nullable Metadata value) {
            if (value == null) {
                return null;
            }
            return new ImmutableMetadata.Builder().from(value);
        }

        @Nullable
        private static ImmutableExternalDocumentation convertToValueTypede_ii_ogcapi_foundation_domain_ImmutableExternalDocumentation(@Nullable ImmutableExternalDocumentation.Builder builder) {
            if (builder == null) {
                return null;
            }
            return builder.build();
        }

        @Nullable
        private static ExternalDocumentation convertToValueTypede_ii_ogcapi_foundation_domain_ImmutableExternalDocumentation(@Nullable ExternalDocumentation value) {
            if (value == null) {
                return null;
            }
            return new ImmutableExternalDocumentation.Builder().from(value).build();
        }

        @Nullable
        private static ImmutableExternalDocumentation.Builder convertToBuilderTypede_ii_ogcapi_foundation_domain_ImmutableExternalDocumentation(@Nullable ExternalDocumentation value) {
            if (value == null) {
                return null;
            }
            return new ImmutableExternalDocumentation.Builder().from(value);
        }

        @Nullable
        private static ImmutableCollectionExtent convertToValueTypede_ii_ogcapi_foundation_domain_ImmutableCollectionExtent(@Nullable ImmutableCollectionExtent.Builder builder) {
            if (builder == null) {
                return null;
            }
            return builder.build();
        }

        @Nullable
        private static CollectionExtent convertToValueTypede_ii_ogcapi_foundation_domain_ImmutableCollectionExtent(@Nullable CollectionExtent value) {
            if (value == null) {
                return null;
            }
            return new ImmutableCollectionExtent.Builder().from(value).build();
        }

        @Nullable
        private static ImmutableCollectionExtent.Builder convertToBuilderTypede_ii_ogcapi_foundation_domain_ImmutableCollectionExtent(@Nullable CollectionExtent value) {
            if (value == null) {
                return null;
            }
            return new ImmutableCollectionExtent.Builder().from(value);
        }

        @Nullable
        private static ImmutableCaching convertToValueTypede_ii_ogcapi_foundation_domain_ImmutableCaching(@Nullable ImmutableCaching.Builder builder) {
            if (builder == null) {
                return null;
            }
            return builder.build();
        }

        @Nullable
        private static Caching convertToValueTypede_ii_ogcapi_foundation_domain_ImmutableCaching(@Nullable Caching value) {
            if (value == null) {
                return null;
            }
            return new ImmutableCaching.Builder().from(value).build();
        }

        @Nullable
        private static ImmutableCaching.Builder convertToBuilderTypede_ii_ogcapi_foundation_domain_ImmutableCaching(@Nullable Caching value) {
            if (value == null) {
                return null;
            }
            return new ImmutableCaching.Builder().from(value);
        }

        private static List<Notification> convertToValueTypede_ii_xtraplatform_services_domain_ImmutableNotification(Iterable<? extends ImmutableNotification.Builder> builderList) {
            ImmutableList.Builder list = ImmutableList.builder();
            for (ImmutableNotification.Builder builder : builderList) {
                list.add(builder.build());
            }
            return list.build();
        }

        private static List<Notification> convertToValueTypede_ii_xtraplatform_services_domain_ImmutableNotification(ImmutableNotification.Builder ... builderArray) {
            ImmutableList.Builder list = ImmutableList.builder();
            for (ImmutableNotification.Builder element : builderArray) {
                list.add(element.build());
            }
            return list.build();
        }

        private static List<ImmutableNotification.Builder> convertToBuilderTypede_ii_xtraplatform_services_domain_ImmutableNotification(Iterable<? extends ImmutableNotification> valueList) {
            ImmutableList.Builder list = ImmutableList.builder();
            for (ImmutableNotification immutableNotification : valueList) {
                list.add(new ImmutableNotification.Builder().from(immutableNotification));
            }
            return list.build();
        }

        private static List<ImmutableNotification.Builder> convertToBuilderTypede_ii_xtraplatform_services_domain_ImmutableNotification(ImmutableNotification ... valueArray) {
            ImmutableList.Builder list = ImmutableList.builder();
            for (ImmutableNotification element : valueArray) {
                list.add(new ImmutableNotification.Builder().from(element));
            }
            return list.build();
        }
    }

    @Generated(from="OgcApiDataV2", generator="Immutables")
    private final class InitShim {
        private byte storageVersionBuildStage = 0;
        private long storageVersion;
        private byte createdAtBuildStage = 0;
        private long createdAt;
        private byte lastModifiedBuildStage = 0;
        private long lastModified;
        private byte entityStorageVersionBuildStage = 0;
        private long entityStorageVersion;
        private byte isAutoBuildStage = 0;
        private boolean isAuto;
        private byte isAutoPersistBuildStage = 0;
        private boolean isAutoPersist;
        private byte labelBuildStage = 0;
        private String label;
        private byte enabledBuildStage = 0;
        private boolean enabled;
        private byte securedBuildStage = 0;
        private boolean secured;
        private byte mergedExtensionsBuildStage = 0;
        private List<ExtensionConfiguration> mergedExtensions;
        private byte entitySchemaVersionBuildStage = 0;
        private long entitySchemaVersion;
        private byte serviceTypeBuildStage = 0;
        private String serviceType;
        private byte apiValidationBuildStage = 0;
        private ValidationResult.MODE apiValidation;
        private byte subPathBuildStage = 0;
        private List<String> subPath;
        private byte isLoadingBuildStage = 0;
        private boolean isLoading;
        private byte hasErrorBuildStage = 0;
        private boolean hasError;
        private byte spatialExtentBuildStage = 0;
        private Optional<BoundingBox> spatialExtent;
        private byte temporalExtentBuildStage = 0;
        private Optional<TemporalExtent> temporalExtent;

        private InitShim() {
        }

        long storageVersion() {
            if (this.storageVersionBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.storageVersionBuildStage == 0) {
                this.storageVersionBuildStage = (byte)-1;
                this.storageVersion = ImmutableOgcApiDataV2.super.storageVersion();
                this.storageVersionBuildStage = 1;
            }
            return this.storageVersion;
        }

        void storageVersion(long storageVersion) {
            this.storageVersion = storageVersion;
            this.storageVersionBuildStage = 1;
        }

        long getCreatedAt() {
            if (this.createdAtBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.createdAtBuildStage == 0) {
                this.createdAtBuildStage = (byte)-1;
                this.createdAt = ImmutableOgcApiDataV2.super.getCreatedAt();
                this.createdAtBuildStage = 1;
            }
            return this.createdAt;
        }

        void createdAt(long createdAt) {
            this.createdAt = createdAt;
            this.createdAtBuildStage = 1;
        }

        long getLastModified() {
            if (this.lastModifiedBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.lastModifiedBuildStage == 0) {
                this.lastModifiedBuildStage = (byte)-1;
                this.lastModified = ImmutableOgcApiDataV2.super.getLastModified();
                this.lastModifiedBuildStage = 1;
            }
            return this.lastModified;
        }

        void lastModified(long lastModified) {
            this.lastModified = lastModified;
            this.lastModifiedBuildStage = 1;
        }

        long getEntityStorageVersion() {
            if (this.entityStorageVersionBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.entityStorageVersionBuildStage == 0) {
                this.entityStorageVersionBuildStage = (byte)-1;
                this.entityStorageVersion = ImmutableOgcApiDataV2.super.getEntityStorageVersion();
                this.entityStorageVersionBuildStage = 1;
            }
            return this.entityStorageVersion;
        }

        void entityStorageVersion(long entityStorageVersion) {
            this.entityStorageVersion = entityStorageVersion;
            this.entityStorageVersionBuildStage = 1;
        }

        boolean isAuto() {
            if (this.isAutoBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.isAutoBuildStage == 0) {
                this.isAutoBuildStage = (byte)-1;
                this.isAuto = ImmutableOgcApiDataV2.super.isAuto();
                this.isAutoBuildStage = 1;
            }
            return this.isAuto;
        }

        boolean isAutoPersist() {
            if (this.isAutoPersistBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.isAutoPersistBuildStage == 0) {
                this.isAutoPersistBuildStage = (byte)-1;
                this.isAutoPersist = ImmutableOgcApiDataV2.super.isAutoPersist();
                this.isAutoPersistBuildStage = 1;
            }
            return this.isAutoPersist;
        }

        String getLabel() {
            if (this.labelBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.labelBuildStage == 0) {
                this.labelBuildStage = (byte)-1;
                this.label = Objects.requireNonNull(ImmutableOgcApiDataV2.super.getLabel(), "label");
                this.labelBuildStage = 1;
            }
            return this.label;
        }

        void label(String label) {
            this.label = label;
            this.labelBuildStage = 1;
        }

        boolean getEnabled() {
            if (this.enabledBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.enabledBuildStage == 0) {
                this.enabledBuildStage = (byte)-1;
                this.enabled = ImmutableOgcApiDataV2.super.getEnabled();
                this.enabledBuildStage = 1;
            }
            return this.enabled;
        }

        void enabled(boolean enabled) {
            this.enabled = enabled;
            this.enabledBuildStage = 1;
        }

        boolean getSecured() {
            if (this.securedBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.securedBuildStage == 0) {
                this.securedBuildStage = (byte)-1;
                this.secured = ImmutableOgcApiDataV2.super.getSecured();
                this.securedBuildStage = 1;
            }
            return this.secured;
        }

        void secured(boolean secured) {
            this.secured = secured;
            this.securedBuildStage = 1;
        }

        List<ExtensionConfiguration> getMergedExtensions() {
            if (this.mergedExtensionsBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.mergedExtensionsBuildStage == 0) {
                this.mergedExtensionsBuildStage = (byte)-1;
                this.mergedExtensions = Objects.requireNonNull(ImmutableOgcApiDataV2.super.getMergedExtensions(), "mergedExtensions");
                this.mergedExtensionsBuildStage = 1;
            }
            return this.mergedExtensions;
        }

        long getEntitySchemaVersion() {
            if (this.entitySchemaVersionBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.entitySchemaVersionBuildStage == 0) {
                this.entitySchemaVersionBuildStage = (byte)-1;
                this.entitySchemaVersion = ImmutableOgcApiDataV2.super.getEntitySchemaVersion();
                this.entitySchemaVersionBuildStage = 1;
            }
            return this.entitySchemaVersion;
        }

        String getServiceType() {
            if (this.serviceTypeBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.serviceTypeBuildStage == 0) {
                this.serviceTypeBuildStage = (byte)-1;
                this.serviceType = Objects.requireNonNull(ImmutableOgcApiDataV2.super.getServiceType(), "serviceType");
                this.serviceTypeBuildStage = 1;
            }
            return this.serviceType;
        }

        void serviceType(String serviceType) {
            this.serviceType = serviceType;
            this.serviceTypeBuildStage = 1;
        }

        ValidationResult.MODE getApiValidation() {
            if (this.apiValidationBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.apiValidationBuildStage == 0) {
                this.apiValidationBuildStage = (byte)-1;
                this.apiValidation = Objects.requireNonNull(ImmutableOgcApiDataV2.super.getApiValidation(), "apiValidation");
                this.apiValidationBuildStage = 1;
            }
            return this.apiValidation;
        }

        void apiValidation(ValidationResult.MODE apiValidation) {
            this.apiValidation = apiValidation;
            this.apiValidationBuildStage = 1;
        }

        List<String> getSubPath() {
            if (this.subPathBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.subPathBuildStage == 0) {
                this.subPathBuildStage = (byte)-1;
                this.subPath = Objects.requireNonNull(ImmutableOgcApiDataV2.super.getSubPath(), "subPath");
                this.subPathBuildStage = 1;
            }
            return this.subPath;
        }

        boolean isLoading() {
            if (this.isLoadingBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.isLoadingBuildStage == 0) {
                this.isLoadingBuildStage = (byte)-1;
                this.isLoading = ImmutableOgcApiDataV2.super.isLoading();
                this.isLoadingBuildStage = 1;
            }
            return this.isLoading;
        }

        boolean hasError() {
            if (this.hasErrorBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.hasErrorBuildStage == 0) {
                this.hasErrorBuildStage = (byte)-1;
                this.hasError = ImmutableOgcApiDataV2.super.hasError();
                this.hasErrorBuildStage = 1;
            }
            return this.hasError;
        }

        Optional<BoundingBox> getSpatialExtent() {
            if (this.spatialExtentBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.spatialExtentBuildStage == 0) {
                this.spatialExtentBuildStage = (byte)-1;
                this.spatialExtent = Objects.requireNonNull(ImmutableOgcApiDataV2.super.getSpatialExtent(), "spatialExtent");
                this.spatialExtentBuildStage = 1;
            }
            return this.spatialExtent;
        }

        Optional<TemporalExtent> getTemporalExtent() {
            if (this.temporalExtentBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.temporalExtentBuildStage == 0) {
                this.temporalExtentBuildStage = (byte)-1;
                this.temporalExtent = Objects.requireNonNull(ImmutableOgcApiDataV2.super.getTemporalExtent(), "temporalExtent");
                this.temporalExtentBuildStage = 1;
            }
            return this.temporalExtent;
        }

        private String formatInitCycleMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if (this.storageVersionBuildStage == -1) {
                attributes.add("storageVersion");
            }
            if (this.createdAtBuildStage == -1) {
                attributes.add("createdAt");
            }
            if (this.lastModifiedBuildStage == -1) {
                attributes.add("lastModified");
            }
            if (this.entityStorageVersionBuildStage == -1) {
                attributes.add("entityStorageVersion");
            }
            if (this.isAutoBuildStage == -1) {
                attributes.add("isAuto");
            }
            if (this.isAutoPersistBuildStage == -1) {
                attributes.add("isAutoPersist");
            }
            if (this.labelBuildStage == -1) {
                attributes.add("label");
            }
            if (this.enabledBuildStage == -1) {
                attributes.add("enabled");
            }
            if (this.securedBuildStage == -1) {
                attributes.add("secured");
            }
            if (this.mergedExtensionsBuildStage == -1) {
                attributes.add("mergedExtensions");
            }
            if (this.entitySchemaVersionBuildStage == -1) {
                attributes.add("entitySchemaVersion");
            }
            if (this.serviceTypeBuildStage == -1) {
                attributes.add("serviceType");
            }
            if (this.apiValidationBuildStage == -1) {
                attributes.add("apiValidation");
            }
            if (this.subPathBuildStage == -1) {
                attributes.add("subPath");
            }
            if (this.isLoadingBuildStage == -1) {
                attributes.add("isLoading");
            }
            if (this.hasErrorBuildStage == -1) {
                attributes.add("hasError");
            }
            if (this.spatialExtentBuildStage == -1) {
                attributes.add("spatialExtent");
            }
            if (this.temporalExtentBuildStage == -1) {
                attributes.add("temporalExtent");
            }
            return "Cannot build OgcApiDataV2, attribute initializers form cycle " + attributes;
        }
    }
}

