/*
 * Decompiled with CFR 0.152.
 */
package de.ii.ogcapi.foundation.domain;

import de.ii.ogcapi.foundation.domain.Link;
import java.util.ArrayList;
import java.util.Objects;
import shadow.com.fasterxml.jackson.annotation.JsonAutoDetect;
import shadow.com.fasterxml.jackson.annotation.JsonCreator;
import shadow.com.fasterxml.jackson.annotation.JsonIgnore;
import shadow.com.fasterxml.jackson.annotation.JsonProperty;
import shadow.com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import shadow.com.google.common.base.MoreObjects;
import shadow.com.google.errorprone.annotations.CanIgnoreReturnValue;
import shadow.javax.annotation.CheckReturnValue;
import shadow.javax.annotation.Nullable;
import shadow.javax.annotation.ParametersAreNonnullByDefault;
import shadow.javax.annotation.concurrent.Immutable;
import shadow.javax.annotation.concurrent.NotThreadSafe;
import shadow.org.immutables.value.Generated;

@ParametersAreNonnullByDefault
@CheckReturnValue
@Generated(from="Link", generator="Immutables")
@Immutable
public final class ImmutableLink
extends Link {
    @Nullable
    private final String rel;
    @Nullable
    private final String type;
    @Nullable
    private final String anchor;
    @Nullable
    private final String title;
    private final String href;
    @Nullable
    private final String hreflang;
    @Nullable
    private final Integer length;
    @Nullable
    private final Boolean templated;
    private final transient String typeLabel;

    private ImmutableLink(@Nullable String rel, @Nullable String type, @Nullable String anchor, @Nullable String title, String href, @Nullable String hreflang, @Nullable Integer length, @Nullable Boolean templated) {
        this.rel = rel;
        this.type = type;
        this.anchor = anchor;
        this.title = title;
        this.href = href;
        this.hreflang = hreflang;
        this.length = length;
        this.templated = templated;
        this.typeLabel = Objects.requireNonNull(super.getTypeLabel(), "typeLabel");
    }

    @Override
    @JsonProperty(value="rel")
    @Nullable
    public String getRel() {
        return this.rel;
    }

    @Override
    @JsonProperty(value="type")
    @Nullable
    public String getType() {
        return this.type;
    }

    @Override
    @JsonProperty(value="anchor")
    @Nullable
    public String getAnchor() {
        return this.anchor;
    }

    @Override
    @JsonProperty(value="title")
    @Nullable
    public String getTitle() {
        return this.title;
    }

    @Override
    @JsonProperty(value="href")
    public String getHref() {
        return this.href;
    }

    @Override
    @JsonProperty(value="hreflang")
    @Nullable
    public String getHreflang() {
        return this.hreflang;
    }

    @Override
    @JsonProperty(value="length")
    @Nullable
    public Integer getLength() {
        return this.length;
    }

    @Override
    @JsonProperty(value="templated")
    @Nullable
    public Boolean getTemplated() {
        return this.templated;
    }

    @Override
    @JsonProperty(value="typeLabel")
    @JsonIgnore
    public String getTypeLabel() {
        return this.typeLabel;
    }

    public final ImmutableLink withRel(@Nullable String value) {
        if (Objects.equals(this.rel, value)) {
            return this;
        }
        return new ImmutableLink(value, this.type, this.anchor, this.title, this.href, this.hreflang, this.length, this.templated);
    }

    public final ImmutableLink withType(@Nullable String value) {
        if (Objects.equals(this.type, value)) {
            return this;
        }
        return new ImmutableLink(this.rel, value, this.anchor, this.title, this.href, this.hreflang, this.length, this.templated);
    }

    public final ImmutableLink withAnchor(@Nullable String value) {
        if (Objects.equals(this.anchor, value)) {
            return this;
        }
        return new ImmutableLink(this.rel, this.type, value, this.title, this.href, this.hreflang, this.length, this.templated);
    }

    public final ImmutableLink withTitle(@Nullable String value) {
        if (Objects.equals(this.title, value)) {
            return this;
        }
        return new ImmutableLink(this.rel, this.type, this.anchor, value, this.href, this.hreflang, this.length, this.templated);
    }

    public final ImmutableLink withHref(String value) {
        String newValue = Objects.requireNonNull(value, "href");
        if (this.href.equals(newValue)) {
            return this;
        }
        return new ImmutableLink(this.rel, this.type, this.anchor, this.title, newValue, this.hreflang, this.length, this.templated);
    }

    public final ImmutableLink withHreflang(@Nullable String value) {
        if (Objects.equals(this.hreflang, value)) {
            return this;
        }
        return new ImmutableLink(this.rel, this.type, this.anchor, this.title, this.href, value, this.length, this.templated);
    }

    public final ImmutableLink withLength(@Nullable Integer value) {
        if (Objects.equals(this.length, value)) {
            return this;
        }
        return new ImmutableLink(this.rel, this.type, this.anchor, this.title, this.href, this.hreflang, value, this.templated);
    }

    public final ImmutableLink withTemplated(@Nullable Boolean value) {
        if (Objects.equals(this.templated, value)) {
            return this;
        }
        return new ImmutableLink(this.rel, this.type, this.anchor, this.title, this.href, this.hreflang, this.length, value);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableLink && this.equalTo((ImmutableLink)another);
    }

    private boolean equalTo(ImmutableLink another) {
        return Objects.equals(this.rel, another.rel) && Objects.equals(this.type, another.type) && Objects.equals(this.anchor, another.anchor) && Objects.equals(this.title, another.title) && this.href.equals(another.href) && Objects.equals(this.hreflang, another.hreflang) && Objects.equals(this.length, another.length) && Objects.equals(this.templated, another.templated) && this.typeLabel.equals(another.typeLabel);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + Objects.hashCode(this.rel);
        h += (h << 5) + Objects.hashCode(this.type);
        h += (h << 5) + Objects.hashCode(this.anchor);
        h += (h << 5) + Objects.hashCode(this.title);
        h += (h << 5) + this.href.hashCode();
        h += (h << 5) + Objects.hashCode(this.hreflang);
        h += (h << 5) + Objects.hashCode(this.length);
        h += (h << 5) + Objects.hashCode(this.templated);
        h += (h << 5) + this.typeLabel.hashCode();
        return h;
    }

    public String toString() {
        return MoreObjects.toStringHelper("Link").omitNullValues().add("rel", this.rel).add("type", this.type).add("anchor", this.anchor).add("title", this.title).add("href", this.href).add("hreflang", this.hreflang).add("length", this.length).add("templated", this.templated).add("typeLabel", this.typeLabel).toString();
    }

    @Deprecated
    @JsonCreator(mode=JsonCreator.Mode.DELEGATING)
    static ImmutableLink fromJson(Json json) {
        Builder builder = new Builder();
        if (json.rel != null) {
            builder.rel(json.rel);
        }
        if (json.type != null) {
            builder.type(json.type);
        }
        if (json.anchor != null) {
            builder.anchor(json.anchor);
        }
        if (json.title != null) {
            builder.title(json.title);
        }
        if (json.href != null) {
            builder.href(json.href);
        }
        if (json.hreflang != null) {
            builder.hreflang(json.hreflang);
        }
        if (json.length != null) {
            builder.length(json.length);
        }
        if (json.templated != null) {
            builder.templated(json.templated);
        }
        return builder.build();
    }

    public static ImmutableLink copyOf(Link instance) {
        if (instance instanceof ImmutableLink) {
            return (ImmutableLink)instance;
        }
        return new Builder().from(instance).build();
    }

    @Generated(from="Link", generator="Immutables")
    @NotThreadSafe
    public static final class Builder {
        private static final long INIT_BIT_HREF = 1L;
        private long initBits = 1L;
        @Nullable
        private String rel;
        @Nullable
        private String type;
        @Nullable
        private String anchor;
        @Nullable
        private String title;
        @Nullable
        private String href;
        @Nullable
        private String hreflang;
        @Nullable
        private Integer length;
        @Nullable
        private Boolean templated;

        @CanIgnoreReturnValue
        public final Builder from(Link instance) {
            Boolean templatedValue;
            Integer lengthValue;
            String titleValue;
            String anchorValue;
            String typeValue;
            Objects.requireNonNull(instance, "instance");
            String relValue = instance.getRel();
            if (relValue != null) {
                this.rel(relValue);
            }
            if ((typeValue = instance.getType()) != null) {
                this.type(typeValue);
            }
            if ((anchorValue = instance.getAnchor()) != null) {
                this.anchor(anchorValue);
            }
            if ((titleValue = instance.getTitle()) != null) {
                this.title(titleValue);
            }
            this.href(instance.getHref());
            String hreflangValue = instance.getHreflang();
            if (hreflangValue != null) {
                this.hreflang(hreflangValue);
            }
            if ((lengthValue = instance.getLength()) != null) {
                this.length(lengthValue);
            }
            if ((templatedValue = instance.getTemplated()) != null) {
                this.templated(templatedValue);
            }
            return this;
        }

        @JsonProperty(value="rel")
        @CanIgnoreReturnValue
        public final Builder rel(@Nullable String rel) {
            this.rel = rel;
            return this;
        }

        @JsonProperty(value="type")
        @CanIgnoreReturnValue
        public final Builder type(@Nullable String type) {
            this.type = type;
            return this;
        }

        @JsonProperty(value="anchor")
        @CanIgnoreReturnValue
        public final Builder anchor(@Nullable String anchor) {
            this.anchor = anchor;
            return this;
        }

        @JsonProperty(value="title")
        @CanIgnoreReturnValue
        public final Builder title(@Nullable String title) {
            this.title = title;
            return this;
        }

        @JsonProperty(value="href")
        @CanIgnoreReturnValue
        public final Builder href(String href) {
            this.href = Objects.requireNonNull(href, "href");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        @JsonProperty(value="hreflang")
        @CanIgnoreReturnValue
        public final Builder hreflang(@Nullable String hreflang) {
            this.hreflang = hreflang;
            return this;
        }

        @JsonProperty(value="length")
        @CanIgnoreReturnValue
        public final Builder length(@Nullable Integer length) {
            this.length = length;
            return this;
        }

        @JsonProperty(value="templated")
        @CanIgnoreReturnValue
        public final Builder templated(@Nullable Boolean templated) {
            this.templated = templated;
            return this;
        }

        public ImmutableLink build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableLink(this.rel, this.type, this.anchor, this.title, this.href, this.hreflang, this.length, this.templated);
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("href");
            }
            return "Cannot build Link, some of required attributes are not set " + attributes;
        }
    }

    @Deprecated
    @JsonDeserialize
    @JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.NONE)
    @Generated(from="Link", generator="Immutables")
    static final class Json
    extends Link {
        @Nullable
        String rel;
        @Nullable
        String type;
        @Nullable
        String anchor;
        @Nullable
        String title;
        @Nullable
        String href;
        @Nullable
        String hreflang;
        @Nullable
        Integer length;
        @Nullable
        Boolean templated;

        Json() {
        }

        @JsonProperty(value="rel")
        public void setRel(@Nullable String rel) {
            this.rel = rel;
        }

        @JsonProperty(value="type")
        public void setType(@Nullable String type) {
            this.type = type;
        }

        @JsonProperty(value="anchor")
        public void setAnchor(@Nullable String anchor) {
            this.anchor = anchor;
        }

        @JsonProperty(value="title")
        public void setTitle(@Nullable String title) {
            this.title = title;
        }

        @JsonProperty(value="href")
        public void setHref(String href) {
            this.href = href;
        }

        @JsonProperty(value="hreflang")
        public void setHreflang(@Nullable String hreflang) {
            this.hreflang = hreflang;
        }

        @JsonProperty(value="length")
        public void setLength(@Nullable Integer length) {
            this.length = length;
        }

        @JsonProperty(value="templated")
        public void setTemplated(@Nullable Boolean templated) {
            this.templated = templated;
        }

        @Override
        public String getRel() {
            throw new UnsupportedOperationException();
        }

        @Override
        public String getType() {
            throw new UnsupportedOperationException();
        }

        @Override
        public String getAnchor() {
            throw new UnsupportedOperationException();
        }

        @Override
        public String getTitle() {
            throw new UnsupportedOperationException();
        }

        @Override
        public String getHref() {
            throw new UnsupportedOperationException();
        }

        @Override
        public String getHreflang() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Integer getLength() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Boolean getTemplated() {
            throw new UnsupportedOperationException();
        }

        @Override
        @JsonIgnore
        public String getTypeLabel() {
            throw new UnsupportedOperationException();
        }
    }
}

