/*
 * Decompiled with CFR 0.152.
 */
package de.ii.ogcapi.foundation.domain;

import de.ii.ogcapi.foundation.domain.ExtensionConfiguration;
import de.ii.ogcapi.foundation.domain.FoundationConfiguration;
import java.util.Objects;
import java.util.Optional;
import shadow.com.fasterxml.jackson.annotation.JsonIgnore;
import shadow.com.fasterxml.jackson.annotation.JsonProperty;
import shadow.com.google.common.base.MoreObjects;
import shadow.com.google.errorprone.annotations.CanIgnoreReturnValue;
import shadow.javax.annotation.CheckReturnValue;
import shadow.javax.annotation.Nullable;
import shadow.javax.annotation.ParametersAreNonnullByDefault;
import shadow.javax.annotation.concurrent.Immutable;
import shadow.javax.annotation.concurrent.NotThreadSafe;
import shadow.org.immutables.value.Generated;

@ParametersAreNonnullByDefault
@CheckReturnValue
@Generated(from="FoundationConfiguration", generator="Immutables")
@Immutable
public final class ImmutableFoundationConfiguration
implements FoundationConfiguration {
    @Nullable
    private final Boolean enabled;
    private final transient boolean isEnabled;
    @Nullable
    private final ExtensionConfiguration defaultValues;
    @Nullable
    private final Boolean useLangParameter;
    @Nullable
    private final Boolean includeLinkHeader;
    @Nullable
    private final String apiCatalogLabel;
    @Nullable
    private final String apiCatalogDescription;
    @Nullable
    private final String googleSiteVerification;

    private ImmutableFoundationConfiguration(@Nullable Boolean enabled, @Nullable ExtensionConfiguration defaultValues, @Nullable Boolean useLangParameter, @Nullable Boolean includeLinkHeader, @Nullable String apiCatalogLabel, @Nullable String apiCatalogDescription, @Nullable String googleSiteVerification) {
        this.enabled = enabled;
        this.defaultValues = defaultValues;
        this.useLangParameter = useLangParameter;
        this.includeLinkHeader = includeLinkHeader;
        this.apiCatalogLabel = apiCatalogLabel;
        this.apiCatalogDescription = apiCatalogDescription;
        this.googleSiteVerification = googleSiteVerification;
        this.isEnabled = FoundationConfiguration.super.isEnabled();
    }

    @Override
    @JsonProperty(value="enabled")
    @Nullable
    public Boolean getEnabled() {
        return this.enabled;
    }

    @Override
    @JsonProperty(value="isEnabled")
    @JsonIgnore
    public boolean isEnabled() {
        return this.isEnabled;
    }

    @Override
    @JsonProperty(value="defaultValues")
    @JsonIgnore
    public Optional<ExtensionConfiguration> getDefaultValues() {
        return Optional.ofNullable(this.defaultValues);
    }

    @Override
    @JsonProperty(value="useLangParameter")
    @Nullable
    public Boolean getUseLangParameter() {
        return this.useLangParameter;
    }

    @Override
    @JsonProperty(value="includeLinkHeader")
    @Nullable
    public Boolean getIncludeLinkHeader() {
        return this.includeLinkHeader;
    }

    @Override
    @JsonProperty(value="apiCatalogLabel")
    @Nullable
    public String getApiCatalogLabel() {
        return this.apiCatalogLabel;
    }

    @Override
    @JsonProperty(value="apiCatalogDescription")
    @Nullable
    public String getApiCatalogDescription() {
        return this.apiCatalogDescription;
    }

    @Override
    @JsonProperty(value="googleSiteVerification")
    @Nullable
    public String getGoogleSiteVerification() {
        return this.googleSiteVerification;
    }

    public final ImmutableFoundationConfiguration withEnabled(@Nullable Boolean value) {
        if (Objects.equals(this.enabled, value)) {
            return this;
        }
        return new ImmutableFoundationConfiguration(value, this.defaultValues, this.useLangParameter, this.includeLinkHeader, this.apiCatalogLabel, this.apiCatalogDescription, this.googleSiteVerification);
    }

    public final ImmutableFoundationConfiguration withDefaultValues(ExtensionConfiguration value) {
        ExtensionConfiguration newValue = Objects.requireNonNull(value, "defaultValues");
        if (this.defaultValues == newValue) {
            return this;
        }
        return new ImmutableFoundationConfiguration(this.enabled, newValue, this.useLangParameter, this.includeLinkHeader, this.apiCatalogLabel, this.apiCatalogDescription, this.googleSiteVerification);
    }

    public final ImmutableFoundationConfiguration withDefaultValues(Optional<? extends ExtensionConfiguration> optional) {
        ExtensionConfiguration value = optional.orElse(null);
        if (this.defaultValues == value) {
            return this;
        }
        return new ImmutableFoundationConfiguration(this.enabled, value, this.useLangParameter, this.includeLinkHeader, this.apiCatalogLabel, this.apiCatalogDescription, this.googleSiteVerification);
    }

    public final ImmutableFoundationConfiguration withUseLangParameter(@Nullable Boolean value) {
        if (Objects.equals(this.useLangParameter, value)) {
            return this;
        }
        return new ImmutableFoundationConfiguration(this.enabled, this.defaultValues, value, this.includeLinkHeader, this.apiCatalogLabel, this.apiCatalogDescription, this.googleSiteVerification);
    }

    public final ImmutableFoundationConfiguration withIncludeLinkHeader(@Nullable Boolean value) {
        if (Objects.equals(this.includeLinkHeader, value)) {
            return this;
        }
        return new ImmutableFoundationConfiguration(this.enabled, this.defaultValues, this.useLangParameter, value, this.apiCatalogLabel, this.apiCatalogDescription, this.googleSiteVerification);
    }

    public final ImmutableFoundationConfiguration withApiCatalogLabel(@Nullable String value) {
        if (Objects.equals(this.apiCatalogLabel, value)) {
            return this;
        }
        return new ImmutableFoundationConfiguration(this.enabled, this.defaultValues, this.useLangParameter, this.includeLinkHeader, value, this.apiCatalogDescription, this.googleSiteVerification);
    }

    public final ImmutableFoundationConfiguration withApiCatalogDescription(@Nullable String value) {
        if (Objects.equals(this.apiCatalogDescription, value)) {
            return this;
        }
        return new ImmutableFoundationConfiguration(this.enabled, this.defaultValues, this.useLangParameter, this.includeLinkHeader, this.apiCatalogLabel, value, this.googleSiteVerification);
    }

    public final ImmutableFoundationConfiguration withGoogleSiteVerification(@Nullable String value) {
        if (Objects.equals(this.googleSiteVerification, value)) {
            return this;
        }
        return new ImmutableFoundationConfiguration(this.enabled, this.defaultValues, this.useLangParameter, this.includeLinkHeader, this.apiCatalogLabel, this.apiCatalogDescription, value);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableFoundationConfiguration && this.equalTo((ImmutableFoundationConfiguration)another);
    }

    private boolean equalTo(ImmutableFoundationConfiguration another) {
        return Objects.equals(this.enabled, another.enabled) && Objects.equals(this.useLangParameter, another.useLangParameter) && Objects.equals(this.includeLinkHeader, another.includeLinkHeader) && Objects.equals(this.apiCatalogLabel, another.apiCatalogLabel) && Objects.equals(this.apiCatalogDescription, another.apiCatalogDescription) && Objects.equals(this.googleSiteVerification, another.googleSiteVerification);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + Objects.hashCode(this.enabled);
        h += (h << 5) + Objects.hashCode(this.useLangParameter);
        h += (h << 5) + Objects.hashCode(this.includeLinkHeader);
        h += (h << 5) + Objects.hashCode(this.apiCatalogLabel);
        h += (h << 5) + Objects.hashCode(this.apiCatalogDescription);
        h += (h << 5) + Objects.hashCode(this.googleSiteVerification);
        return h;
    }

    public String toString() {
        return MoreObjects.toStringHelper("FoundationConfiguration").omitNullValues().add("enabled", this.enabled).add("useLangParameter", this.useLangParameter).add("includeLinkHeader", this.includeLinkHeader).add("apiCatalogLabel", this.apiCatalogLabel).add("apiCatalogDescription", this.apiCatalogDescription).add("googleSiteVerification", this.googleSiteVerification).toString();
    }

    public static ImmutableFoundationConfiguration copyOf(FoundationConfiguration instance) {
        if (instance instanceof ImmutableFoundationConfiguration) {
            return (ImmutableFoundationConfiguration)instance;
        }
        return new Builder().from(instance).build();
    }

    @Generated(from="FoundationConfiguration", generator="Immutables")
    @NotThreadSafe
    public static final class Builder
    extends FoundationConfiguration.Builder {
        @Nullable
        private Boolean enabled;
        @Nullable
        private ExtensionConfiguration defaultValues;
        @Nullable
        private Boolean useLangParameter;
        @Nullable
        private Boolean includeLinkHeader;
        @Nullable
        private String apiCatalogLabel;
        @Nullable
        private String apiCatalogDescription;
        @Nullable
        private String googleSiteVerification;

        @Override
        @CanIgnoreReturnValue
        public final Builder from(ExtensionConfiguration instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        @Override
        @CanIgnoreReturnValue
        public final Builder from(FoundationConfiguration instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        @Override
        private void from(Object object) {
            ExtensionConfiguration instance;
            if (object instanceof ExtensionConfiguration) {
                Boolean enabledValue;
                instance = (ExtensionConfiguration)object;
                Optional<ExtensionConfiguration> defaultValuesOptional = instance.getDefaultValues();
                if (defaultValuesOptional.isPresent()) {
                    this.defaultValues(defaultValuesOptional);
                }
                if ((enabledValue = instance.getEnabled()) != null) {
                    this.enabled(enabledValue);
                }
            }
            if (object instanceof FoundationConfiguration) {
                Boolean useLangParameterValue;
                String googleSiteVerificationValue;
                Boolean includeLinkHeaderValue;
                String apiCatalogLabelValue;
                instance = (FoundationConfiguration)object;
                String apiCatalogDescriptionValue = instance.getApiCatalogDescription();
                if (apiCatalogDescriptionValue != null) {
                    this.apiCatalogDescription(apiCatalogDescriptionValue);
                }
                if ((apiCatalogLabelValue = instance.getApiCatalogLabel()) != null) {
                    this.apiCatalogLabel(apiCatalogLabelValue);
                }
                if ((includeLinkHeaderValue = instance.getIncludeLinkHeader()) != null) {
                    this.includeLinkHeader(includeLinkHeaderValue);
                }
                if ((googleSiteVerificationValue = instance.getGoogleSiteVerification()) != null) {
                    this.googleSiteVerification(googleSiteVerificationValue);
                }
                if ((useLangParameterValue = instance.getUseLangParameter()) != null) {
                    this.useLangParameter(useLangParameterValue);
                }
            }
        }

        @JsonProperty(value="enabled")
        @CanIgnoreReturnValue
        public final Builder enabled(@Nullable Boolean enabled) {
            this.enabled = enabled;
            return this;
        }

        @Override
        @CanIgnoreReturnValue
        public final Builder defaultValues(ExtensionConfiguration defaultValues) {
            this.defaultValues = Objects.requireNonNull(defaultValues, "defaultValues");
            return this;
        }

        @JsonProperty(value="defaultValues")
        @JsonIgnore
        @CanIgnoreReturnValue
        public final Builder defaultValues(Optional<? extends ExtensionConfiguration> defaultValues) {
            this.defaultValues = defaultValues.orElse(null);
            return this;
        }

        @JsonProperty(value="useLangParameter")
        @CanIgnoreReturnValue
        public final Builder useLangParameter(@Nullable Boolean useLangParameter) {
            this.useLangParameter = useLangParameter;
            return this;
        }

        @JsonProperty(value="includeLinkHeader")
        @CanIgnoreReturnValue
        public final Builder includeLinkHeader(@Nullable Boolean includeLinkHeader) {
            this.includeLinkHeader = includeLinkHeader;
            return this;
        }

        @JsonProperty(value="apiCatalogLabel")
        @CanIgnoreReturnValue
        public final Builder apiCatalogLabel(@Nullable String apiCatalogLabel) {
            this.apiCatalogLabel = apiCatalogLabel;
            return this;
        }

        @JsonProperty(value="apiCatalogDescription")
        @CanIgnoreReturnValue
        public final Builder apiCatalogDescription(@Nullable String apiCatalogDescription) {
            this.apiCatalogDescription = apiCatalogDescription;
            return this;
        }

        @JsonProperty(value="googleSiteVerification")
        @CanIgnoreReturnValue
        public final Builder googleSiteVerification(@Nullable String googleSiteVerification) {
            this.googleSiteVerification = googleSiteVerification;
            return this;
        }

        @Override
        public ImmutableFoundationConfiguration build() {
            return new ImmutableFoundationConfiguration(this.enabled, this.defaultValues, this.useLangParameter, this.includeLinkHeader, this.apiCatalogLabel, this.apiCatalogDescription, this.googleSiteVerification);
        }
    }
}

