/*
 * Decompiled with CFR 0.152.
 */
package de.ii.ogcapi.foundation.domain;

import de.ii.ogcapi.foundation.domain.Example;
import java.util.Objects;
import java.util.Optional;
import shadow.com.fasterxml.jackson.annotation.JsonProperty;
import shadow.com.google.common.base.MoreObjects;
import shadow.com.google.errorprone.annotations.CanIgnoreReturnValue;
import shadow.javax.annotation.CheckReturnValue;
import shadow.javax.annotation.Nullable;
import shadow.javax.annotation.ParametersAreNonnullByDefault;
import shadow.javax.annotation.concurrent.Immutable;
import shadow.javax.annotation.concurrent.NotThreadSafe;
import shadow.org.immutables.value.Generated;

@ParametersAreNonnullByDefault
@CheckReturnValue
@Generated(from="Example", generator="Immutables")
@Immutable
public final class ImmutableExample
implements Example {
    @Nullable
    private final String summary;
    @Nullable
    private final String description;
    @Nullable
    private final Object value;
    @Nullable
    private final String externalValue;

    private ImmutableExample(@Nullable String summary, @Nullable String description, @Nullable Object value, @Nullable String externalValue) {
        this.summary = summary;
        this.description = description;
        this.value = value;
        this.externalValue = externalValue;
    }

    @Override
    @JsonProperty(value="summary")
    public Optional<String> getSummary() {
        return Optional.ofNullable(this.summary);
    }

    @Override
    @JsonProperty(value="description")
    public Optional<String> getDescription() {
        return Optional.ofNullable(this.description);
    }

    @Override
    @JsonProperty(value="value")
    public Optional<Object> getValue() {
        return Optional.ofNullable(this.value);
    }

    @Override
    @JsonProperty(value="externalValue")
    public Optional<String> getExternalValue() {
        return Optional.ofNullable(this.externalValue);
    }

    public final ImmutableExample withSummary(String value) {
        String newValue = Objects.requireNonNull(value, "summary");
        if (Objects.equals(this.summary, newValue)) {
            return this;
        }
        return new ImmutableExample(newValue, this.description, this.value, this.externalValue);
    }

    public final ImmutableExample withSummary(Optional<String> optional) {
        String value = optional.orElse(null);
        if (Objects.equals(this.summary, value)) {
            return this;
        }
        return new ImmutableExample(value, this.description, this.value, this.externalValue);
    }

    public final ImmutableExample withDescription(String value) {
        String newValue = Objects.requireNonNull(value, "description");
        if (Objects.equals(this.description, newValue)) {
            return this;
        }
        return new ImmutableExample(this.summary, newValue, this.value, this.externalValue);
    }

    public final ImmutableExample withDescription(Optional<String> optional) {
        String value = optional.orElse(null);
        if (Objects.equals(this.description, value)) {
            return this;
        }
        return new ImmutableExample(this.summary, value, this.value, this.externalValue);
    }

    public final ImmutableExample withValue(Object value) {
        Object newValue = Objects.requireNonNull(value, "value");
        if (this.value == newValue) {
            return this;
        }
        return new ImmutableExample(this.summary, this.description, newValue, this.externalValue);
    }

    public final ImmutableExample withValue(Optional<? extends Object> optional) {
        Object value = optional.orElse(null);
        if (this.value == value) {
            return this;
        }
        return new ImmutableExample(this.summary, this.description, value, this.externalValue);
    }

    public final ImmutableExample withExternalValue(String value) {
        String newValue = Objects.requireNonNull(value, "externalValue");
        if (Objects.equals(this.externalValue, newValue)) {
            return this;
        }
        return new ImmutableExample(this.summary, this.description, this.value, newValue);
    }

    public final ImmutableExample withExternalValue(Optional<String> optional) {
        String value = optional.orElse(null);
        if (Objects.equals(this.externalValue, value)) {
            return this;
        }
        return new ImmutableExample(this.summary, this.description, this.value, value);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableExample && this.equalTo((ImmutableExample)another);
    }

    private boolean equalTo(ImmutableExample another) {
        return Objects.equals(this.summary, another.summary) && Objects.equals(this.description, another.description) && Objects.equals(this.value, another.value) && Objects.equals(this.externalValue, another.externalValue);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + Objects.hashCode(this.summary);
        h += (h << 5) + Objects.hashCode(this.description);
        h += (h << 5) + Objects.hashCode(this.value);
        h += (h << 5) + Objects.hashCode(this.externalValue);
        return h;
    }

    public String toString() {
        return MoreObjects.toStringHelper("Example").omitNullValues().add("summary", this.summary).add("description", this.description).add("value", this.value).add("externalValue", this.externalValue).toString();
    }

    public static ImmutableExample copyOf(Example instance) {
        if (instance instanceof ImmutableExample) {
            return (ImmutableExample)instance;
        }
        return new Builder().from(instance).build();
    }

    @Generated(from="Example", generator="Immutables")
    @NotThreadSafe
    public static final class Builder {
        @Nullable
        private String summary;
        @Nullable
        private String description;
        @Nullable
        private Object value;
        @Nullable
        private String externalValue;

        @CanIgnoreReturnValue
        public final Builder from(Example instance) {
            Optional<String> externalValueOptional;
            Optional<Object> valueOptional;
            Optional<String> descriptionOptional;
            Objects.requireNonNull(instance, "instance");
            Optional<String> summaryOptional = instance.getSummary();
            if (summaryOptional.isPresent()) {
                this.summary(summaryOptional);
            }
            if ((descriptionOptional = instance.getDescription()).isPresent()) {
                this.description(descriptionOptional);
            }
            if ((valueOptional = instance.getValue()).isPresent()) {
                this.value(valueOptional);
            }
            if ((externalValueOptional = instance.getExternalValue()).isPresent()) {
                this.externalValue(externalValueOptional);
            }
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder summary(String summary) {
            this.summary = Objects.requireNonNull(summary, "summary");
            return this;
        }

        @JsonProperty(value="summary")
        @CanIgnoreReturnValue
        public final Builder summary(Optional<String> summary) {
            this.summary = summary.orElse(null);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder description(String description) {
            this.description = Objects.requireNonNull(description, "description");
            return this;
        }

        @JsonProperty(value="description")
        @CanIgnoreReturnValue
        public final Builder description(Optional<String> description) {
            this.description = description.orElse(null);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder value(Object value) {
            this.value = Objects.requireNonNull(value, "value");
            return this;
        }

        @JsonProperty(value="value")
        @CanIgnoreReturnValue
        public final Builder value(Optional<? extends Object> value) {
            this.value = value.orElse(null);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder externalValue(String externalValue) {
            this.externalValue = Objects.requireNonNull(externalValue, "externalValue");
            return this;
        }

        @JsonProperty(value="externalValue")
        @CanIgnoreReturnValue
        public final Builder externalValue(Optional<String> externalValue) {
            this.externalValue = externalValue.orElse(null);
            return this;
        }

        public ImmutableExample build() {
            return new ImmutableExample(this.summary, this.description, this.value, this.externalValue);
        }
    }
}

