/*
 * Decompiled with CFR 0.152.
 */
package de.ii.ogcapi.foundation.domain;

import de.ii.ogcapi.foundation.domain.Caching;
import java.util.Date;
import java.util.Objects;
import shadow.com.fasterxml.jackson.annotation.JsonProperty;
import shadow.com.google.common.base.MoreObjects;
import shadow.com.google.errorprone.annotations.CanIgnoreReturnValue;
import shadow.javax.annotation.CheckReturnValue;
import shadow.javax.annotation.Nullable;
import shadow.javax.annotation.ParametersAreNonnullByDefault;
import shadow.javax.annotation.concurrent.Immutable;
import shadow.javax.annotation.concurrent.NotThreadSafe;
import shadow.org.immutables.value.Generated;

@ParametersAreNonnullByDefault
@CheckReturnValue
@Generated(from="Caching", generator="Immutables")
@Immutable
public final class ImmutableCaching
implements Caching {
    @Nullable
    private final Date lastModified;
    @Nullable
    private final Date expires;
    @Nullable
    private final String cacheControl;
    @Nullable
    private final String cacheControlItems;

    private ImmutableCaching(@Nullable Date lastModified, @Nullable Date expires, @Nullable String cacheControl, @Nullable String cacheControlItems) {
        this.lastModified = lastModified;
        this.expires = expires;
        this.cacheControl = cacheControl;
        this.cacheControlItems = cacheControlItems;
    }

    @Override
    @JsonProperty(value="lastModified")
    @Nullable
    public Date getLastModified() {
        return this.lastModified;
    }

    @Override
    @JsonProperty(value="expires")
    @Nullable
    public Date getExpires() {
        return this.expires;
    }

    @Override
    @JsonProperty(value="cacheControl")
    @Nullable
    public String getCacheControl() {
        return this.cacheControl;
    }

    @Override
    @JsonProperty(value="cacheControlItems")
    @Nullable
    public String getCacheControlItems() {
        return this.cacheControlItems;
    }

    public final ImmutableCaching withLastModified(@Nullable Date value) {
        if (this.lastModified == value) {
            return this;
        }
        return new ImmutableCaching(value, this.expires, this.cacheControl, this.cacheControlItems);
    }

    public final ImmutableCaching withExpires(@Nullable Date value) {
        if (this.expires == value) {
            return this;
        }
        return new ImmutableCaching(this.lastModified, value, this.cacheControl, this.cacheControlItems);
    }

    public final ImmutableCaching withCacheControl(@Nullable String value) {
        if (Objects.equals(this.cacheControl, value)) {
            return this;
        }
        return new ImmutableCaching(this.lastModified, this.expires, value, this.cacheControlItems);
    }

    public final ImmutableCaching withCacheControlItems(@Nullable String value) {
        if (Objects.equals(this.cacheControlItems, value)) {
            return this;
        }
        return new ImmutableCaching(this.lastModified, this.expires, this.cacheControl, value);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableCaching && this.equalTo((ImmutableCaching)another);
    }

    private boolean equalTo(ImmutableCaching another) {
        return Objects.equals(this.lastModified, another.lastModified) && Objects.equals(this.expires, another.expires) && Objects.equals(this.cacheControl, another.cacheControl) && Objects.equals(this.cacheControlItems, another.cacheControlItems);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + Objects.hashCode(this.lastModified);
        h += (h << 5) + Objects.hashCode(this.expires);
        h += (h << 5) + Objects.hashCode(this.cacheControl);
        h += (h << 5) + Objects.hashCode(this.cacheControlItems);
        return h;
    }

    public String toString() {
        return MoreObjects.toStringHelper("Caching").omitNullValues().add("lastModified", this.lastModified).add("expires", this.expires).add("cacheControl", this.cacheControl).add("cacheControlItems", this.cacheControlItems).toString();
    }

    public static ImmutableCaching copyOf(Caching instance) {
        if (instance instanceof ImmutableCaching) {
            return (ImmutableCaching)instance;
        }
        return new Builder().from(instance).build();
    }

    @Generated(from="Caching", generator="Immutables")
    @NotThreadSafe
    public static final class Builder {
        @Nullable
        private Date lastModified;
        @Nullable
        private Date expires;
        @Nullable
        private String cacheControl;
        @Nullable
        private String cacheControlItems;

        @CanIgnoreReturnValue
        public final Builder from(Caching instance) {
            String cacheControlItemsValue;
            String cacheControlValue;
            Date expiresValue;
            Objects.requireNonNull(instance, "instance");
            Date lastModifiedValue = instance.getLastModified();
            if (lastModifiedValue != null) {
                this.lastModified(lastModifiedValue);
            }
            if ((expiresValue = instance.getExpires()) != null) {
                this.expires(expiresValue);
            }
            if ((cacheControlValue = instance.getCacheControl()) != null) {
                this.cacheControl(cacheControlValue);
            }
            if ((cacheControlItemsValue = instance.getCacheControlItems()) != null) {
                this.cacheControlItems(cacheControlItemsValue);
            }
            return this;
        }

        @JsonProperty(value="lastModified")
        @CanIgnoreReturnValue
        public final Builder lastModified(@Nullable Date lastModified) {
            this.lastModified = lastModified;
            return this;
        }

        @JsonProperty(value="expires")
        @CanIgnoreReturnValue
        public final Builder expires(@Nullable Date expires) {
            this.expires = expires;
            return this;
        }

        @JsonProperty(value="cacheControl")
        @CanIgnoreReturnValue
        public final Builder cacheControl(@Nullable String cacheControl) {
            this.cacheControl = cacheControl;
            return this;
        }

        @JsonProperty(value="cacheControlItems")
        @CanIgnoreReturnValue
        public final Builder cacheControlItems(@Nullable String cacheControlItems) {
            this.cacheControlItems = cacheControlItems;
            return this;
        }

        public ImmutableCaching build() {
            return new ImmutableCaching(this.lastModified, this.expires, this.cacheControl, this.cacheControlItems);
        }
    }
}

