/*
 * Decompiled with CFR 0.152.
 */
package de.ii.ogcapi.foundation.domain;

import de.ii.ogcapi.foundation.domain.ExtensionConfiguration;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import shadow.com.fasterxml.jackson.annotation.JsonAlias;
import shadow.com.fasterxml.jackson.annotation.JsonIgnore;
import shadow.org.immutables.value.Value;

public interface ExtendableConfiguration {
    @JsonAlias(value={"capabilities"})
    public List<ExtensionConfiguration> getExtensions();

    default public <T extends ExtensionConfiguration> Optional<T> getExtension(Class<T> clazz) {
        return this.getMergedExtensions().stream().filter(extensionConfiguration -> Objects.equals(extensionConfiguration.getBuildingBlock(), ExtensionConfiguration.getBuildingBlockIdentifier(clazz))).filter(Objects::nonNull).findFirst().map(extensionConfiguration -> extensionConfiguration);
    }

    @JsonIgnore
    @Value.Derived
    @Value.Auxiliary
    default public List<ExtensionConfiguration> getMergedExtensions() {
        return this.getMergedExtensions(this.getExtensions());
    }

    default public List<ExtensionConfiguration> getMergedExtensions(List<ExtensionConfiguration> extensions) {
        LinkedHashMap mergedExtensions = new LinkedHashMap();
        extensions.forEach(extensionConfiguration -> {
            String buildingBlock = extensionConfiguration.getBuildingBlock();
            if (mergedExtensions.containsKey(buildingBlock)) {
                mergedExtensions.put(buildingBlock, extensionConfiguration.mergeInto((ExtensionConfiguration)mergedExtensions.get(buildingBlock)));
            } else {
                mergedExtensions.put(buildingBlock, extensionConfiguration);
            }
        });
        return mergedExtensions.values().stream().map(extensionConfiguration -> extensionConfiguration.getDefaultValues().isPresent() ? extensionConfiguration.mergeInto(extensionConfiguration.getDefaultValues().get()) : extensionConfiguration).collect(Collectors.toList());
    }
}

