/*
 * Decompiled with CFR 0.152.
 */
package de.ii.ogcapi.foundation.domain;

import de.ii.ogcapi.foundation.domain.ExtendableConfiguration;
import de.ii.ogcapi.foundation.domain.ExtensionConfiguration;
import de.ii.ogcapi.foundation.domain.FoundationConfiguration;
import de.ii.ogcapi.foundation.domain.OgcApiDataV2;
import de.ii.xtraplatform.store.domain.entities.ValidationResult;
import java.util.Objects;
import java.util.function.Predicate;
import shadow.com.github.azahnen.dagger.annotations.AutoMultiBind;

@AutoMultiBind
public interface ApiExtension {
    default public boolean isEnabledForApi(OgcApiDataV2 apiData) {
        return this.isExtensionEnabled(apiData, this.getBuildingBlockConfigurationType());
    }

    default public boolean isEnabledForApi(OgcApiDataV2 apiData, String collectionId) {
        return this.isExtensionEnabled((ExtendableConfiguration)apiData.getCollections().get(collectionId), this.getBuildingBlockConfigurationType());
    }

    default public Class<? extends ExtensionConfiguration> getBuildingBlockConfigurationType() {
        return FoundationConfiguration.class;
    }

    default public <T extends ExtensionConfiguration> boolean isExtensionEnabled(ExtendableConfiguration extendableConfiguration, Class<T> clazz) {
        return Objects.nonNull(extendableConfiguration) && extendableConfiguration.getExtension(clazz).filter(ExtensionConfiguration::isEnabled).isPresent();
    }

    default public <T extends ExtensionConfiguration> boolean isExtensionEnabled(ExtendableConfiguration extendableConfiguration, Class<T> clazz, Predicate<T> predicate) {
        return Objects.nonNull(extendableConfiguration) && extendableConfiguration.getExtension(clazz).filter(ExtensionConfiguration::isEnabled).filter(predicate).isPresent();
    }

    default public ValidationResult onStartup(OgcApiDataV2 apiData, ValidationResult.MODE apiValidation) {
        return ValidationResult.of();
    }
}

