/*
 * Decompiled with CFR 0.152.
 */
package de.ii.ogcapi.foundation.app;

import dagger.assisted.AssistedFactory;
import de.ii.ogcapi.foundation.app.OgcApiEntity;
import de.ii.ogcapi.foundation.domain.ApiBuildingBlock;
import de.ii.ogcapi.foundation.domain.ExtensionConfiguration;
import de.ii.ogcapi.foundation.domain.ExtensionRegistry;
import de.ii.ogcapi.foundation.domain.ImmutableCollectionExtent;
import de.ii.ogcapi.foundation.domain.ImmutableMetadata;
import de.ii.ogcapi.foundation.domain.ImmutableOgcApiDataV2;
import de.ii.ogcapi.foundation.domain.Metadata;
import de.ii.ogcapi.foundation.domain.OgcApiDataHydratorExtension;
import de.ii.ogcapi.foundation.domain.OgcApiDataV2;
import de.ii.xtraplatform.store.domain.KeyPathAlias;
import de.ii.xtraplatform.store.domain.KeyPathAliasUnwrap;
import de.ii.xtraplatform.store.domain.entities.AbstractEntityFactory;
import de.ii.xtraplatform.store.domain.entities.EntityData;
import de.ii.xtraplatform.store.domain.entities.EntityDataBuilder;
import de.ii.xtraplatform.store.domain.entities.EntityFactory;
import de.ii.xtraplatform.store.domain.entities.PersistentEntity;
import java.util.AbstractMap;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import shadow.com.github.azahnen.dagger.annotations.AutoBind;
import shadow.com.google.common.collect.ImmutableList;
import shadow.com.google.common.collect.ImmutableMap;
import shadow.javax.inject.Inject;
import shadow.javax.inject.Singleton;

@Singleton
@AutoBind
public class OgcApiFactory
extends AbstractEntityFactory<OgcApiDataV2, OgcApiEntity>
implements EntityFactory {
    private static final Logger LOGGER = LoggerFactory.getLogger(OgcApiFactory.class);
    private final ExtensionRegistry extensionRegistry;

    @Inject
    public OgcApiFactory(ExtensionRegistry extensionRegistry, OgcApiFactoryAssisted ogcApiFactoryAssisted) {
        super(ogcApiFactoryAssisted);
        this.extensionRegistry = extensionRegistry;
    }

    @Override
    public String type() {
        return "services";
    }

    @Override
    public Optional<String> subType() {
        return Optional.of("OGC_API");
    }

    @Override
    public Class<? extends PersistentEntity> entityClass() {
        return OgcApiEntity.class;
    }

    public EntityDataBuilder<OgcApiDataV2> dataBuilder() {
        return new ImmutableOgcApiDataV2.Builder().enabled(true).secured(true).metadata(this.getMetadata()).defaultExtent(new ImmutableCollectionExtent.Builder().spatialComputed(true).temporalComputed(true).build()).extensions(this.getBuildingBlocks());
    }

    @Override
    public Class<? extends EntityData> dataClass() {
        return OgcApiDataV2.class;
    }

    @Override
    public EntityData hydrateData(EntityData entityData) {
        OgcApiDataV2 hydrated = (OgcApiDataV2)entityData;
        if (hydrated.isAuto()) {
            LOGGER.info("Service with id '{}' is in auto mode, generating configuration ...", (Object)hydrated.getId());
        }
        List<OgcApiDataHydratorExtension> extensions = this.extensionRegistry.getExtensionsForType(OgcApiDataHydratorExtension.class);
        extensions.sort(Comparator.comparing(OgcApiDataHydratorExtension::getSortPriority));
        for (OgcApiDataHydratorExtension hydrator : extensions) {
            if (!hydrator.isEnabledForApi(hydrated)) continue;
            hydrated = hydrator.getHydratedData(hydrated);
        }
        return hydrated;
    }

    @Override
    public Optional<KeyPathAlias> getKeyPathAlias(String keyPath) {
        return this.getAliases().entrySet().stream().filter(entry -> Objects.equals(keyPath, entry.getKey())).map(Map.Entry::getValue).findFirst();
    }

    private Metadata getMetadata() {
        return new ImmutableMetadata.Builder().build();
    }

    private List<ExtensionConfiguration> getBuildingBlocks() {
        return this.extensionRegistry.getExtensionsForType(ApiBuildingBlock.class).stream().map(ApiBuildingBlock::getDefaultConfiguration).collect(Collectors.toList());
    }

    private Map<String, KeyPathAlias> getAliases() {
        return this.extensionRegistry.getExtensionsForType(ApiBuildingBlock.class).stream().map(ogcApiBuildingBlock -> ogcApiBuildingBlock.getDefaultConfiguration().getBuildingBlock()).map(buildingBlock -> new AbstractMap.SimpleImmutableEntry<String, KeyPathAlias>(buildingBlock.toLowerCase(), value -> ImmutableMap.of("api", ImmutableList.of(ImmutableMap.builder().put("buildingBlock", (String)buildingBlock).putAll(value).build())))).collect(ImmutableMap.toImmutableMap(Map.Entry::getKey, Map.Entry::getValue));
    }

    private Map<String, KeyPathAliasUnwrap> getReverseAliases() {
        return ImmutableMap.of("api", value -> ((List)value).stream().map(buildingBlock -> new AbstractMap.SimpleImmutableEntry<String, Map>(((String)buildingBlock.get("buildingBlock")).toLowerCase(), (Map)buildingBlock)).collect(ImmutableMap.toImmutableMap(Map.Entry::getKey, Map.Entry::getValue)));
    }

    @AssistedFactory
    public static interface OgcApiFactoryAssisted
    extends AbstractEntityFactory.FactoryAssisted<OgcApiDataV2, OgcApiEntity> {
        @Override
        public OgcApiEntity create(OgcApiDataV2 var1);
    }
}

