/*
 * Decompiled with CFR 0.152.
 */
package de.ii.ogcapi.foundation.app;

import dagger.assisted.Assisted;
import dagger.assisted.AssistedInject;
import de.ii.ogcapi.foundation.domain.ApiExtension;
import de.ii.ogcapi.foundation.domain.ApiMediaType;
import de.ii.ogcapi.foundation.domain.ExtensionRegistry;
import de.ii.ogcapi.foundation.domain.FormatExtension;
import de.ii.ogcapi.foundation.domain.OgcApi;
import de.ii.ogcapi.foundation.domain.OgcApiDataV2;
import de.ii.xtraplatform.services.domain.AbstractService;
import de.ii.xtraplatform.store.domain.entities.ValidationResult;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OgcApiEntity
extends AbstractService<OgcApiDataV2>
implements OgcApi {
    private static final Logger LOGGER = LoggerFactory.getLogger(OgcApiEntity.class);
    private final ExtensionRegistry extensionRegistry;

    @AssistedInject
    public OgcApiEntity(ExtensionRegistry extensionRegistry, @Assisted OgcApiDataV2 data) {
        super(data);
        this.extensionRegistry = extensionRegistry;
    }

    @Override
    public OgcApiDataV2 getData() {
        return (OgcApiDataV2)super.getData();
    }

    @Override
    protected boolean onStartup() throws InterruptedException {
        boolean isSuccess = true;
        OgcApiDataV2 apiData = this.getData();
        ValidationResult.MODE apiValidation = apiData.getApiValidation();
        if (apiValidation != ValidationResult.MODE.NONE) {
            LOGGER.info("Validating service '{}'.", (Object)apiData.getId());
        }
        for (ApiExtension extension : this.extensionRegistry.getExtensions()) {
            if (extension.isEnabledForApi(apiData)) {
                ValidationResult result = extension.onStartup(this.getData(), apiValidation);
                isSuccess = isSuccess && result.isSuccess();
                result.getErrors().forEach(LOGGER::error);
                result.getStrictErrors().forEach(result.getMode() == ValidationResult.MODE.STRICT ? LOGGER::error : LOGGER::warn);
                result.getWarnings().forEach(LOGGER::warn);
            }
            this.checkForStartupCancel();
        }
        if (!isSuccess) {
            LOGGER.error("Service with id '{}' could not be started. See previous log messages for reasons.", (Object)apiData.getId());
        }
        return isSuccess;
    }

    @Override
    public <T extends FormatExtension> Optional<T> getOutputFormat(Class<T> extensionType, ApiMediaType mediaType, String path, Optional<String> collectionId) {
        return this.extensionRegistry.getExtensionsForType(extensionType).stream().filter(outputFormatExtension -> path.matches(outputFormatExtension.getPathPattern())).filter(outputFormatExtension -> mediaType.type().isCompatible(outputFormatExtension.getMediaType().type())).filter(outputFormatExtension -> collectionId.isPresent() ? outputFormatExtension.isEnabledForApi(this.getData(), (String)collectionId.get()) : outputFormatExtension.isEnabledForApi(this.getData())).findFirst();
    }

    @Override
    public <T extends FormatExtension> List<T> getAllOutputFormats(Class<T> extensionType, ApiMediaType mediaType, String path, Optional<T> excludeFormat) {
        return this.extensionRegistry.getExtensionsForType(extensionType).stream().filter(outputFormatExtension -> !Objects.equals(outputFormatExtension, excludeFormat.orElse(null))).filter(outputFormatExtension -> path.matches(outputFormatExtension.getPathPattern())).filter(outputFormatExtension -> mediaType.type().isCompatible(outputFormatExtension.getMediaType().type())).filter(outputFormatExtension -> outputFormatExtension.isEnabledForApi(this.getData())).collect(Collectors.toList());
    }
}

