/*
 * Decompiled with CFR 0.152.
 */
package de.ii.ogcapi.features.html.domain;

import de.ii.ogcapi.features.html.domain.ImmutableFeaturesHtmlConfiguration;
import de.ii.ogcapi.foundation.domain.ExtensionConfiguration;
import de.ii.ogcapi.html.domain.MapClient;
import de.ii.xtraplatform.features.domain.transform.ImmutablePropertyTransformation;
import de.ii.xtraplatform.features.domain.transform.PropertyTransformation;
import de.ii.xtraplatform.features.domain.transform.PropertyTransformations;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import shadow.com.fasterxml.jackson.annotation.JsonAlias;
import shadow.com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import shadow.com.fasterxml.jackson.databind.annotation.JsonSerialize;
import shadow.com.fasterxml.jackson.databind.util.StdConverter;
import shadow.com.google.common.collect.ImmutableMap;
import shadow.javax.annotation.Nullable;
import shadow.org.immutables.value.Value;

@JsonDeserialize(builder=ImmutableFeaturesHtmlConfiguration.Builder.class)
@Value.Immutable
@Value.Style(builder="new", attributeBuilderDetection=true)
public interface FeaturesHtmlConfiguration
extends ExtensionConfiguration,
PropertyTransformations {
    public static final String LINK_WILDCARD = "*{objectType=Link}";

    @Deprecated(since="3.1.0")
    @Nullable
    public LAYOUT getLayout();

    @Nullable
    public POSITION getMapPosition();

    @JsonAlias(value={"itemLabelFormat"})
    public Optional<String> getFeatureTitleTemplate();

    @Override
    @JsonSerialize(converter=IgnoreLinksWildcardSerializer.class)
    public Map<String, List<PropertyTransformation>> getTransformations();

    @Nullable
    public MapClient.Type getMapClientType();

    @Nullable
    public String getStyle();

    @Nullable
    public Boolean getRemoveZoomLevelConstraints();

    @Nullable
    public List<String> getGeometryProperties();

    @Nullable
    public Integer getMaximumPageSize();

    @Value.Check
    default public FeaturesHtmlConfiguration backwardsCompatibility() {
        if (this.getLayout() == LAYOUT.CLASSIC && !this.hasTransformation("*", transformations -> transformations.getFlatten().isPresent())) {
            Map<String, List<PropertyTransformation>> transformations2 = this.withTransformation("*", new ImmutablePropertyTransformation.Builder().flatten(".").build());
            return new ImmutableFeaturesHtmlConfiguration.Builder().from(this).mapPosition(POSITION.RIGHT).transformations(transformations2).build();
        }
        if (this.getLayout() == LAYOUT.COMPLEX_OBJECTS && this.getMapPosition() != POSITION.TOP) {
            return new ImmutableFeaturesHtmlConfiguration.Builder().from(this).mapPosition(POSITION.TOP).build();
        }
        return this;
    }

    @Value.Check
    default public FeaturesHtmlConfiguration transformLinks() {
        if (!this.hasTransformation(LINK_WILDCARD, transformation -> transformation.getReduceStringFormat().isPresent())) {
            Map<String, List<PropertyTransformation>> transformations = this.withTransformation(LINK_WILDCARD, new ImmutablePropertyTransformation.Builder().reduceStringFormat("<a href=\"{{href}}\">{{title}}</a>").build());
            return new ImmutableFeaturesHtmlConfiguration.Builder().from(this).transformations(transformations).build();
        }
        return this;
    }

    default public Builder getBuilder() {
        return new ImmutableFeaturesHtmlConfiguration.Builder();
    }

    @Override
    default public ExtensionConfiguration mergeInto(ExtensionConfiguration source) {
        return new ImmutableFeaturesHtmlConfiguration.Builder().from(source).from(this).transformations(PropertyTransformations.super.mergeInto((PropertyTransformations)((Object)source)).getTransformations()).build();
    }

    public static class IgnoreLinksWildcardSerializer
    extends StdConverter<Map<String, List<PropertyTransformation>>, Map<String, List<PropertyTransformation>>> {
        @Override
        public Map<String, List<PropertyTransformation>> convert(Map<String, List<PropertyTransformation>> value) {
            if (value.containsKey(FeaturesHtmlConfiguration.LINK_WILDCARD) && value.get(FeaturesHtmlConfiguration.LINK_WILDCARD).stream().anyMatch(transformation -> transformation.getReduceStringFormat().isPresent())) {
                return value.entrySet().stream().filter(entry -> !Objects.equals(entry.getKey(), FeaturesHtmlConfiguration.LINK_WILDCARD) || ((List)entry.getValue()).size() != 1 || ((PropertyTransformation)((List)entry.getValue()).get(0)).getReduceStringFormat().isEmpty()).collect(ImmutableMap.toImmutableMap(Map.Entry::getKey, Map.Entry::getValue));
            }
            return value;
        }
    }

    public static enum POSITION {
        AUTO,
        TOP,
        RIGHT;

    }

    public static enum LAYOUT {
        CLASSIC,
        COMPLEX_OBJECTS;

    }

    public static abstract class Builder
    extends ExtensionConfiguration.Builder {
    }
}

