/*
 * Decompiled with CFR 0.152.
 */
package de.ii.ogcapi.features.geojson.ld.domain;

import de.ii.ogcapi.features.geojson.ld.domain.GeoJsonLdConfiguration;
import de.ii.ogcapi.foundation.domain.ExtensionConfiguration;
import java.util.Objects;
import java.util.Optional;
import shadow.com.fasterxml.jackson.annotation.JsonIgnore;
import shadow.com.fasterxml.jackson.annotation.JsonProperty;
import shadow.com.google.common.base.MoreObjects;
import shadow.com.google.common.collect.ImmutableList;
import shadow.com.google.errorprone.annotations.CanIgnoreReturnValue;
import shadow.javax.annotation.CheckReturnValue;
import shadow.javax.annotation.Nullable;
import shadow.javax.annotation.ParametersAreNonnullByDefault;
import shadow.javax.annotation.concurrent.Immutable;
import shadow.javax.annotation.concurrent.NotThreadSafe;
import shadow.org.immutables.value.Generated;

@ParametersAreNonnullByDefault
@CheckReturnValue
@Generated(from="GeoJsonLdConfiguration", generator="Immutables")
@Immutable
public final class ImmutableGeoJsonLdConfiguration
implements GeoJsonLdConfiguration {
    @Nullable
    private final Boolean enabled;
    private final transient boolean isEnabled;
    @Nullable
    private final ExtensionConfiguration defaultValues;
    @Nullable
    private final String contextFileName;
    @Nullable
    private final String context;
    private final ImmutableList<String> types;
    @Nullable
    private final String idTemplate;

    private ImmutableGeoJsonLdConfiguration(@Nullable Boolean enabled, @Nullable ExtensionConfiguration defaultValues, @Nullable String contextFileName, @Nullable String context, ImmutableList<String> types, @Nullable String idTemplate) {
        this.enabled = enabled;
        this.defaultValues = defaultValues;
        this.contextFileName = contextFileName;
        this.context = context;
        this.types = types;
        this.idTemplate = idTemplate;
        this.isEnabled = GeoJsonLdConfiguration.super.isEnabled();
    }

    @Override
    @JsonProperty(value="enabled")
    @Nullable
    public Boolean getEnabled() {
        return this.enabled;
    }

    @Override
    @JsonProperty(value="isEnabled")
    @JsonIgnore
    public boolean isEnabled() {
        return this.isEnabled;
    }

    @Override
    @JsonProperty(value="defaultValues")
    @JsonIgnore
    public Optional<ExtensionConfiguration> getDefaultValues() {
        return Optional.ofNullable(this.defaultValues);
    }

    @Override
    @JsonProperty(value="contextFileName")
    @Nullable
    public String getContextFileName() {
        return this.contextFileName;
    }

    @Override
    @JsonProperty(value="context")
    @Nullable
    public String getContext() {
        return this.context;
    }

    @JsonProperty(value="types")
    public ImmutableList<String> getTypes() {
        return this.types;
    }

    @Override
    @JsonProperty(value="idTemplate")
    public Optional<String> getIdTemplate() {
        return Optional.ofNullable(this.idTemplate);
    }

    public final ImmutableGeoJsonLdConfiguration withEnabled(@Nullable Boolean value) {
        if (Objects.equals(this.enabled, value)) {
            return this;
        }
        return new ImmutableGeoJsonLdConfiguration(value, this.defaultValues, this.contextFileName, this.context, this.types, this.idTemplate);
    }

    public final ImmutableGeoJsonLdConfiguration withDefaultValues(ExtensionConfiguration value) {
        ExtensionConfiguration newValue = Objects.requireNonNull(value, "defaultValues");
        if (this.defaultValues == newValue) {
            return this;
        }
        return new ImmutableGeoJsonLdConfiguration(this.enabled, newValue, this.contextFileName, this.context, this.types, this.idTemplate);
    }

    public final ImmutableGeoJsonLdConfiguration withDefaultValues(Optional<? extends ExtensionConfiguration> optional) {
        ExtensionConfiguration value = optional.orElse(null);
        if (this.defaultValues == value) {
            return this;
        }
        return new ImmutableGeoJsonLdConfiguration(this.enabled, value, this.contextFileName, this.context, this.types, this.idTemplate);
    }

    public final ImmutableGeoJsonLdConfiguration withContextFileName(@Nullable String value) {
        if (Objects.equals(this.contextFileName, value)) {
            return this;
        }
        return new ImmutableGeoJsonLdConfiguration(this.enabled, this.defaultValues, value, this.context, this.types, this.idTemplate);
    }

    public final ImmutableGeoJsonLdConfiguration withContext(@Nullable String value) {
        if (Objects.equals(this.context, value)) {
            return this;
        }
        return new ImmutableGeoJsonLdConfiguration(this.enabled, this.defaultValues, this.contextFileName, value, this.types, this.idTemplate);
    }

    public final ImmutableGeoJsonLdConfiguration withTypes(String ... elements) {
        ImmutableList<String> newValue = ImmutableList.copyOf(elements);
        return new ImmutableGeoJsonLdConfiguration(this.enabled, this.defaultValues, this.contextFileName, this.context, newValue, this.idTemplate);
    }

    public final ImmutableGeoJsonLdConfiguration withTypes(Iterable<String> elements) {
        if (this.types == elements) {
            return this;
        }
        ImmutableList<String> newValue = ImmutableList.copyOf(elements);
        return new ImmutableGeoJsonLdConfiguration(this.enabled, this.defaultValues, this.contextFileName, this.context, newValue, this.idTemplate);
    }

    public final ImmutableGeoJsonLdConfiguration withIdTemplate(String value) {
        String newValue = Objects.requireNonNull(value, "idTemplate");
        if (Objects.equals(this.idTemplate, newValue)) {
            return this;
        }
        return new ImmutableGeoJsonLdConfiguration(this.enabled, this.defaultValues, this.contextFileName, this.context, this.types, newValue);
    }

    public final ImmutableGeoJsonLdConfiguration withIdTemplate(Optional<String> optional) {
        String value = optional.orElse(null);
        if (Objects.equals(this.idTemplate, value)) {
            return this;
        }
        return new ImmutableGeoJsonLdConfiguration(this.enabled, this.defaultValues, this.contextFileName, this.context, this.types, value);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableGeoJsonLdConfiguration && this.equalTo((ImmutableGeoJsonLdConfiguration)another);
    }

    private boolean equalTo(ImmutableGeoJsonLdConfiguration another) {
        return Objects.equals(this.enabled, another.enabled) && Objects.equals(this.contextFileName, another.contextFileName) && Objects.equals(this.context, another.context) && this.types.equals(another.types) && Objects.equals(this.idTemplate, another.idTemplate);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + Objects.hashCode(this.enabled);
        h += (h << 5) + Objects.hashCode(this.contextFileName);
        h += (h << 5) + Objects.hashCode(this.context);
        h += (h << 5) + this.types.hashCode();
        h += (h << 5) + Objects.hashCode(this.idTemplate);
        return h;
    }

    public String toString() {
        return MoreObjects.toStringHelper("GeoJsonLdConfiguration").omitNullValues().add("enabled", this.enabled).add("contextFileName", this.contextFileName).add("context", this.context).add("types", this.types).add("idTemplate", this.idTemplate).toString();
    }

    public static ImmutableGeoJsonLdConfiguration copyOf(GeoJsonLdConfiguration instance) {
        if (instance instanceof ImmutableGeoJsonLdConfiguration) {
            return (ImmutableGeoJsonLdConfiguration)instance;
        }
        return new Builder().from(instance).build();
    }

    @Generated(from="GeoJsonLdConfiguration", generator="Immutables")
    @NotThreadSafe
    public static final class Builder
    extends GeoJsonLdConfiguration.Builder {
        @Nullable
        private Boolean enabled;
        @Nullable
        private ExtensionConfiguration defaultValues;
        @Nullable
        private String contextFileName;
        @Nullable
        private String context;
        private ImmutableList.Builder<String> types = ImmutableList.builder();
        @Nullable
        private String idTemplate;

        @Override
        @CanIgnoreReturnValue
        public final Builder from(ExtensionConfiguration instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        @Override
        @CanIgnoreReturnValue
        public final Builder from(GeoJsonLdConfiguration instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        @Override
        private void from(Object object) {
            ExtensionConfiguration instance;
            if (object instanceof ExtensionConfiguration) {
                Boolean enabledValue;
                instance = (ExtensionConfiguration)object;
                Optional<ExtensionConfiguration> defaultValuesOptional = instance.getDefaultValues();
                if (defaultValuesOptional.isPresent()) {
                    this.defaultValues(defaultValuesOptional);
                }
                if ((enabledValue = instance.getEnabled()) != null) {
                    this.enabled(enabledValue);
                }
            }
            if (object instanceof GeoJsonLdConfiguration) {
                String contextFileNameValue;
                instance = (GeoJsonLdConfiguration)object;
                String contextValue = instance.getContext();
                if (contextValue != null) {
                    this.context(contextValue);
                }
                this.addAllTypes(instance.getTypes());
                Optional<String> idTemplateOptional = instance.getIdTemplate();
                if (idTemplateOptional.isPresent()) {
                    this.idTemplate(idTemplateOptional);
                }
                if ((contextFileNameValue = instance.getContextFileName()) != null) {
                    this.contextFileName(contextFileNameValue);
                }
            }
        }

        @JsonProperty(value="enabled")
        @CanIgnoreReturnValue
        public final Builder enabled(@Nullable Boolean enabled) {
            this.enabled = enabled;
            return this;
        }

        @Override
        @CanIgnoreReturnValue
        public final Builder defaultValues(ExtensionConfiguration defaultValues) {
            this.defaultValues = Objects.requireNonNull(defaultValues, "defaultValues");
            return this;
        }

        @JsonProperty(value="defaultValues")
        @JsonIgnore
        @CanIgnoreReturnValue
        public final Builder defaultValues(Optional<? extends ExtensionConfiguration> defaultValues) {
            this.defaultValues = defaultValues.orElse(null);
            return this;
        }

        @JsonProperty(value="contextFileName")
        @CanIgnoreReturnValue
        public final Builder contextFileName(@Nullable String contextFileName) {
            this.contextFileName = contextFileName;
            return this;
        }

        @JsonProperty(value="context")
        @CanIgnoreReturnValue
        public final Builder context(@Nullable String context) {
            this.context = context;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder addTypes(String element) {
            this.types.add((Object)element);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder addTypes(String ... elements) {
            this.types.add(elements);
            return this;
        }

        @JsonProperty(value="types")
        @CanIgnoreReturnValue
        public final Builder types(Iterable<String> elements) {
            this.types = ImmutableList.builder();
            return this.addAllTypes(elements);
        }

        @CanIgnoreReturnValue
        public final Builder addAllTypes(Iterable<String> elements) {
            this.types.addAll((Iterable)elements);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder idTemplate(String idTemplate) {
            this.idTemplate = Objects.requireNonNull(idTemplate, "idTemplate");
            return this;
        }

        @JsonProperty(value="idTemplate")
        @CanIgnoreReturnValue
        public final Builder idTemplate(Optional<String> idTemplate) {
            this.idTemplate = idTemplate.orElse(null);
            return this;
        }

        @Override
        public ImmutableGeoJsonLdConfiguration build() {
            return new ImmutableGeoJsonLdConfiguration(this.enabled, this.defaultValues, this.contextFileName, this.context, (ImmutableList<String>)this.types.build(), this.idTemplate);
        }
    }
}

