/*
 * Decompiled with CFR 0.152.
 */
package de.ii.ogcapi.features.geojson.domain;

import de.ii.ogcapi.features.geojson.domain.ImmutableJsonSchemaRef;
import de.ii.ogcapi.features.geojson.domain.JsonSchema;
import java.nio.charset.StandardCharsets;
import shadow.com.fasterxml.jackson.annotation.JsonIgnore;
import shadow.com.fasterxml.jackson.annotation.JsonProperty;
import shadow.com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import shadow.com.google.common.hash.Funnel;
import shadow.javax.annotation.Nullable;
import shadow.org.immutables.value.Value;

@JsonDeserialize(as=ImmutableJsonSchemaRef.class)
@Value.Immutable
@Value.Style(jdkOnly=true, deepImmutablesDetection=true)
public abstract class JsonSchemaRef
extends JsonSchema {
    public static final Funnel<JsonSchemaRef> FUNNEL = (from, into) -> {
        into.putString(from.getType(), StandardCharsets.UTF_8);
        into.putString(from.getRef(), StandardCharsets.UTF_8);
    };

    @JsonIgnore
    public final String getType() {
        return "$ref";
    }

    @JsonProperty(value="$ref")
    @Value.Derived
    public String getRef() {
        return String.format("#/%s/%s", this.getDefsName(), this.getObjectType());
    }

    @JsonIgnore
    @Value.Auxiliary
    public String getDefsName() {
        return "$defs";
    }

    @JsonIgnore
    @Value.Auxiliary
    public abstract String getObjectType();

    @JsonIgnore
    @Nullable
    @Value.Auxiliary
    public abstract JsonSchema getDef();
}

