/*
 * Decompiled with CFR 0.152.
 */
package de.ii.ogcapi.features.geojson.domain;

import de.ii.ogcapi.features.geojson.domain.ImmutableJsonSchemaInteger;
import de.ii.ogcapi.features.geojson.domain.JsonSchema;
import java.nio.charset.StandardCharsets;
import java.util.List;
import java.util.Optional;
import shadow.com.fasterxml.jackson.annotation.JsonProperty;
import shadow.com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import shadow.com.google.common.hash.Funnel;
import shadow.org.immutables.value.Value;

@JsonDeserialize(as=ImmutableJsonSchemaInteger.class)
@Value.Immutable
@Value.Style(jdkOnly=true, deepImmutablesDetection=true)
public abstract class JsonSchemaInteger
extends JsonSchema {
    public static final Funnel<JsonSchemaInteger> FUNNEL = (from, into) -> {
        into.putString(from.getType(), StandardCharsets.UTF_8);
        from.getMinimum().ifPresent(val -> into.putLong((long)val));
        from.getMaximum().ifPresent(val -> into.putLong((long)val));
        from.getEnums().stream().sorted().forEachOrdered(val -> into.putInt((int)val));
    };

    public final String getType() {
        return "integer";
    }

    public abstract Optional<Long> getMinimum();

    public abstract Optional<Long> getMaximum();

    @JsonProperty(value="enum")
    public abstract List<Integer> getEnums();
}

