/*
 * Decompiled with CFR 0.152.
 */
package de.ii.ogcapi.features.geojson.domain;

import de.ii.ogcapi.features.geojson.domain.JsonSchema;
import de.ii.ogcapi.features.geojson.domain.JsonSchemaObject;
import de.ii.ogcapi.foundation.domain.ImmutableLink;
import de.ii.ogcapi.foundation.domain.Link;
import de.ii.ogcapi.foundation.domain.PageRepresentation;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import shadow.com.fasterxml.jackson.annotation.JsonAutoDetect;
import shadow.com.fasterxml.jackson.annotation.JsonCreator;
import shadow.com.fasterxml.jackson.annotation.JsonIgnore;
import shadow.com.fasterxml.jackson.annotation.JsonProperty;
import shadow.com.fasterxml.jackson.annotation.JsonTypeInfo;
import shadow.com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import shadow.com.google.errorprone.annotations.CanIgnoreReturnValue;
import shadow.javax.annotation.CheckReturnValue;
import shadow.javax.annotation.Nullable;
import shadow.javax.annotation.ParametersAreNonnullByDefault;
import shadow.javax.annotation.concurrent.Immutable;
import shadow.javax.annotation.concurrent.NotThreadSafe;
import shadow.org.immutables.value.Generated;

@ParametersAreNonnullByDefault
@CheckReturnValue
@Generated(from="JsonSchemaObject", generator="Immutables")
@Immutable
public final class ImmutableJsonSchemaObject
extends JsonSchemaObject {
    @Nullable
    private final String title;
    @Nullable
    private final String description;
    private final List<Link> links;
    @Nullable
    private final Date lastModified;
    private final List<Map<String, Object>> sections;
    private final transient List<Map<String, Object>> orderedSections;
    private final boolean sectionsFirst;
    @Nullable
    private final String name;
    private final boolean isRequired;
    private final List<String> required;
    private final Map<String, JsonSchema> properties;
    private final Map<String, JsonSchema> patternProperties;
    private static final byte STAGE_INITIALIZING = -1;
    private static final byte STAGE_UNINITIALIZED = 0;
    private static final byte STAGE_INITIALIZED = 1;
    private volatile transient InitShim initShim = new InitShim();

    private ImmutableJsonSchemaObject(Builder builder) {
        this.title = builder.title;
        this.description = builder.description;
        this.links = ImmutableJsonSchemaObject.createUnmodifiableList(true, builder.links);
        this.lastModified = builder.lastModified;
        this.sections = ImmutableJsonSchemaObject.createUnmodifiableList(true, builder.sections);
        this.name = builder.name;
        this.required = ImmutableJsonSchemaObject.createUnmodifiableList(true, builder.required);
        this.properties = ImmutableJsonSchemaObject.createUnmodifiableMap(false, false, builder.properties);
        this.patternProperties = ImmutableJsonSchemaObject.createUnmodifiableMap(false, false, builder.patternProperties);
        if (builder.sectionsFirstIsSet()) {
            this.initShim.sectionsFirst(builder.sectionsFirst);
        }
        if (builder.isRequiredIsSet()) {
            this.initShim.isRequired(builder.isRequired);
        }
        this.orderedSections = this.initShim.getOrderedSections();
        this.sectionsFirst = this.initShim.getSectionsFirst();
        this.isRequired = this.initShim.isRequired();
        this.initShim = null;
    }

    private ImmutableJsonSchemaObject(@Nullable String title, @Nullable String description, List<Link> links, @Nullable Date lastModified, List<Map<String, Object>> sections, boolean sectionsFirst, @Nullable String name, boolean isRequired, List<String> required, Map<String, JsonSchema> properties, Map<String, JsonSchema> patternProperties) {
        this.title = title;
        this.description = description;
        this.links = links;
        this.lastModified = lastModified;
        this.sections = sections;
        this.initShim.sectionsFirst(sectionsFirst);
        this.name = name;
        this.initShim.isRequired(isRequired);
        this.required = required;
        this.properties = properties;
        this.patternProperties = patternProperties;
        this.orderedSections = this.initShim.getOrderedSections();
        this.sectionsFirst = this.initShim.getSectionsFirst();
        this.isRequired = this.initShim.isRequired();
        this.initShim = null;
    }

    @Override
    @JsonProperty(value="title")
    public Optional<String> getTitle() {
        return Optional.ofNullable(this.title);
    }

    @Override
    @JsonProperty(value="description")
    public Optional<String> getDescription() {
        return Optional.ofNullable(this.description);
    }

    @Override
    @JsonProperty(value="links")
    public List<Link> getLinks() {
        return this.links;
    }

    @Override
    @JsonProperty(value="lastModified")
    @JsonIgnore
    public Optional<Date> getLastModified() {
        return Optional.ofNullable(this.lastModified);
    }

    @Override
    @JsonProperty(value="sections")
    @JsonIgnore
    public List<Map<String, Object>> getSections() {
        return this.sections;
    }

    @Override
    @JsonProperty(value="orderedSections")
    @JsonIgnore
    public List<Map<String, Object>> getOrderedSections() {
        InitShim shim = this.initShim;
        return shim != null ? shim.getOrderedSections() : this.orderedSections;
    }

    @Override
    @JsonProperty(value="sectionsFirst")
    @JsonIgnore
    public boolean getSectionsFirst() {
        InitShim shim = this.initShim;
        return shim != null ? shim.getSectionsFirst() : this.sectionsFirst;
    }

    @Override
    @JsonProperty(value="name")
    @JsonIgnore
    public Optional<String> getName() {
        return Optional.ofNullable(this.name);
    }

    @Override
    @JsonProperty(value="isRequired")
    @JsonIgnore
    public boolean isRequired() {
        InitShim shim = this.initShim;
        return shim != null ? shim.isRequired() : this.isRequired;
    }

    @Override
    @JsonProperty(value="required")
    public List<String> getRequired() {
        return this.required;
    }

    @Override
    @JsonProperty(value="properties")
    public Map<String, JsonSchema> getProperties() {
        return this.properties;
    }

    @Override
    @JsonProperty(value="patternProperties")
    public Map<String, JsonSchema> getPatternProperties() {
        return this.patternProperties;
    }

    public final ImmutableJsonSchemaObject withTitle(String value) {
        String newValue = Objects.requireNonNull(value, "title");
        if (Objects.equals(this.title, newValue)) {
            return this;
        }
        return new ImmutableJsonSchemaObject(newValue, this.description, this.links, this.lastModified, this.sections, this.sectionsFirst, this.name, this.isRequired, this.required, this.properties, this.patternProperties);
    }

    public final ImmutableJsonSchemaObject withTitle(Optional<String> optional) {
        String value = optional.orElse(null);
        if (Objects.equals(this.title, value)) {
            return this;
        }
        return new ImmutableJsonSchemaObject(value, this.description, this.links, this.lastModified, this.sections, this.sectionsFirst, this.name, this.isRequired, this.required, this.properties, this.patternProperties);
    }

    public final ImmutableJsonSchemaObject withDescription(String value) {
        String newValue = Objects.requireNonNull(value, "description");
        if (Objects.equals(this.description, newValue)) {
            return this;
        }
        return new ImmutableJsonSchemaObject(this.title, newValue, this.links, this.lastModified, this.sections, this.sectionsFirst, this.name, this.isRequired, this.required, this.properties, this.patternProperties);
    }

    public final ImmutableJsonSchemaObject withDescription(Optional<String> optional) {
        String value = optional.orElse(null);
        if (Objects.equals(this.description, value)) {
            return this;
        }
        return new ImmutableJsonSchemaObject(this.title, value, this.links, this.lastModified, this.sections, this.sectionsFirst, this.name, this.isRequired, this.required, this.properties, this.patternProperties);
    }

    public final ImmutableJsonSchemaObject withLinks(Link ... elements) {
        List<Link> newValue = ImmutableJsonSchemaObject.createUnmodifiableList(false, ImmutableJsonSchemaObject.createSafeList(Arrays.asList(elements), true, false));
        return new ImmutableJsonSchemaObject(this.title, this.description, newValue, this.lastModified, this.sections, this.sectionsFirst, this.name, this.isRequired, this.required, this.properties, this.patternProperties);
    }

    public final ImmutableJsonSchemaObject withLinks(Iterable<? extends Link> elements) {
        if (this.links == elements) {
            return this;
        }
        List<Link> newValue = ImmutableJsonSchemaObject.createUnmodifiableList(false, ImmutableJsonSchemaObject.createSafeList(elements, true, false));
        return new ImmutableJsonSchemaObject(this.title, this.description, newValue, this.lastModified, this.sections, this.sectionsFirst, this.name, this.isRequired, this.required, this.properties, this.patternProperties);
    }

    public final ImmutableJsonSchemaObject withLastModified(Date value) {
        Date newValue = Objects.requireNonNull(value, "lastModified");
        if (this.lastModified == newValue) {
            return this;
        }
        return new ImmutableJsonSchemaObject(this.title, this.description, this.links, newValue, this.sections, this.sectionsFirst, this.name, this.isRequired, this.required, this.properties, this.patternProperties);
    }

    public final ImmutableJsonSchemaObject withLastModified(Optional<? extends Date> optional) {
        Date value = optional.orElse(null);
        if (this.lastModified == value) {
            return this;
        }
        return new ImmutableJsonSchemaObject(this.title, this.description, this.links, value, this.sections, this.sectionsFirst, this.name, this.isRequired, this.required, this.properties, this.patternProperties);
    }

    @SafeVarargs
    public final ImmutableJsonSchemaObject withSections(Map<String, Object> ... elements) {
        List<Map<String, Object>> newValue = ImmutableJsonSchemaObject.createUnmodifiableList(false, ImmutableJsonSchemaObject.createSafeList(Arrays.asList(elements), true, false));
        return new ImmutableJsonSchemaObject(this.title, this.description, this.links, this.lastModified, newValue, this.sectionsFirst, this.name, this.isRequired, this.required, this.properties, this.patternProperties);
    }

    public final ImmutableJsonSchemaObject withSections(Iterable<? extends Map<String, Object>> elements) {
        if (this.sections == elements) {
            return this;
        }
        List<Map<String, Object>> newValue = ImmutableJsonSchemaObject.createUnmodifiableList(false, ImmutableJsonSchemaObject.createSafeList(elements, true, false));
        return new ImmutableJsonSchemaObject(this.title, this.description, this.links, this.lastModified, newValue, this.sectionsFirst, this.name, this.isRequired, this.required, this.properties, this.patternProperties);
    }

    public final ImmutableJsonSchemaObject withSectionsFirst(boolean value) {
        if (this.sectionsFirst == value) {
            return this;
        }
        return new ImmutableJsonSchemaObject(this.title, this.description, this.links, this.lastModified, this.sections, value, this.name, this.isRequired, this.required, this.properties, this.patternProperties);
    }

    public final ImmutableJsonSchemaObject withName(String value) {
        String newValue = Objects.requireNonNull(value, "name");
        if (Objects.equals(this.name, newValue)) {
            return this;
        }
        return new ImmutableJsonSchemaObject(this.title, this.description, this.links, this.lastModified, this.sections, this.sectionsFirst, newValue, this.isRequired, this.required, this.properties, this.patternProperties);
    }

    public final ImmutableJsonSchemaObject withName(Optional<String> optional) {
        String value = optional.orElse(null);
        if (Objects.equals(this.name, value)) {
            return this;
        }
        return new ImmutableJsonSchemaObject(this.title, this.description, this.links, this.lastModified, this.sections, this.sectionsFirst, value, this.isRequired, this.required, this.properties, this.patternProperties);
    }

    public final ImmutableJsonSchemaObject withIsRequired(boolean value) {
        if (this.isRequired == value) {
            return this;
        }
        return new ImmutableJsonSchemaObject(this.title, this.description, this.links, this.lastModified, this.sections, this.sectionsFirst, this.name, value, this.required, this.properties, this.patternProperties);
    }

    public final ImmutableJsonSchemaObject withRequired(String ... elements) {
        List<String> newValue = ImmutableJsonSchemaObject.createUnmodifiableList(false, ImmutableJsonSchemaObject.createSafeList(Arrays.asList(elements), true, false));
        return new ImmutableJsonSchemaObject(this.title, this.description, this.links, this.lastModified, this.sections, this.sectionsFirst, this.name, this.isRequired, newValue, this.properties, this.patternProperties);
    }

    public final ImmutableJsonSchemaObject withRequired(Iterable<String> elements) {
        if (this.required == elements) {
            return this;
        }
        List<String> newValue = ImmutableJsonSchemaObject.createUnmodifiableList(false, ImmutableJsonSchemaObject.createSafeList(elements, true, false));
        return new ImmutableJsonSchemaObject(this.title, this.description, this.links, this.lastModified, this.sections, this.sectionsFirst, this.name, this.isRequired, newValue, this.properties, this.patternProperties);
    }

    public final ImmutableJsonSchemaObject withProperties(Map<String, ? extends JsonSchema> entries) {
        if (this.properties == entries) {
            return this;
        }
        Map<String, JsonSchema> newValue = ImmutableJsonSchemaObject.createUnmodifiableMap(true, false, entries);
        return new ImmutableJsonSchemaObject(this.title, this.description, this.links, this.lastModified, this.sections, this.sectionsFirst, this.name, this.isRequired, this.required, newValue, this.patternProperties);
    }

    public final ImmutableJsonSchemaObject withPatternProperties(Map<String, ? extends JsonSchema> entries) {
        if (this.patternProperties == entries) {
            return this;
        }
        Map<String, JsonSchema> newValue = ImmutableJsonSchemaObject.createUnmodifiableMap(true, false, entries);
        return new ImmutableJsonSchemaObject(this.title, this.description, this.links, this.lastModified, this.sections, this.sectionsFirst, this.name, this.isRequired, this.required, this.properties, newValue);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableJsonSchemaObject && this.equalTo((ImmutableJsonSchemaObject)another);
    }

    private boolean equalTo(ImmutableJsonSchemaObject another) {
        return Objects.equals(this.title, another.title) && Objects.equals(this.description, another.description) && this.links.equals(another.links) && Objects.equals(this.lastModified, another.lastModified) && this.sections.equals(another.sections) && this.orderedSections.equals(another.orderedSections) && this.sectionsFirst == another.sectionsFirst && this.required.equals(another.required) && this.properties.equals(another.properties) && this.patternProperties.equals(another.patternProperties);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + Objects.hashCode(this.title);
        h += (h << 5) + Objects.hashCode(this.description);
        h += (h << 5) + this.links.hashCode();
        h += (h << 5) + Objects.hashCode(this.lastModified);
        h += (h << 5) + this.sections.hashCode();
        h += (h << 5) + this.orderedSections.hashCode();
        h += (h << 5) + Boolean.hashCode(this.sectionsFirst);
        h += (h << 5) + this.required.hashCode();
        h += (h << 5) + this.properties.hashCode();
        h += (h << 5) + this.patternProperties.hashCode();
        return h;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder("JsonSchemaObject{");
        if (this.title != null) {
            builder.append("title=").append(this.title);
        }
        if (this.description != null) {
            if (builder.length() > 17) {
                builder.append(", ");
            }
            builder.append("description=").append(this.description);
        }
        if (builder.length() > 17) {
            builder.append(", ");
        }
        builder.append("links=").append(this.links);
        if (this.lastModified != null) {
            builder.append(", ");
            builder.append("lastModified=").append(this.lastModified);
        }
        builder.append(", ");
        builder.append("sections=").append(this.sections);
        builder.append(", ");
        builder.append("orderedSections=").append(this.orderedSections);
        builder.append(", ");
        builder.append("sectionsFirst=").append(this.sectionsFirst);
        builder.append(", ");
        builder.append("required=").append(this.required);
        builder.append(", ");
        builder.append("properties=").append(this.properties);
        builder.append(", ");
        builder.append("patternProperties=").append(this.patternProperties);
        return builder.append("}").toString();
    }

    @Deprecated
    @JsonCreator(mode=JsonCreator.Mode.DELEGATING)
    static ImmutableJsonSchemaObject fromJson(Json json) {
        Builder builder = ImmutableJsonSchemaObject.builder();
        if (json.title != null) {
            builder.title(json.title);
        }
        if (json.description != null) {
            builder.description(json.description);
        }
        if (json.links != null) {
            builder.addAllLinks(json.links);
        }
        if (json.lastModified != null) {
            builder.lastModified(json.lastModified);
        }
        if (json.sections != null) {
            builder.addAllSections(json.sections);
        }
        if (json.sectionsFirstIsSet) {
            builder.sectionsFirst(json.sectionsFirst);
        }
        if (json.name != null) {
            builder.name(json.name);
        }
        if (json.isRequiredIsSet) {
            builder.isRequired(json.isRequired);
        }
        if (json.required != null) {
            builder.addAllRequired(json.required);
        }
        if (json.properties != null) {
            builder.putAllProperties(json.properties);
        }
        if (json.patternProperties != null) {
            builder.putAllPatternProperties(json.patternProperties);
        }
        return builder.build();
    }

    public static ImmutableJsonSchemaObject copyOf(JsonSchemaObject instance) {
        if (instance instanceof ImmutableJsonSchemaObject) {
            return (ImmutableJsonSchemaObject)instance;
        }
        return ImmutableJsonSchemaObject.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    private static <T> List<T> createSafeList(Iterable<? extends T> iterable, boolean checkNulls, boolean skipNulls) {
        ArrayList<T> list;
        if (iterable instanceof Collection) {
            int size = ((Collection)iterable).size();
            if (size == 0) {
                return Collections.emptyList();
            }
            list = new ArrayList();
        } else {
            list = new ArrayList<T>();
        }
        for (T element : iterable) {
            if (skipNulls && element == null) continue;
            if (checkNulls) {
                Objects.requireNonNull(element, "element");
            }
            list.add(element);
        }
        return list;
    }

    private static <T> List<T> createUnmodifiableList(boolean clone, List<T> list) {
        switch (list.size()) {
            case 0: {
                return Collections.emptyList();
            }
            case 1: {
                return Collections.singletonList(list.get(0));
            }
        }
        if (clone) {
            return Collections.unmodifiableList(new ArrayList<T>(list));
        }
        if (list instanceof ArrayList) {
            ((ArrayList)list).trimToSize();
        }
        return Collections.unmodifiableList(list);
    }

    private static <K, V> Map<K, V> createUnmodifiableMap(boolean checkNulls, boolean skipNulls, Map<? extends K, ? extends V> map) {
        switch (map.size()) {
            case 0: {
                return Collections.emptyMap();
            }
            case 1: {
                Map.Entry<K, V> e = map.entrySet().iterator().next();
                K k = e.getKey();
                V v = e.getValue();
                if (checkNulls) {
                    Objects.requireNonNull(k, "key");
                    Objects.requireNonNull(v, "value");
                }
                if (skipNulls && (k == null || v == null)) {
                    return Collections.emptyMap();
                }
                return Collections.singletonMap(k, v);
            }
        }
        LinkedHashMap<K, V> linkedMap = new LinkedHashMap<K, V>(map.size());
        if (skipNulls || checkNulls) {
            for (Map.Entry<K, V> e : map.entrySet()) {
                K k = e.getKey();
                V v = e.getValue();
                if (skipNulls) {
                    if (k == null || v == null) {
                        continue;
                    }
                } else if (checkNulls) {
                    Objects.requireNonNull(k, "key");
                    Objects.requireNonNull(v, "value");
                }
                linkedMap.put(k, v);
            }
        } else {
            linkedMap.putAll(map);
        }
        return Collections.unmodifiableMap(linkedMap);
    }

    @Generated(from="JsonSchemaObject", generator="Immutables")
    @NotThreadSafe
    public static final class Builder {
        private static final long OPT_BIT_SECTIONS_FIRST = 1L;
        private static final long OPT_BIT_IS_REQUIRED = 2L;
        private long optBits;
        @Nullable
        private String title;
        @Nullable
        private String description;
        private List<Link> links = new ArrayList<Link>();
        @Nullable
        private Date lastModified;
        private List<Map<String, Object>> sections = new ArrayList<Map<String, Object>>();
        private boolean sectionsFirst;
        @Nullable
        private String name;
        private boolean isRequired;
        private List<String> required = new ArrayList<String>();
        private Map<String, JsonSchema> properties = new LinkedHashMap<String, JsonSchema>();
        private Map<String, JsonSchema> patternProperties = new LinkedHashMap<String, JsonSchema>();

        private Builder() {
        }

        @CanIgnoreReturnValue
        public final Builder from(JsonSchemaObject instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder from(PageRepresentation instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder from(JsonSchema instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        private void from(Object object) {
            PageRepresentation instance;
            if (object instanceof JsonSchemaObject) {
                instance = (JsonSchemaObject)object;
                this.putAllPatternProperties(((JsonSchemaObject)instance).getPatternProperties());
                this.addAllRequired(((JsonSchemaObject)instance).getRequired());
                this.putAllProperties(((JsonSchemaObject)instance).getProperties());
            }
            if (object instanceof PageRepresentation) {
                Optional<String> titleOptional;
                instance = (PageRepresentation)object;
                Optional<String> descriptionOptional = instance.getDescription();
                if (descriptionOptional.isPresent()) {
                    this.description(descriptionOptional);
                }
                this.addAllLinks(instance.getLinks());
                Optional<Date> lastModifiedOptional = instance.getLastModified();
                if (lastModifiedOptional.isPresent()) {
                    this.lastModified(lastModifiedOptional);
                }
                if ((titleOptional = instance.getTitle()).isPresent()) {
                    this.title(titleOptional);
                }
                this.addAllSections(instance.getSections());
                this.sectionsFirst(instance.getSectionsFirst());
            }
            if (object instanceof JsonSchema) {
                instance = (JsonSchema)object;
                Optional<String> nameOptional = ((JsonSchema)instance).getName();
                if (nameOptional.isPresent()) {
                    this.name(nameOptional);
                }
                this.isRequired(((JsonSchema)instance).isRequired());
            }
        }

        @CanIgnoreReturnValue
        public final Builder title(String title) {
            this.title = Objects.requireNonNull(title, "title");
            return this;
        }

        @JsonProperty(value="title")
        @CanIgnoreReturnValue
        public final Builder title(Optional<String> title) {
            this.title = title.orElse(null);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder description(String description) {
            this.description = Objects.requireNonNull(description, "description");
            return this;
        }

        @JsonProperty(value="description")
        @CanIgnoreReturnValue
        public final Builder description(Optional<String> description) {
            this.description = description.orElse(null);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder addLinks(Link element) {
            element = ImmutableLink.copyOf(element);
            this.links.add(Objects.requireNonNull(element, "links element"));
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder addLinks(Link ... elements) {
            for (Link element : elements) {
                element = ImmutableLink.copyOf(element);
                this.links.add(Objects.requireNonNull(element, "links element"));
            }
            return this;
        }

        @JsonProperty(value="links")
        @CanIgnoreReturnValue
        public final Builder links(Iterable<? extends Link> elements) {
            this.links.clear();
            return this.addAllLinks(elements);
        }

        @CanIgnoreReturnValue
        public final Builder addAllLinks(Iterable<? extends Link> elements) {
            for (Link link : elements) {
                ImmutableLink immutableLink = ImmutableLink.copyOf(link);
                this.links.add(Objects.requireNonNull(immutableLink, "links element"));
            }
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder lastModified(Date lastModified) {
            this.lastModified = Objects.requireNonNull(lastModified, "lastModified");
            return this;
        }

        @JsonProperty(value="lastModified")
        @JsonIgnore
        @CanIgnoreReturnValue
        public final Builder lastModified(Optional<? extends Date> lastModified) {
            this.lastModified = lastModified.orElse(null);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder addSections(Map<String, Object> element) {
            this.sections.add(Objects.requireNonNull(element, "sections element"));
            return this;
        }

        @SafeVarargs
        @CanIgnoreReturnValue
        public final Builder addSections(Map<String, Object> ... elements) {
            for (Map<String, Object> element : elements) {
                this.sections.add(Objects.requireNonNull(element, "sections element"));
            }
            return this;
        }

        @JsonProperty(value="sections")
        @JsonIgnore
        @CanIgnoreReturnValue
        public final Builder sections(Iterable<? extends Map<String, Object>> elements) {
            this.sections.clear();
            return this.addAllSections(elements);
        }

        @CanIgnoreReturnValue
        public final Builder addAllSections(Iterable<? extends Map<String, Object>> elements) {
            for (Map<String, Object> map : elements) {
                this.sections.add(Objects.requireNonNull(map, "sections element"));
            }
            return this;
        }

        @JsonProperty(value="sectionsFirst")
        @JsonIgnore
        @CanIgnoreReturnValue
        public final Builder sectionsFirst(boolean sectionsFirst) {
            this.sectionsFirst = sectionsFirst;
            this.optBits |= 1L;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder name(String name) {
            this.name = Objects.requireNonNull(name, "name");
            return this;
        }

        @JsonProperty(value="name")
        @JsonIgnore
        @CanIgnoreReturnValue
        public final Builder name(Optional<String> name) {
            this.name = name.orElse(null);
            return this;
        }

        @JsonProperty(value="isRequired")
        @JsonIgnore
        @CanIgnoreReturnValue
        public final Builder isRequired(boolean isRequired) {
            this.isRequired = isRequired;
            this.optBits |= 2L;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder addRequired(String element) {
            this.required.add(Objects.requireNonNull(element, "required element"));
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder addRequired(String ... elements) {
            for (String element : elements) {
                this.required.add(Objects.requireNonNull(element, "required element"));
            }
            return this;
        }

        @JsonProperty(value="required")
        @CanIgnoreReturnValue
        public final Builder required(Iterable<String> elements) {
            this.required.clear();
            return this.addAllRequired(elements);
        }

        @CanIgnoreReturnValue
        public final Builder addAllRequired(Iterable<String> elements) {
            for (String element : elements) {
                this.required.add(Objects.requireNonNull(element, "required element"));
            }
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder putProperties(String key, JsonSchema value) {
            this.properties.put(Objects.requireNonNull(key, "properties key"), Objects.requireNonNull(value, "properties value"));
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder putProperties(Map.Entry<String, ? extends JsonSchema> entry) {
            String k = entry.getKey();
            JsonSchema v = entry.getValue();
            this.properties.put(Objects.requireNonNull(k, "properties key"), Objects.requireNonNull(v, "properties value"));
            return this;
        }

        @JsonProperty(value="properties")
        @CanIgnoreReturnValue
        public final Builder properties(Map<String, ? extends JsonSchema> entries) {
            this.properties.clear();
            return this.putAllProperties(entries);
        }

        @CanIgnoreReturnValue
        public final Builder putAllProperties(Map<String, ? extends JsonSchema> entries) {
            for (Map.Entry<String, ? extends JsonSchema> e : entries.entrySet()) {
                String k = e.getKey();
                JsonSchema v = e.getValue();
                this.properties.put(Objects.requireNonNull(k, "properties key"), Objects.requireNonNull(v, "properties value"));
            }
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder putPatternProperties(String key, JsonSchema value) {
            this.patternProperties.put(Objects.requireNonNull(key, "patternProperties key"), Objects.requireNonNull(value, "patternProperties value"));
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder putPatternProperties(Map.Entry<String, ? extends JsonSchema> entry) {
            String k = entry.getKey();
            JsonSchema v = entry.getValue();
            this.patternProperties.put(Objects.requireNonNull(k, "patternProperties key"), Objects.requireNonNull(v, "patternProperties value"));
            return this;
        }

        @JsonProperty(value="patternProperties")
        @CanIgnoreReturnValue
        public final Builder patternProperties(Map<String, ? extends JsonSchema> entries) {
            this.patternProperties.clear();
            return this.putAllPatternProperties(entries);
        }

        @CanIgnoreReturnValue
        public final Builder putAllPatternProperties(Map<String, ? extends JsonSchema> entries) {
            for (Map.Entry<String, ? extends JsonSchema> e : entries.entrySet()) {
                String k = e.getKey();
                JsonSchema v = e.getValue();
                this.patternProperties.put(Objects.requireNonNull(k, "patternProperties key"), Objects.requireNonNull(v, "patternProperties value"));
            }
            return this;
        }

        public ImmutableJsonSchemaObject build() {
            return new ImmutableJsonSchemaObject(this);
        }

        private boolean sectionsFirstIsSet() {
            return (this.optBits & 1L) != 0L;
        }

        private boolean isRequiredIsSet() {
            return (this.optBits & 2L) != 0L;
        }
    }

    @Deprecated
    @JsonDeserialize
    @JsonTypeInfo(use=JsonTypeInfo.Id.NONE)
    @JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.NONE)
    @Generated(from="JsonSchemaObject", generator="Immutables")
    static final class Json
    extends JsonSchemaObject {
        @Nullable
        Optional<String> title = Optional.empty();
        @Nullable
        Optional<String> description = Optional.empty();
        @Nullable
        List<Link> links = Collections.emptyList();
        @Nullable
        Optional<Date> lastModified = Optional.empty();
        @Nullable
        List<Map<String, Object>> sections = Collections.emptyList();
        boolean sectionsFirst;
        boolean sectionsFirstIsSet;
        @Nullable
        Optional<String> name = Optional.empty();
        boolean isRequired;
        boolean isRequiredIsSet;
        @Nullable
        List<String> required = Collections.emptyList();
        @Nullable
        Map<String, JsonSchema> properties = Collections.emptyMap();
        @Nullable
        Map<String, JsonSchema> patternProperties = Collections.emptyMap();

        Json() {
        }

        @JsonProperty(value="title")
        public void setTitle(Optional<String> title) {
            this.title = title;
        }

        @JsonProperty(value="description")
        public void setDescription(Optional<String> description) {
            this.description = description;
        }

        @JsonProperty(value="links")
        public void setLinks(List<Link> links) {
            this.links = links;
        }

        @JsonProperty(value="lastModified")
        @JsonIgnore
        public void setLastModified(Optional<Date> lastModified) {
            this.lastModified = lastModified;
        }

        @JsonProperty(value="sections")
        @JsonIgnore
        public void setSections(List<Map<String, Object>> sections) {
            this.sections = sections;
        }

        @JsonProperty(value="sectionsFirst")
        @JsonIgnore
        public void setSectionsFirst(boolean sectionsFirst) {
            this.sectionsFirst = sectionsFirst;
            this.sectionsFirstIsSet = true;
        }

        @JsonProperty(value="name")
        @JsonIgnore
        public void setName(Optional<String> name) {
            this.name = name;
        }

        @JsonProperty(value="isRequired")
        @JsonIgnore
        public void setIsRequired(boolean isRequired) {
            this.isRequired = isRequired;
            this.isRequiredIsSet = true;
        }

        @JsonProperty(value="required")
        public void setRequired(List<String> required) {
            this.required = required;
        }

        @JsonProperty(value="properties")
        public void setProperties(Map<String, JsonSchema> properties) {
            this.properties = properties;
        }

        @JsonProperty(value="patternProperties")
        public void setPatternProperties(Map<String, JsonSchema> patternProperties) {
            this.patternProperties = patternProperties;
        }

        @Override
        public Optional<String> getTitle() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Optional<String> getDescription() {
            throw new UnsupportedOperationException();
        }

        @Override
        public List<Link> getLinks() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Optional<Date> getLastModified() {
            throw new UnsupportedOperationException();
        }

        @Override
        public List<Map<String, Object>> getSections() {
            throw new UnsupportedOperationException();
        }

        @Override
        @JsonIgnore
        public List<Map<String, Object>> getOrderedSections() {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean getSectionsFirst() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Optional<String> getName() {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean isRequired() {
            throw new UnsupportedOperationException();
        }

        @Override
        public List<String> getRequired() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Map<String, JsonSchema> getProperties() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Map<String, JsonSchema> getPatternProperties() {
            throw new UnsupportedOperationException();
        }
    }

    @Generated(from="JsonSchemaObject", generator="Immutables")
    private final class InitShim {
        private byte orderedSectionsBuildStage = 0;
        private List<Map<String, Object>> orderedSections;
        private byte sectionsFirstBuildStage = 0;
        private boolean sectionsFirst;
        private byte isRequiredBuildStage = 0;
        private boolean isRequired;

        private InitShim() {
        }

        List<Map<String, Object>> getOrderedSections() {
            if (this.orderedSectionsBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.orderedSectionsBuildStage == 0) {
                this.orderedSectionsBuildStage = (byte)-1;
                this.orderedSections = Objects.requireNonNull(ImmutableJsonSchemaObject.super.getOrderedSections(), "orderedSections");
                this.orderedSectionsBuildStage = 1;
            }
            return this.orderedSections;
        }

        boolean getSectionsFirst() {
            if (this.sectionsFirstBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.sectionsFirstBuildStage == 0) {
                this.sectionsFirstBuildStage = (byte)-1;
                this.sectionsFirst = ImmutableJsonSchemaObject.super.getSectionsFirst();
                this.sectionsFirstBuildStage = 1;
            }
            return this.sectionsFirst;
        }

        void sectionsFirst(boolean sectionsFirst) {
            this.sectionsFirst = sectionsFirst;
            this.sectionsFirstBuildStage = 1;
        }

        boolean isRequired() {
            if (this.isRequiredBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.isRequiredBuildStage == 0) {
                this.isRequiredBuildStage = (byte)-1;
                this.isRequired = ImmutableJsonSchemaObject.super.isRequired();
                this.isRequiredBuildStage = 1;
            }
            return this.isRequired;
        }

        void isRequired(boolean isRequired) {
            this.isRequired = isRequired;
            this.isRequiredBuildStage = 1;
        }

        private String formatInitCycleMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if (this.orderedSectionsBuildStage == -1) {
                attributes.add("orderedSections");
            }
            if (this.sectionsFirstBuildStage == -1) {
                attributes.add("sectionsFirst");
            }
            if (this.isRequiredBuildStage == -1) {
                attributes.add("isRequired");
            }
            return "Cannot build JsonSchemaObject, attribute initializers form cycle " + attributes;
        }
    }
}

