/*
 * Decompiled with CFR 0.152.
 */
package de.ii.ogcapi.features.geojson.domain;

import de.ii.ogcapi.features.geojson.domain.GeoJsonConfiguration;
import de.ii.ogcapi.foundation.domain.ExtensionConfiguration;
import de.ii.xtraplatform.features.domain.transform.PropertyTransformation;
import de.ii.xtraplatform.features.domain.transform.PropertyTransformations;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import shadow.com.fasterxml.jackson.annotation.JsonIgnore;
import shadow.com.fasterxml.jackson.annotation.JsonProperty;
import shadow.com.google.common.base.MoreObjects;
import shadow.com.google.common.collect.ImmutableMap;
import shadow.com.google.errorprone.annotations.CanIgnoreReturnValue;
import shadow.javax.annotation.CheckReturnValue;
import shadow.javax.annotation.Nullable;
import shadow.javax.annotation.ParametersAreNonnullByDefault;
import shadow.javax.annotation.concurrent.Immutable;
import shadow.javax.annotation.concurrent.NotThreadSafe;
import shadow.org.immutables.value.Generated;

@ParametersAreNonnullByDefault
@CheckReturnValue
@Generated(from="GeoJsonConfiguration", generator="Immutables")
@Immutable
public final class ImmutableGeoJsonConfiguration
implements GeoJsonConfiguration {
    @Nullable
    private final Boolean enabled;
    private final transient boolean isEnabled;
    @Nullable
    private final ExtensionConfiguration defaultValues;
    private final ImmutableMap<String, List<PropertyTransformation>> transformations;
    private final transient boolean hasDeprecatedTransformationKeys;
    @Nullable
    private final GeoJsonConfiguration.NESTED_OBJECTS nestedObjectStrategy;
    @Nullable
    private final GeoJsonConfiguration.MULTIPLICITY multiplicityStrategy;
    @Nullable
    private final Boolean useFormattedJsonOutput;
    @Nullable
    private final String separator;
    private final transient boolean isFlattened;
    private static final byte STAGE_INITIALIZING = -1;
    private static final byte STAGE_UNINITIALIZED = 0;
    private static final byte STAGE_INITIALIZED = 1;
    private volatile transient InitShim initShim = new InitShim();

    private ImmutableGeoJsonConfiguration(@Nullable Boolean enabled, @Nullable ExtensionConfiguration defaultValues, ImmutableMap<String, List<PropertyTransformation>> transformations, @Nullable GeoJsonConfiguration.NESTED_OBJECTS nestedObjectStrategy, @Nullable GeoJsonConfiguration.MULTIPLICITY multiplicityStrategy, @Nullable Boolean useFormattedJsonOutput, @Nullable String separator) {
        this.enabled = enabled;
        this.defaultValues = defaultValues;
        this.transformations = transformations;
        this.nestedObjectStrategy = nestedObjectStrategy;
        this.multiplicityStrategy = multiplicityStrategy;
        this.useFormattedJsonOutput = useFormattedJsonOutput;
        this.separator = separator;
        this.isEnabled = this.initShim.isEnabled();
        this.hasDeprecatedTransformationKeys = this.initShim.hasDeprecatedTransformationKeys();
        this.isFlattened = this.initShim.isFlattened();
        this.initShim = null;
    }

    private boolean isEnabledInitialize() {
        return GeoJsonConfiguration.super.isEnabled();
    }

    private boolean hasDeprecatedTransformationKeysInitialize() {
        return GeoJsonConfiguration.super.hasDeprecatedTransformationKeys();
    }

    private boolean isFlattenedInitialize() {
        return GeoJsonConfiguration.super.isFlattened();
    }

    @Override
    @JsonProperty(value="enabled")
    @Nullable
    public Boolean getEnabled() {
        return this.enabled;
    }

    @Override
    @JsonProperty(value="isEnabled")
    @JsonIgnore
    public boolean isEnabled() {
        InitShim shim = this.initShim;
        return shim != null ? shim.isEnabled() : this.isEnabled;
    }

    @Override
    @JsonProperty(value="defaultValues")
    @JsonIgnore
    public Optional<ExtensionConfiguration> getDefaultValues() {
        return Optional.ofNullable(this.defaultValues);
    }

    @JsonProperty(value="transformations")
    public ImmutableMap<String, List<PropertyTransformation>> getTransformations() {
        return this.transformations;
    }

    @Override
    @JsonProperty(value="hasDeprecatedTransformationKeys")
    @JsonIgnore
    public boolean hasDeprecatedTransformationKeys() {
        InitShim shim = this.initShim;
        return shim != null ? shim.hasDeprecatedTransformationKeys() : this.hasDeprecatedTransformationKeys;
    }

    @Override
    @JsonProperty(value="nestedObjectStrategy")
    @Deprecated
    @Nullable
    public GeoJsonConfiguration.NESTED_OBJECTS getNestedObjectStrategy() {
        return this.nestedObjectStrategy;
    }

    @Override
    @JsonProperty(value="multiplicityStrategy")
    @Deprecated
    @Nullable
    public GeoJsonConfiguration.MULTIPLICITY getMultiplicityStrategy() {
        return this.multiplicityStrategy;
    }

    @Override
    @JsonProperty(value="useFormattedJsonOutput")
    @Deprecated
    @Nullable
    public Boolean getUseFormattedJsonOutput() {
        return this.useFormattedJsonOutput;
    }

    @Override
    @JsonProperty(value="separator")
    @Deprecated
    @Nullable
    public String getSeparator() {
        return this.separator;
    }

    @Override
    @JsonProperty(value="isFlattened")
    @JsonIgnore
    public boolean isFlattened() {
        InitShim shim = this.initShim;
        return shim != null ? shim.isFlattened() : this.isFlattened;
    }

    public final ImmutableGeoJsonConfiguration withEnabled(@Nullable Boolean value) {
        if (Objects.equals(this.enabled, value)) {
            return this;
        }
        return ImmutableGeoJsonConfiguration.validate(new ImmutableGeoJsonConfiguration(value, this.defaultValues, this.transformations, this.nestedObjectStrategy, this.multiplicityStrategy, this.useFormattedJsonOutput, this.separator));
    }

    public final ImmutableGeoJsonConfiguration withDefaultValues(ExtensionConfiguration value) {
        ExtensionConfiguration newValue = Objects.requireNonNull(value, "defaultValues");
        if (this.defaultValues == newValue) {
            return this;
        }
        return ImmutableGeoJsonConfiguration.validate(new ImmutableGeoJsonConfiguration(this.enabled, newValue, this.transformations, this.nestedObjectStrategy, this.multiplicityStrategy, this.useFormattedJsonOutput, this.separator));
    }

    public final ImmutableGeoJsonConfiguration withDefaultValues(Optional<? extends ExtensionConfiguration> optional) {
        ExtensionConfiguration value = optional.orElse(null);
        if (this.defaultValues == value) {
            return this;
        }
        return ImmutableGeoJsonConfiguration.validate(new ImmutableGeoJsonConfiguration(this.enabled, value, this.transformations, this.nestedObjectStrategy, this.multiplicityStrategy, this.useFormattedJsonOutput, this.separator));
    }

    public final ImmutableGeoJsonConfiguration withTransformations(Map<String, ? extends List<PropertyTransformation>> entries) {
        if (this.transformations == entries) {
            return this;
        }
        ImmutableMap<String, List<PropertyTransformation>> newValue = ImmutableMap.copyOf(entries);
        return ImmutableGeoJsonConfiguration.validate(new ImmutableGeoJsonConfiguration(this.enabled, this.defaultValues, newValue, this.nestedObjectStrategy, this.multiplicityStrategy, this.useFormattedJsonOutput, this.separator));
    }

    @Deprecated
    public final ImmutableGeoJsonConfiguration withNestedObjectStrategy(@Nullable GeoJsonConfiguration.NESTED_OBJECTS value) {
        if (this.nestedObjectStrategy == value) {
            return this;
        }
        if (Objects.equals((Object)this.nestedObjectStrategy, (Object)value)) {
            return this;
        }
        return ImmutableGeoJsonConfiguration.validate(new ImmutableGeoJsonConfiguration(this.enabled, this.defaultValues, this.transformations, value, this.multiplicityStrategy, this.useFormattedJsonOutput, this.separator));
    }

    @Deprecated
    public final ImmutableGeoJsonConfiguration withMultiplicityStrategy(@Nullable GeoJsonConfiguration.MULTIPLICITY value) {
        if (this.multiplicityStrategy == value) {
            return this;
        }
        if (Objects.equals((Object)this.multiplicityStrategy, (Object)value)) {
            return this;
        }
        return ImmutableGeoJsonConfiguration.validate(new ImmutableGeoJsonConfiguration(this.enabled, this.defaultValues, this.transformations, this.nestedObjectStrategy, value, this.useFormattedJsonOutput, this.separator));
    }

    @Deprecated
    public final ImmutableGeoJsonConfiguration withUseFormattedJsonOutput(@Nullable Boolean value) {
        if (Objects.equals(this.useFormattedJsonOutput, value)) {
            return this;
        }
        return ImmutableGeoJsonConfiguration.validate(new ImmutableGeoJsonConfiguration(this.enabled, this.defaultValues, this.transformations, this.nestedObjectStrategy, this.multiplicityStrategy, value, this.separator));
    }

    @Deprecated
    public final ImmutableGeoJsonConfiguration withSeparator(@Nullable String value) {
        if (Objects.equals(this.separator, value)) {
            return this;
        }
        return ImmutableGeoJsonConfiguration.validate(new ImmutableGeoJsonConfiguration(this.enabled, this.defaultValues, this.transformations, this.nestedObjectStrategy, this.multiplicityStrategy, this.useFormattedJsonOutput, value));
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableGeoJsonConfiguration && this.equalTo((ImmutableGeoJsonConfiguration)another);
    }

    private boolean equalTo(ImmutableGeoJsonConfiguration another) {
        return Objects.equals(this.enabled, another.enabled) && this.transformations.equals(another.transformations) && Objects.equals((Object)this.nestedObjectStrategy, (Object)another.nestedObjectStrategy) && Objects.equals((Object)this.multiplicityStrategy, (Object)another.multiplicityStrategy) && Objects.equals(this.useFormattedJsonOutput, another.useFormattedJsonOutput) && Objects.equals(this.separator, another.separator);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + Objects.hashCode(this.enabled);
        h += (h << 5) + this.transformations.hashCode();
        h += (h << 5) + Objects.hashCode((Object)this.nestedObjectStrategy);
        h += (h << 5) + Objects.hashCode((Object)this.multiplicityStrategy);
        h += (h << 5) + Objects.hashCode(this.useFormattedJsonOutput);
        h += (h << 5) + Objects.hashCode(this.separator);
        return h;
    }

    public String toString() {
        return MoreObjects.toStringHelper("GeoJsonConfiguration").omitNullValues().add("enabled", this.enabled).add("transformations", this.transformations).add("nestedObjectStrategy", (Object)this.nestedObjectStrategy).add("multiplicityStrategy", (Object)this.multiplicityStrategy).add("useFormattedJsonOutput", this.useFormattedJsonOutput).add("separator", this.separator).toString();
    }

    private static ImmutableGeoJsonConfiguration validate(ImmutableGeoJsonConfiguration instance) {
        instance = (ImmutableGeoJsonConfiguration)instance.backwardsCompatibility();
        return instance;
    }

    public static ImmutableGeoJsonConfiguration copyOf(GeoJsonConfiguration instance) {
        if (instance instanceof ImmutableGeoJsonConfiguration) {
            return (ImmutableGeoJsonConfiguration)instance;
        }
        return new Builder().from(instance).build();
    }

    @Generated(from="GeoJsonConfiguration", generator="Immutables")
    @NotThreadSafe
    public static final class Builder
    extends GeoJsonConfiguration.Builder {
        @Nullable
        private Boolean enabled;
        @Nullable
        private ExtensionConfiguration defaultValues;
        private ImmutableMap.Builder<String, List<PropertyTransformation>> transformations = ImmutableMap.builder();
        @Nullable
        private GeoJsonConfiguration.NESTED_OBJECTS nestedObjectStrategy;
        @Nullable
        private GeoJsonConfiguration.MULTIPLICITY multiplicityStrategy;
        @Nullable
        private Boolean useFormattedJsonOutput;
        @Nullable
        private String separator;

        @Override
        @CanIgnoreReturnValue
        public final Builder from(GeoJsonConfiguration instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        @Override
        @CanIgnoreReturnValue
        public final Builder from(ExtensionConfiguration instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        @Override
        @CanIgnoreReturnValue
        public final Builder from(PropertyTransformations instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        @Override
        private void from(Object object) {
            Object instance;
            if (object instanceof GeoJsonConfiguration) {
                String separatorValue;
                Boolean useFormattedJsonOutputValue;
                GeoJsonConfiguration.MULTIPLICITY multiplicityStrategyValue;
                instance = (GeoJsonConfiguration)object;
                GeoJsonConfiguration.NESTED_OBJECTS nestedObjectStrategyValue = instance.getNestedObjectStrategy();
                if (nestedObjectStrategyValue != null) {
                    this.nestedObjectStrategy(nestedObjectStrategyValue);
                }
                if ((multiplicityStrategyValue = instance.getMultiplicityStrategy()) != null) {
                    this.multiplicityStrategy(multiplicityStrategyValue);
                }
                if ((useFormattedJsonOutputValue = instance.getUseFormattedJsonOutput()) != null) {
                    this.useFormattedJsonOutput(useFormattedJsonOutputValue);
                }
                if ((separatorValue = instance.getSeparator()) != null) {
                    this.separator(separatorValue);
                }
            }
            if (object instanceof ExtensionConfiguration) {
                Boolean enabledValue;
                instance = (ExtensionConfiguration)object;
                Optional<ExtensionConfiguration> defaultValuesOptional = instance.getDefaultValues();
                if (defaultValuesOptional.isPresent()) {
                    this.defaultValues(defaultValuesOptional);
                }
                if ((enabledValue = instance.getEnabled()) != null) {
                    this.enabled(enabledValue);
                }
            }
            if (object instanceof PropertyTransformations) {
                instance = (PropertyTransformations)object;
                this.putAllTransformations(instance.getTransformations());
            }
        }

        @JsonProperty(value="enabled")
        @CanIgnoreReturnValue
        public final Builder enabled(@Nullable Boolean enabled) {
            this.enabled = enabled;
            return this;
        }

        @Override
        @CanIgnoreReturnValue
        public final Builder defaultValues(ExtensionConfiguration defaultValues) {
            this.defaultValues = Objects.requireNonNull(defaultValues, "defaultValues");
            return this;
        }

        @JsonProperty(value="defaultValues")
        @JsonIgnore
        @CanIgnoreReturnValue
        public final Builder defaultValues(Optional<? extends ExtensionConfiguration> defaultValues) {
            this.defaultValues = defaultValues.orElse(null);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder putTransformations(String key, List<PropertyTransformation> value) {
            this.transformations.put(key, value);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder putTransformations(Map.Entry<String, ? extends List<PropertyTransformation>> entry) {
            this.transformations.put(entry);
            return this;
        }

        @JsonProperty(value="transformations")
        @CanIgnoreReturnValue
        public final Builder transformations(Map<String, ? extends List<PropertyTransformation>> entries) {
            this.transformations = ImmutableMap.builder();
            return this.putAllTransformations(entries);
        }

        @CanIgnoreReturnValue
        public final Builder putAllTransformations(Map<String, ? extends List<PropertyTransformation>> entries) {
            this.transformations.putAll(entries);
            return this;
        }

        @JsonProperty(value="nestedObjectStrategy")
        @Deprecated
        @CanIgnoreReturnValue
        public final Builder nestedObjectStrategy(@Nullable GeoJsonConfiguration.NESTED_OBJECTS nestedObjectStrategy) {
            this.nestedObjectStrategy = nestedObjectStrategy;
            return this;
        }

        @JsonProperty(value="multiplicityStrategy")
        @Deprecated
        @CanIgnoreReturnValue
        public final Builder multiplicityStrategy(@Nullable GeoJsonConfiguration.MULTIPLICITY multiplicityStrategy) {
            this.multiplicityStrategy = multiplicityStrategy;
            return this;
        }

        @JsonProperty(value="useFormattedJsonOutput")
        @Deprecated
        @CanIgnoreReturnValue
        public final Builder useFormattedJsonOutput(@Nullable Boolean useFormattedJsonOutput) {
            this.useFormattedJsonOutput = useFormattedJsonOutput;
            return this;
        }

        @JsonProperty(value="separator")
        @Deprecated
        @CanIgnoreReturnValue
        public final Builder separator(@Nullable String separator) {
            this.separator = separator;
            return this;
        }

        @Override
        public ImmutableGeoJsonConfiguration build() {
            return ImmutableGeoJsonConfiguration.validate(new ImmutableGeoJsonConfiguration(this.enabled, this.defaultValues, this.transformations.build(), this.nestedObjectStrategy, this.multiplicityStrategy, this.useFormattedJsonOutput, this.separator));
        }
    }

    @Generated(from="GeoJsonConfiguration", generator="Immutables")
    private final class InitShim {
        private byte isEnabledBuildStage = 0;
        private boolean isEnabled;
        private byte hasDeprecatedTransformationKeysBuildStage = 0;
        private boolean hasDeprecatedTransformationKeys;
        private byte isFlattenedBuildStage = 0;
        private boolean isFlattened;

        private InitShim() {
        }

        boolean isEnabled() {
            if (this.isEnabledBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.isEnabledBuildStage == 0) {
                this.isEnabledBuildStage = (byte)-1;
                this.isEnabled = ImmutableGeoJsonConfiguration.this.isEnabledInitialize();
                this.isEnabledBuildStage = 1;
            }
            return this.isEnabled;
        }

        boolean hasDeprecatedTransformationKeys() {
            if (this.hasDeprecatedTransformationKeysBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.hasDeprecatedTransformationKeysBuildStage == 0) {
                this.hasDeprecatedTransformationKeysBuildStage = (byte)-1;
                this.hasDeprecatedTransformationKeys = ImmutableGeoJsonConfiguration.this.hasDeprecatedTransformationKeysInitialize();
                this.hasDeprecatedTransformationKeysBuildStage = 1;
            }
            return this.hasDeprecatedTransformationKeys;
        }

        boolean isFlattened() {
            if (this.isFlattenedBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.isFlattenedBuildStage == 0) {
                this.isFlattenedBuildStage = (byte)-1;
                this.isFlattened = ImmutableGeoJsonConfiguration.this.isFlattenedInitialize();
                this.isFlattenedBuildStage = 1;
            }
            return this.isFlattened;
        }

        private String formatInitCycleMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if (this.isEnabledBuildStage == -1) {
                attributes.add("isEnabled");
            }
            if (this.hasDeprecatedTransformationKeysBuildStage == -1) {
                attributes.add("hasDeprecatedTransformationKeys");
            }
            if (this.isFlattenedBuildStage == -1) {
                attributes.add("isFlattened");
            }
            return "Cannot build GeoJsonConfiguration, attribute initializers form cycle " + attributes;
        }
    }
}

