/*
 * Decompiled with CFR 0.152.
 */
package de.ii.ogcapi.features.custom.extensions.domain;

import de.ii.ogcapi.features.custom.extensions.domain.FeaturesExtensionsConfiguration;
import de.ii.ogcapi.foundation.domain.ExtensionConfiguration;
import java.util.ArrayList;
import java.util.Objects;
import java.util.Optional;
import shadow.com.fasterxml.jackson.annotation.JsonIgnore;
import shadow.com.fasterxml.jackson.annotation.JsonProperty;
import shadow.com.google.common.base.MoreObjects;
import shadow.com.google.errorprone.annotations.CanIgnoreReturnValue;
import shadow.javax.annotation.CheckReturnValue;
import shadow.javax.annotation.Nullable;
import shadow.javax.annotation.ParametersAreNonnullByDefault;
import shadow.javax.annotation.concurrent.Immutable;
import shadow.javax.annotation.concurrent.NotThreadSafe;
import shadow.org.immutables.value.Generated;

@ParametersAreNonnullByDefault
@CheckReturnValue
@Generated(from="FeaturesExtensionsConfiguration", generator="Immutables")
@Immutable
public final class ImmutableFeaturesExtensionsConfiguration
implements FeaturesExtensionsConfiguration {
    @Nullable
    private final Boolean enabled;
    private final transient boolean isEnabled;
    @Nullable
    private final ExtensionConfiguration defaultValues;
    @Nullable
    private final Boolean postOnItems;
    private final transient boolean shouldSupportPostOnItems;
    @Nullable
    private final Boolean intersectsParameter;
    private static final byte STAGE_INITIALIZING = -1;
    private static final byte STAGE_UNINITIALIZED = 0;
    private static final byte STAGE_INITIALIZED = 1;
    private volatile transient InitShim initShim = new InitShim();

    private ImmutableFeaturesExtensionsConfiguration(@Nullable Boolean enabled, @Nullable ExtensionConfiguration defaultValues, @Nullable Boolean postOnItems, @Nullable Boolean intersectsParameter) {
        this.enabled = enabled;
        this.defaultValues = defaultValues;
        this.postOnItems = postOnItems;
        this.intersectsParameter = intersectsParameter;
        this.isEnabled = this.initShim.isEnabled();
        this.shouldSupportPostOnItems = this.initShim.shouldSupportPostOnItems();
        this.initShim = null;
    }

    private boolean isEnabledInitialize() {
        return FeaturesExtensionsConfiguration.super.isEnabled();
    }

    private boolean shouldSupportPostOnItemsInitialize() {
        return FeaturesExtensionsConfiguration.super.shouldSupportPostOnItems();
    }

    @Override
    @JsonProperty(value="enabled")
    @Nullable
    public Boolean getEnabled() {
        return this.enabled;
    }

    @Override
    @JsonProperty(value="isEnabled")
    @JsonIgnore
    public boolean isEnabled() {
        InitShim shim = this.initShim;
        return shim != null ? shim.isEnabled() : this.isEnabled;
    }

    @Override
    @JsonProperty(value="defaultValues")
    @JsonIgnore
    public Optional<ExtensionConfiguration> getDefaultValues() {
        return Optional.ofNullable(this.defaultValues);
    }

    @Override
    @JsonProperty(value="postOnItems")
    @Nullable
    public Boolean getPostOnItems() {
        return this.postOnItems;
    }

    @Override
    @JsonProperty(value="shouldSupportPostOnItems")
    @JsonIgnore
    public boolean shouldSupportPostOnItems() {
        InitShim shim = this.initShim;
        return shim != null ? shim.shouldSupportPostOnItems() : this.shouldSupportPostOnItems;
    }

    @Override
    @JsonProperty(value="intersectsParameter")
    @Nullable
    public Boolean getIntersectsParameter() {
        return this.intersectsParameter;
    }

    public final ImmutableFeaturesExtensionsConfiguration withEnabled(@Nullable Boolean value) {
        if (Objects.equals(this.enabled, value)) {
            return this;
        }
        return new ImmutableFeaturesExtensionsConfiguration(value, this.defaultValues, this.postOnItems, this.intersectsParameter);
    }

    public final ImmutableFeaturesExtensionsConfiguration withDefaultValues(ExtensionConfiguration value) {
        ExtensionConfiguration newValue = Objects.requireNonNull(value, "defaultValues");
        if (this.defaultValues == newValue) {
            return this;
        }
        return new ImmutableFeaturesExtensionsConfiguration(this.enabled, newValue, this.postOnItems, this.intersectsParameter);
    }

    public final ImmutableFeaturesExtensionsConfiguration withDefaultValues(Optional<? extends ExtensionConfiguration> optional) {
        ExtensionConfiguration value = optional.orElse(null);
        if (this.defaultValues == value) {
            return this;
        }
        return new ImmutableFeaturesExtensionsConfiguration(this.enabled, value, this.postOnItems, this.intersectsParameter);
    }

    public final ImmutableFeaturesExtensionsConfiguration withPostOnItems(@Nullable Boolean value) {
        if (Objects.equals(this.postOnItems, value)) {
            return this;
        }
        return new ImmutableFeaturesExtensionsConfiguration(this.enabled, this.defaultValues, value, this.intersectsParameter);
    }

    public final ImmutableFeaturesExtensionsConfiguration withIntersectsParameter(@Nullable Boolean value) {
        if (Objects.equals(this.intersectsParameter, value)) {
            return this;
        }
        return new ImmutableFeaturesExtensionsConfiguration(this.enabled, this.defaultValues, this.postOnItems, value);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableFeaturesExtensionsConfiguration && this.equalTo((ImmutableFeaturesExtensionsConfiguration)another);
    }

    private boolean equalTo(ImmutableFeaturesExtensionsConfiguration another) {
        return Objects.equals(this.enabled, another.enabled) && Objects.equals(this.postOnItems, another.postOnItems) && Objects.equals(this.intersectsParameter, another.intersectsParameter);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + Objects.hashCode(this.enabled);
        h += (h << 5) + Objects.hashCode(this.postOnItems);
        h += (h << 5) + Objects.hashCode(this.intersectsParameter);
        return h;
    }

    public String toString() {
        return MoreObjects.toStringHelper("FeaturesExtensionsConfiguration").omitNullValues().add("enabled", this.enabled).add("postOnItems", this.postOnItems).add("intersectsParameter", this.intersectsParameter).toString();
    }

    public static ImmutableFeaturesExtensionsConfiguration copyOf(FeaturesExtensionsConfiguration instance) {
        if (instance instanceof ImmutableFeaturesExtensionsConfiguration) {
            return (ImmutableFeaturesExtensionsConfiguration)instance;
        }
        return new Builder().from(instance).build();
    }

    @Generated(from="FeaturesExtensionsConfiguration", generator="Immutables")
    @NotThreadSafe
    public static final class Builder
    extends FeaturesExtensionsConfiguration.Builder {
        @Nullable
        private Boolean enabled;
        @Nullable
        private ExtensionConfiguration defaultValues;
        @Nullable
        private Boolean postOnItems;
        @Nullable
        private Boolean intersectsParameter;

        @Override
        @CanIgnoreReturnValue
        public final Builder from(FeaturesExtensionsConfiguration instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        @Override
        @CanIgnoreReturnValue
        public final Builder from(ExtensionConfiguration instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        @Override
        private void from(Object object) {
            ExtensionConfiguration instance;
            if (object instanceof FeaturesExtensionsConfiguration) {
                Boolean postOnItemsValue;
                instance = (FeaturesExtensionsConfiguration)object;
                Boolean intersectsParameterValue = instance.getIntersectsParameter();
                if (intersectsParameterValue != null) {
                    this.intersectsParameter(intersectsParameterValue);
                }
                if ((postOnItemsValue = instance.getPostOnItems()) != null) {
                    this.postOnItems(postOnItemsValue);
                }
            }
            if (object instanceof ExtensionConfiguration) {
                Boolean enabledValue;
                instance = (ExtensionConfiguration)object;
                Optional<ExtensionConfiguration> defaultValuesOptional = instance.getDefaultValues();
                if (defaultValuesOptional.isPresent()) {
                    this.defaultValues(defaultValuesOptional);
                }
                if ((enabledValue = instance.getEnabled()) != null) {
                    this.enabled(enabledValue);
                }
            }
        }

        @JsonProperty(value="enabled")
        @CanIgnoreReturnValue
        public final Builder enabled(@Nullable Boolean enabled) {
            this.enabled = enabled;
            return this;
        }

        @Override
        @CanIgnoreReturnValue
        public final Builder defaultValues(ExtensionConfiguration defaultValues) {
            this.defaultValues = Objects.requireNonNull(defaultValues, "defaultValues");
            return this;
        }

        @JsonProperty(value="defaultValues")
        @JsonIgnore
        @CanIgnoreReturnValue
        public final Builder defaultValues(Optional<? extends ExtensionConfiguration> defaultValues) {
            this.defaultValues = defaultValues.orElse(null);
            return this;
        }

        @JsonProperty(value="postOnItems")
        @CanIgnoreReturnValue
        public final Builder postOnItems(@Nullable Boolean postOnItems) {
            this.postOnItems = postOnItems;
            return this;
        }

        @JsonProperty(value="intersectsParameter")
        @CanIgnoreReturnValue
        public final Builder intersectsParameter(@Nullable Boolean intersectsParameter) {
            this.intersectsParameter = intersectsParameter;
            return this;
        }

        @Override
        public ImmutableFeaturesExtensionsConfiguration build() {
            return new ImmutableFeaturesExtensionsConfiguration(this.enabled, this.defaultValues, this.postOnItems, this.intersectsParameter);
        }
    }

    @Generated(from="FeaturesExtensionsConfiguration", generator="Immutables")
    private final class InitShim {
        private byte isEnabledBuildStage = 0;
        private boolean isEnabled;
        private byte shouldSupportPostOnItemsBuildStage = 0;
        private boolean shouldSupportPostOnItems;

        private InitShim() {
        }

        boolean isEnabled() {
            if (this.isEnabledBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.isEnabledBuildStage == 0) {
                this.isEnabledBuildStage = (byte)-1;
                this.isEnabled = ImmutableFeaturesExtensionsConfiguration.this.isEnabledInitialize();
                this.isEnabledBuildStage = 1;
            }
            return this.isEnabled;
        }

        boolean shouldSupportPostOnItems() {
            if (this.shouldSupportPostOnItemsBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.shouldSupportPostOnItemsBuildStage == 0) {
                this.shouldSupportPostOnItemsBuildStage = (byte)-1;
                this.shouldSupportPostOnItems = ImmutableFeaturesExtensionsConfiguration.this.shouldSupportPostOnItemsInitialize();
                this.shouldSupportPostOnItemsBuildStage = 1;
            }
            return this.shouldSupportPostOnItems;
        }

        private String formatInitCycleMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if (this.isEnabledBuildStage == -1) {
                attributes.add("isEnabled");
            }
            if (this.shouldSupportPostOnItemsBuildStage == -1) {
                attributes.add("shouldSupportPostOnItems");
            }
            return "Cannot build FeaturesExtensionsConfiguration, attribute initializers form cycle " + attributes;
        }
    }
}

