/*
 * Decompiled with CFR 0.152.
 */
package de.ii.ogcapi.features.core.domain.processing;

import de.ii.ogcapi.features.core.domain.processing.FeatureProcess;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import shadow.org.immutables.value.Value;

public class FeatureProcessChain {
    private static final String DAPA_PATH_ELEMENT = "processes";
    private final List<FeatureProcess> processes;

    public FeatureProcessChain(List<FeatureProcess> processes) {
        this.processes = processes;
    }

    @Value.Derived
    @Value.Auxiliary
    public List<FeatureProcess> asList() {
        return this.processes;
    }

    @Value.Derived
    @Value.Auxiliary
    public String getSubSubPath() {
        return "/processes/" + String.join((CharSequence)":", this.processes.stream().map(process -> process.getName()).collect(Collectors.toList()));
    }

    public boolean includes(String ... processNames) {
        for (String name : processNames) {
            if (!this.processes.stream().anyMatch(process -> process.getName().equals(name) || name.equals("*"))) continue;
            return true;
        }
        return false;
    }

    public String getOperationSummary() {
        return this.processes.get(this.processes.size() - 1).getSummary();
    }

    public Optional<String> getOperationDescription() {
        return this.processes.get(this.processes.size() - 1).getDescription();
    }

    public Optional<String> getResponseDescription() {
        return Optional.empty();
    }
}

