/*
 * Decompiled with CFR 0.152.
 */
package de.ii.ogcapi.features.core.domain;

import de.ii.ogcapi.features.core.domain.FeaturesCollectionQueryables;
import de.ii.ogcapi.features.core.domain.FeaturesCoreConfiguration;
import de.ii.ogcapi.foundation.domain.Caching;
import de.ii.ogcapi.foundation.domain.CachingConfiguration;
import de.ii.ogcapi.foundation.domain.ExtensionConfiguration;
import de.ii.xtraplatform.crs.domain.EpsgCrs;
import de.ii.xtraplatform.features.domain.transform.PropertyTransformation;
import de.ii.xtraplatform.features.domain.transform.PropertyTransformations;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import shadow.com.fasterxml.jackson.annotation.JsonIgnore;
import shadow.com.fasterxml.jackson.annotation.JsonProperty;
import shadow.com.google.common.base.MoreObjects;
import shadow.com.google.common.collect.ImmutableList;
import shadow.com.google.common.collect.ImmutableMap;
import shadow.com.google.common.collect.ImmutableSet;
import shadow.com.google.errorprone.annotations.CanIgnoreReturnValue;
import shadow.javax.annotation.CheckReturnValue;
import shadow.javax.annotation.Nullable;
import shadow.javax.annotation.ParametersAreNonnullByDefault;
import shadow.javax.annotation.concurrent.Immutable;
import shadow.javax.annotation.concurrent.NotThreadSafe;
import shadow.org.immutables.value.Generated;

@ParametersAreNonnullByDefault
@CheckReturnValue
@Generated(from="FeaturesCoreConfiguration", generator="Immutables")
@Immutable
public final class ImmutableFeaturesCoreConfiguration
implements FeaturesCoreConfiguration {
    @Nullable
    private final Boolean enabled;
    private final transient boolean isEnabled;
    @Nullable
    private final ExtensionConfiguration defaultValues;
    private final transient boolean hasDeprecatedTransformationKeys;
    @Nullable
    private final Caching caching;
    @Nullable
    private final String featureProvider;
    @Nullable
    private final String featureType;
    private final ImmutableList<String> featureTypes;
    @Nullable
    private final FeaturesCoreConfiguration.DefaultCrs defaultCrs;
    @Nullable
    private final Integer minimumPageSize;
    @Nullable
    private final Integer defaultPageSize;
    @Nullable
    private final Integer maximumPageSize;
    private final ImmutableSet<String> embeddedFeatureLinkRels;
    @Nullable
    private final Boolean showsFeatureSelfLink;
    @Nullable
    private final FeaturesCoreConfiguration.ItemType itemType;
    @Nullable
    private final FeaturesCollectionQueryables queryables;
    private final ImmutableMap<String, Integer> coordinatePrecision;
    private final ImmutableMap<String, List<PropertyTransformation>> transformations;
    private final transient EpsgCrs defaultEpsgCrs;
    private final transient Map<String, String> allFilterParameters;
    private final transient List<String> qOrOtherFilterParameters;
    private final transient List<String> qProperties;
    private final transient boolean hasDeprecatedQueryables;
    private static final byte STAGE_INITIALIZING = -1;
    private static final byte STAGE_UNINITIALIZED = 0;
    private static final byte STAGE_INITIALIZED = 1;
    private volatile transient InitShim initShim = new InitShim();

    private ImmutableFeaturesCoreConfiguration(Builder builder) {
        this.enabled = builder.enabled;
        this.defaultValues = builder.defaultValues;
        this.caching = builder.caching;
        this.featureProvider = builder.featureProvider;
        this.featureType = builder.featureType;
        this.defaultCrs = builder.defaultCrs;
        this.minimumPageSize = builder.minimumPageSize;
        this.defaultPageSize = builder.defaultPageSize;
        this.maximumPageSize = builder.maximumPageSize;
        this.embeddedFeatureLinkRels = builder.embeddedFeatureLinkRels.build();
        this.showsFeatureSelfLink = builder.showsFeatureSelfLink;
        this.itemType = builder.itemType;
        this.queryables = builder.queryables;
        this.coordinatePrecision = builder.coordinatePrecision.build();
        this.transformations = builder.transformations.build();
        if (builder.featureTypesIsSet()) {
            this.initShim.featureTypes((ImmutableList<String>)builder.featureTypes.build());
        }
        this.isEnabled = this.initShim.isEnabled();
        this.hasDeprecatedTransformationKeys = this.initShim.hasDeprecatedTransformationKeys();
        this.featureTypes = this.initShim.getFeatureTypes();
        this.defaultEpsgCrs = this.initShim.getDefaultEpsgCrs();
        this.allFilterParameters = this.initShim.getAllFilterParameters();
        this.qOrOtherFilterParameters = this.initShim.getQOrOtherFilterParameters();
        this.qProperties = this.initShim.getQProperties();
        this.hasDeprecatedQueryables = this.initShim.hasDeprecatedQueryables();
        this.initShim = null;
    }

    private ImmutableFeaturesCoreConfiguration(@Nullable Boolean enabled, @Nullable ExtensionConfiguration defaultValues, @Nullable Caching caching, @Nullable String featureProvider, @Nullable String featureType, ImmutableList<String> featureTypes, @Nullable FeaturesCoreConfiguration.DefaultCrs defaultCrs, @Nullable Integer minimumPageSize, @Nullable Integer defaultPageSize, @Nullable Integer maximumPageSize, ImmutableSet<String> embeddedFeatureLinkRels, @Nullable Boolean showsFeatureSelfLink, @Nullable FeaturesCoreConfiguration.ItemType itemType, @Nullable FeaturesCollectionQueryables queryables, ImmutableMap<String, Integer> coordinatePrecision, ImmutableMap<String, List<PropertyTransformation>> transformations) {
        this.enabled = enabled;
        this.defaultValues = defaultValues;
        this.caching = caching;
        this.featureProvider = featureProvider;
        this.featureType = featureType;
        this.initShim.featureTypes(featureTypes);
        this.defaultCrs = defaultCrs;
        this.minimumPageSize = minimumPageSize;
        this.defaultPageSize = defaultPageSize;
        this.maximumPageSize = maximumPageSize;
        this.embeddedFeatureLinkRels = embeddedFeatureLinkRels;
        this.showsFeatureSelfLink = showsFeatureSelfLink;
        this.itemType = itemType;
        this.queryables = queryables;
        this.coordinatePrecision = coordinatePrecision;
        this.transformations = transformations;
        this.isEnabled = this.initShim.isEnabled();
        this.hasDeprecatedTransformationKeys = this.initShim.hasDeprecatedTransformationKeys();
        this.featureTypes = this.initShim.getFeatureTypes();
        this.defaultEpsgCrs = this.initShim.getDefaultEpsgCrs();
        this.allFilterParameters = this.initShim.getAllFilterParameters();
        this.qOrOtherFilterParameters = this.initShim.getQOrOtherFilterParameters();
        this.qProperties = this.initShim.getQProperties();
        this.hasDeprecatedQueryables = this.initShim.hasDeprecatedQueryables();
        this.initShim = null;
    }

    private boolean isEnabledInitialize() {
        return FeaturesCoreConfiguration.super.isEnabled();
    }

    private boolean hasDeprecatedTransformationKeysInitialize() {
        return FeaturesCoreConfiguration.super.hasDeprecatedTransformationKeys();
    }

    private List<String> getFeatureTypesInitialize() {
        return FeaturesCoreConfiguration.super.getFeatureTypes();
    }

    private EpsgCrs getDefaultEpsgCrsInitialize() {
        return FeaturesCoreConfiguration.super.getDefaultEpsgCrs();
    }

    private Map<String, String> getAllFilterParametersInitialize() {
        return FeaturesCoreConfiguration.super.getAllFilterParameters();
    }

    private List<String> getQOrOtherFilterParametersInitialize() {
        return FeaturesCoreConfiguration.super.getQOrOtherFilterParameters();
    }

    private List<String> getQPropertiesInitialize() {
        return FeaturesCoreConfiguration.super.getQProperties();
    }

    private boolean hasDeprecatedQueryablesInitialize() {
        return FeaturesCoreConfiguration.super.hasDeprecatedQueryables();
    }

    @Override
    @JsonProperty(value="enabled")
    @Nullable
    public Boolean getEnabled() {
        return this.enabled;
    }

    @Override
    @JsonProperty(value="isEnabled")
    @JsonIgnore
    public boolean isEnabled() {
        InitShim shim = this.initShim;
        return shim != null ? shim.isEnabled() : this.isEnabled;
    }

    @Override
    @JsonProperty(value="defaultValues")
    @JsonIgnore
    public Optional<ExtensionConfiguration> getDefaultValues() {
        return Optional.ofNullable(this.defaultValues);
    }

    @Override
    @JsonProperty(value="hasDeprecatedTransformationKeys")
    @JsonIgnore
    public boolean hasDeprecatedTransformationKeys() {
        InitShim shim = this.initShim;
        return shim != null ? shim.hasDeprecatedTransformationKeys() : this.hasDeprecatedTransformationKeys;
    }

    @Override
    @JsonProperty(value="caching")
    @Nullable
    public Caching getCaching() {
        return this.caching;
    }

    @Override
    @JsonProperty(value="featureProvider")
    public Optional<String> getFeatureProvider() {
        return Optional.ofNullable(this.featureProvider);
    }

    @Override
    @JsonProperty(value="featureType")
    public Optional<String> getFeatureType() {
        return Optional.ofNullable(this.featureType);
    }

    @JsonProperty(access=JsonProperty.Access.WRITE_ONLY)
    public ImmutableList<String> getFeatureTypes() {
        InitShim shim = this.initShim;
        return shim != null ? shim.getFeatureTypes() : this.featureTypes;
    }

    @Override
    @JsonProperty(value="defaultCrs")
    @Nullable
    public FeaturesCoreConfiguration.DefaultCrs getDefaultCrs() {
        return this.defaultCrs;
    }

    @Override
    @JsonProperty(value="minimumPageSize")
    @Nullable
    public Integer getMinimumPageSize() {
        return this.minimumPageSize;
    }

    @Override
    @JsonProperty(value="defaultPageSize")
    @Nullable
    public Integer getDefaultPageSize() {
        return this.defaultPageSize;
    }

    @Override
    @JsonProperty(value="maximumPageSize")
    @Nullable
    public Integer getMaximumPageSize() {
        return this.maximumPageSize;
    }

    @JsonProperty(value="embeddedFeatureLinkRels")
    public ImmutableSet<String> getEmbeddedFeatureLinkRels() {
        return this.embeddedFeatureLinkRels;
    }

    @Override
    @JsonProperty(value="showsFeatureSelfLink")
    @Deprecated
    @Nullable
    public Boolean getShowsFeatureSelfLink() {
        return this.showsFeatureSelfLink;
    }

    @Override
    @JsonProperty(value="itemType")
    public Optional<FeaturesCoreConfiguration.ItemType> getItemType() {
        return Optional.ofNullable(this.itemType);
    }

    @Override
    @JsonProperty(value="queryables")
    public Optional<FeaturesCollectionQueryables> getQueryables() {
        return Optional.ofNullable(this.queryables);
    }

    @JsonProperty(value="coordinatePrecision")
    public ImmutableMap<String, Integer> getCoordinatePrecision() {
        return this.coordinatePrecision;
    }

    @JsonProperty(value="transformations")
    public ImmutableMap<String, List<PropertyTransformation>> getTransformations() {
        return this.transformations;
    }

    @Override
    @JsonProperty(value="defaultEpsgCrs")
    @JsonIgnore
    public EpsgCrs getDefaultEpsgCrs() {
        InitShim shim = this.initShim;
        return shim != null ? shim.getDefaultEpsgCrs() : this.defaultEpsgCrs;
    }

    @Override
    @JsonProperty(value="allFilterParameters")
    @JsonIgnore
    public Map<String, String> getAllFilterParameters() {
        InitShim shim = this.initShim;
        return shim != null ? shim.getAllFilterParameters() : this.allFilterParameters;
    }

    @Override
    @JsonProperty(value="qOrOtherFilterParameters")
    @JsonIgnore
    public List<String> getQOrOtherFilterParameters() {
        InitShim shim = this.initShim;
        return shim != null ? shim.getQOrOtherFilterParameters() : this.qOrOtherFilterParameters;
    }

    @Override
    @JsonProperty(value="qProperties")
    @JsonIgnore
    public List<String> getQProperties() {
        InitShim shim = this.initShim;
        return shim != null ? shim.getQProperties() : this.qProperties;
    }

    @Override
    @JsonProperty(value="hasDeprecatedQueryables")
    @JsonIgnore
    public boolean hasDeprecatedQueryables() {
        InitShim shim = this.initShim;
        return shim != null ? shim.hasDeprecatedQueryables() : this.hasDeprecatedQueryables;
    }

    public final ImmutableFeaturesCoreConfiguration withEnabled(@Nullable Boolean value) {
        if (Objects.equals(this.enabled, value)) {
            return this;
        }
        return new ImmutableFeaturesCoreConfiguration(value, this.defaultValues, this.caching, this.featureProvider, this.featureType, this.featureTypes, this.defaultCrs, this.minimumPageSize, this.defaultPageSize, this.maximumPageSize, this.embeddedFeatureLinkRels, this.showsFeatureSelfLink, this.itemType, this.queryables, this.coordinatePrecision, this.transformations);
    }

    public final ImmutableFeaturesCoreConfiguration withDefaultValues(ExtensionConfiguration value) {
        ExtensionConfiguration newValue = Objects.requireNonNull(value, "defaultValues");
        if (this.defaultValues == newValue) {
            return this;
        }
        return new ImmutableFeaturesCoreConfiguration(this.enabled, newValue, this.caching, this.featureProvider, this.featureType, this.featureTypes, this.defaultCrs, this.minimumPageSize, this.defaultPageSize, this.maximumPageSize, this.embeddedFeatureLinkRels, this.showsFeatureSelfLink, this.itemType, this.queryables, this.coordinatePrecision, this.transformations);
    }

    public final ImmutableFeaturesCoreConfiguration withDefaultValues(Optional<? extends ExtensionConfiguration> optional) {
        ExtensionConfiguration value = optional.orElse(null);
        if (this.defaultValues == value) {
            return this;
        }
        return new ImmutableFeaturesCoreConfiguration(this.enabled, value, this.caching, this.featureProvider, this.featureType, this.featureTypes, this.defaultCrs, this.minimumPageSize, this.defaultPageSize, this.maximumPageSize, this.embeddedFeatureLinkRels, this.showsFeatureSelfLink, this.itemType, this.queryables, this.coordinatePrecision, this.transformations);
    }

    public final ImmutableFeaturesCoreConfiguration withCaching(@Nullable Caching value) {
        if (this.caching == value) {
            return this;
        }
        return new ImmutableFeaturesCoreConfiguration(this.enabled, this.defaultValues, value, this.featureProvider, this.featureType, this.featureTypes, this.defaultCrs, this.minimumPageSize, this.defaultPageSize, this.maximumPageSize, this.embeddedFeatureLinkRels, this.showsFeatureSelfLink, this.itemType, this.queryables, this.coordinatePrecision, this.transformations);
    }

    public final ImmutableFeaturesCoreConfiguration withFeatureProvider(String value) {
        String newValue = Objects.requireNonNull(value, "featureProvider");
        if (Objects.equals(this.featureProvider, newValue)) {
            return this;
        }
        return new ImmutableFeaturesCoreConfiguration(this.enabled, this.defaultValues, this.caching, newValue, this.featureType, this.featureTypes, this.defaultCrs, this.minimumPageSize, this.defaultPageSize, this.maximumPageSize, this.embeddedFeatureLinkRels, this.showsFeatureSelfLink, this.itemType, this.queryables, this.coordinatePrecision, this.transformations);
    }

    public final ImmutableFeaturesCoreConfiguration withFeatureProvider(Optional<String> optional) {
        String value = optional.orElse(null);
        if (Objects.equals(this.featureProvider, value)) {
            return this;
        }
        return new ImmutableFeaturesCoreConfiguration(this.enabled, this.defaultValues, this.caching, value, this.featureType, this.featureTypes, this.defaultCrs, this.minimumPageSize, this.defaultPageSize, this.maximumPageSize, this.embeddedFeatureLinkRels, this.showsFeatureSelfLink, this.itemType, this.queryables, this.coordinatePrecision, this.transformations);
    }

    public final ImmutableFeaturesCoreConfiguration withFeatureType(String value) {
        String newValue = Objects.requireNonNull(value, "featureType");
        if (Objects.equals(this.featureType, newValue)) {
            return this;
        }
        return new ImmutableFeaturesCoreConfiguration(this.enabled, this.defaultValues, this.caching, this.featureProvider, newValue, this.featureTypes, this.defaultCrs, this.minimumPageSize, this.defaultPageSize, this.maximumPageSize, this.embeddedFeatureLinkRels, this.showsFeatureSelfLink, this.itemType, this.queryables, this.coordinatePrecision, this.transformations);
    }

    public final ImmutableFeaturesCoreConfiguration withFeatureType(Optional<String> optional) {
        String value = optional.orElse(null);
        if (Objects.equals(this.featureType, value)) {
            return this;
        }
        return new ImmutableFeaturesCoreConfiguration(this.enabled, this.defaultValues, this.caching, this.featureProvider, value, this.featureTypes, this.defaultCrs, this.minimumPageSize, this.defaultPageSize, this.maximumPageSize, this.embeddedFeatureLinkRels, this.showsFeatureSelfLink, this.itemType, this.queryables, this.coordinatePrecision, this.transformations);
    }

    public final ImmutableFeaturesCoreConfiguration withFeatureTypes(String ... elements) {
        ImmutableList<String> newValue = ImmutableList.copyOf(elements);
        return new ImmutableFeaturesCoreConfiguration(this.enabled, this.defaultValues, this.caching, this.featureProvider, this.featureType, newValue, this.defaultCrs, this.minimumPageSize, this.defaultPageSize, this.maximumPageSize, this.embeddedFeatureLinkRels, this.showsFeatureSelfLink, this.itemType, this.queryables, this.coordinatePrecision, this.transformations);
    }

    public final ImmutableFeaturesCoreConfiguration withFeatureTypes(Iterable<String> elements) {
        if (this.featureTypes == elements) {
            return this;
        }
        ImmutableList<String> newValue = ImmutableList.copyOf(elements);
        return new ImmutableFeaturesCoreConfiguration(this.enabled, this.defaultValues, this.caching, this.featureProvider, this.featureType, newValue, this.defaultCrs, this.minimumPageSize, this.defaultPageSize, this.maximumPageSize, this.embeddedFeatureLinkRels, this.showsFeatureSelfLink, this.itemType, this.queryables, this.coordinatePrecision, this.transformations);
    }

    public final ImmutableFeaturesCoreConfiguration withDefaultCrs(@Nullable FeaturesCoreConfiguration.DefaultCrs value) {
        if (this.defaultCrs == value) {
            return this;
        }
        if (Objects.equals((Object)this.defaultCrs, (Object)value)) {
            return this;
        }
        return new ImmutableFeaturesCoreConfiguration(this.enabled, this.defaultValues, this.caching, this.featureProvider, this.featureType, this.featureTypes, value, this.minimumPageSize, this.defaultPageSize, this.maximumPageSize, this.embeddedFeatureLinkRels, this.showsFeatureSelfLink, this.itemType, this.queryables, this.coordinatePrecision, this.transformations);
    }

    public final ImmutableFeaturesCoreConfiguration withMinimumPageSize(@Nullable Integer value) {
        if (Objects.equals(this.minimumPageSize, value)) {
            return this;
        }
        return new ImmutableFeaturesCoreConfiguration(this.enabled, this.defaultValues, this.caching, this.featureProvider, this.featureType, this.featureTypes, this.defaultCrs, value, this.defaultPageSize, this.maximumPageSize, this.embeddedFeatureLinkRels, this.showsFeatureSelfLink, this.itemType, this.queryables, this.coordinatePrecision, this.transformations);
    }

    public final ImmutableFeaturesCoreConfiguration withDefaultPageSize(@Nullable Integer value) {
        if (Objects.equals(this.defaultPageSize, value)) {
            return this;
        }
        return new ImmutableFeaturesCoreConfiguration(this.enabled, this.defaultValues, this.caching, this.featureProvider, this.featureType, this.featureTypes, this.defaultCrs, this.minimumPageSize, value, this.maximumPageSize, this.embeddedFeatureLinkRels, this.showsFeatureSelfLink, this.itemType, this.queryables, this.coordinatePrecision, this.transformations);
    }

    public final ImmutableFeaturesCoreConfiguration withMaximumPageSize(@Nullable Integer value) {
        if (Objects.equals(this.maximumPageSize, value)) {
            return this;
        }
        return new ImmutableFeaturesCoreConfiguration(this.enabled, this.defaultValues, this.caching, this.featureProvider, this.featureType, this.featureTypes, this.defaultCrs, this.minimumPageSize, this.defaultPageSize, value, this.embeddedFeatureLinkRels, this.showsFeatureSelfLink, this.itemType, this.queryables, this.coordinatePrecision, this.transformations);
    }

    public final ImmutableFeaturesCoreConfiguration withEmbeddedFeatureLinkRels(String ... elements) {
        ImmutableSet<String> newValue = ImmutableSet.copyOf(elements);
        return new ImmutableFeaturesCoreConfiguration(this.enabled, this.defaultValues, this.caching, this.featureProvider, this.featureType, this.featureTypes, this.defaultCrs, this.minimumPageSize, this.defaultPageSize, this.maximumPageSize, newValue, this.showsFeatureSelfLink, this.itemType, this.queryables, this.coordinatePrecision, this.transformations);
    }

    public final ImmutableFeaturesCoreConfiguration withEmbeddedFeatureLinkRels(Iterable<String> elements) {
        if (this.embeddedFeatureLinkRels == elements) {
            return this;
        }
        ImmutableSet<String> newValue = ImmutableSet.copyOf(elements);
        return new ImmutableFeaturesCoreConfiguration(this.enabled, this.defaultValues, this.caching, this.featureProvider, this.featureType, this.featureTypes, this.defaultCrs, this.minimumPageSize, this.defaultPageSize, this.maximumPageSize, newValue, this.showsFeatureSelfLink, this.itemType, this.queryables, this.coordinatePrecision, this.transformations);
    }

    @Deprecated
    public final ImmutableFeaturesCoreConfiguration withShowsFeatureSelfLink(@Nullable Boolean value) {
        if (Objects.equals(this.showsFeatureSelfLink, value)) {
            return this;
        }
        return new ImmutableFeaturesCoreConfiguration(this.enabled, this.defaultValues, this.caching, this.featureProvider, this.featureType, this.featureTypes, this.defaultCrs, this.minimumPageSize, this.defaultPageSize, this.maximumPageSize, this.embeddedFeatureLinkRels, value, this.itemType, this.queryables, this.coordinatePrecision, this.transformations);
    }

    public final ImmutableFeaturesCoreConfiguration withItemType(FeaturesCoreConfiguration.ItemType value) {
        FeaturesCoreConfiguration.ItemType newValue = Objects.requireNonNull(value, "itemType");
        if (this.itemType == newValue) {
            return this;
        }
        return new ImmutableFeaturesCoreConfiguration(this.enabled, this.defaultValues, this.caching, this.featureProvider, this.featureType, this.featureTypes, this.defaultCrs, this.minimumPageSize, this.defaultPageSize, this.maximumPageSize, this.embeddedFeatureLinkRels, this.showsFeatureSelfLink, newValue, this.queryables, this.coordinatePrecision, this.transformations);
    }

    public final ImmutableFeaturesCoreConfiguration withItemType(Optional<? extends FeaturesCoreConfiguration.ItemType> optional) {
        FeaturesCoreConfiguration.ItemType value = optional.orElse(null);
        if (Objects.equals((Object)this.itemType, (Object)value)) {
            return this;
        }
        return new ImmutableFeaturesCoreConfiguration(this.enabled, this.defaultValues, this.caching, this.featureProvider, this.featureType, this.featureTypes, this.defaultCrs, this.minimumPageSize, this.defaultPageSize, this.maximumPageSize, this.embeddedFeatureLinkRels, this.showsFeatureSelfLink, value, this.queryables, this.coordinatePrecision, this.transformations);
    }

    public final ImmutableFeaturesCoreConfiguration withQueryables(FeaturesCollectionQueryables value) {
        FeaturesCollectionQueryables newValue = Objects.requireNonNull(value, "queryables");
        if (this.queryables == newValue) {
            return this;
        }
        return new ImmutableFeaturesCoreConfiguration(this.enabled, this.defaultValues, this.caching, this.featureProvider, this.featureType, this.featureTypes, this.defaultCrs, this.minimumPageSize, this.defaultPageSize, this.maximumPageSize, this.embeddedFeatureLinkRels, this.showsFeatureSelfLink, this.itemType, newValue, this.coordinatePrecision, this.transformations);
    }

    public final ImmutableFeaturesCoreConfiguration withQueryables(Optional<? extends FeaturesCollectionQueryables> optional) {
        FeaturesCollectionQueryables value = optional.orElse(null);
        if (this.queryables == value) {
            return this;
        }
        return new ImmutableFeaturesCoreConfiguration(this.enabled, this.defaultValues, this.caching, this.featureProvider, this.featureType, this.featureTypes, this.defaultCrs, this.minimumPageSize, this.defaultPageSize, this.maximumPageSize, this.embeddedFeatureLinkRels, this.showsFeatureSelfLink, this.itemType, value, this.coordinatePrecision, this.transformations);
    }

    public final ImmutableFeaturesCoreConfiguration withCoordinatePrecision(Map<String, ? extends Integer> entries) {
        if (this.coordinatePrecision == entries) {
            return this;
        }
        ImmutableMap<String, Integer> newValue = ImmutableMap.copyOf(entries);
        return new ImmutableFeaturesCoreConfiguration(this.enabled, this.defaultValues, this.caching, this.featureProvider, this.featureType, this.featureTypes, this.defaultCrs, this.minimumPageSize, this.defaultPageSize, this.maximumPageSize, this.embeddedFeatureLinkRels, this.showsFeatureSelfLink, this.itemType, this.queryables, newValue, this.transformations);
    }

    public final ImmutableFeaturesCoreConfiguration withTransformations(Map<String, ? extends List<PropertyTransformation>> entries) {
        if (this.transformations == entries) {
            return this;
        }
        ImmutableMap<String, List<PropertyTransformation>> newValue = ImmutableMap.copyOf(entries);
        return new ImmutableFeaturesCoreConfiguration(this.enabled, this.defaultValues, this.caching, this.featureProvider, this.featureType, this.featureTypes, this.defaultCrs, this.minimumPageSize, this.defaultPageSize, this.maximumPageSize, this.embeddedFeatureLinkRels, this.showsFeatureSelfLink, this.itemType, this.queryables, this.coordinatePrecision, newValue);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableFeaturesCoreConfiguration && this.equalTo((ImmutableFeaturesCoreConfiguration)another);
    }

    private boolean equalTo(ImmutableFeaturesCoreConfiguration another) {
        return Objects.equals(this.enabled, another.enabled) && Objects.equals(this.caching, another.caching) && Objects.equals(this.featureProvider, another.featureProvider) && Objects.equals(this.featureType, another.featureType) && this.featureTypes.equals(another.featureTypes) && Objects.equals((Object)this.defaultCrs, (Object)another.defaultCrs) && Objects.equals(this.minimumPageSize, another.minimumPageSize) && Objects.equals(this.defaultPageSize, another.defaultPageSize) && Objects.equals(this.maximumPageSize, another.maximumPageSize) && this.embeddedFeatureLinkRels.equals(another.embeddedFeatureLinkRels) && Objects.equals(this.showsFeatureSelfLink, another.showsFeatureSelfLink) && Objects.equals((Object)this.itemType, (Object)another.itemType) && Objects.equals(this.queryables, another.queryables) && this.coordinatePrecision.equals(another.coordinatePrecision) && this.transformations.equals(another.transformations);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + Objects.hashCode(this.enabled);
        h += (h << 5) + Objects.hashCode(this.caching);
        h += (h << 5) + Objects.hashCode(this.featureProvider);
        h += (h << 5) + Objects.hashCode(this.featureType);
        h += (h << 5) + this.featureTypes.hashCode();
        h += (h << 5) + Objects.hashCode((Object)this.defaultCrs);
        h += (h << 5) + Objects.hashCode(this.minimumPageSize);
        h += (h << 5) + Objects.hashCode(this.defaultPageSize);
        h += (h << 5) + Objects.hashCode(this.maximumPageSize);
        h += (h << 5) + this.embeddedFeatureLinkRels.hashCode();
        h += (h << 5) + Objects.hashCode(this.showsFeatureSelfLink);
        h += (h << 5) + Objects.hashCode((Object)this.itemType);
        h += (h << 5) + Objects.hashCode(this.queryables);
        h += (h << 5) + this.coordinatePrecision.hashCode();
        h += (h << 5) + this.transformations.hashCode();
        return h;
    }

    public String toString() {
        return MoreObjects.toStringHelper("FeaturesCoreConfiguration").omitNullValues().add("enabled", this.enabled).add("caching", this.caching).add("featureProvider", this.featureProvider).add("featureType", this.featureType).add("featureTypes", this.featureTypes).add("defaultCrs", (Object)this.defaultCrs).add("minimumPageSize", this.minimumPageSize).add("defaultPageSize", this.defaultPageSize).add("maximumPageSize", this.maximumPageSize).add("embeddedFeatureLinkRels", this.embeddedFeatureLinkRels).add("showsFeatureSelfLink", this.showsFeatureSelfLink).add("itemType", (Object)this.itemType).add("queryables", this.queryables).add("coordinatePrecision", this.coordinatePrecision).add("transformations", this.transformations).toString();
    }

    public static ImmutableFeaturesCoreConfiguration copyOf(FeaturesCoreConfiguration instance) {
        if (instance instanceof ImmutableFeaturesCoreConfiguration) {
            return (ImmutableFeaturesCoreConfiguration)instance;
        }
        return new Builder().from(instance).build();
    }

    @Generated(from="FeaturesCoreConfiguration", generator="Immutables")
    @NotThreadSafe
    public static final class Builder
    extends FeaturesCoreConfiguration.Builder {
        private static final long OPT_BIT_FEATURE_TYPES = 1L;
        private long optBits;
        @Nullable
        private Boolean enabled;
        @Nullable
        private ExtensionConfiguration defaultValues;
        @Nullable
        private Caching caching;
        @Nullable
        private String featureProvider;
        @Nullable
        private String featureType;
        private ImmutableList.Builder<String> featureTypes = ImmutableList.builder();
        @Nullable
        private FeaturesCoreConfiguration.DefaultCrs defaultCrs;
        @Nullable
        private Integer minimumPageSize;
        @Nullable
        private Integer defaultPageSize;
        @Nullable
        private Integer maximumPageSize;
        private ImmutableSet.Builder<String> embeddedFeatureLinkRels = ImmutableSet.builder();
        @Nullable
        private Boolean showsFeatureSelfLink;
        @Nullable
        private FeaturesCoreConfiguration.ItemType itemType;
        @Nullable
        private FeaturesCollectionQueryables queryables;
        private ImmutableMap.Builder<String, Integer> coordinatePrecision = ImmutableMap.builder();
        private ImmutableMap.Builder<String, List<PropertyTransformation>> transformations = ImmutableMap.builder();

        @Override
        @CanIgnoreReturnValue
        public final Builder from(FeaturesCoreConfiguration instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        @Override
        @CanIgnoreReturnValue
        public final Builder from(ExtensionConfiguration instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        @Override
        @CanIgnoreReturnValue
        public final Builder from(CachingConfiguration instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        @Override
        @CanIgnoreReturnValue
        public final Builder from(PropertyTransformations instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        @Override
        private void from(Object object) {
            Caching cachingValue;
            Object instance;
            long bits = 0L;
            if (object instanceof FeaturesCoreConfiguration) {
                Optional<String> featureTypeOptional;
                Integer maximumPageSizeValue;
                FeaturesCoreConfiguration.DefaultCrs defaultCrsValue;
                Optional<String> featureProviderOptional;
                Boolean showsFeatureSelfLinkValue;
                Integer minimumPageSizeValue;
                Integer defaultPageSizeValue;
                instance = (FeaturesCoreConfiguration)object;
                Optional<FeaturesCoreConfiguration.ItemType> itemTypeOptional = instance.getItemType();
                if (itemTypeOptional.isPresent()) {
                    this.itemType(itemTypeOptional);
                }
                if ((defaultPageSizeValue = instance.getDefaultPageSize()) != null) {
                    this.defaultPageSize(defaultPageSizeValue);
                }
                if ((minimumPageSizeValue = instance.getMinimumPageSize()) != null) {
                    this.minimumPageSize(minimumPageSizeValue);
                }
                if ((showsFeatureSelfLinkValue = instance.getShowsFeatureSelfLink()) != null) {
                    this.showsFeatureSelfLink(showsFeatureSelfLinkValue);
                }
                if ((featureProviderOptional = instance.getFeatureProvider()).isPresent()) {
                    this.featureProvider(featureProviderOptional);
                }
                if ((defaultCrsValue = instance.getDefaultCrs()) != null) {
                    this.defaultCrs(defaultCrsValue);
                }
                if ((maximumPageSizeValue = instance.getMaximumPageSize()) != null) {
                    this.maximumPageSize(maximumPageSizeValue);
                }
                this.putAllCoordinatePrecision(instance.getCoordinatePrecision());
                if ((bits & 1L) == 0L) {
                    this.putAllTransformations(instance.getTransformations());
                    bits |= 1L;
                }
                if ((featureTypeOptional = instance.getFeatureType()).isPresent()) {
                    this.featureType(featureTypeOptional);
                }
                this.addAllEmbeddedFeatureLinkRels(instance.getEmbeddedFeatureLinkRels());
                this.addAllFeatureTypes(instance.getFeatureTypes());
                Optional<FeaturesCollectionQueryables> queryablesOptional = instance.getQueryables();
                if (queryablesOptional.isPresent()) {
                    this.queryables(queryablesOptional);
                }
            }
            if (object instanceof ExtensionConfiguration) {
                Boolean enabledValue;
                instance = (ExtensionConfiguration)object;
                Optional<ExtensionConfiguration> defaultValuesOptional = instance.getDefaultValues();
                if (defaultValuesOptional.isPresent()) {
                    this.defaultValues(defaultValuesOptional);
                }
                if ((enabledValue = instance.getEnabled()) != null) {
                    this.enabled(enabledValue);
                }
            }
            if (object instanceof CachingConfiguration && (cachingValue = (instance = (CachingConfiguration)object).getCaching()) != null) {
                this.caching(cachingValue);
            }
            if (object instanceof PropertyTransformations) {
                instance = (PropertyTransformations)object;
                if ((bits & 1L) == 0L) {
                    this.putAllTransformations(instance.getTransformations());
                    bits |= 1L;
                }
            }
        }

        @JsonProperty(value="enabled")
        @CanIgnoreReturnValue
        public final Builder enabled(@Nullable Boolean enabled) {
            this.enabled = enabled;
            return this;
        }

        @Override
        @CanIgnoreReturnValue
        public final Builder defaultValues(ExtensionConfiguration defaultValues) {
            this.defaultValues = Objects.requireNonNull(defaultValues, "defaultValues");
            return this;
        }

        @JsonProperty(value="defaultValues")
        @JsonIgnore
        @CanIgnoreReturnValue
        public final Builder defaultValues(Optional<? extends ExtensionConfiguration> defaultValues) {
            this.defaultValues = defaultValues.orElse(null);
            return this;
        }

        @JsonProperty(value="caching")
        @CanIgnoreReturnValue
        public final Builder caching(@Nullable Caching caching) {
            this.caching = caching;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder featureProvider(String featureProvider) {
            this.featureProvider = Objects.requireNonNull(featureProvider, "featureProvider");
            return this;
        }

        @JsonProperty(value="featureProvider")
        @CanIgnoreReturnValue
        public final Builder featureProvider(Optional<String> featureProvider) {
            this.featureProvider = featureProvider.orElse(null);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder featureType(String featureType) {
            this.featureType = Objects.requireNonNull(featureType, "featureType");
            return this;
        }

        @JsonProperty(value="featureType")
        @CanIgnoreReturnValue
        public final Builder featureType(Optional<String> featureType) {
            this.featureType = featureType.orElse(null);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder addFeatureTypes(String element) {
            this.featureTypes.add((Object)element);
            this.optBits |= 1L;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder addFeatureTypes(String ... elements) {
            this.featureTypes.add(elements);
            this.optBits |= 1L;
            return this;
        }

        @JsonProperty(access=JsonProperty.Access.WRITE_ONLY)
        @CanIgnoreReturnValue
        public final Builder featureTypes(Iterable<String> elements) {
            this.featureTypes = ImmutableList.builder();
            return this.addAllFeatureTypes(elements);
        }

        @CanIgnoreReturnValue
        public final Builder addAllFeatureTypes(Iterable<String> elements) {
            this.featureTypes.addAll((Iterable)elements);
            this.optBits |= 1L;
            return this;
        }

        @JsonProperty(value="defaultCrs")
        @CanIgnoreReturnValue
        public final Builder defaultCrs(@Nullable FeaturesCoreConfiguration.DefaultCrs defaultCrs) {
            this.defaultCrs = defaultCrs;
            return this;
        }

        @JsonProperty(value="minimumPageSize")
        @CanIgnoreReturnValue
        public final Builder minimumPageSize(@Nullable Integer minimumPageSize) {
            this.minimumPageSize = minimumPageSize;
            return this;
        }

        @JsonProperty(value="defaultPageSize")
        @CanIgnoreReturnValue
        public final Builder defaultPageSize(@Nullable Integer defaultPageSize) {
            this.defaultPageSize = defaultPageSize;
            return this;
        }

        @JsonProperty(value="maximumPageSize")
        @CanIgnoreReturnValue
        public final Builder maximumPageSize(@Nullable Integer maximumPageSize) {
            this.maximumPageSize = maximumPageSize;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder addEmbeddedFeatureLinkRels(String element) {
            this.embeddedFeatureLinkRels.add((Object)element);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder addEmbeddedFeatureLinkRels(String ... elements) {
            this.embeddedFeatureLinkRels.add(elements);
            return this;
        }

        @JsonProperty(value="embeddedFeatureLinkRels")
        @CanIgnoreReturnValue
        public final Builder embeddedFeatureLinkRels(Iterable<String> elements) {
            this.embeddedFeatureLinkRels = ImmutableSet.builder();
            return this.addAllEmbeddedFeatureLinkRels(elements);
        }

        @CanIgnoreReturnValue
        public final Builder addAllEmbeddedFeatureLinkRels(Iterable<String> elements) {
            this.embeddedFeatureLinkRels.addAll((Iterable)elements);
            return this;
        }

        @JsonProperty(value="showsFeatureSelfLink")
        @Deprecated
        @CanIgnoreReturnValue
        public final Builder showsFeatureSelfLink(@Nullable Boolean showsFeatureSelfLink) {
            this.showsFeatureSelfLink = showsFeatureSelfLink;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder itemType(FeaturesCoreConfiguration.ItemType itemType) {
            this.itemType = Objects.requireNonNull(itemType, "itemType");
            return this;
        }

        @JsonProperty(value="itemType")
        @CanIgnoreReturnValue
        public final Builder itemType(Optional<? extends FeaturesCoreConfiguration.ItemType> itemType) {
            this.itemType = itemType.orElse(null);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder queryables(FeaturesCollectionQueryables queryables) {
            this.queryables = Objects.requireNonNull(queryables, "queryables");
            return this;
        }

        @JsonProperty(value="queryables")
        @CanIgnoreReturnValue
        public final Builder queryables(Optional<? extends FeaturesCollectionQueryables> queryables) {
            this.queryables = queryables.orElse(null);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder putCoordinatePrecision(String key, int value) {
            this.coordinatePrecision.put(key, value);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder putCoordinatePrecision(Map.Entry<String, ? extends Integer> entry) {
            this.coordinatePrecision.put(entry);
            return this;
        }

        @JsonProperty(value="coordinatePrecision")
        @CanIgnoreReturnValue
        public final Builder coordinatePrecision(Map<String, ? extends Integer> entries) {
            this.coordinatePrecision = ImmutableMap.builder();
            return this.putAllCoordinatePrecision(entries);
        }

        @CanIgnoreReturnValue
        public final Builder putAllCoordinatePrecision(Map<String, ? extends Integer> entries) {
            this.coordinatePrecision.putAll(entries);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder putTransformations(String key, List<PropertyTransformation> value) {
            this.transformations.put(key, value);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder putTransformations(Map.Entry<String, ? extends List<PropertyTransformation>> entry) {
            this.transformations.put(entry);
            return this;
        }

        @JsonProperty(value="transformations")
        @CanIgnoreReturnValue
        public final Builder transformations(Map<String, ? extends List<PropertyTransformation>> entries) {
            this.transformations = ImmutableMap.builder();
            return this.putAllTransformations(entries);
        }

        @CanIgnoreReturnValue
        public final Builder putAllTransformations(Map<String, ? extends List<PropertyTransformation>> entries) {
            this.transformations.putAll(entries);
            return this;
        }

        @Override
        public ImmutableFeaturesCoreConfiguration build() {
            return new ImmutableFeaturesCoreConfiguration(this);
        }

        private boolean featureTypesIsSet() {
            return (this.optBits & 1L) != 0L;
        }
    }

    @Generated(from="FeaturesCoreConfiguration", generator="Immutables")
    private final class InitShim {
        private byte isEnabledBuildStage = 0;
        private boolean isEnabled;
        private byte hasDeprecatedTransformationKeysBuildStage = 0;
        private boolean hasDeprecatedTransformationKeys;
        private byte featureTypesBuildStage = 0;
        private ImmutableList<String> featureTypes;
        private byte defaultEpsgCrsBuildStage = 0;
        private EpsgCrs defaultEpsgCrs;
        private byte allFilterParametersBuildStage = 0;
        private Map<String, String> allFilterParameters;
        private byte qOrOtherFilterParametersBuildStage = 0;
        private List<String> qOrOtherFilterParameters;
        private byte qPropertiesBuildStage = 0;
        private List<String> qProperties;
        private byte hasDeprecatedQueryablesBuildStage = 0;
        private boolean hasDeprecatedQueryables;

        private InitShim() {
        }

        boolean isEnabled() {
            if (this.isEnabledBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.isEnabledBuildStage == 0) {
                this.isEnabledBuildStage = (byte)-1;
                this.isEnabled = ImmutableFeaturesCoreConfiguration.this.isEnabledInitialize();
                this.isEnabledBuildStage = 1;
            }
            return this.isEnabled;
        }

        boolean hasDeprecatedTransformationKeys() {
            if (this.hasDeprecatedTransformationKeysBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.hasDeprecatedTransformationKeysBuildStage == 0) {
                this.hasDeprecatedTransformationKeysBuildStage = (byte)-1;
                this.hasDeprecatedTransformationKeys = ImmutableFeaturesCoreConfiguration.this.hasDeprecatedTransformationKeysInitialize();
                this.hasDeprecatedTransformationKeysBuildStage = 1;
            }
            return this.hasDeprecatedTransformationKeys;
        }

        ImmutableList<String> getFeatureTypes() {
            if (this.featureTypesBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.featureTypesBuildStage == 0) {
                this.featureTypesBuildStage = (byte)-1;
                this.featureTypes = ImmutableList.copyOf(ImmutableFeaturesCoreConfiguration.this.getFeatureTypesInitialize());
                this.featureTypesBuildStage = 1;
            }
            return this.featureTypes;
        }

        void featureTypes(ImmutableList<String> featureTypes) {
            this.featureTypes = featureTypes;
            this.featureTypesBuildStage = 1;
        }

        EpsgCrs getDefaultEpsgCrs() {
            if (this.defaultEpsgCrsBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.defaultEpsgCrsBuildStage == 0) {
                this.defaultEpsgCrsBuildStage = (byte)-1;
                this.defaultEpsgCrs = Objects.requireNonNull(ImmutableFeaturesCoreConfiguration.this.getDefaultEpsgCrsInitialize(), "defaultEpsgCrs");
                this.defaultEpsgCrsBuildStage = 1;
            }
            return this.defaultEpsgCrs;
        }

        Map<String, String> getAllFilterParameters() {
            if (this.allFilterParametersBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.allFilterParametersBuildStage == 0) {
                this.allFilterParametersBuildStage = (byte)-1;
                this.allFilterParameters = Objects.requireNonNull(ImmutableFeaturesCoreConfiguration.this.getAllFilterParametersInitialize(), "allFilterParameters");
                this.allFilterParametersBuildStage = 1;
            }
            return this.allFilterParameters;
        }

        List<String> getQOrOtherFilterParameters() {
            if (this.qOrOtherFilterParametersBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.qOrOtherFilterParametersBuildStage == 0) {
                this.qOrOtherFilterParametersBuildStage = (byte)-1;
                this.qOrOtherFilterParameters = Objects.requireNonNull(ImmutableFeaturesCoreConfiguration.this.getQOrOtherFilterParametersInitialize(), "qOrOtherFilterParameters");
                this.qOrOtherFilterParametersBuildStage = 1;
            }
            return this.qOrOtherFilterParameters;
        }

        List<String> getQProperties() {
            if (this.qPropertiesBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.qPropertiesBuildStage == 0) {
                this.qPropertiesBuildStage = (byte)-1;
                this.qProperties = Objects.requireNonNull(ImmutableFeaturesCoreConfiguration.this.getQPropertiesInitialize(), "qProperties");
                this.qPropertiesBuildStage = 1;
            }
            return this.qProperties;
        }

        boolean hasDeprecatedQueryables() {
            if (this.hasDeprecatedQueryablesBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.hasDeprecatedQueryablesBuildStage == 0) {
                this.hasDeprecatedQueryablesBuildStage = (byte)-1;
                this.hasDeprecatedQueryables = ImmutableFeaturesCoreConfiguration.this.hasDeprecatedQueryablesInitialize();
                this.hasDeprecatedQueryablesBuildStage = 1;
            }
            return this.hasDeprecatedQueryables;
        }

        private String formatInitCycleMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if (this.isEnabledBuildStage == -1) {
                attributes.add("isEnabled");
            }
            if (this.hasDeprecatedTransformationKeysBuildStage == -1) {
                attributes.add("hasDeprecatedTransformationKeys");
            }
            if (this.featureTypesBuildStage == -1) {
                attributes.add("featureTypes");
            }
            if (this.defaultEpsgCrsBuildStage == -1) {
                attributes.add("defaultEpsgCrs");
            }
            if (this.allFilterParametersBuildStage == -1) {
                attributes.add("allFilterParameters");
            }
            if (this.qOrOtherFilterParametersBuildStage == -1) {
                attributes.add("qOrOtherFilterParameters");
            }
            if (this.qPropertiesBuildStage == -1) {
                attributes.add("qProperties");
            }
            if (this.hasDeprecatedQueryablesBuildStage == -1) {
                attributes.add("hasDeprecatedQueryables");
            }
            return "Cannot build FeaturesCoreConfiguration, attribute initializers form cycle " + attributes;
        }
    }
}

