/*
 * Decompiled with CFR 0.152.
 */
package de.ii.ogcapi.features.core.domain;

import de.ii.ogcapi.features.core.domain.FeaturesCoreConfiguration;
import de.ii.ogcapi.foundation.domain.FeatureTypeConfigurationOgcApi;
import de.ii.ogcapi.foundation.domain.OgcApiDataV2;
import de.ii.xtraplatform.features.domain.FeatureProvider2;
import de.ii.xtraplatform.features.domain.FeatureSchema;
import java.util.AbstractMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import shadow.com.google.common.collect.ImmutableMap;

public interface FeaturesCoreProviders {
    public boolean hasFeatureProvider(OgcApiDataV2 var1);

    public Optional<FeatureProvider2> getFeatureProvider(OgcApiDataV2 var1);

    public FeatureProvider2 getFeatureProviderOrThrow(OgcApiDataV2 var1);

    public boolean hasFeatureProvider(OgcApiDataV2 var1, FeatureTypeConfigurationOgcApi var2);

    public Optional<FeatureProvider2> getFeatureProvider(OgcApiDataV2 var1, FeatureTypeConfigurationOgcApi var2);

    public FeatureProvider2 getFeatureProviderOrThrow(OgcApiDataV2 var1, FeatureTypeConfigurationOgcApi var2);

    default public Optional<FeatureSchema> getFeatureSchema(OgcApiDataV2 apiData, FeatureTypeConfigurationOgcApi featureType) {
        String featureTypeId = featureType.getExtension(FeaturesCoreConfiguration.class).flatMap(FeaturesCoreConfiguration::getFeatureType).orElse(featureType.getId());
        Optional<FeatureProvider2> featureProvider = this.getFeatureProvider(apiData, featureType);
        return featureProvider.map(provider -> (FeatureSchema)provider.getData().getTypes().get(featureTypeId));
    }

    default public Map<String, FeatureSchema> getFeatureSchemas(OgcApiDataV2 apiData) {
        return apiData.getCollections().entrySet().stream().map(entry -> {
            FeatureTypeConfigurationOgcApi featureType = (FeatureTypeConfigurationOgcApi)entry.getValue();
            String featureTypeId = featureType.getExtension(FeaturesCoreConfiguration.class).map(cfg -> cfg.getFeatureType().orElse(featureType.getId())).orElse(featureType.getId());
            Optional<FeatureProvider2> featureProvider = this.getFeatureProvider(apiData, featureType);
            Optional<FeatureSchema> schema = featureProvider.map(provider -> (FeatureSchema)provider.getData().getTypes().get(featureTypeId));
            if (schema.isEmpty()) {
                return null;
            }
            return new AbstractMap.SimpleImmutableEntry<String, FeatureSchema>(featureType.getId(), schema.get());
        }).filter(Objects::nonNull).collect(ImmutableMap.toImmutableMap(Map.Entry::getKey, Map.Entry::getValue));
    }
}

