/*
 * Decompiled with CFR 0.152.
 */
package de.ii.ogcapi.features.core.domain;

import de.ii.ogcapi.features.core.domain.FeaturesCollectionQueryables;
import de.ii.ogcapi.features.core.domain.ImmutableFeaturesCollectionQueryables;
import de.ii.ogcapi.features.core.domain.ImmutableFeaturesCoreConfiguration;
import de.ii.ogcapi.foundation.domain.CachingConfiguration;
import de.ii.ogcapi.foundation.domain.ExtensionConfiguration;
import de.ii.xtraplatform.crs.domain.EpsgCrs;
import de.ii.xtraplatform.crs.domain.ImmutableEpsgCrs;
import de.ii.xtraplatform.crs.domain.OgcCrs;
import de.ii.xtraplatform.features.domain.transform.PropertyTransformation;
import de.ii.xtraplatform.features.domain.transform.PropertyTransformations;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import shadow.com.fasterxml.jackson.annotation.JsonIgnore;
import shadow.com.fasterxml.jackson.annotation.JsonProperty;
import shadow.com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import shadow.com.google.common.collect.ImmutableList;
import shadow.com.google.common.collect.ImmutableMap;
import shadow.com.google.common.collect.ImmutableSet;
import shadow.javax.annotation.Nullable;
import shadow.org.immutables.value.Value;

@JsonDeserialize(builder=ImmutableFeaturesCoreConfiguration.Builder.class)
@Value.Immutable
@Value.Style(builder="new")
public interface FeaturesCoreConfiguration
extends ExtensionConfiguration,
PropertyTransformations,
CachingConfiguration {
    public static final int MINIMUM_PAGE_SIZE = 1;
    public static final int DEFAULT_PAGE_SIZE = 10;
    public static final int MAX_PAGE_SIZE = 10000;
    public static final String PARAMETER_Q = "q";
    public static final String PARAMETER_BBOX = "bbox";
    public static final String PARAMETER_DATETIME = "datetime";
    public static final String DATETIME_INTERVAL_SEPARATOR = "/";

    public Optional<String> getFeatureProvider();

    public Optional<String> getFeatureType();

    @JsonProperty(access=JsonProperty.Access.WRITE_ONLY)
    @Value.Default
    default public List<String> getFeatureTypes() {
        return this.getFeatureType().isPresent() ? ImmutableList.of(this.getFeatureType().get()) : ImmutableList.of();
    }

    @Nullable
    public DefaultCrs getDefaultCrs();

    @Nullable
    public Integer getMinimumPageSize();

    @Nullable
    public Integer getDefaultPageSize();

    @Nullable
    public Integer getMaximumPageSize();

    public Set<String> getEmbeddedFeatureLinkRels();

    @Deprecated
    @Nullable
    public Boolean getShowsFeatureSelfLink();

    public Optional<ItemType> getItemType();

    public Optional<FeaturesCollectionQueryables> getQueryables();

    public Map<String, Integer> getCoordinatePrecision();

    @Override
    public Map<String, List<PropertyTransformation>> getTransformations();

    @JsonIgnore
    @Value.Derived
    @Value.Auxiliary
    default public EpsgCrs getDefaultEpsgCrs() {
        return ImmutableEpsgCrs.copyOf(this.getDefaultCrs() == DefaultCrs.CRS84h ? OgcCrs.CRS84h : OgcCrs.CRS84);
    }

    @JsonIgnore
    @Value.Derived
    @Value.Auxiliary
    default public Map<String, String> getAllFilterParameters() {
        if (this.getQueryables().isPresent()) {
            FeaturesCollectionQueryables queryables = this.getQueryables().get();
            LinkedHashMap<String, String> parameters = new LinkedHashMap<String, String>();
            if (!queryables.getSpatial().isEmpty()) {
                parameters.put(PARAMETER_BBOX, queryables.getSpatial().get(0));
            } else {
                parameters.put(PARAMETER_BBOX, "PROPERTY_NOT_AVAILABLE");
            }
            if (queryables.getTemporal().size() > 1) {
                parameters.put(PARAMETER_DATETIME, String.format("%s%s%s", queryables.getTemporal().get(0), DATETIME_INTERVAL_SEPARATOR, queryables.getTemporal().get(1)));
            } else if (!queryables.getTemporal().isEmpty()) {
                parameters.put(PARAMETER_DATETIME, queryables.getTemporal().get(0));
            } else {
                parameters.put(PARAMETER_DATETIME, "PROPERTY_NOT_AVAILABLE");
            }
            queryables.getSpatial().forEach(property -> parameters.put((String)property, (String)property));
            queryables.getTemporal().forEach(property -> parameters.put((String)property, (String)property));
            queryables.getQ().forEach(property -> parameters.put((String)property, (String)property));
            queryables.getOther().forEach(property -> parameters.put((String)property, (String)property));
            return parameters;
        }
        return ImmutableMap.of(PARAMETER_BBOX, "PROPERTY_NOT_AVAILABLE", PARAMETER_DATETIME, "PROPERTY_NOT_AVAILABLE");
    }

    @JsonIgnore
    @Value.Derived
    @Value.Auxiliary
    default public List<String> getQOrOtherFilterParameters() {
        if (this.getQueryables().isPresent()) {
            return Stream.concat(this.getQueryables().get().getQ().stream(), this.getQueryables().get().getOther().stream()).collect(Collectors.toList());
        }
        return ImmutableList.of();
    }

    @JsonIgnore
    @Value.Derived
    @Value.Auxiliary
    default public List<String> getQProperties() {
        if (this.getQueryables().isPresent()) {
            return this.getQueryables().get().getQ();
        }
        return ImmutableList.of();
    }

    @JsonIgnore
    @Value.Derived
    @Value.Auxiliary
    default public boolean hasDeprecatedQueryables() {
        return this.getQueryables().orElse(FeaturesCollectionQueryables.of()).getAll().stream().anyMatch(key -> key.matches(".*\\[[^\\]]*\\].*"));
    }

    default public List<String> normalizeQueryables(List<String> queryables, String collectionId) {
        return queryables.stream().map(queryable -> {
            if (queryable.matches(".*\\[[^\\]]*\\].*")) {
                LOGGER.info("The queryable '{}' in collection '{}' uses a deprecated style that includes square brackets for arrays. The brackets have been dropped during hydration.", queryable, (Object)collectionId);
                return queryable.replaceAll("\\[[^\\]]*\\]", "");
            }
            return queryable;
        }).collect(Collectors.toUnmodifiableList());
    }

    default public Optional<FeaturesCollectionQueryables> normalizeQueryables(String collectionId) {
        Optional<FeaturesCollectionQueryables> queryables = this.getQueryables();
        if (queryables.isPresent()) {
            List<String> spatial = this.normalizeQueryables(queryables.get().getSpatial(), collectionId);
            List<String> temporal = this.normalizeQueryables(queryables.get().getTemporal(), collectionId);
            List<String> q = this.normalizeQueryables(queryables.get().getQ(), collectionId);
            List<String> other = this.normalizeQueryables(queryables.get().getOther(), collectionId);
            queryables = Optional.of(new ImmutableFeaturesCollectionQueryables.Builder().spatial(spatial).temporal(temporal).q(q).other(other).build());
        }
        return queryables;
    }

    default public List<String> removeQueryables(List<String> queryables, Collection<String> queryablesToRemove) {
        return queryables.stream().filter(queryable -> !queryablesToRemove.contains(queryable)).collect(Collectors.toUnmodifiableList());
    }

    default public Optional<FeaturesCollectionQueryables> removeQueryables(Collection<String> queryablesToRemove) {
        Optional<FeaturesCollectionQueryables> queryables = this.getQueryables();
        if (queryables.isPresent()) {
            List<String> spatial = this.removeQueryables(queryables.get().getSpatial(), queryablesToRemove);
            List<String> temporal = this.removeQueryables(queryables.get().getTemporal(), queryablesToRemove);
            List<String> q = this.removeQueryables(queryables.get().getQ(), queryablesToRemove);
            List<String> other = this.removeQueryables(queryables.get().getOther(), queryablesToRemove);
            queryables = Optional.of(new ImmutableFeaturesCollectionQueryables.Builder().spatial(spatial).temporal(temporal).q(q).other(other).build());
        }
        return queryables;
    }

    default public Builder getBuilder() {
        return new ImmutableFeaturesCoreConfiguration.Builder().from(this);
    }

    @Override
    default public ExtensionConfiguration mergeInto(ExtensionConfiguration source) {
        ImmutableFeaturesCoreConfiguration.Builder builder = new ImmutableFeaturesCoreConfiguration.Builder().from(source).from(this).transformations(PropertyTransformations.super.mergeInto((PropertyTransformations)((Object)source)).getTransformations());
        if (this.getQueryables().isPresent() && ((FeaturesCoreConfiguration)source).getQueryables().isPresent()) {
            builder.queryables(this.getQueryables().get().mergeInto(((FeaturesCoreConfiguration)source).getQueryables().get()));
        }
        LinkedHashMap<String, Integer> mergedCoordinatePrecision = new LinkedHashMap<String, Integer>(((FeaturesCoreConfiguration)source).getCoordinatePrecision());
        mergedCoordinatePrecision.putAll(this.getCoordinatePrecision());
        builder.coordinatePrecision(mergedCoordinatePrecision);
        builder.embeddedFeatureLinkRels(((ImmutableSet.Builder)((ImmutableSet.Builder)ImmutableSet.builder().addAll(((FeaturesCoreConfiguration)source).getEmbeddedFeatureLinkRels())).addAll(this.getEmbeddedFeatureLinkRels())).build());
        return builder.build();
    }

    public static enum ItemType {
        unknown,
        feature,
        record;

    }

    public static enum DefaultCrs {
        CRS84,
        CRS84h;

    }

    public static abstract class Builder
    extends ExtensionConfiguration.Builder {
    }
}

