/*
 * Decompiled with CFR 0.152.
 */
package de.ii.ogcapi.features.core.domain;

import de.ii.ogcapi.foundation.domain.ApiRequestContext;
import de.ii.ogcapi.foundation.domain.ExtensionConfiguration;
import de.ii.ogcapi.foundation.domain.FeatureTypeConfigurationOgcApi;
import de.ii.ogcapi.foundation.domain.I18n;
import de.ii.ogcapi.foundation.domain.Link;
import de.ii.ogcapi.foundation.domain.OgcApiDataV2;
import de.ii.xtraplatform.codelists.domain.Codelist;
import de.ii.xtraplatform.crs.domain.CrsTransformer;
import de.ii.xtraplatform.crs.domain.EpsgCrs;
import de.ii.xtraplatform.features.domain.FeatureProperty;
import de.ii.xtraplatform.features.domain.FeatureSchema;
import de.ii.xtraplatform.features.domain.FeatureType;
import java.io.OutputStream;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.OptionalLong;
import shadow.com.google.common.collect.ImmutableList;
import shadow.javax.annotation.Nullable;
import shadow.org.immutables.value.Value;

public interface FeatureTransformationContext {
    public OgcApiDataV2 getApiData();

    public String getCollectionId();

    public Optional<FeatureSchema> getFeatureSchema();

    public OutputStream getOutputStream();

    public Optional<CrsTransformer> getCrsTransformer();

    public Optional<EpsgCrs> getSourceCrs();

    public EpsgCrs getDefaultCrs();

    @Value.Derived
    default public EpsgCrs getTargetCrs() {
        if (this.getCrsTransformer().isPresent()) {
            return this.getCrsTransformer().get().getTargetCrs();
        }
        return this.getSourceCrs().orElse(this.getDefaultCrs());
    }

    public List<Link> getLinks();

    public boolean isFeatureCollection();

    public Map<String, Codelist> getCodelists();

    @Value.Default
    default public boolean getShowsFeatureSelfLink() {
        return true;
    }

    @Value.Default
    default public boolean isHitsOnly() {
        return false;
    }

    @Value.Default
    default public boolean isHitsOnlyIfMore() {
        return false;
    }

    @Value.Default
    default public boolean isPropertyOnly() {
        return false;
    }

    @Value.Default
    default public List<String> getFields() {
        return ImmutableList.of("*");
    }

    public ApiRequestContext getOgcApiRequest();

    public int getLimit();

    public int getOffset();

    @Value.Derived
    default public int getPage() {
        return this.getLimit() > 0 ? (this.getLimit() + this.getOffset()) / this.getLimit() : 0;
    }

    public Optional<Locale> getLanguage();

    public Optional<I18n> getI18n();

    @Nullable
    public State getState();

    @Value.Derived
    default public String getServiceUrl() {
        return this.getOgcApiRequest().getUriCustomizer().copy().cutPathAfterSegments(this.getApiData().getSubPath().toArray(new String[0])).clearParameters().toString();
    }

    @Value.Derived
    @Value.Auxiliary
    default public Optional<FeatureTypeConfigurationOgcApi> getCollection() {
        return Optional.ofNullable((FeatureTypeConfigurationOgcApi)this.getApiData().getCollections().get(this.getCollectionId()));
    }

    @Value.Default
    default public double getMaxAllowableOffset() {
        return 0.0;
    }

    @Value.Default
    default public boolean shouldSwapCoordinates() {
        return false;
    }

    @Value.Default
    default public List<Integer> getGeometryPrecision() {
        return ImmutableList.of(Integer.valueOf(0), Integer.valueOf(0), Integer.valueOf(0));
    }

    default public <T extends ExtensionConfiguration> T getConfiguration(Class<T> clazz) {
        return (T)((ExtensionConfiguration)Optional.ofNullable((FeatureTypeConfigurationOgcApi)this.getApiData().getCollections().get(this.getCollectionId())).flatMap(featureTypeConfiguration -> featureTypeConfiguration.getExtension(clazz)).or(() -> this.getApiData().getExtension(clazz)).orElseThrow());
    }

    public static abstract class State {
        public abstract Event getEvent();

        public abstract OptionalLong getNumberReturned();

        public abstract OptionalLong getNumberMatched();

        public abstract Optional<FeatureType> getCurrentFeatureType();

        public abstract Optional<FeatureProperty> getCurrentFeatureProperty();

        public abstract List<Integer> getCurrentMultiplicity();

        public abstract Optional<String> getCurrentValue();
    }

    public static enum Event {
        START,
        END,
        FEATURE_START,
        FEATURE_END,
        PROPERTY,
        COORDINATES,
        GEOMETRY_END,
        ARRAY_START,
        OBJECT_START,
        OBJECT_END,
        ARRAY_END;

    }
}

