/*
 * Decompiled with CFR 0.152.
 */
package de.ii.ogcapi.crs.domain;

import de.ii.ogcapi.crs.domain.CrsConfiguration;
import de.ii.ogcapi.foundation.domain.ExtensionConfiguration;
import de.ii.xtraplatform.crs.domain.EpsgCrs;
import java.util.Objects;
import java.util.Optional;
import shadow.com.fasterxml.jackson.annotation.JsonIgnore;
import shadow.com.fasterxml.jackson.annotation.JsonProperty;
import shadow.com.google.common.base.MoreObjects;
import shadow.com.google.common.collect.ImmutableSet;
import shadow.com.google.errorprone.annotations.CanIgnoreReturnValue;
import shadow.javax.annotation.CheckReturnValue;
import shadow.javax.annotation.Nullable;
import shadow.javax.annotation.ParametersAreNonnullByDefault;
import shadow.javax.annotation.concurrent.Immutable;
import shadow.javax.annotation.concurrent.NotThreadSafe;
import shadow.org.immutables.value.Generated;

@ParametersAreNonnullByDefault
@CheckReturnValue
@Generated(from="CrsConfiguration", generator="Immutables")
@Immutable
public final class ImmutableCrsConfiguration
implements CrsConfiguration {
    @Nullable
    private final Boolean enabled;
    private final transient boolean isEnabled;
    @Nullable
    private final ExtensionConfiguration defaultValues;
    private final ImmutableSet<EpsgCrs> additionalCrs;

    private ImmutableCrsConfiguration(@Nullable Boolean enabled, @Nullable ExtensionConfiguration defaultValues, ImmutableSet<EpsgCrs> additionalCrs) {
        this.enabled = enabled;
        this.defaultValues = defaultValues;
        this.additionalCrs = additionalCrs;
        this.isEnabled = CrsConfiguration.super.isEnabled();
    }

    @Override
    @JsonProperty(value="enabled")
    @Nullable
    public Boolean getEnabled() {
        return this.enabled;
    }

    @Override
    @JsonProperty(value="isEnabled")
    @JsonIgnore
    public boolean isEnabled() {
        return this.isEnabled;
    }

    @Override
    @JsonProperty(value="defaultValues")
    @JsonIgnore
    public Optional<ExtensionConfiguration> getDefaultValues() {
        return Optional.ofNullable(this.defaultValues);
    }

    @JsonProperty(value="additionalCrs")
    public ImmutableSet<EpsgCrs> getAdditionalCrs() {
        return this.additionalCrs;
    }

    public final ImmutableCrsConfiguration withEnabled(@Nullable Boolean value) {
        if (Objects.equals(this.enabled, value)) {
            return this;
        }
        return new ImmutableCrsConfiguration(value, this.defaultValues, this.additionalCrs);
    }

    public final ImmutableCrsConfiguration withDefaultValues(ExtensionConfiguration value) {
        ExtensionConfiguration newValue = Objects.requireNonNull(value, "defaultValues");
        if (this.defaultValues == newValue) {
            return this;
        }
        return new ImmutableCrsConfiguration(this.enabled, newValue, this.additionalCrs);
    }

    public final ImmutableCrsConfiguration withDefaultValues(Optional<? extends ExtensionConfiguration> optional) {
        ExtensionConfiguration value = optional.orElse(null);
        if (this.defaultValues == value) {
            return this;
        }
        return new ImmutableCrsConfiguration(this.enabled, value, this.additionalCrs);
    }

    public final ImmutableCrsConfiguration withAdditionalCrs(EpsgCrs ... elements) {
        ImmutableSet<EpsgCrs> newValue = ImmutableSet.copyOf(elements);
        return new ImmutableCrsConfiguration(this.enabled, this.defaultValues, newValue);
    }

    public final ImmutableCrsConfiguration withAdditionalCrs(Iterable<? extends EpsgCrs> elements) {
        if (this.additionalCrs == elements) {
            return this;
        }
        ImmutableSet<EpsgCrs> newValue = ImmutableSet.copyOf(elements);
        return new ImmutableCrsConfiguration(this.enabled, this.defaultValues, newValue);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableCrsConfiguration && this.equalTo((ImmutableCrsConfiguration)another);
    }

    private boolean equalTo(ImmutableCrsConfiguration another) {
        return Objects.equals(this.enabled, another.enabled) && this.additionalCrs.equals(another.additionalCrs);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + Objects.hashCode(this.enabled);
        h += (h << 5) + this.additionalCrs.hashCode();
        return h;
    }

    public String toString() {
        return MoreObjects.toStringHelper("CrsConfiguration").omitNullValues().add("enabled", this.enabled).add("additionalCrs", this.additionalCrs).toString();
    }

    public static ImmutableCrsConfiguration copyOf(CrsConfiguration instance) {
        if (instance instanceof ImmutableCrsConfiguration) {
            return (ImmutableCrsConfiguration)instance;
        }
        return new Builder().from(instance).build();
    }

    @Generated(from="CrsConfiguration", generator="Immutables")
    @NotThreadSafe
    public static final class Builder
    extends CrsConfiguration.Builder {
        @Nullable
        private Boolean enabled;
        @Nullable
        private ExtensionConfiguration defaultValues;
        private ImmutableSet.Builder<EpsgCrs> additionalCrs = ImmutableSet.builder();

        @Override
        @CanIgnoreReturnValue
        public final Builder from(CrsConfiguration instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        @Override
        @CanIgnoreReturnValue
        public final Builder from(ExtensionConfiguration instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        @Override
        private void from(Object object) {
            ExtensionConfiguration instance;
            if (object instanceof CrsConfiguration) {
                instance = (CrsConfiguration)object;
                this.addAllAdditionalCrs(instance.getAdditionalCrs());
            }
            if (object instanceof ExtensionConfiguration) {
                Boolean enabledValue;
                instance = (ExtensionConfiguration)object;
                Optional<ExtensionConfiguration> defaultValuesOptional = instance.getDefaultValues();
                if (defaultValuesOptional.isPresent()) {
                    this.defaultValues(defaultValuesOptional);
                }
                if ((enabledValue = instance.getEnabled()) != null) {
                    this.enabled(enabledValue);
                }
            }
        }

        @JsonProperty(value="enabled")
        @CanIgnoreReturnValue
        public final Builder enabled(@Nullable Boolean enabled) {
            this.enabled = enabled;
            return this;
        }

        @Override
        @CanIgnoreReturnValue
        public final Builder defaultValues(ExtensionConfiguration defaultValues) {
            this.defaultValues = Objects.requireNonNull(defaultValues, "defaultValues");
            return this;
        }

        @JsonProperty(value="defaultValues")
        @JsonIgnore
        @CanIgnoreReturnValue
        public final Builder defaultValues(Optional<? extends ExtensionConfiguration> defaultValues) {
            this.defaultValues = defaultValues.orElse(null);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder addAdditionalCrs(EpsgCrs element) {
            this.additionalCrs.add((Object)element);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder addAdditionalCrs(EpsgCrs ... elements) {
            this.additionalCrs.add(elements);
            return this;
        }

        @JsonProperty(value="additionalCrs")
        @CanIgnoreReturnValue
        public final Builder additionalCrs(Iterable<? extends EpsgCrs> elements) {
            this.additionalCrs = ImmutableSet.builder();
            return this.addAllAdditionalCrs(elements);
        }

        @CanIgnoreReturnValue
        public final Builder addAllAdditionalCrs(Iterable<? extends EpsgCrs> elements) {
            this.additionalCrs.addAll(elements);
            return this;
        }

        @Override
        public ImmutableCrsConfiguration build() {
            return new ImmutableCrsConfiguration(this.enabled, this.defaultValues, (ImmutableSet<EpsgCrs>)this.additionalCrs.build());
        }
    }
}

