/*
 * Decompiled with CFR 0.152.
 */
package de.ii.ogcapi.crs.app;

import de.ii.ogcapi.crs.domain.CrsConfiguration;
import de.ii.ogcapi.crs.domain.ImmutableCrsConfiguration;
import de.ii.ogcapi.features.core.domain.FeaturesCoreConfiguration;
import de.ii.ogcapi.features.core.domain.FeaturesCoreProviders;
import de.ii.ogcapi.foundation.domain.ApiBuildingBlock;
import de.ii.ogcapi.foundation.domain.ExtensionConfiguration;
import de.ii.ogcapi.foundation.domain.OgcApiDataV2;
import de.ii.xtraplatform.crs.domain.CrsTransformerFactory;
import de.ii.xtraplatform.crs.domain.EpsgCrs;
import de.ii.xtraplatform.crs.domain.OgcCrs;
import de.ii.xtraplatform.store.domain.entities.ImmutableValidationResult;
import de.ii.xtraplatform.store.domain.entities.ValidationResult;
import java.util.Iterator;
import java.util.Optional;
import shadow.com.github.azahnen.dagger.annotations.AutoBind;
import shadow.javax.inject.Inject;
import shadow.javax.inject.Singleton;

@Singleton
@AutoBind
public class CapabilityCrs
implements ApiBuildingBlock {
    private final CrsTransformerFactory crsTransformerFactory;
    private final FeaturesCoreProviders featuresCoreProviders;

    @Inject
    public CapabilityCrs(CrsTransformerFactory crsTransformerFactory, FeaturesCoreProviders featuresCoreProviders) {
        this.crsTransformerFactory = crsTransformerFactory;
        this.featuresCoreProviders = featuresCoreProviders;
    }

    @Override
    public ExtensionConfiguration getDefaultConfiguration() {
        return new ImmutableCrsConfiguration.Builder().enabled(true).build();
    }

    @Override
    public ValidationResult onStartup(OgcApiDataV2 apiData, ValidationResult.MODE apiValidation) {
        EpsgCrs crs;
        Optional<CrsConfiguration> crsConfiguration = apiData.getExtension(CrsConfiguration.class).filter(ExtensionConfiguration::isEnabled);
        if (crsConfiguration.isEmpty()) {
            return ValidationResult.of();
        }
        EpsgCrs defaultCrs = apiData.getExtension(FeaturesCoreConfiguration.class).map(FeaturesCoreConfiguration::getDefaultEpsgCrs).orElse(OgcCrs.CRS84);
        EpsgCrs providerCrs = this.featuresCoreProviders.getFeatureProvider(apiData).flatMap(featureProvider2 -> featureProvider2.getData().getNativeCrs()).orElse(OgcCrs.CRS84);
        EpsgCrs lastCrs = null;
        try {
            lastCrs = defaultCrs;
            this.crsTransformerFactory.getTransformer(providerCrs, defaultCrs);
            Iterator<EpsgCrs> iterator = crsConfiguration.get().getAdditionalCrs().iterator();
            while (iterator.hasNext()) {
                lastCrs = crs = iterator.next();
                this.crsTransformerFactory.getTransformer(providerCrs, crs);
            }
        }
        catch (Throwable e) {
            return ImmutableValidationResult.builder().mode(apiValidation).addErrors(String.format("Could not find transformation for %s -> %s: %s", providerCrs.toHumanReadableString(), lastCrs.toHumanReadableString(), e.getMessage())).build();
        }
        try {
            lastCrs = defaultCrs;
            this.crsTransformerFactory.getTransformer(defaultCrs, providerCrs);
            Iterator<EpsgCrs> e = crsConfiguration.get().getAdditionalCrs().iterator();
            while (e.hasNext()) {
                lastCrs = crs = e.next();
                this.crsTransformerFactory.getTransformer(crs, providerCrs);
            }
        }
        catch (Throwable e) {
            return ImmutableValidationResult.builder().mode(apiValidation).addErrors(String.format("Could not find transformation for %s -> %s: %s", lastCrs.toHumanReadableString(), providerCrs.toHumanReadableString(), e.getMessage())).build();
        }
        return ValidationResult.of();
    }
}

