/*
 * Decompiled with CFR 0.152.
 */
package de.ii.ogcapi.common.domain;

import de.ii.ogcapi.common.domain.CommonConfiguration;
import de.ii.ogcapi.foundation.domain.Caching;
import de.ii.ogcapi.foundation.domain.CachingConfiguration;
import de.ii.ogcapi.foundation.domain.ExtensionConfiguration;
import de.ii.ogcapi.foundation.domain.Link;
import java.util.Objects;
import java.util.Optional;
import shadow.com.fasterxml.jackson.annotation.JsonIgnore;
import shadow.com.fasterxml.jackson.annotation.JsonMerge;
import shadow.com.fasterxml.jackson.annotation.JsonProperty;
import shadow.com.fasterxml.jackson.annotation.OptBoolean;
import shadow.com.google.common.base.MoreObjects;
import shadow.com.google.common.collect.ImmutableList;
import shadow.com.google.errorprone.annotations.CanIgnoreReturnValue;
import shadow.javax.annotation.CheckReturnValue;
import shadow.javax.annotation.Nullable;
import shadow.javax.annotation.ParametersAreNonnullByDefault;
import shadow.javax.annotation.concurrent.Immutable;
import shadow.javax.annotation.concurrent.NotThreadSafe;
import shadow.org.immutables.value.Generated;

@ParametersAreNonnullByDefault
@CheckReturnValue
@Generated(from="CommonConfiguration", generator="Immutables")
@Immutable
public final class ImmutableCommonConfiguration
implements CommonConfiguration {
    @Nullable
    private final Boolean enabled;
    private final transient boolean isEnabled;
    @Nullable
    private final ExtensionConfiguration defaultValues;
    @Nullable
    private final Caching caching;
    private final ImmutableList<Link> additionalLinks;

    private ImmutableCommonConfiguration(@Nullable Boolean enabled, @Nullable ExtensionConfiguration defaultValues, @Nullable Caching caching, ImmutableList<Link> additionalLinks) {
        this.enabled = enabled;
        this.defaultValues = defaultValues;
        this.caching = caching;
        this.additionalLinks = additionalLinks;
        this.isEnabled = CommonConfiguration.super.isEnabled();
    }

    @Override
    @JsonProperty(value="enabled")
    @Nullable
    public Boolean getEnabled() {
        return this.enabled;
    }

    @Override
    @JsonProperty(value="isEnabled")
    @JsonIgnore
    public boolean isEnabled() {
        return this.isEnabled;
    }

    @Override
    @JsonProperty(value="defaultValues")
    @JsonIgnore
    public Optional<ExtensionConfiguration> getDefaultValues() {
        return Optional.ofNullable(this.defaultValues);
    }

    @Override
    @JsonProperty(value="caching")
    @Nullable
    public Caching getCaching() {
        return this.caching;
    }

    @JsonProperty(value="additionalLinks")
    @JsonMerge(value=OptBoolean.FALSE)
    public ImmutableList<Link> getAdditionalLinks() {
        return this.additionalLinks;
    }

    public final ImmutableCommonConfiguration withEnabled(@Nullable Boolean value) {
        if (Objects.equals(this.enabled, value)) {
            return this;
        }
        return new ImmutableCommonConfiguration(value, this.defaultValues, this.caching, this.additionalLinks);
    }

    public final ImmutableCommonConfiguration withDefaultValues(ExtensionConfiguration value) {
        ExtensionConfiguration newValue = Objects.requireNonNull(value, "defaultValues");
        if (this.defaultValues == newValue) {
            return this;
        }
        return new ImmutableCommonConfiguration(this.enabled, newValue, this.caching, this.additionalLinks);
    }

    public final ImmutableCommonConfiguration withDefaultValues(Optional<? extends ExtensionConfiguration> optional) {
        ExtensionConfiguration value = optional.orElse(null);
        if (this.defaultValues == value) {
            return this;
        }
        return new ImmutableCommonConfiguration(this.enabled, value, this.caching, this.additionalLinks);
    }

    public final ImmutableCommonConfiguration withCaching(@Nullable Caching value) {
        if (this.caching == value) {
            return this;
        }
        return new ImmutableCommonConfiguration(this.enabled, this.defaultValues, value, this.additionalLinks);
    }

    public final ImmutableCommonConfiguration withAdditionalLinks(Link ... elements) {
        ImmutableList<Link> newValue = ImmutableList.copyOf(elements);
        return new ImmutableCommonConfiguration(this.enabled, this.defaultValues, this.caching, newValue);
    }

    public final ImmutableCommonConfiguration withAdditionalLinks(Iterable<? extends Link> elements) {
        if (this.additionalLinks == elements) {
            return this;
        }
        ImmutableList<Link> newValue = ImmutableList.copyOf(elements);
        return new ImmutableCommonConfiguration(this.enabled, this.defaultValues, this.caching, newValue);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableCommonConfiguration && this.equalTo((ImmutableCommonConfiguration)another);
    }

    private boolean equalTo(ImmutableCommonConfiguration another) {
        return Objects.equals(this.enabled, another.enabled) && Objects.equals(this.caching, another.caching) && this.additionalLinks.equals(another.additionalLinks);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + Objects.hashCode(this.enabled);
        h += (h << 5) + Objects.hashCode(this.caching);
        h += (h << 5) + this.additionalLinks.hashCode();
        return h;
    }

    public String toString() {
        return MoreObjects.toStringHelper("CommonConfiguration").omitNullValues().add("enabled", this.enabled).add("caching", this.caching).add("additionalLinks", this.additionalLinks).toString();
    }

    public static ImmutableCommonConfiguration copyOf(CommonConfiguration instance) {
        if (instance instanceof ImmutableCommonConfiguration) {
            return (ImmutableCommonConfiguration)instance;
        }
        return new Builder().from(instance).build();
    }

    @Generated(from="CommonConfiguration", generator="Immutables")
    @NotThreadSafe
    public static final class Builder
    extends CommonConfiguration.Builder {
        @Nullable
        private Boolean enabled;
        @Nullable
        private ExtensionConfiguration defaultValues;
        @Nullable
        private Caching caching;
        private ImmutableList.Builder<Link> additionalLinks = ImmutableList.builder();

        @Override
        @CanIgnoreReturnValue
        public final Builder from(CommonConfiguration instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        @Override
        @CanIgnoreReturnValue
        public final Builder from(ExtensionConfiguration instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        @Override
        @CanIgnoreReturnValue
        public final Builder from(CachingConfiguration instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        @Override
        private void from(Object object) {
            Caching cachingValue;
            Object instance;
            if (object instanceof CommonConfiguration) {
                instance = (CommonConfiguration)object;
                this.addAllAdditionalLinks(instance.getAdditionalLinks());
            }
            if (object instanceof ExtensionConfiguration) {
                Boolean enabledValue;
                instance = (ExtensionConfiguration)object;
                Optional<ExtensionConfiguration> defaultValuesOptional = instance.getDefaultValues();
                if (defaultValuesOptional.isPresent()) {
                    this.defaultValues(defaultValuesOptional);
                }
                if ((enabledValue = instance.getEnabled()) != null) {
                    this.enabled(enabledValue);
                }
            }
            if (object instanceof CachingConfiguration && (cachingValue = (instance = (CachingConfiguration)object).getCaching()) != null) {
                this.caching(cachingValue);
            }
        }

        @JsonProperty(value="enabled")
        @CanIgnoreReturnValue
        public final Builder enabled(@Nullable Boolean enabled) {
            this.enabled = enabled;
            return this;
        }

        @Override
        @CanIgnoreReturnValue
        public final Builder defaultValues(ExtensionConfiguration defaultValues) {
            this.defaultValues = Objects.requireNonNull(defaultValues, "defaultValues");
            return this;
        }

        @JsonProperty(value="defaultValues")
        @JsonIgnore
        @CanIgnoreReturnValue
        public final Builder defaultValues(Optional<? extends ExtensionConfiguration> defaultValues) {
            this.defaultValues = defaultValues.orElse(null);
            return this;
        }

        @JsonProperty(value="caching")
        @CanIgnoreReturnValue
        public final Builder caching(@Nullable Caching caching) {
            this.caching = caching;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder addAdditionalLinks(Link element) {
            this.additionalLinks.add((Object)element);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder addAdditionalLinks(Link ... elements) {
            this.additionalLinks.add(elements);
            return this;
        }

        @JsonProperty(value="additionalLinks")
        @JsonMerge(value=OptBoolean.FALSE)
        @CanIgnoreReturnValue
        public final Builder additionalLinks(Iterable<? extends Link> elements) {
            this.additionalLinks = ImmutableList.builder();
            return this.addAllAdditionalLinks(elements);
        }

        @CanIgnoreReturnValue
        public final Builder addAllAdditionalLinks(Iterable<? extends Link> elements) {
            this.additionalLinks.addAll(elements);
            return this;
        }

        @Override
        public ImmutableCommonConfiguration build() {
            return new ImmutableCommonConfiguration(this.enabled, this.defaultValues, this.caching, (ImmutableList<Link>)this.additionalLinks.build());
        }
    }
}

