/*
 * Decompiled with CFR 0.152.
 */
package de.ii.ogcapi.collections.domain;

import de.ii.ogcapi.collections.domain.CollectionsConfiguration;
import de.ii.ogcapi.foundation.domain.Caching;
import de.ii.ogcapi.foundation.domain.CachingConfiguration;
import de.ii.ogcapi.foundation.domain.ExtensionConfiguration;
import de.ii.ogcapi.foundation.domain.Link;
import java.util.Objects;
import java.util.Optional;
import shadow.com.fasterxml.jackson.annotation.JsonIgnore;
import shadow.com.fasterxml.jackson.annotation.JsonMerge;
import shadow.com.fasterxml.jackson.annotation.JsonProperty;
import shadow.com.fasterxml.jackson.annotation.OptBoolean;
import shadow.com.google.common.base.MoreObjects;
import shadow.com.google.common.collect.ImmutableList;
import shadow.com.google.errorprone.annotations.CanIgnoreReturnValue;
import shadow.javax.annotation.CheckReturnValue;
import shadow.javax.annotation.Nullable;
import shadow.javax.annotation.ParametersAreNonnullByDefault;
import shadow.javax.annotation.concurrent.Immutable;
import shadow.javax.annotation.concurrent.NotThreadSafe;
import shadow.org.immutables.value.Generated;

@ParametersAreNonnullByDefault
@CheckReturnValue
@Generated(from="CollectionsConfiguration", generator="Immutables")
@Immutable
public final class ImmutableCollectionsConfiguration
implements CollectionsConfiguration {
    @Nullable
    private final Boolean enabled;
    private final transient boolean isEnabled;
    @Nullable
    private final ExtensionConfiguration defaultValues;
    @Nullable
    private final Caching caching;
    private final ImmutableList<Link> additionalLinks;
    @Nullable
    private final Boolean collectionIdAsParameter;
    @Nullable
    private final Boolean collectionDefinitionsAreIdentical;

    private ImmutableCollectionsConfiguration(@Nullable Boolean enabled, @Nullable ExtensionConfiguration defaultValues, @Nullable Caching caching, ImmutableList<Link> additionalLinks, @Nullable Boolean collectionIdAsParameter, @Nullable Boolean collectionDefinitionsAreIdentical) {
        this.enabled = enabled;
        this.defaultValues = defaultValues;
        this.caching = caching;
        this.additionalLinks = additionalLinks;
        this.collectionIdAsParameter = collectionIdAsParameter;
        this.collectionDefinitionsAreIdentical = collectionDefinitionsAreIdentical;
        this.isEnabled = CollectionsConfiguration.super.isEnabled();
    }

    @Override
    @JsonProperty(value="enabled")
    @Nullable
    public Boolean getEnabled() {
        return this.enabled;
    }

    @Override
    @JsonProperty(value="isEnabled")
    @JsonIgnore
    public boolean isEnabled() {
        return this.isEnabled;
    }

    @Override
    @JsonProperty(value="defaultValues")
    @JsonIgnore
    public Optional<ExtensionConfiguration> getDefaultValues() {
        return Optional.ofNullable(this.defaultValues);
    }

    @Override
    @JsonProperty(value="caching")
    @Nullable
    public Caching getCaching() {
        return this.caching;
    }

    @JsonProperty(value="additionalLinks")
    @JsonMerge(value=OptBoolean.FALSE)
    public ImmutableList<Link> getAdditionalLinks() {
        return this.additionalLinks;
    }

    @Override
    @JsonProperty(value="collectionIdAsParameter")
    public Optional<Boolean> getCollectionIdAsParameter() {
        return Optional.ofNullable(this.collectionIdAsParameter);
    }

    @Override
    @JsonProperty(value="collectionDefinitionsAreIdentical")
    public Optional<Boolean> getCollectionDefinitionsAreIdentical() {
        return Optional.ofNullable(this.collectionDefinitionsAreIdentical);
    }

    public final ImmutableCollectionsConfiguration withEnabled(@Nullable Boolean value) {
        if (Objects.equals(this.enabled, value)) {
            return this;
        }
        return new ImmutableCollectionsConfiguration(value, this.defaultValues, this.caching, this.additionalLinks, this.collectionIdAsParameter, this.collectionDefinitionsAreIdentical);
    }

    public final ImmutableCollectionsConfiguration withDefaultValues(ExtensionConfiguration value) {
        ExtensionConfiguration newValue = Objects.requireNonNull(value, "defaultValues");
        if (this.defaultValues == newValue) {
            return this;
        }
        return new ImmutableCollectionsConfiguration(this.enabled, newValue, this.caching, this.additionalLinks, this.collectionIdAsParameter, this.collectionDefinitionsAreIdentical);
    }

    public final ImmutableCollectionsConfiguration withDefaultValues(Optional<? extends ExtensionConfiguration> optional) {
        ExtensionConfiguration value = optional.orElse(null);
        if (this.defaultValues == value) {
            return this;
        }
        return new ImmutableCollectionsConfiguration(this.enabled, value, this.caching, this.additionalLinks, this.collectionIdAsParameter, this.collectionDefinitionsAreIdentical);
    }

    public final ImmutableCollectionsConfiguration withCaching(@Nullable Caching value) {
        if (this.caching == value) {
            return this;
        }
        return new ImmutableCollectionsConfiguration(this.enabled, this.defaultValues, value, this.additionalLinks, this.collectionIdAsParameter, this.collectionDefinitionsAreIdentical);
    }

    public final ImmutableCollectionsConfiguration withAdditionalLinks(Link ... elements) {
        ImmutableList<Link> newValue = ImmutableList.copyOf(elements);
        return new ImmutableCollectionsConfiguration(this.enabled, this.defaultValues, this.caching, newValue, this.collectionIdAsParameter, this.collectionDefinitionsAreIdentical);
    }

    public final ImmutableCollectionsConfiguration withAdditionalLinks(Iterable<? extends Link> elements) {
        if (this.additionalLinks == elements) {
            return this;
        }
        ImmutableList<Link> newValue = ImmutableList.copyOf(elements);
        return new ImmutableCollectionsConfiguration(this.enabled, this.defaultValues, this.caching, newValue, this.collectionIdAsParameter, this.collectionDefinitionsAreIdentical);
    }

    public final ImmutableCollectionsConfiguration withCollectionIdAsParameter(boolean value) {
        Boolean newValue = value;
        if (Objects.equals(this.collectionIdAsParameter, newValue)) {
            return this;
        }
        return new ImmutableCollectionsConfiguration(this.enabled, this.defaultValues, this.caching, this.additionalLinks, newValue, this.collectionDefinitionsAreIdentical);
    }

    public final ImmutableCollectionsConfiguration withCollectionIdAsParameter(Optional<Boolean> optional) {
        Boolean value = optional.orElse(null);
        if (Objects.equals(this.collectionIdAsParameter, value)) {
            return this;
        }
        return new ImmutableCollectionsConfiguration(this.enabled, this.defaultValues, this.caching, this.additionalLinks, value, this.collectionDefinitionsAreIdentical);
    }

    public final ImmutableCollectionsConfiguration withCollectionDefinitionsAreIdentical(boolean value) {
        Boolean newValue = value;
        if (Objects.equals(this.collectionDefinitionsAreIdentical, newValue)) {
            return this;
        }
        return new ImmutableCollectionsConfiguration(this.enabled, this.defaultValues, this.caching, this.additionalLinks, this.collectionIdAsParameter, newValue);
    }

    public final ImmutableCollectionsConfiguration withCollectionDefinitionsAreIdentical(Optional<Boolean> optional) {
        Boolean value = optional.orElse(null);
        if (Objects.equals(this.collectionDefinitionsAreIdentical, value)) {
            return this;
        }
        return new ImmutableCollectionsConfiguration(this.enabled, this.defaultValues, this.caching, this.additionalLinks, this.collectionIdAsParameter, value);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableCollectionsConfiguration && this.equalTo((ImmutableCollectionsConfiguration)another);
    }

    private boolean equalTo(ImmutableCollectionsConfiguration another) {
        return Objects.equals(this.enabled, another.enabled) && Objects.equals(this.caching, another.caching) && this.additionalLinks.equals(another.additionalLinks) && Objects.equals(this.collectionIdAsParameter, another.collectionIdAsParameter) && Objects.equals(this.collectionDefinitionsAreIdentical, another.collectionDefinitionsAreIdentical);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + Objects.hashCode(this.enabled);
        h += (h << 5) + Objects.hashCode(this.caching);
        h += (h << 5) + this.additionalLinks.hashCode();
        h += (h << 5) + Objects.hashCode(this.collectionIdAsParameter);
        h += (h << 5) + Objects.hashCode(this.collectionDefinitionsAreIdentical);
        return h;
    }

    public String toString() {
        return MoreObjects.toStringHelper("CollectionsConfiguration").omitNullValues().add("enabled", this.enabled).add("caching", this.caching).add("additionalLinks", this.additionalLinks).add("collectionIdAsParameter", this.collectionIdAsParameter).add("collectionDefinitionsAreIdentical", this.collectionDefinitionsAreIdentical).toString();
    }

    public static ImmutableCollectionsConfiguration copyOf(CollectionsConfiguration instance) {
        if (instance instanceof ImmutableCollectionsConfiguration) {
            return (ImmutableCollectionsConfiguration)instance;
        }
        return new Builder().from(instance).build();
    }

    @Generated(from="CollectionsConfiguration", generator="Immutables")
    @NotThreadSafe
    public static final class Builder
    extends CollectionsConfiguration.Builder {
        @Nullable
        private Boolean enabled;
        @Nullable
        private ExtensionConfiguration defaultValues;
        @Nullable
        private Caching caching;
        private ImmutableList.Builder<Link> additionalLinks = ImmutableList.builder();
        @Nullable
        private Boolean collectionIdAsParameter;
        @Nullable
        private Boolean collectionDefinitionsAreIdentical;

        @Override
        @CanIgnoreReturnValue
        public final Builder from(ExtensionConfiguration instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        @Override
        @CanIgnoreReturnValue
        public final Builder from(CachingConfiguration instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        @Override
        @CanIgnoreReturnValue
        public final Builder from(CollectionsConfiguration instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        @Override
        private void from(Object object) {
            Caching cachingValue;
            Object instance;
            if (object instanceof ExtensionConfiguration) {
                Boolean enabledValue;
                instance = (ExtensionConfiguration)object;
                Optional<ExtensionConfiguration> defaultValuesOptional = instance.getDefaultValues();
                if (defaultValuesOptional.isPresent()) {
                    this.defaultValues(defaultValuesOptional);
                }
                if ((enabledValue = instance.getEnabled()) != null) {
                    this.enabled(enabledValue);
                }
            }
            if (object instanceof CachingConfiguration && (cachingValue = (instance = (CachingConfiguration)object).getCaching()) != null) {
                this.caching(cachingValue);
            }
            if (object instanceof CollectionsConfiguration) {
                Optional<Boolean> collectionIdAsParameterOptional;
                instance = (CollectionsConfiguration)object;
                this.addAllAdditionalLinks(instance.getAdditionalLinks());
                Optional<Boolean> collectionDefinitionsAreIdenticalOptional = instance.getCollectionDefinitionsAreIdentical();
                if (collectionDefinitionsAreIdenticalOptional.isPresent()) {
                    this.collectionDefinitionsAreIdentical(collectionDefinitionsAreIdenticalOptional);
                }
                if ((collectionIdAsParameterOptional = instance.getCollectionIdAsParameter()).isPresent()) {
                    this.collectionIdAsParameter(collectionIdAsParameterOptional);
                }
            }
        }

        @JsonProperty(value="enabled")
        @CanIgnoreReturnValue
        public final Builder enabled(@Nullable Boolean enabled) {
            this.enabled = enabled;
            return this;
        }

        @Override
        @CanIgnoreReturnValue
        public final Builder defaultValues(ExtensionConfiguration defaultValues) {
            this.defaultValues = Objects.requireNonNull(defaultValues, "defaultValues");
            return this;
        }

        @JsonProperty(value="defaultValues")
        @JsonIgnore
        @CanIgnoreReturnValue
        public final Builder defaultValues(Optional<? extends ExtensionConfiguration> defaultValues) {
            this.defaultValues = defaultValues.orElse(null);
            return this;
        }

        @JsonProperty(value="caching")
        @CanIgnoreReturnValue
        public final Builder caching(@Nullable Caching caching) {
            this.caching = caching;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder addAdditionalLinks(Link element) {
            this.additionalLinks.add((Object)element);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder addAdditionalLinks(Link ... elements) {
            this.additionalLinks.add(elements);
            return this;
        }

        @JsonProperty(value="additionalLinks")
        @JsonMerge(value=OptBoolean.FALSE)
        @CanIgnoreReturnValue
        public final Builder additionalLinks(Iterable<? extends Link> elements) {
            this.additionalLinks = ImmutableList.builder();
            return this.addAllAdditionalLinks(elements);
        }

        @CanIgnoreReturnValue
        public final Builder addAllAdditionalLinks(Iterable<? extends Link> elements) {
            this.additionalLinks.addAll(elements);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder collectionIdAsParameter(boolean collectionIdAsParameter) {
            this.collectionIdAsParameter = collectionIdAsParameter;
            return this;
        }

        @JsonProperty(value="collectionIdAsParameter")
        @CanIgnoreReturnValue
        public final Builder collectionIdAsParameter(Optional<Boolean> collectionIdAsParameter) {
            this.collectionIdAsParameter = collectionIdAsParameter.orElse(null);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder collectionDefinitionsAreIdentical(boolean collectionDefinitionsAreIdentical) {
            this.collectionDefinitionsAreIdentical = collectionDefinitionsAreIdentical;
            return this;
        }

        @JsonProperty(value="collectionDefinitionsAreIdentical")
        @CanIgnoreReturnValue
        public final Builder collectionDefinitionsAreIdentical(Optional<Boolean> collectionDefinitionsAreIdentical) {
            this.collectionDefinitionsAreIdentical = collectionDefinitionsAreIdentical.orElse(null);
            return this;
        }

        @Override
        public ImmutableCollectionsConfiguration build() {
            return new ImmutableCollectionsConfiguration(this.enabled, this.defaultValues, this.caching, (ImmutableList<Link>)this.additionalLinks.build(), this.collectionIdAsParameter, this.collectionDefinitionsAreIdentical);
        }
    }
}

