/*
 * Decompiled with CFR 0.152.
 */
package de.ii.ogcapi.collections.domain;

import de.ii.ogcapi.collections.domain.ImmutableCollectionsConfiguration;
import de.ii.ogcapi.foundation.domain.CachingConfiguration;
import de.ii.ogcapi.foundation.domain.ExtensionConfiguration;
import de.ii.ogcapi.foundation.domain.Link;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import shadow.com.fasterxml.jackson.annotation.JsonMerge;
import shadow.com.fasterxml.jackson.annotation.OptBoolean;
import shadow.com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import shadow.com.google.common.collect.Lists;
import shadow.org.immutables.value.Value;

@JsonDeserialize(builder=ImmutableCollectionsConfiguration.Builder.class)
@Value.Immutable
@Value.Style(builder="new")
public interface CollectionsConfiguration
extends ExtensionConfiguration,
CachingConfiguration {
    @JsonMerge(value=OptBoolean.FALSE)
    public List<Link> getAdditionalLinks();

    public Optional<Boolean> getCollectionIdAsParameter();

    public Optional<Boolean> getCollectionDefinitionsAreIdentical();

    default public Builder getBuilder() {
        return new ImmutableCollectionsConfiguration.Builder();
    }

    @Override
    default public ExtensionConfiguration mergeInto(ExtensionConfiguration source) {
        ImmutableCollectionsConfiguration.Builder builder = new ImmutableCollectionsConfiguration.Builder().from(source).from(this);
        ArrayList<Link> links = Lists.newArrayList(((CollectionsConfiguration)source).getAdditionalLinks());
        this.getAdditionalLinks().forEach(link -> {
            if (!links.contains(link)) {
                links.add((Link)link);
            }
        });
        builder.additionalLinks(links);
        return builder.build();
    }

    public static abstract class Builder
    extends ExtensionConfiguration.Builder {
    }
}

