/*
 * Decompiled with CFR 0.152.
 */
package de.ii.ldproxy.cfg;

import de.ii.ldproxy.cfg.Builders;
import de.ii.ldproxy.cfg.EntityFactories;
import de.ii.ldproxy.cfg.JacksonSubTypes;
import de.ii.ldproxy.cfg.OgcApiExtensionRegistry;
import de.ii.ldproxy.cfg.RequiredIncludes;
import de.ii.ogcapi.foundation.domain.OgcApiDataV2;
import de.ii.xtraplatform.base.domain.AppConfiguration;
import de.ii.xtraplatform.base.domain.AppContext;
import de.ii.xtraplatform.base.domain.Constants;
import de.ii.xtraplatform.base.domain.JacksonProvider;
import de.ii.xtraplatform.base.domain.StoreConfiguration;
import de.ii.xtraplatform.codelists.domain.CodelistData;
import de.ii.xtraplatform.features.domain.FeatureProviderDataV2;
import de.ii.xtraplatform.features.sql.domain.FeatureProviderSqlData;
import de.ii.xtraplatform.services.domain.ServiceData;
import de.ii.xtraplatform.store.app.EventStoreDefault;
import de.ii.xtraplatform.store.app.EventSubscriptions;
import de.ii.xtraplatform.store.app.ValueEncodingJackson;
import de.ii.xtraplatform.store.app.entities.EntityDataDefaultsStoreImpl;
import de.ii.xtraplatform.store.app.entities.EntityDataStoreImpl;
import de.ii.xtraplatform.store.domain.EventStoreDriver;
import de.ii.xtraplatform.store.domain.EventStoreSubscriber;
import de.ii.xtraplatform.store.domain.Identifier;
import de.ii.xtraplatform.store.domain.TypedEvent;
import de.ii.xtraplatform.store.domain.ValueEncoding;
import de.ii.xtraplatform.store.domain.entities.EntityData;
import de.ii.xtraplatform.store.domain.entities.EntityDataBuilder;
import de.ii.xtraplatform.store.domain.entities.EntityDataDefaultsStore;
import de.ii.xtraplatform.store.domain.entities.EntityDataStore;
import de.ii.xtraplatform.store.domain.entities.EntityFactory;
import de.ii.xtraplatform.store.domain.entities.EntityRegistry;
import de.ii.xtraplatform.store.domain.entities.EntityState;
import de.ii.xtraplatform.store.domain.entities.PersistentEntity;
import de.ii.xtraplatform.store.infra.EventStoreDriverFs;
import java.io.IOException;
import java.net.URI;
import java.nio.file.Path;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.CompletionException;
import java.util.function.Consumer;
import shadow.com.fasterxml.jackson.core.type.TypeReference;
import shadow.com.fasterxml.jackson.databind.ObjectMapper;

public class LdproxyCfg {
    private final EntityDataDefaultsStore entityDataDefaultsStore;
    private final EntityDataStore<EntityData> entityDataStore;
    private final Builders builders;
    private final Map<String, EventStoreSubscriber> subscribers;
    private final ObjectMapper objectMapper;
    private final RequiredIncludes requiredIncludes = new RequiredIncludes();

    public LdproxyCfg(Path dataDirectory) {
        this.builders = new Builders(){};
        this.subscribers = new LinkedHashMap<String, EventStoreSubscriber>();
        StoreConfiguration storeConfiguration = new StoreConfiguration();
        JacksonProvider jackson = new JacksonProvider(JacksonSubTypes::ids);
        this.objectMapper = new ValueEncodingJackson(jackson, true).getMapper(ValueEncoding.FORMAT.YML);
        EventStoreDriverFs storeDriver = new EventStoreDriverFs(dataDirectory, storeConfiguration);
        EventStoreDefault eventStore = new EventStoreDefault(storeConfiguration, (EventStoreDriver)storeDriver, new EventSubscriptions(){

            @Override
            public void addSubscriber(EventStoreSubscriber subscriber) {
                subscriber.getEventTypes().forEach(type -> LdproxyCfg.this.subscribers.put((String)type, subscriber));
            }

            @Override
            public void emitEvent(TypedEvent event) {
                if (LdproxyCfg.this.subscribers.containsKey(event.type())) {
                    LdproxyCfg.this.subscribers.get(event.type()).onEmit(event);
                }
            }

            @Override
            public void startListening() {
            }
        });
        EntityRegistry entityRegistryNoOp = new EntityRegistry(){

            @Override
            public <T extends PersistentEntity> List<T> getEntitiesForType(Class<T> type) {
                return null;
            }

            @Override
            public <T extends PersistentEntity> Optional<T> getEntity(Class<T> type, String id) {
                return Optional.empty();
            }

            @Override
            public Optional<PersistentEntity> getEntity(String type, String id) {
                return Optional.empty();
            }

            @Override
            public Optional<EntityState.STATE> getEntityState(String type, String id) {
                return Optional.empty();
            }

            @Override
            public <T extends PersistentEntity> void addEntityListener(Class<T> type, Consumer<T> listener, boolean existing) {
            }

            @Override
            public <T extends PersistentEntity> void addEntityGoneListener(Class<T> type, Consumer<T> listener) {
            }
        };
        AppContext appContext = new AppContext(){

            @Override
            public String getName() {
                return null;
            }

            @Override
            public String getVersion() {
                return null;
            }

            @Override
            public Constants.ENV getEnvironment() {
                return null;
            }

            @Override
            public Path getDataDir() {
                return null;
            }

            @Override
            public Path getTmpDir() {
                return null;
            }

            @Override
            public Path getConfigurationFile() {
                return null;
            }

            @Override
            public AppConfiguration getConfiguration() {
                AppConfiguration appConfiguration = new AppConfiguration();
                appConfiguration.store.failOnUnknownProperties = true;
                return appConfiguration;
            }

            @Override
            public URI getUri() {
                return null;
            }
        };
        OgcApiExtensionRegistry extensionRegistry = new OgcApiExtensionRegistry();
        Set<EntityFactory> factories = EntityFactories.factories(extensionRegistry);
        this.entityDataDefaultsStore = new EntityDataDefaultsStoreImpl(appContext, eventStore, jackson, () -> factories);
        this.entityDataStore = new EntityDataStoreImpl(appContext, eventStore, jackson, () -> factories, this.entityDataDefaultsStore);
    }

    public Builders builder() {
        return this.builders;
    }

    public <T extends EntityData> void writeEntity(T data, Path ... patches) throws IOException {
        try {
            this.entityDataStore.put(data.getId(), data, this.getType(data)).join();
            for (Path patch : patches) {
                Map<String, Object> patchMap = this.objectMapper.readValue(patch.toFile(), new TypeReference<Map<String, Object>>(){});
                this.entityDataStore.patch(data.getId(), patchMap, true, this.getType(data)).join();
            }
        }
        catch (CompletionException e) {
            if (e.getCause() instanceof IOException) {
                throw (IOException)e.getCause();
            }
            throw e;
        }
        catch (Throwable e) {
            e.printStackTrace();
        }
    }

    public <T extends EntityData> void writeDefaults(T data, Path ... defaults) throws IOException {
        Identifier defaultsIdentifier = Identifier.from(data.getId(), this.getType(data), this.getSubType(data));
        EntityDataBuilder<EntityData> builder = this.entityDataDefaultsStore.getBuilder(defaultsIdentifier).fillRequiredFieldsWithPlaceholders();
        for (Path defaultFile : defaults) {
            this.objectMapper.readerForUpdating(builder).readValue(defaultFile.toFile());
        }
        Map<String, Object> asMap = this.entityDataDefaultsStore.asMap(Identifier.from(data.getId(), this.getType(data)), (EntityData)builder.build());
        try {
            this.entityDataDefaultsStore.patch(data.getId(), asMap, this.getType(data), this.getSubType(data)).join();
        }
        catch (CompletionException e) {
            if (e.getCause() instanceof IOException) {
                throw (IOException)e.getCause();
            }
            throw e;
        }
    }

    private <T extends EntityData> String getType(T data) {
        if (data instanceof CodelistData) {
            return "codelists";
        }
        if (data instanceof FeatureProviderDataV2) {
            return "providers";
        }
        if (data instanceof ServiceData) {
            return "services";
        }
        return null;
    }

    private <T extends EntityData> String getSubType(T data) {
        if (data instanceof CodelistData) {
            return null;
        }
        if (data instanceof FeatureProviderSqlData) {
            return "feature/sql".replace('/', '.').toLowerCase();
        }
        if (data instanceof OgcApiDataV2) {
            return "OGC_API".toLowerCase();
        }
        return null;
    }
}

