/*
 * Decompiled with CFR 0.152.
 */
package ch.qos.logback.access.jetty;

import ch.qos.logback.access.jetty.JettyServerAdapter;
import ch.qos.logback.access.joran.JoranConfigurator;
import ch.qos.logback.access.spi.AccessEvent;
import ch.qos.logback.access.spi.IAccessEvent;
import ch.qos.logback.core.Appender;
import ch.qos.logback.core.ContextBase;
import ch.qos.logback.core.filter.Filter;
import ch.qos.logback.core.joran.spi.JoranException;
import ch.qos.logback.core.spi.AppenderAttachable;
import ch.qos.logback.core.spi.AppenderAttachableImpl;
import ch.qos.logback.core.spi.FilterAttachable;
import ch.qos.logback.core.spi.FilterAttachableImpl;
import ch.qos.logback.core.spi.FilterReply;
import ch.qos.logback.core.status.ErrorStatus;
import ch.qos.logback.core.status.InfoStatus;
import ch.qos.logback.core.util.FileUtil;
import ch.qos.logback.core.util.OptionHelper;
import ch.qos.logback.core.util.StatusPrinter;
import java.io.File;
import java.net.URL;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import shadow.org.eclipse.jetty.server.Request;
import shadow.org.eclipse.jetty.server.RequestLog;
import shadow.org.eclipse.jetty.server.Response;
import shadow.org.eclipse.jetty.util.component.LifeCycle;

public class RequestLogImpl
extends ContextBase
implements RequestLog,
AppenderAttachable<IAccessEvent>,
FilterAttachable<IAccessEvent> {
    public static final String DEFAULT_CONFIG_FILE = "etc" + File.separatorChar + "logback-access.xml";
    AppenderAttachableImpl<IAccessEvent> aai = new AppenderAttachableImpl();
    FilterAttachableImpl<IAccessEvent> fai = new FilterAttachableImpl();
    String fileName;
    String resource;
    boolean started = false;
    boolean quiet = false;

    public RequestLogImpl() {
        this.putObject("EVALUATOR_MAP", new HashMap());
    }

    @Override
    public void log(Request jettyRequest, Response jettyResponse) {
        JettyServerAdapter adapter = new JettyServerAdapter(jettyRequest, jettyResponse);
        AccessEvent accessEvent = new AccessEvent(jettyRequest, jettyResponse, adapter);
        if (this.getFilterChainDecision(accessEvent) == FilterReply.DENY) {
            return;
        }
        this.aai.appendLoopOnAppenders(accessEvent);
    }

    private void addInfo(String msg) {
        this.getStatusManager().add(new InfoStatus(msg, this));
    }

    private void addError(String msg) {
        this.getStatusManager().add(new ErrorStatus(msg, this));
    }

    @Override
    public void start() {
        this.configure();
        if (!this.isQuiet()) {
            StatusPrinter.print(this.getStatusManager());
        }
        this.started = true;
    }

    protected void configure() {
        URL configURL = this.getConfigurationFileURL();
        if (configURL != null) {
            this.runJoranOnFile(configURL);
        } else {
            this.addError("Could not find configuration file for logback-access");
        }
    }

    protected URL getConfigurationFileURL() {
        if (this.fileName != null) {
            this.addInfo("Will use configuration file [" + this.fileName + "]");
            File file = new File(this.fileName);
            if (!file.exists()) {
                return null;
            }
            return FileUtil.fileToURL(file);
        }
        if (this.resource != null) {
            this.addInfo("Will use configuration resource [" + this.resource + "]");
            return this.getClass().getResource(this.resource);
        }
        String jettyHomeProperty = OptionHelper.getSystemProperty("jetty.home");
        String defaultConfigFile = DEFAULT_CONFIG_FILE;
        if (!OptionHelper.isEmpty(jettyHomeProperty)) {
            defaultConfigFile = jettyHomeProperty + File.separatorChar + DEFAULT_CONFIG_FILE;
        } else {
            this.addInfo("[jetty.home] system property not set.");
        }
        File file = new File(defaultConfigFile);
        this.addInfo("Assuming default configuration file [" + defaultConfigFile + "]");
        if (!file.exists()) {
            return null;
        }
        return FileUtil.fileToURL(file);
    }

    private void runJoranOnFile(URL configURL) {
        try {
            JoranConfigurator jc = new JoranConfigurator();
            jc.setContext(this);
            jc.doConfigure(configURL);
            if (this.getName() == null) {
                this.setName("LogbackRequestLog");
            }
        }
        catch (JoranException joranException) {
            // empty catch block
        }
    }

    @Override
    public void stop() {
        this.aai.detachAndStopAllAppenders();
        this.started = false;
    }

    public boolean isRunning() {
        return this.started;
    }

    public void setFileName(String fileName) {
        this.fileName = fileName;
    }

    public void setResource(String resource) {
        this.resource = resource;
    }

    @Override
    public boolean isStarted() {
        return this.started;
    }

    public boolean isStarting() {
        return false;
    }

    public boolean isStopping() {
        return false;
    }

    public boolean isStopped() {
        return !this.started;
    }

    public boolean isFailed() {
        return false;
    }

    public boolean isQuiet() {
        return this.quiet;
    }

    public void setQuiet(boolean quiet) {
        this.quiet = quiet;
    }

    @Override
    public void addAppender(Appender<IAccessEvent> newAppender) {
        this.aai.addAppender(newAppender);
    }

    @Override
    public Iterator<Appender<IAccessEvent>> iteratorForAppenders() {
        return this.aai.iteratorForAppenders();
    }

    @Override
    public Appender<IAccessEvent> getAppender(String name) {
        return this.aai.getAppender(name);
    }

    @Override
    public boolean isAttached(Appender<IAccessEvent> appender) {
        return this.aai.isAttached(appender);
    }

    @Override
    public void detachAndStopAllAppenders() {
        this.aai.detachAndStopAllAppenders();
    }

    @Override
    public boolean detachAppender(Appender<IAccessEvent> appender) {
        return this.aai.detachAppender(appender);
    }

    @Override
    public boolean detachAppender(String name) {
        return this.aai.detachAppender(name);
    }

    @Override
    public void addFilter(Filter<IAccessEvent> newFilter) {
        this.fai.addFilter(newFilter);
    }

    @Override
    public void clearAllFilters() {
        this.fai.clearAllFilters();
    }

    @Override
    public List<Filter<IAccessEvent>> getCopyOfAttachedFiltersList() {
        return this.fai.getCopyOfAttachedFiltersList();
    }

    @Override
    public FilterReply getFilterChainDecision(IAccessEvent event) {
        return this.fai.getFilterChainDecision(event);
    }

    public void addLifeCycleListener(LifeCycle.Listener listener) {
    }

    public void removeLifeCycleListener(LifeCycle.Listener listener) {
    }
}

