/*
 * Decompiled with CFR 0.152.
 */
package ch.qos.logback.access.jetty;

import ch.qos.logback.access.spi.ServerAdapter;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import shadow.org.eclipse.jetty.http.HttpFields;
import shadow.org.eclipse.jetty.server.Request;
import shadow.org.eclipse.jetty.server.Response;

public class JettyServerAdapter
implements ServerAdapter {
    Request request;
    Response response;

    public JettyServerAdapter(Request jettyRequest, Response jettyResponse) {
        this.request = jettyRequest;
        this.response = jettyResponse;
    }

    @Override
    public long getContentLength() {
        return this.response.getContentCount();
    }

    @Override
    public int getStatusCode() {
        return this.response.getStatus();
    }

    @Override
    public long getRequestTimestamp() {
        return this.request.getTimeStamp();
    }

    @Override
    public Map<String, String> buildResponseHeaderMap() {
        HashMap<String, String> responseHeaderMap = new HashMap<String, String>();
        HttpFields httpFields = this.response.getHttpFields();
        Enumeration<String> e = httpFields.getFieldNames();
        while (e.hasMoreElements()) {
            String key = e.nextElement();
            String value = this.response.getHeader(key);
            responseHeaderMap.put(key, value);
        }
        return responseHeaderMap;
    }
}

