/*
 * Decompiled with CFR 0.152.
 */
package org.sparx;

import java.util.Iterator;
import java.util.NoSuchElementException;
import org.sparx.ObjectType;
import org.sparx.Swimlane;

public class Swimlanes
implements Iterable<Swimlane> {
    private long comObject = 0L;

    private native Swimlane comAdd(long var1, String var3, int var4);

    private native long comAddReference(long var1);

    private native void comDelete(long var1, Object var3);

    private native void comDeleteAll(long var1);

    private native void comDestructor(long var1);

    private native int comGetCount(long var1);

    private native long comGetObjectType(long var1);

    private native Swimlane comInsert(long var1, int var3, String var4, int var5);

    private native Swimlane comItems(long var1, Object var3);

    Swimlanes(long l) {
        this.comObject = l;
    }

    public Swimlanes(Swimlanes swimlanes) {
        this.comObject = this.comAddReference(swimlanes.comObject);
    }

    protected void finalize() {
        this.destroy();
    }

    public Swimlane Add(String string, int n) {
        return this.comAdd(this.comObject, string, n);
    }

    public void Delete(Object object) {
        this.comDelete(this.comObject, object);
    }

    public void DeleteAll() {
        this.comDeleteAll(this.comObject);
    }

    public void destroy() {
        if (this.comObject != 0L) {
            this.comDestructor(this.comObject);
            this.comObject = 0L;
        }
    }

    long GetComObject() {
        return this.comObject;
    }

    public int GetCount() {
        return this.comGetCount(this.comObject);
    }

    public ObjectType GetObjectType() {
        return ObjectType.values()[(int)this.comGetObjectType(this.comObject)];
    }

    public Swimlane Insert(int n, String string, int n2) {
        return this.comInsert(this.comObject, n, string, n2);
    }

    public Swimlane Items(Object object) {
        return this.comItems(this.comObject, object);
    }

    @Override
    public Iterator<Swimlane> iterator() {
        return new SwimlanesIterator(this);
    }

    static {
        if (System.getProperty("os.arch").equals("x86")) {
            System.loadLibrary("SSJavaCOM");
        } else {
            System.loadLibrary("SSJavaCOM64");
        }
    }

    public class SwimlanesIterator
    implements Iterator<Swimlane> {
        private Swimlanes m_Swimlanes;
        private short position = (short)-1;

        SwimlanesIterator(Swimlanes swimlanes2) {
            this.m_Swimlanes = swimlanes2;
        }

        @Override
        public boolean hasNext() {
            return this.m_Swimlanes.GetCount() > this.position + 1;
        }

        @Override
        public Swimlane next() throws NoSuchElementException {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            this.position = (short)(this.position + 1);
            return this.m_Swimlanes.Items(this.position);
        }

        @Override
        public void remove() throws UnsupportedOperationException {
            throw new UnsupportedOperationException();
        }
    }
}

