/*
 * Decompiled with CFR 0.152.
 */
package org.sparx;

import org.sparx.ObjectType;

public class Simulation {
    private long comObject = 0L;

    private native long comAddReference(long var1);

    private native boolean comBroadcastSignal(long var1, String var3, String var4);

    private native void comDestructor(long var1);

    private native long comGetObjectType(long var1);

    private native int comGetSpeed(long var1);

    private native boolean comIsSimulatorRunning(long var1);

    private native boolean comPause(long var1);

    private native void comSetSpeed(long var1, int var3);

    private native boolean comStart(long var1);

    private native boolean comStepIn(long var1);

    private native boolean comStepOut(long var1);

    private native boolean comStepOver(long var1);

    private native boolean comStop(long var1);

    Simulation(long l) {
        this.comObject = l;
    }

    public Simulation(Simulation simulation) {
        this.comObject = this.comAddReference(simulation.comObject);
    }

    protected void finalize() {
        this.destroy();
    }

    public boolean BroadcastSignal(String string, String string2) {
        return this.comBroadcastSignal(this.comObject, string, string2);
    }

    public void destroy() {
        if (this.comObject != 0L) {
            this.comDestructor(this.comObject);
            this.comObject = 0L;
        }
    }

    long GetComObject() {
        return this.comObject;
    }

    public ObjectType GetObjectType() {
        return ObjectType.values()[(int)this.comGetObjectType(this.comObject)];
    }

    public int GetSpeed() {
        return this.comGetSpeed(this.comObject);
    }

    public boolean IsSimulatorRunning() {
        return this.comIsSimulatorRunning(this.comObject);
    }

    public boolean Pause() {
        return this.comPause(this.comObject);
    }

    public void SetSpeed(int n) {
        this.comSetSpeed(this.comObject, n);
    }

    public boolean Start() {
        return this.comStart(this.comObject);
    }

    public boolean StepIn() {
        return this.comStepIn(this.comObject);
    }

    public boolean StepOut() {
        return this.comStepOut(this.comObject);
    }

    public boolean StepOver() {
        return this.comStepOver(this.comObject);
    }

    public boolean Stop() {
        return this.comStop(this.comObject);
    }

    static {
        if (System.getProperty("os.arch").equals("x86")) {
            System.loadLibrary("SSJavaCOM");
        } else {
            System.loadLibrary("SSJavaCOM64");
        }
    }
}

