/*
 * Decompiled with CFR 0.152.
 */
package org.sparx;

import java.util.Iterator;
import java.util.NoSuchElementException;
import org.sparx.ObjectType;
import org.sparx.Property;

public class Properties
implements Iterable<Object> {
    private long comObject = 0L;

    private native long comAddReference(long var1);

    private native void comDestructor(long var1);

    private native int comGetCount(long var1);

    private native long comGetObjectType(long var1);

    private native Property comItem(long var1, Object var3);

    Properties(long l) {
        this.comObject = l;
    }

    public Properties(Properties properties) {
        this.comObject = this.comAddReference(properties.comObject);
    }

    protected void finalize() {
        this.destroy();
    }

    public void destroy() {
        if (this.comObject != 0L) {
            this.comDestructor(this.comObject);
            this.comObject = 0L;
        }
    }

    long GetComObject() {
        return this.comObject;
    }

    public int GetCount() {
        return this.comGetCount(this.comObject);
    }

    public ObjectType GetObjectType() {
        return ObjectType.values()[(int)this.comGetObjectType(this.comObject)];
    }

    public Property Item(Object object) {
        return this.comItem(this.comObject, object);
    }

    @Override
    public Iterator<Object> iterator() {
        return new PropertiesIterator(this);
    }

    static {
        if (System.getProperty("os.arch").equals("x86")) {
            System.loadLibrary("SSJavaCOM");
        } else {
            System.loadLibrary("SSJavaCOM64");
        }
    }

    public class PropertiesIterator
    implements Iterator<Object> {
        private Properties m_Properties;
        private short position = (short)-1;

        PropertiesIterator(Properties properties2) {
            this.m_Properties = properties2;
        }

        @Override
        public boolean hasNext() {
            return this.m_Properties.GetCount() > this.position + 1;
        }

        @Override
        public Object next() throws NoSuchElementException {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            this.position = (short)(this.position + 1);
            return this.m_Properties.Item(this.position);
        }

        @Override
        public void remove() throws UnsupportedOperationException {
            throw new UnsupportedOperationException();
        }
    }
}

