/*
 * Decompiled with CFR 0.152.
 */
package org.sparx;

import java.util.Iterator;
import java.util.NoSuchElementException;
import org.sparx.EventProperty;
import org.sparx.ObjectType;

public class EventProperties
implements Iterable<Object> {
    private long comObject = 0L;

    private native long comAddReference(long var1);

    private native void comDestructor(long var1);

    private native EventProperty comGet(long var1, Object var3);

    private native int comGetCount(long var1);

    private native long comGetObjectType(long var1);

    EventProperties(long l) {
        this.comObject = l;
    }

    public EventProperties(EventProperties eventProperties) {
        this.comObject = this.comAddReference(eventProperties.comObject);
    }

    protected void finalize() {
        this.destroy();
    }

    public void destroy() {
        if (this.comObject != 0L) {
            this.comDestructor(this.comObject);
            this.comObject = 0L;
        }
    }

    public EventProperty Get(Object object) {
        return this.comGet(this.comObject, object);
    }

    long GetComObject() {
        return this.comObject;
    }

    public int GetCount() {
        return this.comGetCount(this.comObject);
    }

    public ObjectType GetObjectType() {
        return ObjectType.values()[(int)this.comGetObjectType(this.comObject)];
    }

    @Override
    public Iterator<Object> iterator() {
        return new EventPropertiesIterator(this);
    }

    static {
        if (System.getProperty("os.arch").equals("x86")) {
            System.loadLibrary("SSJavaCOM");
        } else {
            System.loadLibrary("SSJavaCOM64");
        }
    }

    public class EventPropertiesIterator
    implements Iterator<Object> {
        private EventProperties m_EventProperties;
        private short position = (short)-1;

        EventPropertiesIterator(EventProperties eventProperties2) {
            this.m_EventProperties = eventProperties2;
        }

        @Override
        public boolean hasNext() {
            return this.m_EventProperties.GetCount() > this.position + 1;
        }

        @Override
        public Object next() throws NoSuchElementException {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            this.position = (short)(this.position + 1);
            return this.m_EventProperties.Get(this.position);
        }

        @Override
        public void remove() throws UnsupportedOperationException {
            throw new UnsupportedOperationException();
        }
    }
}

