/*
 * Decompiled with CFR 0.152.
 */
package org.sparx;

import java.util.Iterator;
import java.util.NoSuchElementException;
import org.sparx.ObjectType;

public class Collection<T>
implements Iterable<T> {
    private long comObject = 0L;

    private native T comAddNew(long var1, String var3, String var4);

    private native long comAddReference(long var1);

    private native void comDelete(long var1, short var3);

    private native void comDeleteAt(long var1, short var3, boolean var4);

    private native void comDestructor(long var1);

    private native T comGetAt(long var1, short var3);

    private native T comGetByName(long var1, String var3);

    private native short comGetCount(long var1);

    private native String comGetLastError(long var1);

    private native long comGetObjectType(long var1);

    private native void comRefresh(long var1);

    Collection(long l) {
        this.comObject = l;
    }

    public Collection(Collection collection) {
        this.comObject = this.comAddReference(collection.comObject);
    }

    protected void finalize() {
        this.destroy();
    }

    public T AddNew(String string, String string2) {
        return this.comAddNew(this.comObject, string, string2);
    }

    public void Delete(short s) {
        this.comDelete(this.comObject, s);
    }

    public void DeleteAt(short s, boolean bl) {
        this.comDeleteAt(this.comObject, s, bl);
    }

    public void destroy() {
        if (this.comObject != 0L) {
            this.comDestructor(this.comObject);
            this.comObject = 0L;
        }
    }

    public T GetAt(short s) {
        return this.comGetAt(this.comObject, s);
    }

    public T GetByName(String string) {
        return this.comGetByName(this.comObject, string);
    }

    long GetComObject() {
        return this.comObject;
    }

    public short GetCount() {
        return this.comGetCount(this.comObject);
    }

    public String GetLastError() {
        return this.comGetLastError(this.comObject);
    }

    public ObjectType GetObjectType() {
        return ObjectType.values()[(int)this.comGetObjectType(this.comObject)];
    }

    @Override
    public Iterator<T> iterator() {
        return new CollectionIterator(this);
    }

    public void Refresh() {
        this.comRefresh(this.comObject);
    }

    static {
        if (System.getProperty("os.arch").equals("x86")) {
            System.loadLibrary("SSJavaCOM");
        } else {
            System.loadLibrary("SSJavaCOM64");
        }
    }

    public class CollectionIterator<T>
    implements Iterator<T> {
        private Collection<T> m_Collection;
        private short position = (short)-1;

        CollectionIterator(Collection<T> collection2) {
            this.m_Collection = collection2;
        }

        @Override
        public boolean hasNext() {
            return this.m_Collection.GetCount() > this.position + 1;
        }

        @Override
        public T next() throws NoSuchElementException {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            this.position = (short)(this.position + 1);
            return this.m_Collection.GetAt(this.position);
        }

        @Override
        public void remove() throws UnsupportedOperationException {
            throw new UnsupportedOperationException();
        }
    }
}

