/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.tdb2.loader;

import java.util.Arrays;
import java.util.List;
import org.apache.jena.sparql.core.DatasetGraph;
import org.apache.jena.tdb2.loader.DataLoader;
import org.apache.jena.tdb2.loader.LoaderFactory;
import org.apache.jena.tdb2.loader.base.LoaderOps;
import org.apache.jena.tdb2.loader.base.MonitorOutput;

public class Loader {
    public static void load(DatasetGraph dataset, String ... dataURLs) {
        Loader.load(dataset, false, dataURLs);
    }

    public static void load(DatasetGraph dataset, boolean showProgress, String ... dataURLs) {
        Loader.load(dataset, Arrays.asList(dataURLs), showProgress);
    }

    public static void load(DatasetGraph dataset, List<String> dataURLs, boolean showProgress) {
        DataLoader loader = Loader.create(dataset, showProgress);
        loader.startBulk();
        try {
            loader.load(dataURLs);
            loader.finishBulk();
        }
        catch (RuntimeException ex) {
            loader.finishException(ex);
            throw ex;
        }
    }

    public static DataLoader create(DatasetGraph dataset, boolean showProgress) {
        MonitorOutput output = showProgress ? LoaderOps.outputToLog() : LoaderOps.nullOutput();
        DataLoader loader = LoaderFactory.createLoader(dataset, output);
        return loader;
    }

    public static void read(DatasetGraph dataset, String ... dataURLs) {
        Loader.read(dataset, false, dataURLs);
    }

    public static void read(DatasetGraph dataset, boolean showProgress, String ... dataURLs) {
        Loader.read(dataset, Arrays.asList(dataURLs), showProgress);
    }

    public static void read(DatasetGraph dataset, List<String> dataURLs, boolean showProgress) {
        MonitorOutput output = showProgress ? LoaderOps.outputToLog() : LoaderOps.nullOutput();
        DataLoader loader = LoaderFactory.basicLoader(dataset, output);
        loader.startBulk();
        try {
            loader.load(dataURLs);
            loader.finishBulk();
        }
        catch (RuntimeException ex) {
            loader.finishException(ex);
            throw ex;
        }
    }
}

