/*
 * Decompiled with CFR 0.152.
 */
package de.interactive_instruments.ShapeChange.Util.ea;

import de.interactive_instruments.ShapeChange.Model.TaggedValues;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class EATaggedValue {
    protected String name;
    protected String fqName = "";
    protected List<String> values;
    protected boolean createAsMemoField = false;

    public EATaggedValue(String name, String value) {
        this(name, value, false);
    }

    public EATaggedValue(String name, String fqName, String value) {
        this(name, fqName, value, false);
    }

    public EATaggedValue(String name, String value, boolean createAsMemoField) {
        this(name, null, value, createAsMemoField);
    }

    public EATaggedValue(String name, String fqName, String value, boolean createAsMemoField) {
        this.name = name;
        this.fqName = fqName == null ? "" : fqName;
        this.values = new ArrayList<String>();
        if (value != null) {
            this.values.add(value);
        }
        this.createAsMemoField = createAsMemoField;
    }

    public EATaggedValue(String name, List<String> values) {
        this(name, null, values);
    }

    public EATaggedValue(String name, String fqName, List<String> values) {
        this.name = name;
        this.fqName = fqName == null ? "" : fqName;
        this.values = values != null ? values : new ArrayList<String>();
    }

    public String getName() {
        return this.name;
    }

    public String getFQName() {
        return this.fqName;
    }

    public List<String> getValues() {
        return this.values;
    }

    public boolean createAsMemoField() {
        return this.createAsMemoField;
    }

    public void addValue(String value) {
        this.values.add(value);
    }

    public static List<EATaggedValue> fromTaggedValues(TaggedValues taggedValues) {
        ArrayList<EATaggedValue> result = new ArrayList<EATaggedValue>();
        for (Map.Entry<String, List<String>> e : taggedValues.asMap().entrySet()) {
            result.add(new EATaggedValue(e.getKey(), e.getValue()));
        }
        return result;
    }
}

