/*
 * Decompiled with CFR 0.152.
 */
package de.interactive_instruments.ShapeChange.Util.ea;

import de.interactive_instruments.ShapeChange.Model.ClassInfo;
import de.interactive_instruments.ShapeChange.Model.PackageInfo;
import de.interactive_instruments.ShapeChange.Util.ea.AbstractEAUtil;
import de.interactive_instruments.ShapeChange.Util.ea.EAElementUtil;
import de.interactive_instruments.ShapeChange.Util.ea.EAException;
import de.interactive_instruments.ShapeChange.Util.ea.EAPackageUtil;
import java.io.File;
import java.io.IOException;
import java.util.ArrayDeque;
import java.util.Map;
import java.util.SortedMap;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang3.StringUtils;
import org.sparx.Collection;
import org.sparx.Connector;
import org.sparx.CreateModelType;
import org.sparx.Element;
import org.sparx.Package;
import org.sparx.Repository;

public class EARepositoryUtil
extends AbstractEAUtil {
    public static void compact() {
        System.gc();
        System.runFinalization();
    }

    public static void setEABatchAppend(Repository rep, boolean batchAppend) {
        rep.SetBatchAppend(batchAppend);
    }

    public static void setEAEnableUIUpdates(Repository rep, boolean enableUIUpdates) {
        rep.SetEnableUIUpdates(enableUIUpdates);
    }

    public static Integer getEAChildPackageByName(Repository rep, int eaParentPkgId, String name) {
        Package eaParentPkg = rep.GetPackageByID(eaParentPkgId);
        Collection pkgs = eaParentPkg.GetPackages();
        for (short i = 0; i < pkgs.GetCount(); i = (short)(i + 1)) {
            Package p = (Package)pkgs.GetAt(i);
            if (!p.GetName().equals(name)) continue;
            return p.GetPackageID();
        }
        return null;
    }

    public static Package findPackage(Repository rep, String name) {
        Collection models = rep.GetModels();
        for (short i = 0; i < models.GetCount(); i = (short)(i + 1)) {
            Package pkg = EAPackageUtil.findPackage((Package)models.GetAt(i), name);
            if (pkg == null) continue;
            return pkg;
        }
        return null;
    }

    public static Integer getEAChildPackageByStereotype(Repository rep, int eaParentPkgId, String stereotype) {
        Package eaParentPkg = rep.GetPackageByID(eaParentPkgId);
        Collection pkgs = eaParentPkg.GetPackages();
        for (short i = 0; i < pkgs.GetCount(); i = (short)(i + 1)) {
            Package p = (Package)pkgs.GetAt(i);
            if (!p.GetStereotypeEx().contains(stereotype)) continue;
            return p.GetPackageID();
        }
        return null;
    }

    public static void deletePackage(Repository rep, int eaPkgId) {
        Package eaPkg = rep.GetPackageByID(eaPkgId);
        if (eaPkg != null) {
            Collection pkgs;
            if (eaPkg.GetParentID() == 0) {
                pkgs = rep.GetModels();
            } else {
                Package eaParentPkg = rep.GetPackageByID(eaPkg.GetParentID());
                pkgs = eaParentPkg.GetPackages();
            }
            for (short i = 0; i < pkgs.GetCount(); i = (short)(i + 1)) {
                Package p = (Package)pkgs.GetAt(i);
                if (p.GetPackageID() != eaPkgId) continue;
                pkgs.Delete(i);
                pkgs.Refresh();
                break;
            }
        }
    }

    public static Connector createEAGeneralization(Repository rep, int c1ElementId, String c1Name, int c2ElementId, String c2Name) throws EAException {
        Element c1 = rep.GetElementByID(c1ElementId);
        Collection c1Cons = c1.GetConnectors();
        Connector con = (Connector)c1Cons.AddNew("", "Generalization");
        con.SetSupplierID(c2ElementId);
        if (!con.Update()) {
            throw new EAException(EARepositoryUtil.createMessage(EARepositoryUtil.message(102), c1Name, c2Name, con.GetLastError()));
        }
        c1Cons.Refresh();
        return con;
    }

    public static Connector createEAGeneralization(Repository rep, Element c1, Element c2) throws EAException {
        Collection c1Cons = c1.GetConnectors();
        Connector con = (Connector)c1Cons.AddNew("", "Generalization");
        con.SetSupplierID(c2.GetElementID());
        if (!con.Update()) {
            throw new EAException(EARepositoryUtil.createMessage(EARepositoryUtil.message(102), c1.GetName(), c2.GetName(), con.GetLastError()));
        }
        c1Cons.Refresh();
        return con;
    }

    public static void closeRepository(Repository rep) {
        rep.SetEnableUIUpdates(true);
        rep.RefreshModelView(0);
        rep.SetEnableCache(false);
        rep.SetBatchAppend(false);
        rep.CloseFile();
        rep.Exit();
    }

    public static Repository openRepository(File repfileIn, boolean createIfNotExisting) throws EAException {
        File repfile = repfileIn;
        if (!repfileIn.getName().toLowerCase().endsWith(".eap")) {
            repfile = new File(repfileIn.getName() + ".eap");
        }
        String absname = repfile.getAbsolutePath();
        Repository rep = new Repository();
        if (!repfile.exists() && createIfNotExisting) {
            try {
                FileUtils.forceMkdirParent((File)repfile);
            }
            catch (IOException e) {
                throw new EAException("Could not create directory structure for EA repository at " + absname + ". Exception message is: " + e.getMessage());
            }
            if (!rep.CreateModel(CreateModelType.cmEAPFromBase, absname, 0)) {
                String errormsg = rep.GetLastError();
                rep = null;
                throw new EAException("Could not create EA repository at " + absname + ". EA error message is: " + errormsg);
            }
        }
        if (!rep.OpenFile(absname)) {
            String errormsg = rep.GetLastError();
            rep = null;
            throw new EAException("Could not open EA repository at " + absname + ". EA error message is: " + errormsg);
        }
        return rep;
    }

    public static Element createEAClass(Repository rep, String className, int eaPkgId) throws EAException {
        return EARepositoryUtil.createEAClass(rep, className, eaPkgId, "Class");
    }

    public static Element createEAClass(Repository rep, String className, int eaPkgId, String type) throws EAException {
        Package eaPkg = rep.GetPackageByID(eaPkgId);
        Collection elements = eaPkg.GetElements();
        Element e = (Element)elements.AddNew(className, type);
        if (!e.Update()) {
            throw new EAException(EARepositoryUtil.createMessage(EARepositoryUtil.message(101), className, e.GetLastError()));
        }
        elements.Refresh();
        return e;
    }

    public static int createEAPackage(Repository rep, PackageInfo pi, int eaParentPkgId) throws EAException {
        Package eaParentPkg = rep.GetPackageByID(eaParentPkgId);
        Collection eaParentPkgs = eaParentPkg.GetPackages();
        Package eaPkg = (Package)eaParentPkgs.AddNew(pi.name(), "Package");
        if (!eaPkg.Update()) {
            throw new EAException(EARepositoryUtil.createMessage(EARepositoryUtil.message(103), pi.name(), eaPkg.GetLastError()));
        }
        eaParentPkgs.Refresh();
        return eaPkg.GetPackageID();
    }

    public static int establishEAPackageHierarchy(ClassInfo ci, int containerPkgId, SortedMap<Integer, SortedMap<PackageInfo, Integer>> eaPkgIdByModelPkg_byContainerPkgId, Repository rep, int numberOfSchemasSelectedForProcessing, String author, String status) throws EAException {
        PackageInfo pkg;
        ArrayDeque<PackageInfo> pathToAppSchemaAsStack = new ArrayDeque<PackageInfo>();
        if (numberOfSchemasSelectedForProcessing > 1) {
            PackageInfo lastPkg = null;
            for (pkg = ci.pkg(); pkg != null && (lastPkg == null || pkg.targetNamespace() == lastPkg.targetNamespace()); pkg = pkg.owner()) {
                pathToAppSchemaAsStack.addFirst(pkg);
                lastPkg = pkg;
            }
        } else if (!ci.pkg().isSchema()) {
            for (pkg = ci.pkg(); pkg != null && !pkg.isSchema(); pkg = pkg.owner()) {
                pathToAppSchemaAsStack.addFirst(pkg);
            }
        }
        if (pathToAppSchemaAsStack.isEmpty()) {
            return containerPkgId;
        }
        Map eaPkgIdByModelPkg = (Map)eaPkgIdByModelPkg_byContainerPkgId.get(containerPkgId);
        Integer eaParentPkgId = containerPkgId;
        Integer eaPkgId = null;
        while (!pathToAppSchemaAsStack.isEmpty()) {
            PackageInfo pi = (PackageInfo)pathToAppSchemaAsStack.removeFirst();
            if (eaPkgIdByModelPkg.containsKey(pi)) {
                eaPkgId = (Integer)eaPkgIdByModelPkg.get(pi);
            } else {
                eaPkgId = EARepositoryUtil.createEAPackage(rep, pi, eaParentPkgId);
                eaPkgIdByModelPkg.put(pi, eaPkgId);
                if (author != null || status != null) {
                    Package pkgE = rep.GetPackageByID(eaPkgId.intValue());
                    if (StringUtils.isNotBlank((CharSequence)author)) {
                        EAElementUtil.setEAAuthor(pkgE.GetElement(), author);
                    }
                    if (StringUtils.isNotBlank((CharSequence)status)) {
                        EAElementUtil.setEAStatus(pkgE.GetElement(), status);
                    }
                }
            }
            eaParentPkgId = eaPkgId;
        }
        return eaPkgId;
    }

    public static String message(int mnr) {
        switch (mnr) {
            case 101: {
                return "EA error encountered while updating new EA class element '$1$'. Error message is: $2$";
            }
            case 102: {
                return "EA error encountered while updating new EA (generalization) connector between classes '$1$' and '$2$'. Error message is: $3$";
            }
            case 103: {
                return "EA error encountered while updating new EA package '$1$'. Error message is: $2$";
            }
        }
        return "(" + EARepositoryUtil.class.getName() + ") Unknown message with number: " + mnr;
    }
}

