/*
 * Decompiled with CFR 0.152.
 */
package de.interactive_instruments.ShapeChange.Util.ea;

import de.interactive_instruments.ShapeChange.Util.ea.AbstractEAUtil;
import de.interactive_instruments.ShapeChange.Util.ea.EAException;
import de.interactive_instruments.ShapeChange.Util.ea.EAMethodUtil;
import de.interactive_instruments.ShapeChange.Util.ea.EATaggedValue;
import java.util.SortedMap;
import java.util.TreeMap;
import org.sparx.Collection;
import org.sparx.ParamTag;
import org.sparx.Parameter;

public class EAParameterUtil
extends AbstractEAUtil {
    public static void setEAType(Parameter p, String type) throws EAException {
        p.SetType(type);
        if (!p.Update()) {
            throw new EAException(EAParameterUtil.createMessage(EAParameterUtil.message(101), p.GetName(), p.GetLastError()));
        }
    }

    public static SortedMap<String, EATaggedValue> getEATaggedValues(Parameter att) {
        TreeMap<String, EATaggedValue> result = new TreeMap<String, EATaggedValue>();
        Collection tvs = att.GetTaggedValues();
        for (short i = 0; i < tvs.GetCount(); i = (short)(i + 1)) {
            ParamTag tv = (ParamTag)tvs.GetAt(i);
            String name = tv.GetTag();
            String fqName = tv.GetFQName();
            String value = tv.GetValue();
            String key = name + "#" + fqName;
            if (result.containsKey(key)) {
                EATaggedValue eatv = (EATaggedValue)result.get(key);
                eatv.addValue(value);
                continue;
            }
            result.put(key, new EATaggedValue(name, fqName, value));
        }
        return result;
    }

    public static String message(int mnr) {
        switch (mnr) {
            case 101: {
                return "EA error encountered while updating 'Type' of EA parameter '$1$'. Error message is: $2$";
            }
        }
        return "(" + EAMethodUtil.class.getName() + ") Unknown message with number: " + mnr;
    }
}

