/*
 * Decompiled with CFR 0.152.
 */
package de.interactive_instruments.ShapeChange.Util.ea;

import de.interactive_instruments.ShapeChange.Util.ea.AbstractEAUtil;
import de.interactive_instruments.ShapeChange.Util.ea.EAElementUtil;
import de.interactive_instruments.ShapeChange.Util.ea.EAException;
import de.interactive_instruments.ShapeChange.Util.ea.EATaggedValue;
import java.util.Set;
import java.util.SortedMap;
import org.sparx.Collection;
import org.sparx.Element;
import org.sparx.Package;

public class EAPackageUtil
extends AbstractEAUtil {
    public static void setTaggedValue(Package pkg, String name, String value) throws EAException {
        Element e = pkg.GetElement();
        EATaggedValue tv = new EATaggedValue(name, value);
        EAElementUtil.deleteTaggedValue(e, tv.getName());
        EAElementUtil.addTaggedValue(e, tv);
    }

    public static Package addPackage(Package owner, String newPackageName, String newPackageType) throws EAException {
        Package pkg = (Package)owner.GetPackages().AddNew(newPackageName, newPackageType);
        if (!pkg.Update()) {
            throw new EAException(EAPackageUtil.createMessage(EAPackageUtil.message(101), newPackageName, owner.GetName(), pkg.GetLastError()));
        }
        return pkg;
    }

    public static Package findPackage(Package pkgIn, String name) {
        if (pkgIn.GetName().equals(name)) {
            return pkgIn;
        }
        Collection pkgs = pkgIn.GetPackages();
        for (short i = 0; i < pkgs.GetCount(); i = (short)(i + 1)) {
            Package resPkg = EAPackageUtil.findPackage((Package)pkgs.GetAt(i), name);
            if (resPkg == null) continue;
            return resPkg;
        }
        return null;
    }

    public static void lookUpElements(Package pkg, Set<String> elementTypes, SortedMap<String, Integer> resultMap) {
        Collection elmts = pkg.GetElements();
        for (short i = 0; i < elmts.GetCount(); i = (short)(i + 1)) {
            Element elmt = (Element)elmts.GetAt(i);
            if (!elementTypes.contains(elmt.GetType())) continue;
            resultMap.put(elmt.GetName(), elmt.GetElementID());
        }
        Collection pkgs = pkg.GetPackages();
        for (short i = 0; i < pkgs.GetCount(); i = (short)(i + 1)) {
            EAPackageUtil.lookUpElements((Package)pkgs.GetAt(i), elementTypes, resultMap);
        }
    }

    public static void deleteElement(Package pkg, int elementId) {
        Collection elmts = pkg.GetElements();
        for (short i = 0; i < elmts.GetCount(); i = (short)(i + 1)) {
            Element e = (Element)elmts.GetAt(i);
            if (e.GetElementID() != elementId) continue;
            elmts.Delete(i);
            break;
        }
        elmts.Refresh();
    }

    public static String message(int mnr) {
        switch (mnr) {
            case 101: {
                return "EA error encountered while adding child package '$1$' to EA package '$2$'. Error message is: $3$";
            }
        }
        return "(" + EAPackageUtil.class.getName() + ") Unknown message with number: " + mnr;
    }
}

