/*
 * Decompiled with CFR 0.152.
 */
package de.interactive_instruments.ShapeChange.Util.ea;

import com.google.common.base.Joiner;
import com.google.common.collect.ListMultimap;
import com.google.common.collect.MultimapBuilder;
import de.interactive_instruments.ShapeChange.Util.ea.EAAttributeUtil;
import de.interactive_instruments.ShapeChange.Util.ea.EAConnectorEndUtil;
import de.interactive_instruments.ShapeChange.Util.ea.EAConnectorUtil;
import de.interactive_instruments.ShapeChange.Util.ea.EAElementUtil;
import de.interactive_instruments.ShapeChange.Util.ea.EAException;
import de.interactive_instruments.ShapeChange.Util.ea.EAMethodUtil;
import de.interactive_instruments.ShapeChange.Util.ea.EAParameterUtil;
import de.interactive_instruments.ShapeChange.Util.ea.EARepositoryUtil;
import de.interactive_instruments.ShapeChange.Util.ea.EATaggedValue;
import java.io.File;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedMap;
import java.util.StringJoiner;
import org.apache.commons.lang3.StringUtils;
import org.sparx.Attribute;
import org.sparx.AttributeConstraint;
import org.sparx.Collection;
import org.sparx.Connector;
import org.sparx.ConnectorConstraint;
import org.sparx.ConnectorEnd;
import org.sparx.Constraint;
import org.sparx.Element;
import org.sparx.Method;
import org.sparx.ObjectType;
import org.sparx.Package;
import org.sparx.Parameter;
import org.sparx.Repository;

public class EAModelDiff {
    private StringJoiner sj = new StringJoiner("\n");
    private Repository rep = null;
    private Repository refRep = null;
    private Set<String> allowedElementTypes = new HashSet<String>();
    private Set<String> allowedConnectorTypes = new HashSet<String>();
    private Set<Integer> idsOfCheckedConnectors = new HashSet<Integer>();
    private Set<Integer> refIdsOfCheckedConnectors = new HashSet<Integer>();
    private Map<Integer, EAPackageInfo> pkgInfosByID = new HashMap<Integer, EAPackageInfo>();
    private Map<Integer, EAPackageInfo> refPkgInfosByID = new HashMap<Integer, EAPackageInfo>();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean similar(File file, File refFile) {
        this.sj = new StringJoiner("\n");
        this.idsOfCheckedConnectors = new HashSet<Integer>();
        this.refIdsOfCheckedConnectors = new HashSet<Integer>();
        this.allowedElementTypes.add("Class");
        this.allowedElementTypes.add("Interface");
        this.allowedElementTypes.add("Package");
        this.allowedConnectorTypes.add("Aggregation");
        this.allowedConnectorTypes.add("Association");
        this.allowedConnectorTypes.add("Generalization");
        this.allowedConnectorTypes.add("Generalisation");
        this.allowedConnectorTypes.add("Realization");
        this.allowedConnectorTypes.add("Realisation");
        try {
            this.rep = EARepositoryUtil.openRepository(file, true);
            this.rep.SetEnableCache(true);
            this.rep.SetEnableUIUpdates(false);
        }
        catch (EAException e) {
            this.sj.add("Could not open .eap file " + file.getAbsolutePath());
            EARepositoryUtil.closeRepository(this.rep);
            this.rep = null;
            return false;
        }
        try {
            this.refRep = EARepositoryUtil.openRepository(refFile, true);
            this.refRep.SetEnableCache(true);
            this.refRep.SetEnableUIUpdates(false);
        }
        catch (EAException e) {
            this.sj.add("Could not open reference .eap file " + refFile.getAbsolutePath());
            EARepositoryUtil.closeRepository(this.rep);
            this.rep = null;
            EARepositoryUtil.closeRepository(this.refRep);
            this.refRep = null;
            return false;
        }
        try {
            boolean e = this.diffPackages(null, (Collection<Package>)this.rep.GetModels(), (Collection<Package>)this.refRep.GetModels());
            return e;
        }
        catch (Exception e) {
            this.sj.add("Exception while comparing EAP '" + file + "' to reference '" + refFile + "'. Exception message is: " + e.getMessage());
            e.printStackTrace();
            boolean bl = false;
            return bl;
        }
        finally {
            EARepositoryUtil.closeRepository(this.rep);
            this.rep = null;
            EARepositoryUtil.closeRepository(this.refRep);
            this.refRep = null;
        }
    }

    private boolean diffPackages(EAPackageInfo parentPkg, Collection<Package> eaPkgs, Collection<Package> refEaPkgs) {
        ListMultimap<String, EAPackageInfo> pkgsByName = this.parseEAPackages(eaPkgs, this.pkgInfosByID);
        ListMultimap<String, EAPackageInfo> refPkgsByName = this.parseEAPackages(refEaPkgs, this.refPkgInfosByID);
        if (pkgsByName.size() > refPkgsByName.size()) {
            this.sj.add((String)(parentPkg == null ? "" : "Package " + parentPkg.getModelPath() + " - ") + "Reference model has less child packages.");
            return false;
        }
        if (pkgsByName.size() < refPkgsByName.size()) {
            this.sj.add((String)(parentPkg == null ? "" : "Package " + parentPkg.getModelPath() + " - ") + "Reference model has more child packages.");
            return false;
        }
        boolean result = true;
        for (String refPkgName : refPkgsByName.keySet()) {
            List refPkgsForName = refPkgsByName.get((Object)refPkgName);
            List pkgsForName = pkgsByName.removeAll((Object)refPkgName);
            if (pkgsForName.size() > refPkgsForName.size()) {
                System.out.println((String)(parentPkg == null ? "Model" : "Package " + parentPkg.getModelPath()) + " - Reference has less child packages with name '" + refPkgName + "'.");
                result = false;
                continue;
            }
            if (pkgsForName.size() < refPkgsForName.size()) {
                System.out.println((String)(parentPkg == null ? "Model" : "Package " + parentPkg.getModelPath()) + " - Reference has more child packages with name '" + refPkgName + "'.");
                result = false;
                continue;
            }
            for (int i = 0; i < refPkgsForName.size(); ++i) {
                EAPackageInfo refPkg = (EAPackageInfo)refPkgsForName.get(i);
                EAPackageInfo pkg = (EAPackageInfo)pkgsForName.get(i);
                result &= this.diffPackage(pkg, refPkg);
            }
        }
        for (EAPackageInfo pkg : pkgsByName.values()) {
            this.sj.add((String)(parentPkg == null ? "Model" : "Package " + parentPkg.getModelPath()) + " - Found unexpected package with name '" + pkg.getName() + "'.");
            result = false;
        }
        return result;
    }

    private boolean diffPackage(EAPackageInfo pkgInfo, EAPackageInfo refPkgInfo) {
        boolean result = true;
        Package pkg = this.rep.GetPackageByID(pkgInfo.getId().intValue());
        Package refPkg = this.refRep.GetPackageByID(refPkgInfo.getId().intValue());
        if (pkgInfo.getElement() != null && refPkgInfo.getElement() != null) {
            result &= this.diffElement(pkgInfo.getElement(), refPkgInfo.getElement());
        }
        result &= this.diffElements(pkgInfo, (Collection<Element>)pkg.GetElements(), (Collection<Element>)refPkg.GetElements());
        return result &= this.diffPackages(pkgInfo, (Collection<Package>)pkg.GetPackages(), (Collection<Package>)refPkg.GetPackages());
    }

    private boolean diffElements(EAPackageInfo pkg, Collection<Element> eaElmts, Collection<Element> refEaElmts) {
        ListMultimap<String, EAModelElementInfo> elmtsByName = this.parseEAElements(pkg.getModelPath(), eaElmts);
        ListMultimap<String, EAModelElementInfo> refElmtsByName = this.parseEAElements(pkg.getModelPath(), refEaElmts);
        if (elmtsByName.size() > refElmtsByName.size()) {
            this.sj.add("Package " + pkg.getModelPath() + " - Reference package has less elements.");
            return false;
        }
        if (elmtsByName.size() < refElmtsByName.size()) {
            this.sj.add("Package " + pkg.getModelPath() + " - Reference package has more elements.");
            return false;
        }
        boolean result = true;
        for (String refElmtName : refElmtsByName.keySet()) {
            List refElmtsForName = refElmtsByName.get((Object)refElmtName);
            List elmtsForName = elmtsByName.removeAll((Object)refElmtName);
            if (elmtsForName.size() > refElmtsForName.size()) {
                this.sj.add("Package " + pkg.getModelPath() + " - Reference package has less elements with name '" + refElmtName + "'.");
                result = false;
                continue;
            }
            if (elmtsForName.size() < refElmtsForName.size()) {
                this.sj.add("Package " + pkg.getModelPath() + " - Reference package has more elements with name '" + refElmtName + "'.");
                result = false;
                continue;
            }
            for (int i = 0; i < refElmtsForName.size(); ++i) {
                EAModelElementInfo refElmt = (EAModelElementInfo)refElmtsForName.get(i);
                EAModelElementInfo elmt = (EAModelElementInfo)elmtsForName.get(i);
                result &= this.diffElement(elmt, refElmt);
            }
        }
        for (EAModelElementInfo elmt : elmtsByName.values()) {
            this.sj.add("Package " + pkg.getModelPath() + " - Found unexpected element with name '" + elmt.getName() + "'.");
            result = false;
        }
        return result;
    }

    private boolean diffConnectors(EAModelElementInfo elmt, Collection<Connector> eaConns, Collection<Connector> refEaConns) {
        ListMultimap<String, EAConnectorInfo> connsByKey = this.parseEAConnectors(elmt.getModelPath(), eaConns, this.rep);
        ListMultimap<String, EAConnectorInfo> refConnsByKey = this.parseEAConnectors(elmt.getModelPath(), refEaConns, this.refRep);
        if (connsByKey.size() > refConnsByKey.size()) {
            this.sj.add("Element " + elmt.getModelPath() + " - Reference has less connectors.");
            return false;
        }
        if (connsByKey.size() < refConnsByKey.size()) {
            this.sj.add("Element " + elmt.getModelPath() + " - Reference has more connectors.");
            return false;
        }
        boolean result = true;
        for (String refConnKey : refConnsByKey.keySet()) {
            List refConnsForKey = refConnsByKey.get((Object)refConnKey);
            List connsForKey = connsByKey.removeAll((Object)refConnKey);
            if (connsForKey.size() > refConnsForKey.size()) {
                this.sj.add("Element " + elmt.getModelPath() + " - Reference has less connectors with key: " + refConnKey);
                result = false;
                continue;
            }
            if (connsForKey.size() < refConnsForKey.size()) {
                this.sj.add("Element " + elmt.getModelPath() + " - Reference has more connectors with key: " + refConnKey);
                result = false;
                continue;
            }
            for (int i = 0; i < refConnsForKey.size(); ++i) {
                EAConnectorInfo refConn = (EAConnectorInfo)refConnsForKey.get(i);
                EAConnectorInfo conn = (EAConnectorInfo)connsForKey.get(i);
                result &= this.diffConnector(elmt.getModelPath(), this.rep.GetConnectorByID(conn.getId().intValue()), this.refRep.GetConnectorByID(refConn.getId().intValue()));
            }
        }
        for (EAConnectorInfo conn : connsByKey.values()) {
            this.sj.add("Element " + elmt.getModelPath() + " - Found unexpected connector with key: " + conn.getKey());
            result = false;
        }
        return result;
    }

    private boolean diffMethods(EAModelElementInfo elmt, Collection<Method> eaMethods, Collection<Method> refEaMethods) {
        ListMultimap<String, EAModelElementInfo> methodsByName = this.parseEAMethods(elmt.getModelPath(), eaMethods);
        ListMultimap<String, EAModelElementInfo> refMethodsByName = this.parseEAMethods(elmt.getModelPath(), refEaMethods);
        if (methodsByName.size() > refMethodsByName.size()) {
            this.sj.add("Element " + elmt.getModelPath() + " - Reference has less methods.");
            return false;
        }
        if (methodsByName.size() < refMethodsByName.size()) {
            this.sj.add("Element " + elmt.getModelPath() + " - Reference has more methods.");
            return false;
        }
        boolean result = true;
        for (String refMethodName : refMethodsByName.keySet()) {
            List refMethodsForName = refMethodsByName.get((Object)refMethodName);
            List methodsForName = methodsByName.removeAll((Object)refMethodName);
            if (methodsForName.size() > refMethodsForName.size()) {
                this.sj.add("Element " + elmt.getModelPath() + " - Reference has less methods with name '" + refMethodName + "'.");
                result = false;
                continue;
            }
            if (methodsForName.size() < refMethodsForName.size()) {
                this.sj.add("Element " + elmt.getModelPath() + " - Reference has more methods with name '" + refMethodName + "'.");
                result = false;
                continue;
            }
            for (int i = 0; i < refMethodsForName.size(); ++i) {
                EAModelElementInfo refMethod = (EAModelElementInfo)refMethodsForName.get(i);
                EAModelElementInfo method = (EAModelElementInfo)methodsForName.get(i);
                result &= this.diffMethod(method, refMethod);
            }
        }
        for (EAModelElementInfo method : methodsByName.values()) {
            this.sj.add("Element " + elmt.getModelPath() + " - Found unexpected method with name '" + method.getName() + "'.");
            result = false;
        }
        return result;
    }

    private boolean diffMethod(EAModelElementInfo method, EAModelElementInfo refMethod) {
        Method meth = this.rep.GetMethodByID(method.getId().intValue());
        Method refMeth = this.refRep.GetMethodByID(refMethod.getId().intValue());
        boolean result = true;
        result &= this.similar(method.getModelPath(), "Abstract", meth.GetAbstract(), refMeth.GetAbstract());
        result &= this.similar(method.getModelPath(), "Code", meth.GetCode(), refMeth.GetCode());
        result &= this.similar(method.getModelPath(), "Concurrency", meth.GetConcurrency(), refMeth.GetConcurrency());
        result &= this.similarIgnoreCase(method.getModelPath(), "FQStereotype", meth.GetFQStereotype(), refMeth.GetFQStereotype());
        result &= this.similar(method.getModelPath(), "IsConst", meth.GetIsConst(), refMeth.GetIsConst());
        result &= this.similar(method.getModelPath(), "IsLeaf", meth.GetIsLeaf(), refMeth.GetIsLeaf());
        result &= this.similar(method.getModelPath(), "IsPure", meth.GetIsPure(), refMeth.GetIsPure());
        result &= this.similar(method.getModelPath(), "IsQuery", meth.GetIsQuery(), refMeth.GetIsQuery());
        result &= this.similar(method.getModelPath(), "IsRoot", meth.GetIsRoot(), refMeth.GetIsRoot());
        result &= this.similar(method.getModelPath(), "IsStatic", meth.GetIsStatic(), refMeth.GetIsStatic());
        result &= this.similar(method.getModelPath(), "IsSynchronized", meth.GetIsSynchronized(), refMeth.GetIsSynchronized());
        result &= this.similar(method.getModelPath(), "Notes", meth.GetNotes(), refMeth.GetNotes());
        result &= this.similar(method.getModelPath(), "ObjectType", meth.GetObjectType(), refMeth.GetObjectType());
        result &= this.diffParameters(method.getModelPath(), (Collection<Parameter>)meth.GetParameters(), (Collection<Parameter>)refMeth.GetParameters());
        result &= this.similar(method.getModelPath(), "ReturnIsArray", meth.GetReturnIsArray(), refMeth.GetReturnIsArray());
        result &= this.similar(method.getModelPath(), "ReturnType", meth.GetReturnType(), refMeth.GetReturnType());
        result &= this.similarIgnoreCase(method.getModelPath(), "StereotypeEx", meth.GetStereotypeEx(), refMeth.GetStereotypeEx());
        result &= this.similar(method.getModelPath(), "Style", meth.GetStyle(), refMeth.GetStyle());
        result &= this.similar(method.getModelPath(), "StyleEx", meth.GetStyleEx(), refMeth.GetStyleEx());
        result &= this.similar(method.getModelPath(), EAMethodUtil.getEATaggedValues(meth), EAMethodUtil.getEATaggedValues(refMeth));
        result &= this.similar(method.getModelPath(), "Throws", meth.GetThrows(), refMeth.GetThrows());
        return result &= this.similar(method.getModelPath(), "Visibility", meth.GetVisibility(), refMeth.GetVisibility());
    }

    private boolean diffParameters(String modelPath, Collection<Parameter> eaParams, Collection<Parameter> refEaParams) {
        short countRefParams;
        short countParams = eaParams.GetCount();
        if (countParams > (countRefParams = refEaParams.GetCount())) {
            this.sj.add("Method " + modelPath + " - Reference has less parameters.");
            return false;
        }
        if (countParams < countRefParams) {
            this.sj.add("Method " + modelPath + " - Reference has more parameters.");
            return false;
        }
        boolean result = true;
        for (short i = 0; i < countRefParams; i = (short)(i + 1)) {
            Parameter refParam = (Parameter)refEaParams.GetAt(i);
            Parameter param = (Parameter)eaParams.GetAt(i);
            result &= this.diffParameter(modelPath + ", parameter [" + (i + 1) + "]", param, refParam);
        }
        return result;
    }

    private boolean diffAttributes(String elmtModelPath, Collection<Attribute> eaAtts, Collection<Attribute> refEaAtts) {
        ListMultimap<String, EAModelElementInfo> attsByName = this.parseEAAttributes(elmtModelPath, eaAtts);
        ListMultimap<String, EAModelElementInfo> refAttsByName = this.parseEAAttributes(elmtModelPath, refEaAtts);
        if (attsByName.size() > refAttsByName.size()) {
            this.sj.add("Element " + elmtModelPath + " - Reference element has less attributes.");
            return false;
        }
        if (attsByName.size() < refAttsByName.size()) {
            this.sj.add("Element" + elmtModelPath + " - Reference element has more attributes.");
            return false;
        }
        boolean result = true;
        for (String refAttName : refAttsByName.keySet()) {
            List refAttsForName = refAttsByName.get((Object)refAttName);
            List attsForName = attsByName.removeAll((Object)refAttName);
            if (attsForName.size() > refAttsForName.size()) {
                this.sj.add("Element " + elmtModelPath + " - Reference element has less attributes with name '" + refAttName + "'.");
                result = false;
                continue;
            }
            if (attsForName.size() < refAttsForName.size()) {
                this.sj.add("Element " + elmtModelPath + " - Reference element has more attributes with name '" + refAttName + "'.");
                result = false;
                continue;
            }
            for (int i = 0; i < refAttsForName.size(); ++i) {
                EAModelElementInfo refAtt = (EAModelElementInfo)refAttsForName.get(i);
                EAModelElementInfo att = (EAModelElementInfo)attsForName.get(i);
                result &= this.diffAttribute(att, refAtt);
            }
        }
        for (EAModelElementInfo att : attsByName.values()) {
            this.sj.add("Element " + elmtModelPath + " - Found unexpected attribute with name '" + att.getName() + "'.");
            result = false;
        }
        return result;
    }

    private ListMultimap<String, EAModelElementInfo> parseEAElements(String pkgModelPath, Collection<Element> elmts) {
        ListMultimap result = MultimapBuilder.treeKeys().arrayListValues().build();
        for (short i = 0; i < elmts.GetCount(); i = (short)(i + 1)) {
            Element elmt = (Element)elmts.GetAt(i);
            String elmtType = elmt.GetType();
            if (this.ignoreElementType(elmtType)) continue;
            int id = elmt.GetElementID();
            String name = elmt.GetName();
            String path = pkgModelPath + "::" + name;
            if (result.containsKey((Object)name)) {
                int index = result.get((Object)name).size() + 1;
                path = path + "[" + index + "]";
            }
            EAModelElementInfo elmtInfo = new EAModelElementInfo(name, id, path);
            result.put((Object)name, (Object)elmtInfo);
        }
        return result;
    }

    private ListMultimap<String, EAConnectorInfo> parseEAConnectors(String elmtModelPath, Collection<Connector> conns, Repository repOfConns) {
        ListMultimap result = MultimapBuilder.treeKeys().arrayListValues().build();
        for (short i = 0; i < conns.GetCount(); i = (short)(i + 1)) {
            Connector conn = (Connector)conns.GetAt(i);
            String connType = conn.GetType();
            if (this.ignoreConnectorType(connType)) continue;
            int id = conn.GetConnectorID();
            String name = conn.GetName();
            String key = this.getKey(conn, conn.GetClientEnd(), conn.GetSupplierEnd(), repOfConns);
            String path = elmtModelPath + ", connector" + key;
            if (result.containsKey((Object)name)) {
                int index = result.get((Object)name).size() + 1;
                path = path + "[" + index + "]";
            }
            EAConnectorInfo elmtInfo = new EAConnectorInfo(name, id, path, key);
            result.put((Object)key, (Object)elmtInfo);
        }
        return result;
    }

    private ListMultimap<String, EAModelElementInfo> parseEAMethods(String elmtModelPath, Collection<Method> methods) {
        ListMultimap result = MultimapBuilder.treeKeys().arrayListValues().build();
        for (short i = 0; i < methods.GetCount(); i = (short)(i + 1)) {
            Method method = (Method)methods.GetAt(i);
            int id = method.GetMethodID();
            String name = method.GetName();
            String path = elmtModelPath + ", method " + name;
            if (result.containsKey((Object)name)) {
                int index = result.get((Object)name).size() + 1;
                path = path + "[" + index + "]";
            }
            EAModelElementInfo elmtInfo = new EAModelElementInfo(name, id, path);
            result.put((Object)name, (Object)elmtInfo);
        }
        return result;
    }

    private ListMultimap<String, EAModelElementInfo> parseEAAttributes(String elmtModelPath, Collection<Attribute> atts) {
        ListMultimap result = MultimapBuilder.treeKeys().arrayListValues().build();
        for (short i = 0; i < atts.GetCount(); i = (short)(i + 1)) {
            Attribute att = (Attribute)atts.GetAt(i);
            int id = att.GetAttributeID();
            String name = att.GetName();
            String path = elmtModelPath + "." + name;
            if (result.containsKey((Object)name)) {
                int index = result.get((Object)name).size() + 1;
                path = path + "[" + index + "]";
            }
            EAModelElementInfo attInfo = new EAModelElementInfo(name, id, path);
            result.put((Object)name, (Object)attInfo);
        }
        return result;
    }

    private boolean diffElement(EAModelElementInfo elmtInfo, EAModelElementInfo refElmtInfo) {
        Element elmt = this.rep.GetElementByID(elmtInfo.getId().intValue());
        Element refElmt = this.refRep.GetElementByID(refElmtInfo.getId().intValue());
        String elmtType = elmt.GetType();
        String refElmtType = refElmt.GetType();
        if (this.ignoreElementType(elmtType)) {
            this.sj.add(elmtInfo.getModelPath() + " - Ignored because its type is " + elmtType);
            return true;
        }
        boolean result = true;
        result &= this.similar(elmtInfo.getModelPath(), "Abstract", elmt.GetAbstract(), refElmt.GetAbstract());
        result &= this.similar(elmtInfo.getModelPath(), "Alias", elmt.GetAlias(), refElmt.GetAlias());
        result &= this.similar(elmtInfo.getModelPath(), "IsAssociationClass", elmt.IsAssociationClass(), refElmt.IsAssociationClass());
        if (elmt.IsAssociationClass() && refElmt.IsAssociationClass()) {
            result &= this.diffConnector(elmtInfo.getModelPath(), this.rep.GetConnectorByID(elmt.GetAssociationClassConnectorID()), this.refRep.GetConnectorByID(refElmt.GetAssociationClassConnectorID()));
        }
        result &= this.similar(elmtInfo.getModelPath(), "Author", elmt.GetAuthor(), refElmt.GetAuthor());
        ListMultimap<String, EAConstraintInfo> consByName = this.parseEAConstraints((Collection<Constraint>)elmt.GetConstraints());
        ListMultimap<String, EAConstraintInfo> refConsByName = this.parseEAConstraints((Collection<Constraint>)refElmt.GetConstraints());
        result &= this.diffConstraints(elmtInfo.getModelPath(), consByName, refConsByName);
        result &= this.similar(elmtInfo.getModelPath(), "FQName", elmt.GetFQName(), refElmt.GetFQName());
        result &= this.similarIgnoreCase(elmtInfo.getModelPath(), "FQStereotype", elmt.GetFQStereotype(), refElmt.GetFQStereotype());
        result &= this.similar(elmtInfo.getModelPath(), "GenType", elmt.GetGentype(), refElmt.GetGentype());
        result &= this.similar(elmtInfo.getModelPath(), "IsActive", elmt.GetIsActive(), refElmt.GetIsActive());
        result &= this.similar(elmtInfo.getModelPath(), "IsComposite", elmt.GetIsComposite(), refElmt.GetIsComposite());
        result &= this.similar(elmtInfo.getModelPath(), "IsLeaf", elmt.GetIsLeaf(), refElmt.GetIsLeaf());
        result &= this.similar(elmtInfo.getModelPath(), "IsNew", elmt.GetIsNew(), refElmt.GetIsNew());
        result &= this.similar(elmtInfo.getModelPath(), "IsRoot", elmt.GetIsRoot(), refElmt.GetIsRoot());
        result &= this.similar(elmtInfo.getModelPath(), "IsSpec", elmt.GetIsSpec(), refElmt.GetIsSpec());
        result &= this.similar(elmtInfo.getModelPath(), "LinkedDocument", elmt.GetLinkedDocument(), refElmt.GetLinkedDocument());
        result &= this.diffMethods(elmtInfo, (Collection<Method>)elmt.GetMethods(), (Collection<Method>)refElmt.GetMethods());
        result &= this.similar(elmtInfo.getModelPath(), "Multiplicity", elmt.GetMultiplicity(), refElmt.GetMultiplicity());
        result &= this.similar(elmtInfo.getModelPath(), "Notes", elmt.GetNotes(), refElmt.GetNotes());
        result &= this.similar(elmtInfo.getModelPath(), "ObjectType", elmt.GetObjectType(), refElmt.GetObjectType());
        result &= this.similar(elmtInfo.getModelPath(), "Status", elmt.GetStatus(), refElmt.GetStatus());
        result &= this.similarIgnoreCase(elmtInfo.getModelPath(), "StereotypeEx", elmt.GetStereotypeEx(), refElmt.GetStereotypeEx());
        result &= this.similar(elmtInfo.getModelPath(), "StyleEx", elmt.GetStyleEx(), refElmt.GetStyleEx());
        result &= this.similar(elmtInfo.getModelPath(), "Tablespace", elmt.GetTablespace(), refElmt.GetTablespace());
        result &= this.similar(elmtInfo.getModelPath(), "Tag", elmt.GetTag(), refElmt.GetTag());
        result &= this.similar(elmtInfo.getModelPath(), EAElementUtil.getEATaggedValues(elmt), EAElementUtil.getEATaggedValues(refElmt));
        result &= this.similar(elmtInfo.getModelPath(), "Type", elmtType, refElmtType);
        result &= this.similar(elmtInfo.getModelPath(), "Visibility", elmt.GetVisibility(), refElmt.GetVisibility());
        result &= this.diffAttributes(elmtInfo.getModelPath(), (Collection<Attribute>)elmt.GetAttributes(), (Collection<Attribute>)refElmt.GetAttributes());
        return result &= this.diffConnectors(elmtInfo, (Collection<Connector>)elmt.GetConnectors(), (Collection<Connector>)refElmt.GetConnectors());
    }

    private boolean diffAttribute(EAModelElementInfo attInfo, EAModelElementInfo refAttInfo) {
        Attribute att = this.rep.GetAttributeByID(attInfo.getId().intValue());
        Attribute refAtt = this.refRep.GetAttributeByID(refAttInfo.getId().intValue());
        boolean result = true;
        result &= this.similar(attInfo.getModelPath(), "Alias", att.GetAlias(), refAtt.GetAlias());
        result &= this.similar(attInfo.getModelPath(), "AllowDuplicates (DB: Not Null)", att.GetAllowDuplicates(), refAtt.GetAllowDuplicates());
        result &= this.similarReferencedElementName(attInfo.getModelPath(), "ClassifierID", att.GetClassifierID(), refAtt.GetClassifierID());
        result &= this.similar(attInfo.getModelPath(), "Container", att.GetContainer(), refAtt.GetContainer());
        result &= this.similar(attInfo.getModelPath(), "Containment", att.GetContainment(), refAtt.GetContainment());
        ListMultimap<String, EAConstraintInfo> consByName = this.parseEAAttributeConstraints((Collection<AttributeConstraint>)att.GetConstraints());
        ListMultimap<String, EAConstraintInfo> refConsByName = this.parseEAAttributeConstraints((Collection<AttributeConstraint>)refAtt.GetConstraints());
        result &= this.diffConstraints(attInfo.getModelPath(), consByName, refConsByName);
        result &= this.similar(attInfo.getModelPath(), "Default", att.GetDefault(), refAtt.GetDefault());
        result &= this.similarIgnoreCase(attInfo.getModelPath(), "FQStereotype", att.GetFQStereotype(), refAtt.GetFQStereotype());
        result &= this.similar(attInfo.getModelPath(), "IsCollection (DB: is foreign key)", att.GetIsCollection(), refAtt.GetIsCollection());
        result &= this.similar(attInfo.getModelPath(), "IsConst", att.GetIsConst(), refAtt.GetIsConst());
        result &= this.similar(attInfo.getModelPath(), "IsDerived", att.GetIsDerived(), refAtt.GetIsDerived());
        result &= this.similar(attInfo.getModelPath(), "IsID", att.GetIsID(), refAtt.GetIsID());
        result &= this.similar(attInfo.getModelPath(), "IsOrdered (DB: is primary key)", att.GetIsOrdered(), refAtt.GetIsOrdered());
        result &= this.similar(attInfo.getModelPath(), "IsStatic (DB: is unique)", att.GetIsStatic(), refAtt.GetIsStatic());
        result &= this.similar(attInfo.getModelPath(), "Length", att.GetLength(), refAtt.GetLength());
        result &= this.similar(attInfo.getModelPath(), "LowerBound", att.GetLowerBound(), refAtt.GetLowerBound());
        result &= this.similar(attInfo.getModelPath(), "Notes", att.GetNotes(), refAtt.GetNotes());
        result &= this.similar(attInfo.getModelPath(), "ObjectType", att.GetObjectType(), refAtt.GetObjectType());
        result &= this.similar(attInfo.getModelPath(), "Precision", att.GetPrecision(), refAtt.GetPrecision());
        result &= this.similar(attInfo.getModelPath(), "Scale", att.GetScale(), refAtt.GetScale());
        result &= this.similarIgnoreCase(attInfo.getModelPath(), "StereotypeEx", att.GetStereotypeEx(), refAtt.GetStereotypeEx());
        result &= this.similar(attInfo.getModelPath(), "Style", att.GetStyle(), refAtt.GetStyle());
        result &= this.similar(attInfo.getModelPath(), "StyleEx", att.GetStyleEx(), refAtt.GetStyleEx());
        result &= this.similar(attInfo.getModelPath(), EAAttributeUtil.getEATaggedValuesWithCombinedKeys(att), EAAttributeUtil.getEATaggedValuesWithCombinedKeys(refAtt));
        result &= this.similar(attInfo.getModelPath(), "Type", att.GetType(), refAtt.GetType());
        result &= this.similar(attInfo.getModelPath(), "UpperBound", att.GetUpperBound(), refAtt.GetUpperBound());
        return result &= this.similar(attInfo.getModelPath(), "Visibility", att.GetVisibility(), refAtt.GetVisibility());
    }

    private boolean diffParameter(String modelPath, Parameter param, Parameter refParam) {
        boolean result = true;
        result &= this.similar(modelPath, "Alias", param.GetAlias(), refParam.GetAlias());
        result &= this.similar(modelPath, "Default", param.GetDefault(), refParam.GetDefault());
        result &= this.similar(modelPath, "IsConst", param.GetIsConst(), refParam.GetIsConst());
        result &= this.similar(modelPath, "Kind", param.GetKind(), refParam.GetKind());
        result &= this.similar(modelPath, "Name", param.GetName(), refParam.GetName());
        result &= this.similar(modelPath, "Notes", param.GetNotes(), refParam.GetNotes());
        result &= this.similar(modelPath, "ObjectType", param.GetObjectType(), refParam.GetObjectType());
        result &= this.similarIgnoreCase(modelPath, "StereotypeEx", param.GetStereotypeEx(), refParam.GetStereotypeEx());
        result &= this.similar(modelPath, "Style", param.GetStyle(), refParam.GetStyle());
        result &= this.similar(modelPath, "StyleEx", param.GetStyleEx(), refParam.GetStyleEx());
        result &= this.similar(modelPath, "Type", param.GetType(), refParam.GetType());
        return result &= this.similar(modelPath, EAParameterUtil.getEATaggedValues(param), EAParameterUtil.getEATaggedValues(refParam));
    }

    private boolean similar(String modelPath, SortedMap<String, EATaggedValue> tvs, SortedMap<String, EATaggedValue> refTvs) {
        if (tvs.size() > refTvs.size()) {
            this.sj.add(modelPath + " - Reference has less tagged values.");
            return false;
        }
        if (tvs.size() < refTvs.size()) {
            this.sj.add(modelPath + " - Reference has more tagged values.");
            return false;
        }
        boolean result = true;
        for (String refTvKey : refTvs.keySet()) {
            String refTvValuesString;
            EATaggedValue refTv = (EATaggedValue)refTvs.get(refTvKey);
            EATaggedValue tv = (EATaggedValue)tvs.remove(refTvKey);
            String refTVModelPath = modelPath + ", tagged value '" + refTv.getName() + "' (FQName '" + refTv.getFQName() + "')";
            if (tv == null) {
                this.sj.add(modelPath + " - Missing tagged value with name '" + refTv.getName() + "', FQName '" + refTv.getFQName() + "' and values: " + StringUtils.join(refTv.getValues(), (String)", ") + ".");
                result = false;
                continue;
            }
            if (tv.getValues().size() > refTv.getValues().size()) {
                this.sj.add(refTVModelPath + " - Reference has less values.");
                result = false;
                continue;
            }
            if (tv.getValues().size() < refTv.getValues().size()) {
                this.sj.add(refTVModelPath + " - Reference has more values.");
                result = false;
                continue;
            }
            List<String> tvValues = tv.getValues();
            Collections.sort(tvValues);
            List<String> refTvValues = refTv.getValues();
            Collections.sort(refTvValues);
            if (tv.getName().equalsIgnoreCase("OIDFieldName") || tv.getName().equalsIgnoreCase("LengthFieldName") || tv.getName().equalsIgnoreCase("ShapeFieldName") || tv.getName().equalsIgnoreCase("DestinationForeignKey") || tv.getName().equalsIgnoreCase("DestinationPrimaryKey") || tv.getName().equalsIgnoreCase("OriginForeignKey") || tv.getName().equalsIgnoreCase("OriginPrimaryKey") || tv.getName().equalsIgnoreCase("AreaFieldName") || StringUtils.isNotBlank((CharSequence)tv.getFQName()) && tv.getFQName().equalsIgnoreCase("ArcGIS::AttributeIndex::Fields")) {
                result &= this.similarAttributesReferencedByTaggedValue(tv.getName(), refTVModelPath, tvValues, refTvValues);
                continue;
            }
            String tvValuesString = Joiner.on((String)", ").skipNulls().join(tvValues);
            if (tvValuesString.equals(refTvValuesString = Joiner.on((String)", ").skipNulls().join(refTvValues))) continue;
            this.sj.add(refTVModelPath + " - Different values. EXPECTED '" + refTvValuesString + "' FOUND '" + tvValuesString + "'.");
            result = false;
        }
        for (EATaggedValue tv : tvs.values()) {
            this.sj.add(modelPath + " - Found unexpected tagged value '" + tv.getName() + "', FQName '" + tv.getFQName() + "' and values: " + StringUtils.join(tv.getValues(), (String)", ") + ".");
            result = false;
        }
        return result;
    }

    private boolean similarAttributesReferencedByTaggedValue(String tvName, String tvModelPath, List<String> tvValues, List<String> refTvValues) {
        boolean result = true;
        for (int i = 0; i < tvValues.size(); ++i) {
            String val = tvValues.get(i);
            String refVal = refTvValues.get(i);
            if (StringUtils.isBlank((CharSequence)val) && StringUtils.isBlank((CharSequence)refVal)) continue;
            if (StringUtils.isBlank((CharSequence)val) || StringUtils.isBlank((CharSequence)refVal)) {
                this.sj.add(tvModelPath + " - Different value for tag '" + tvName + "' at index '" + i + "'. EXPECTED '" + StringUtils.stripToEmpty((String)refVal) + "' FOUND '" + StringUtils.stripToEmpty((String)val) + "'.");
                result = false;
                continue;
            }
            Attribute att = this.rep.GetAttributeByGuid(val);
            Attribute refAtt = this.refRep.GetAttributeByGuid(refVal);
            Element elmt = this.rep.GetElementByID(att.GetParentID());
            Element refElmt = this.refRep.GetElementByID(refAtt.GetParentID());
            String refTvValueString = "attribute '" + refAtt.GetName() + "' of element '" + refElmt.GetName();
            String tvValueString = "attribute '" + att.GetName() + "' of element '" + elmt.GetName();
            if (tvValueString.equals(refTvValueString)) continue;
            this.sj.add(tvModelPath + " - Different referenced attribute for tag '" + tvName + "' (value at index '" + i + "'). EXPECTED '" + refTvValueString + "' FOUND '" + tvValueString + "'.");
            result = false;
        }
        return result;
    }

    private boolean similarReferencedElementName(String modelPath, String attributeToCompare, int elmtId, int refElmtId) {
        String refElmtName;
        if (elmtId <= 0 && refElmtId <= 0) {
            return true;
        }
        if (elmtId <= 0 && refElmtId > 0) {
            this.sj.add(modelPath + " - Reference has " + attributeToCompare + ", while compared model element has not.");
            return false;
        }
        if (elmtId > 0 && refElmtId <= 0) {
            this.sj.add(modelPath + " - Compared model element has " + attributeToCompare + ", while reference has not.");
            return false;
        }
        Element elmt = this.rep.GetElementByID(elmtId);
        Element refElmt = this.refRep.GetElementByID(refElmtId);
        String elmtName = elmt.GetName();
        if (!elmtName.equals(refElmtName = refElmt.GetName())) {
            this.sj.add(modelPath + " - Different " + attributeToCompare + ". EXPECTED element with name '" + refElmtName + "' FOUND element with name '" + elmtName + ".");
            return false;
        }
        return true;
    }

    private boolean diffConstraints(String elmtModelPath, ListMultimap<String, EAConstraintInfo> consByName, ListMultimap<String, EAConstraintInfo> refConsByName) {
        if (consByName.size() > refConsByName.size()) {
            this.sj.add("Element " + elmtModelPath + " - Reference element has less constraints.");
            return false;
        }
        if (consByName.size() < refConsByName.size()) {
            this.sj.add("Element " + elmtModelPath + " - Reference element has more constraints.");
            return false;
        }
        boolean result = true;
        for (String refConName : refConsByName.keySet()) {
            List refConsForName = refConsByName.get((Object)refConName);
            List consForName = consByName.removeAll((Object)refConName);
            if (consForName.size() > refConsForName.size()) {
                this.sj.add("Element " + elmtModelPath + " - Reference element has less constraints with name '" + refConName + "'.");
                result = false;
                continue;
            }
            if (consForName.size() < refConsForName.size()) {
                this.sj.add("Element " + elmtModelPath + " - Reference element has more constraints with name '" + refConName + "'.");
                result = false;
                continue;
            }
            for (int i = 0; i < refConsForName.size(); ++i) {
                String conModelPath = elmtModelPath + ", " + (i + 1) + ". constraint '" + refConName + "'";
                EAConstraintInfo refCon = (EAConstraintInfo)refConsForName.get(i);
                EAConstraintInfo con = (EAConstraintInfo)consForName.get(i);
                result &= this.similar(conModelPath, "Status", con.getStatus(), refCon.getStatus());
                result &= this.similar(conModelPath, "Notes", con.getNotes(), refCon.getNotes());
                result &= this.similar(conModelPath, "Type", con.getType(), refCon.getType());
            }
        }
        for (EAConstraintInfo con : consByName.values()) {
            this.sj.add("Element " + elmtModelPath + " - Found unexpected constraint with name '" + con.getName() + "', type '" + con.getType() + "', status '" + con.getStatus() + "', and notes '" + con.getNotes() + "'.");
            result = false;
        }
        return result;
    }

    private ListMultimap<String, EAConstraintInfo> parseEAConstraints(Collection<Constraint> cons) {
        ListMultimap result = MultimapBuilder.treeKeys().arrayListValues().build();
        for (short i = 0; i < cons.GetCount(); i = (short)(i + 1)) {
            Constraint con = (Constraint)cons.GetAt(i);
            result.put((Object)con.GetName(), (Object)new EAConstraintInfo(con.GetName(), con.GetType(), con.GetStatus(), con.GetNotes()));
        }
        return result;
    }

    private ListMultimap<String, EAConstraintInfo> parseEAAttributeConstraints(Collection<AttributeConstraint> cons) {
        ListMultimap result = MultimapBuilder.treeKeys().arrayListValues().build();
        for (short i = 0; i < cons.GetCount(); i = (short)(i + 1)) {
            AttributeConstraint con = (AttributeConstraint)cons.GetAt(i);
            result.put((Object)con.GetName(), (Object)new EAConstraintInfo(con.GetName(), con.GetType(), "", con.GetNotes()));
        }
        return result;
    }

    private ListMultimap<String, EAConstraintInfo> parseEAConnectorConstraints(Collection<ConnectorConstraint> cons) {
        ListMultimap result = MultimapBuilder.treeKeys().arrayListValues().build();
        for (short i = 0; i < cons.GetCount(); i = (short)(i + 1)) {
            ConnectorConstraint con = (ConnectorConstraint)cons.GetAt(i);
            result.put((Object)con.GetName(), (Object)new EAConstraintInfo(con.GetName(), con.GetType(), "", con.GetNotes()));
        }
        return result;
    }

    private boolean ignoreElementType(String elmtType) {
        return !this.allowedElementTypes.contains(elmtType);
    }

    private boolean ignoreConnectorType(String connType) {
        return !this.allowedConnectorTypes.contains(connType);
    }

    private boolean diffConnector(String modelPath, Connector conn, Connector refConn) {
        int connId = conn.GetConnectorID();
        int refConnId = refConn.GetConnectorID();
        if (this.idsOfCheckedConnectors.contains(connId) && this.refIdsOfCheckedConnectors.contains(refConnId)) {
            return true;
        }
        this.idsOfCheckedConnectors.add(connId);
        this.refIdsOfCheckedConnectors.add(refConnId);
        boolean result = true;
        ConnectorEnd client = conn.GetClientEnd();
        ConnectorEnd supplier = conn.GetSupplierEnd();
        String connKey = this.getKey(conn, client, supplier, this.rep);
        String connModelPath = modelPath + ", connector " + connKey;
        result &= this.similar(connModelPath, "Alias", conn.GetAlias(), refConn.GetAlias());
        Element connAssoc = conn.GetAssociationClass();
        Element refConnAssoc = refConn.GetAssociationClass();
        result &= this.similar(connModelPath, "has association class", connAssoc != null, refConnAssoc != null);
        if (connAssoc != null && refConnAssoc != null) {
            result &= this.similar(connModelPath, "association class name", connAssoc.GetName(), refConnAssoc.GetName());
        }
        ListMultimap<String, EAConstraintInfo> consByName = this.parseEAConnectorConstraints((Collection<ConnectorConstraint>)conn.GetConstraints());
        ListMultimap<String, EAConstraintInfo> refConsByName = this.parseEAConnectorConstraints((Collection<ConnectorConstraint>)refConn.GetConstraints());
        result &= this.diffConstraints(connModelPath, consByName, refConsByName);
        result &= this.similar(connModelPath, "Direction", conn.GetDirection(), refConn.GetDirection());
        result &= this.similarIgnoreCase(connModelPath, "FQStereotype", conn.GetFQStereotype(), refConn.GetFQStereotype());
        result &= this.similar(connModelPath, "ForeignKeyInformation", conn.GetForeignKeyInformation(), refConn.GetForeignKeyInformation());
        result &= this.similar(connModelPath, "IsLeaf", conn.GetIsLeaf(), refConn.GetIsLeaf());
        result &= this.similar(connModelPath, "IsRoot", conn.GetIsRoot(), refConn.GetIsRoot());
        result &= this.similar(connModelPath, "IsSpec", conn.GetIsSpec(), refConn.GetIsSpec());
        result &= this.similar(connModelPath, "Name", conn.GetName(), refConn.GetName());
        result &= this.similar(connModelPath, "Notes", conn.GetNotes(), refConn.GetNotes());
        result &= this.similar(connModelPath, "ObjectType", conn.GetObjectType(), refConn.GetObjectType());
        result &= this.similarIgnoreCase(connModelPath, "StereotypeEx", conn.GetStereotypeEx(), refConn.GetStereotypeEx());
        result &= this.similar(connModelPath, "StyleEx", conn.GetStyleEx(), refConn.GetStyleEx());
        result &= this.similar(connModelPath, "Subtype", conn.GetSubtype(), refConn.GetSubtype());
        result &= this.similar(connModelPath, "Type", conn.GetType(), refConn.GetType());
        result &= this.similar(connModelPath, EAConnectorUtil.getEATaggedValues(conn), EAConnectorUtil.getEATaggedValues(refConn));
        boolean clientEndsSimilar = this.similarReferencedElementName(connModelPath, "name of element that owns the ClientEnd", conn.GetClientID(), refConn.GetClientID());
        result &= clientEndsSimilar;
        boolean supplierEndsSimilar = this.similarReferencedElementName(connModelPath, "name of element that owns the SupplierEnd", conn.GetSupplierID(), refConn.GetSupplierID());
        result &= supplierEndsSimilar;
        if (clientEndsSimilar && supplierEndsSimilar) {
            result &= this.diffConnectorEnd(connModelPath + ", client (source) end", conn.GetClientEnd(), refConn.GetClientEnd());
            result &= this.diffConnectorEnd(connModelPath + ", supplier (target) end", conn.GetSupplierEnd(), refConn.GetSupplierEnd());
        }
        return result;
    }

    private boolean diffConnectorEnd(String modelPath, ConnectorEnd connEnd, ConnectorEnd refConnEnd) {
        boolean result = true;
        result &= this.similar(modelPath, "Aggregation", connEnd.GetAggregation(), refConnEnd.GetAggregation());
        result &= this.similar(modelPath, "Alias", connEnd.GetAlias(), refConnEnd.GetAlias());
        result &= this.similar(modelPath, "AllowDuplicates", connEnd.GetAllowDuplicates(), refConnEnd.GetAllowDuplicates());
        result &= this.similar(modelPath, "OwnedByClassifier", connEnd.GetOwnedByClassifier(), refConnEnd.GetOwnedByClassifier());
        result &= this.similar(modelPath, "Cardinality", connEnd.GetCardinality(), refConnEnd.GetCardinality());
        result &= this.similar(modelPath, "Constraint", connEnd.GetConstraint(), refConnEnd.GetConstraint());
        result &= this.similar(modelPath, "Containment", connEnd.GetContainment(), refConnEnd.GetContainment());
        result &= this.similar(modelPath, "Derived", connEnd.GetDerived(), refConnEnd.GetDerived());
        result &= this.similar(modelPath, "DerivedUnion", connEnd.GetDerivedUnion(), refConnEnd.GetDerivedUnion());
        result &= this.similar(modelPath, "End", connEnd.GetEnd(), refConnEnd.GetEnd());
        result &= this.similar(modelPath, "IsChangeable", connEnd.GetIsChangeable(), refConnEnd.GetIsChangeable());
        result &= this.similar(modelPath, "Navigable", connEnd.GetNavigable(), refConnEnd.GetNavigable());
        result &= this.similar(modelPath, "ObjectType", connEnd.GetObjectType(), refConnEnd.GetObjectType());
        result &= this.similar(modelPath, "Ordering", connEnd.GetOrdering(), refConnEnd.GetOrdering());
        result &= this.similar(modelPath, "Qualifier", connEnd.GetQualifier(), refConnEnd.GetQualifier());
        result &= this.similar(modelPath, "Role", connEnd.GetRole(), refConnEnd.GetRole());
        result &= this.similar(modelPath, "RoleNote", connEnd.GetRoleNote(), refConnEnd.GetRoleNote());
        result &= this.similar(modelPath, "RoleType", connEnd.GetRoleType(), refConnEnd.GetRoleType());
        result &= this.similarIgnoreCase(modelPath, "StereotypeEx", connEnd.GetStereotypeEx(), refConnEnd.GetStereotypeEx());
        result &= this.similar(modelPath, "Visibility", connEnd.GetVisibility(), refConnEnd.GetVisibility());
        return result &= this.similar(modelPath, EAConnectorEndUtil.getEATaggedValues(connEnd), EAConnectorEndUtil.getEATaggedValues(refConnEnd));
    }

    private String getKey(Connector conn, ConnectorEnd client, ConnectorEnd supplier, Repository repOfConn) {
        Element clientElmt = repOfConn.GetElementByID(conn.GetClientID());
        Element supplierElmt = repOfConn.GetElementByID(conn.GetSupplierID());
        String connKey = conn.GetType() + " Source/Client '" + client.GetRole() + "' (at element '" + clientElmt.GetName() + "') > '" + conn.GetName() + "' > Target/Supplier '" + supplier.GetRole() + "' (at element '" + supplierElmt.GetName() + "')";
        return connKey;
    }

    private boolean similar(String modelPath, String attributeToCompare, boolean attValue, boolean refAttValue) {
        if (attValue != refAttValue) {
            this.sj.add(modelPath + " - Different " + attributeToCompare + ". EXPECTED '" + refAttValue + "' FOUND '" + attValue + "'.");
            return false;
        }
        return true;
    }

    private boolean similar(String modelPath, String attributeToCompare, ObjectType attValue, ObjectType refAttValue) {
        if (attValue != refAttValue) {
            this.sj.add(modelPath + " - Different " + attributeToCompare + ". EXPECTED '" + refAttValue.name() + "' FOUND '" + attValue.name() + "'.");
            return false;
        }
        return true;
    }

    private boolean similar(String modelPath, String attributeToCompare, String attValue, String refAttValue) {
        if (!attValue.equals(refAttValue)) {
            this.sj.add(modelPath + " - Different " + attributeToCompare + ". EXPECTED '" + refAttValue + "' FOUND '" + attValue + "'.");
            return false;
        }
        return true;
    }

    private boolean similarIgnoreCase(String modelPath, String attributeToCompare, String attValue, String refAttValue) {
        if (!attValue.equalsIgnoreCase(refAttValue)) {
            this.sj.add(modelPath + " - Different " + attributeToCompare + ". EXPECTED '" + refAttValue + "' FOUND '" + attValue + "'. Case is ignored.");
            return false;
        }
        return true;
    }

    private boolean similar(String modelPath, String attributeToCompare, long attValue, long refAttValue) {
        if (attValue != refAttValue) {
            this.sj.add(modelPath + " - Different " + attributeToCompare + ". EXPECTED '" + refAttValue + "' FOUND '" + attValue + "'.");
            return false;
        }
        return true;
    }

    private ListMultimap<String, EAPackageInfo> parseEAPackages(Collection<Package> pkgs, Map<Integer, EAPackageInfo> pkgsById) {
        ListMultimap result = MultimapBuilder.treeKeys().arrayListValues().build();
        for (short i = 0; i < pkgs.GetCount(); i = (short)(i + 1)) {
            Package pkg = (Package)pkgs.GetAt(i);
            int id = pkg.GetPackageID();
            String name = pkg.GetName();
            int parentId = pkg.GetParentID();
            Object path = parentId == 0 ? name : pkgsById.get(parentId).getModelPath() + "::" + name;
            if (result.containsKey((Object)name)) {
                int index = result.get((Object)name).size() + 1;
                path = (String)path + "[" + index + "]";
            }
            EAModelElementInfo pkgElmtInfo = null;
            Element pkgElmt = pkg.GetElement();
            if (pkgElmt != null) {
                String pkgElmtName = pkgElmt.GetName();
                pkgElmtInfo = new EAModelElementInfo(pkgElmtName, pkgElmt.GetElementID(), (String)path);
            }
            EAPackageInfo pkgInfo = new EAPackageInfo(name, id, (String)path, pkgElmtInfo);
            result.put((Object)pkgInfo.getName(), (Object)pkgInfo);
            pkgsById.put(id, pkgInfo);
        }
        return result;
    }

    public String getDiffDetails() {
        return this.sj.toString();
    }

    class EAConnectorInfo
    extends EAModelElementInfo {
        private String key;

        public EAConnectorInfo(String name, Integer id, String modelPath, String key) {
            super(name, id, modelPath);
            this.key = key;
        }

        public String getKey() {
            return this.key;
        }
    }

    class EAPackageInfo
    extends EAModelElementInfo {
        private EAModelElementInfo element;

        public EAPackageInfo(String name, Integer id, String modelPath, EAModelElementInfo element) {
            super(name, id, modelPath);
            this.element = element;
        }

        public EAModelElementInfo getElement() {
            return this.element;
        }
    }

    class EAModelElementInfo {
        private String name;
        private Integer id;
        private String modelPath;

        public EAModelElementInfo(String name, Integer id, String modelPath) {
            this.name = name;
            this.id = id;
            this.modelPath = modelPath;
        }

        public String getName() {
            return this.name;
        }

        public Integer getId() {
            return this.id;
        }

        public String getModelPath() {
            return this.modelPath;
        }
    }

    class EAConstraintInfo {
        private String name;
        private String type;
        private String status;
        private String notes;

        public EAConstraintInfo(String name, String type, String status, String notes) {
            this.name = name;
            this.type = type;
            this.status = status;
            this.notes = notes;
        }

        public String getName() {
            return this.name;
        }

        public String getType() {
            return this.type;
        }

        public String getStatus() {
            return this.status;
        }

        public String getNotes() {
            return this.notes;
        }
    }
}

