/*
 * Decompiled with CFR 0.152.
 */
package de.interactive_instruments.ShapeChange.Util.ea;

import de.interactive_instruments.ShapeChange.Util.ea.AbstractEAUtil;
import de.interactive_instruments.ShapeChange.Util.ea.EAException;
import de.interactive_instruments.ShapeChange.Util.ea.EATaggedValue;
import java.util.List;
import java.util.SortedMap;
import java.util.TreeMap;
import org.sparx.Collection;
import org.sparx.Method;
import org.sparx.MethodTag;
import org.sparx.Parameter;

public class EAMethodUtil
extends AbstractEAUtil {
    public static void setEAStereotypeEx(Method m, String stereotype) throws EAException {
        m.SetStereotypeEx(stereotype);
        if (!m.Update()) {
            throw new EAException(EAMethodUtil.createMessage(EAMethodUtil.message(101), m.GetName(), m.GetLastError()));
        }
    }

    public static void setEACode(Method m, String code) throws EAException {
        m.SetCode(code);
        if (!m.Update()) {
            throw new EAException(EAMethodUtil.createMessage(EAMethodUtil.message(103), m.GetName(), m.GetLastError()));
        }
    }

    public static void deleteTaggedValue(Method m, String nameOfTVToDelete) {
        Collection cTV = m.GetTaggedValues();
        cTV.Refresh();
        for (short i = 0; i < cTV.GetCount(); i = (short)(i + 1)) {
            MethodTag tv = (MethodTag)cTV.GetAt(i);
            if (!tv.GetName().equalsIgnoreCase(nameOfTVToDelete)) continue;
            cTV.Delete(i);
        }
        cTV.Refresh();
    }

    public static void setTaggedValues(Method m, List<EATaggedValue> tvs) throws EAException {
        for (EATaggedValue tv : tvs) {
            EAMethodUtil.deleteTaggedValue(m, tv.getName());
        }
        EAMethodUtil.addTaggedValues(m, tvs);
    }

    public static void addTaggedValues(Method m, List<EATaggedValue> tvs) throws EAException {
        if (tvs != null && !tvs.isEmpty()) {
            Collection cTV = m.GetTaggedValues();
            for (EATaggedValue tv : tvs) {
                String name = tv.getName();
                List<String> values = tv.getValues();
                if (values == null) continue;
                for (String v : values) {
                    MethodTag eaTv = (MethodTag)cTV.AddNew(name, "");
                    cTV.Refresh();
                    if (tv.createAsMemoField() || v.length() > 255) {
                        eaTv.SetValue("<memo>");
                        eaTv.SetNotes(v);
                    } else {
                        eaTv.SetValue(v);
                        eaTv.SetNotes("");
                    }
                    if (eaTv.Update()) continue;
                    throw new EAException(EAMethodUtil.createMessage(EAMethodUtil.message(105), name, m.GetName(), v, eaTv.GetLastError()));
                }
            }
        }
    }

    public static void setEAPos(Method m, int pos) throws EAException {
        m.SetPos(pos);
        if (!m.Update()) {
            throw new EAException(EAMethodUtil.createMessage(EAMethodUtil.message(104), m.GetName(), m.GetLastError()));
        }
    }

    public static Parameter createEAParameter(Method m, String name) throws EAException {
        Collection parameters = m.GetParameters();
        Parameter param = (Parameter)parameters.AddNew(name, "");
        if (!param.Update()) {
            throw new EAException(EAMethodUtil.createMessage(EAMethodUtil.message(107), name, m.GetName(), m.GetLastError()));
        }
        parameters.Refresh();
        return param;
    }

    public static Parameter getFirstParameter(Method m) {
        Collection params = m.GetParameters();
        params.Refresh();
        if (params.GetCount() > 0) {
            return (Parameter)params.GetAt((short)0);
        }
        return null;
    }

    public static SortedMap<String, EATaggedValue> getEATaggedValues(Method meth) {
        TreeMap<String, EATaggedValue> result = new TreeMap<String, EATaggedValue>();
        Collection tvs = meth.GetTaggedValues();
        for (short i = 0; i < tvs.GetCount(); i = (short)(i + 1)) {
            MethodTag tv = (MethodTag)tvs.GetAt(i);
            String name = tv.GetName();
            String fqName = tv.GetFQName();
            String tvValue = tv.GetValue();
            String value = tvValue.equals("<memo>") ? tv.GetNotes() : tvValue;
            String key = name + "#" + fqName;
            if (result.containsKey(key)) {
                EATaggedValue eatv = (EATaggedValue)result.get(key);
                eatv.addValue(value);
                continue;
            }
            result.put(key, new EATaggedValue(name, fqName, value));
        }
        return result;
    }

    public static String message(int mnr) {
        switch (mnr) {
            case 101: {
                return "EA error encountered while updating 'StereotypeEx' of EA method '$1$'. Error message is: $2$";
            }
            case 102: {
                return "EA error encountered while updating new EA parameter '$1$' on method '$2$'. Error message is: $3$";
            }
            case 103: {
                return "EA error encountered while updating 'Code' of EA method '$1$'. Error message is: $2$";
            }
            case 104: {
                return "EA error encountered while updating 'Pos' of EA method '$1$'. Error message is: $2$";
            }
            case 105: {
                return "EA error encountered while updating EA tagged value '$1$' of element '$2$' with value '$3$'. Error message is: $4$";
            }
        }
        return "(" + EAMethodUtil.class.getName() + ") Unknown message with number: " + mnr;
    }
}

