/*
 * Decompiled with CFR 0.152.
 */
package de.interactive_instruments.ShapeChange.Util.ea;

import de.interactive_instruments.ShapeChange.Model.TaggedValues;
import de.interactive_instruments.ShapeChange.Multiplicity;
import de.interactive_instruments.ShapeChange.Util.ea.AbstractEAUtil;
import de.interactive_instruments.ShapeChange.Util.ea.EAAttributeUtil;
import de.interactive_instruments.ShapeChange.Util.ea.EAException;
import de.interactive_instruments.ShapeChange.Util.ea.EATaggedValue;
import java.util.List;
import java.util.Set;
import java.util.SortedMap;
import java.util.TreeMap;
import org.apache.commons.lang3.StringUtils;
import org.sparx.Attribute;
import org.sparx.Collection;
import org.sparx.Connector;
import org.sparx.Constraint;
import org.sparx.Element;
import org.sparx.Method;
import org.sparx.TaggedValue;

public class EAElementUtil
extends AbstractEAUtil {
    public static void addTaggedValue(Element e, EATaggedValue tv) throws EAException {
        Collection cTV = e.GetTaggedValues();
        String name = tv.getName();
        String type = "";
        List<String> values = tv.getValues();
        if (values != null) {
            for (String v : values) {
                TaggedValue eaTv = (TaggedValue)cTV.AddNew(name, type);
                cTV.Refresh();
                if (tv.createAsMemoField() || v.length() > 255) {
                    eaTv.SetValue("<memo>");
                    eaTv.SetNotes(v);
                } else {
                    eaTv.SetValue(v);
                    eaTv.SetNotes("");
                }
                if (eaTv.Update()) continue;
                throw new EAException(EAElementUtil.createMessage(EAElementUtil.message(106), name, e.GetName(), v, eaTv.GetLastError()));
            }
        }
    }

    public static void addTaggedValues(Element e, List<EATaggedValue> tvs) throws EAException {
        if (tvs != null && !tvs.isEmpty()) {
            Collection cTV = e.GetTaggedValues();
            for (EATaggedValue tv : tvs) {
                String name = tv.getName();
                List<String> values = tv.getValues();
                if (values == null) continue;
                for (String v : values) {
                    TaggedValue eaTv = (TaggedValue)cTV.AddNew(name, "");
                    cTV.Refresh();
                    if (tv.createAsMemoField() || v.length() > 255) {
                        eaTv.SetValue("<memo>");
                        eaTv.SetNotes(v);
                    } else {
                        eaTv.SetValue(v);
                        eaTv.SetNotes("");
                    }
                    if (eaTv.Update()) continue;
                    throw new EAException(EAElementUtil.createMessage(EAElementUtil.message(106), name, e.GetName(), v, eaTv.GetLastError()));
                }
            }
        }
    }

    public static void addTaggedValues(Element e, TaggedValues tvs) throws EAException {
        if (tvs != null && !tvs.isEmpty()) {
            Collection cTV = e.GetTaggedValues();
            for (String tag : tvs.keySet()) {
                String[] values;
                for (String v : values = tvs.get(tag)) {
                    TaggedValue tv = (TaggedValue)cTV.AddNew(tag, "");
                    cTV.Refresh();
                    if (v.length() > 255) {
                        tv.SetValue("<memo>");
                        tv.SetNotes(v);
                    } else {
                        tv.SetValue(v);
                        tv.SetNotes("");
                    }
                    if (tv.Update()) continue;
                    throw new EAException(EAElementUtil.createMessage(EAElementUtil.message(106), tag, e.GetName(), v, tv.GetLastError()));
                }
            }
        }
    }

    public static void deleteTaggedValue(Element e, String nameOfTVToDelete) {
        Collection cTV = e.GetTaggedValues();
        cTV.Refresh();
        for (short i = 0; i < cTV.GetCount(); i = (short)(i + 1)) {
            TaggedValue tv = (TaggedValue)cTV.GetAt(i);
            if (!tv.GetName().equalsIgnoreCase(nameOfTVToDelete)) continue;
            cTV.Delete(i);
        }
        cTV.Refresh();
    }

    public static void setEAAbstract(Element e, boolean isAbstract) throws EAException {
        e.SetAbstract("true");
        if (!e.Update()) {
            throw new EAException(EAElementUtil.createMessage(EAElementUtil.message(101), e.GetName(), e.GetLastError()));
        }
    }

    public static void setEAAlias(Element e, String aliasName) throws EAException {
        e.SetAlias(aliasName);
        if (!e.Update()) {
            throw new EAException(EAElementUtil.createMessage(EAElementUtil.message(102), e.GetName(), e.GetLastError()));
        }
    }

    public static void loadLinkedDocument(Element e, String linkedDocumentAbsolutePath) throws EAException {
        e.LoadLinkedDocument(linkedDocumentAbsolutePath);
        if (!e.Update()) {
            throw new EAException(EAElementUtil.createMessage(EAElementUtil.message(109), e.GetName(), linkedDocumentAbsolutePath, e.GetLastError()));
        }
    }

    public static void setEAGenType(Element e, String gentype) throws EAException {
        e.SetGentype(gentype);
        if (!e.Update()) {
            throw new EAException(EAElementUtil.createMessage(EAElementUtil.message(103), e.GetName(), e.GetLastError()));
        }
    }

    public static void setEANotes(Element e, String documentation) throws EAException {
        e.SetNotes(documentation);
        if (!e.Update()) {
            throw new EAException(EAElementUtil.createMessage(EAElementUtil.message(111), e.GetName(), e.GetLastError()));
        }
    }

    public static void setEAAuthor(Element e, String author) throws EAException {
        e.SetAuthor(author);
        if (!e.Update()) {
            throw new EAException(EAElementUtil.createMessage(EAElementUtil.message(104), e.GetName(), e.GetLastError()));
        }
    }

    public static void setEAStatus(Element e, String status) throws EAException {
        e.SetStatus(status);
        if (!e.Update()) {
            throw new EAException(EAElementUtil.createMessage(EAElementUtil.message(112), e.GetName(), e.GetLastError()));
        }
    }

    public static void setEAStereotype(Element e, String stereotype) throws EAException {
        e.SetStereotype(stereotype);
        if (!e.Update()) {
            throw new EAException(EAElementUtil.createMessage(EAElementUtil.message(110), e.GetName(), e.GetLastError()));
        }
    }

    public static void setEAStereotypeEx(Element e, String stereotypeEx) throws EAException {
        e.SetStereotypeEx(stereotypeEx);
        if (!e.Update()) {
            throw new EAException(EAElementUtil.createMessage(EAElementUtil.message(105), e.GetName(), e.GetLastError()));
        }
    }

    public static void setTaggedValue(Element e, EATaggedValue tv) throws EAException {
        EAElementUtil.deleteTaggedValue(e, tv.getName());
        EAElementUtil.addTaggedValue(e, tv);
    }

    public static void setTaggedValue(Element e, String name, String value) throws EAException {
        EATaggedValue tv = new EATaggedValue(name, value);
        EAElementUtil.deleteTaggedValue(e, tv.getName());
        EAElementUtil.addTaggedValue(e, tv);
    }

    public static void setTaggedValues(Element e, List<EATaggedValue> tvs) throws EAException {
        for (EATaggedValue tv : tvs) {
            EAElementUtil.deleteTaggedValue(e, tv.getName());
        }
        EAElementUtil.addTaggedValues(e, tvs);
    }

    public static void setTaggedValues(Element e, TaggedValues tvs) throws EAException {
        for (String tvName : tvs.asMap().keySet()) {
            EAElementUtil.deleteTaggedValue(e, tvName);
        }
        EAElementUtil.addTaggedValues(e, tvs);
    }

    public static String taggedValue(Element elmt, String tvName) {
        Collection tvs = elmt.GetTaggedValues();
        for (TaggedValue tv : tvs) {
            if (!tvName.equals(tv.GetName())) continue;
            String value = tv.GetValue();
            if (value.equals("<memo>")) {
                value = tv.GetNotes();
            }
            return value;
        }
        return null;
    }

    public static void updateTaggedValue(Element e, String name, String value, boolean createAsMemoField) throws EAException {
        boolean isQualifiedName = name.contains("::");
        Collection cTV = e.GetTaggedValues();
        cTV.Refresh();
        for (short i = 0; i < cTV.GetCount(); i = (short)(i + 1)) {
            TaggedValue tv = (TaggedValue)cTV.GetAt(i);
            if ((!isQualifiedName || !tv.GetFQName().equalsIgnoreCase(name)) && !tv.GetName().equalsIgnoreCase(name)) continue;
            if (createAsMemoField || value.length() > 255) {
                tv.SetValue("<memo>");
                tv.SetNotes(value);
            } else {
                tv.SetValue(value);
                tv.SetNotes("");
            }
            if (tv.Update()) continue;
            throw new EAException(EAElementUtil.createMessage(EAElementUtil.message(106), name, e.GetName(), value, tv.GetLastError()));
        }
        cTV.Refresh();
    }

    public static Method createEAMethod(Element elmt, String name) throws EAException {
        Collection methods = elmt.GetMethods();
        Method m = (Method)methods.AddNew(name, "");
        if (!m.Update()) {
            throw new EAException(EAElementUtil.createMessage(EAElementUtil.message(107), name, elmt.GetName(), m.GetLastError()));
        }
        methods.Refresh();
        return m;
    }

    public static Attribute createEAAttribute(Element e, String name, String alias, String documentation, Set<String> stereotypes, List<EATaggedValue> taggedValues, boolean isDerived, boolean isOrdered, boolean allowDuplicates, String initialValue, boolean isReadOnly, Multiplicity m, String type, Integer classifierID) throws EAException {
        Collection atts = e.GetAttributes();
        Attribute att = (Attribute)atts.AddNew(name, "");
        if (!att.Update()) {
            throw new EAException(EAElementUtil.createMessage(EAElementUtil.message(108), name, e.GetName(), e.GetLastError()));
        }
        atts.Refresh();
        if (alias != null) {
            att.SetStyle(alias);
        }
        if (documentation != null) {
            att.SetNotes(documentation);
        }
        if (stereotypes != null) {
            att.SetStereotypeEx(EAElementUtil.stereotypesCSV(stereotypes));
        }
        if (taggedValues != null) {
            EAAttributeUtil.setTaggedValues(att, taggedValues);
        }
        att.SetIsDerived(isDerived);
        att.SetIsOrdered(isOrdered);
        att.SetAllowDuplicates(allowDuplicates);
        if (initialValue != null) {
            att.SetDefault(initialValue);
        }
        att.SetIsConst(isReadOnly);
        att.SetVisibility("public");
        if (m != null) {
            att.SetLowerBound("" + m.minOccurs);
            if (m.maxOccurs == Integer.MAX_VALUE) {
                att.SetUpperBound("*");
            } else {
                att.SetUpperBound("" + m.maxOccurs);
            }
        }
        if (type != null) {
            att.SetType(type);
        }
        if (classifierID != null) {
            att.SetClassifierID(classifierID.intValue());
        }
        if (!att.Update()) {
            throw new EAException(EAElementUtil.createMessage(EAElementUtil.message(108), name, e.GetName(), e.GetLastError()));
        }
        return att;
    }

    public static Connector createEAAssociation(Element client, Element supplier) throws EAException {
        Collection clientCons = client.GetConnectors();
        Connector con = (Connector)clientCons.AddNew("", "Association");
        con.SetSupplierID(supplier.GetElementID());
        if (!con.Update()) {
            throw new EAException(EAElementUtil.createMessage(EAElementUtil.message(1005), client.GetName(), supplier.GetName(), con.GetLastError()));
        }
        clientCons.Refresh();
        return con;
    }

    public static Method getEAMethodWithStereotypeEx(Element e, String stereotype) {
        Collection methods = e.GetMethods();
        methods.Refresh();
        for (short i = 0; i < methods.GetCount(); i = (short)(i + 1)) {
            Method m = (Method)methods.GetAt(i);
            if (!m.GetStereotypeEx().contains(stereotype)) continue;
            return m;
        }
        return null;
    }

    public static Attribute getAttributeByName(Element elmt, String attName) {
        Attribute result = null;
        Collection atts = elmt.GetAttributes();
        for (short i = 0; i < atts.GetCount(); i = (short)(i + 1)) {
            Attribute att = (Attribute)atts.GetAt(i);
            if (!att.GetName().equals(attName)) continue;
            result = att;
            break;
        }
        return result;
    }

    public static SortedMap<String, EATaggedValue> getEATaggedValues(Element elmt) {
        TreeMap<String, EATaggedValue> result = new TreeMap<String, EATaggedValue>();
        Collection tvs = elmt.GetTaggedValues();
        for (short i = 0; i < tvs.GetCount(); i = (short)(i + 1)) {
            TaggedValue tv = (TaggedValue)tvs.GetAt(i);
            String name = tv.GetName();
            String fqName = tv.GetFQName();
            String tvValue = tv.GetValue();
            String value = tvValue.equals("<memo>") ? tv.GetNotes() : tvValue;
            String key = name + "#" + fqName;
            if (result.containsKey(key)) {
                EATaggedValue eatv = (EATaggedValue)result.get(key);
                eatv.addValue(value);
                continue;
            }
            result.put(key, new EATaggedValue(name, fqName, value));
        }
        return result;
    }

    public static Constraint addConstraint(Element e, String name, String type, String text, String status) throws EAException {
        Collection cons = e.GetConstraints();
        Constraint con = (Constraint)cons.AddNew(name, type);
        cons.Refresh();
        con.SetNotes(text);
        if (StringUtils.isNotBlank((CharSequence)status)) {
            con.SetStatus(status);
        }
        if (!con.Update()) {
            throw new EAException(EAElementUtil.createMessage(EAElementUtil.message(1006), name, e.GetName(), con.GetLastError()));
        }
        return con;
    }

    public static Constraint addConstraint(Element e, String name, String type, String text) throws EAException {
        return EAElementUtil.addConstraint(e, name, type, text, null);
    }

    public static String message(int mnr) {
        switch (mnr) {
            case 101: {
                return "EA error encountered while updating 'Abstract' of EA element '$1$'. Error message is: $2$";
            }
            case 102: {
                return "EA error encountered while updating 'Alias' of EA element '$1$'. Error message is: $2$";
            }
            case 103: {
                return "EA error encountered while updating 'GenType' of EA element '$1$'. Error message is: $2$";
            }
            case 104: {
                return "EA error encountered while updating 'Notes' of EA element '$1$'. Error message is: $2$";
            }
            case 105: {
                return "EA error encountered while updating 'StereotypeEx' of EA element '$1$'. Error message is: $2$";
            }
            case 106: {
                return "EA error encountered while updating EA tagged value '$1$' of element '$2$' with value '$3$'. Error message is: $4$";
            }
            case 107: {
                return "EA error encountered while updating new EA method '$1$' on element '$2$'. Error message is: $3$";
            }
            case 108: {
                return "EA error encountered while updating new EA attribute '$1$' on element '$2$'. Error message is: $3$";
            }
            case 109: {
                return "EA error encountered while loading linked document for EA element '$1$' from path '$2$'. Error message is: $3$";
            }
            case 110: {
                return "EA error encountered while updating 'Stereotype' of EA element '$1$'. Error message is: $2$";
            }
            case 111: {
                return "EA error encountered while updating 'Author' of EA element '$1$'. Error message is: $2$";
            }
            case 112: {
                return "EA error encountered while updating 'Status' of EA element '$1$'. Error message is: $2$";
            }
            case 1005: {
                return "EA error encountered while updating new EA connector between elements '$1$' and '$2$'. Error message is: $3$";
            }
            case 1006: {
                return "EA error encountered while updating new EA constraint '$1$' for element '$2$'. Error message is: $3$";
            }
        }
        return "(" + EAElementUtil.class.getName() + ") Unknown message with number: " + mnr;
    }
}

